/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.stevekung.fishofthieves.client.renderer.entity.layers.GlowFishLayer;
import com.stevekung.fishofthieves.client.renderer.entity.layers.HeadphoneLayer;
import com.stevekung.fishofthieves.entity.FishData;
import com.stevekung.fishofthieves.entity.ThievesFish;
import java.util.function.Consumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.AbstractFish;

public abstract class ThievesFishRenderer<V extends FishData, T extends AbstractFish, M extends EntityModel<T>>
extends MobRenderer<T, M> {
    protected ThievesFishRenderer(EntityRendererProvider.Context context, M entityModel) {
        super(context, entityModel, 0.15f);
        this.m_115326_(new GlowFishLayer(this));
        this.m_115326_(new HeadphoneLayer(this, context));
    }

    public void render(T livingEntity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        this.f_114477_ = ((ThievesFish)livingEntity).isTrophy() ? 0.25f : 0.15f;
        super.m_7392_(livingEntity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    protected void setupRotations(T entity, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_(entity, poseStack, ageInTicks, rotationYaw, partialTicks);
        boolean inWater = entity.m_20069_() || ((ThievesFish)entity).isNoFlip();
        RotationRenderData rotationRenderData = this.setupRotations(entity, inWater);
        float degree = rotationRenderData.baseDegree * Mth.m_14031_((float)(rotationRenderData.bodyRotBase * rotationRenderData.bodyRotSpeed * ageInTicks));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(degree));
        if (!inWater) {
            rotationRenderData.translateConsumer.accept(poseStack);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        }
    }

    public ResourceLocation getTextureLocation(T livingEntity) {
        return ((ThievesFish)livingEntity).getVariant().getTexture();
    }

    protected void scale(T livingEntity, PoseStack poseStack, float partialTickTime) {
        float scale = ((ThievesFish)livingEntity).isTrophy() ? 1.0f : 0.5f;
        poseStack.m_85841_(scale, scale, scale);
    }

    protected abstract RotationRenderData setupRotations(T var1, boolean var2);

    protected record RotationRenderData(float bodyRotBase, float bodyRotSpeed, float baseDegree, Consumer<PoseStack> translateConsumer) {
        public static RotationRenderData create(float bodyRotBase, float bodyRotSpeed, float baseDegree, Consumer<PoseStack> translateConsumer) {
            return new RotationRenderData(bodyRotBase, bodyRotSpeed, baseDegree, translateConsumer);
        }
    }
}

