/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.stevekung.fishofthieves.block.FishPlaqueBlock;
import com.stevekung.fishofthieves.blockentity.FishPlaqueBlockEntity;
import com.stevekung.fishofthieves.registry.FOTTags;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class FishPlaqueRenderer
implements BlockEntityRenderer<FishPlaqueBlockEntity> {
    private final EntityRenderDispatcher entityRenderer;

    public FishPlaqueRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = context.m_234446_();
    }

    public void render(FishPlaqueBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        Entity entity = blockEntity.getOrCreateDisplayEntity(blockEntity.m_58904_());
        if (entity != null) {
            BlockState blockState = blockEntity.m_58900_();
            Direction facing = (Direction)blockState.m_61143_((Property)FishPlaqueBlock.FACING);
            int rotation = (Integer)blockState.m_61143_((Property)FishPlaqueBlock.ROTATION) - 1;
            boolean isHorizontal = entity.m_6095_().m_204039_(FOTTags.EntityTypes.HORIZONTAL_MOB_RENDER);
            float scale = 0.53125f;
            float stepMultiplier = isHorizontal ? 0.3f : 0.4f;
            float maxScale = Math.max(entity.m_20205_(), entity.m_20206_());
            float yDegree = -facing.m_122435_() + 90.0f;
            Vec3 vec3 = new Vec3((double)((float)facing.m_122429_() * stepMultiplier), (double)(-scale), (double)((float)facing.m_122431_() * stepMultiplier));
            if (maxScale > 1.0f) {
                scale /= maxScale;
            }
            poseStack.m_85837_(-vec3.m_7096_(), -vec3.m_7098_(), -vec3.m_7094_());
            poseStack.m_252781_(Axis.f_252436_.m_252977_(yDegree));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            if (isHorizontal) {
                switch (rotation) {
                    case 0: {
                        poseStack.m_85837_(-0.1, 0.0, 0.0);
                        break;
                    }
                    case 1: {
                        poseStack.m_85837_(-0.083125, 0.0, -0.1);
                        break;
                    }
                    case 2: {
                        poseStack.m_85837_(0.0, 0.0, (double)(-scale) * 0.22);
                        break;
                    }
                    case 3: {
                        poseStack.m_85837_(0.073125, 0.0, -0.1);
                        break;
                    }
                    case 4: {
                        poseStack.m_85837_(0.123125, 0.0, 0.0);
                        break;
                    }
                    case 5: {
                        poseStack.m_85837_(0.083125, 0.0, 0.073125);
                        break;
                    }
                    case 6: {
                        poseStack.m_85837_(0.0, 0.0, (double)(-scale) * -0.22);
                        break;
                    }
                    case 7: {
                        poseStack.m_85837_(-0.073125, 0.0, 0.073125);
                    }
                }
                poseStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_((float)rotation * 360.0f / 8.0f));
            } else {
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(-rotation) * 360.0f / 8.0f));
            }
            poseStack.m_85841_(scale, scale, scale);
            this.entityRenderer.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, bufferSource, packedLight);
        }
        poseStack.m_85849_();
    }
}

