/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer.entity.layers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.animal.Wrecker;
import com.stevekung.fishofthieves.entity.variant.WreckerVariant;
import com.stevekung.fishofthieves.registry.FOTRegistry;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class WreckerBulbLayer<T extends Wrecker, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final Map<WreckerVariant, ResourceLocation> BULB_BY_TYPE = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> map.putAll((Map)FOTRegistry.WRECKER_VARIANT.m_123024_().collect(ImmutableMap.toImmutableMap(Function.identity(), variant -> FishOfThieves.res("textures/entity/wrecker/%s_bulb.png".formatted(FOTRegistry.WRECKER_VARIANT.m_7981_(variant).m_135815_()))))));

    public WreckerBulbLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!livingEntity.m_20145_()) {
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110488_((ResourceLocation)BULB_BY_TYPE.get(((Wrecker)livingEntity).getVariant())));
            float color = Mth.m_14036_((float)(1.0f + Mth.m_14089_((float)(ageInTicks * 0.05f))), (float)0.25f, (float)1.0f);
            this.m_117386_().m_7695_(poseStack, vertexConsumer, 0xF00000, OverlayTexture.f_118083_, color, color, color, 1.0f);
        }
    }
}

