/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.FishData;
import com.stevekung.fishofthieves.entity.PartyFish;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public interface ThievesFish<T extends FishData>
extends PartyFish {
    public static final Ingredient WORMS = Ingredient.m_204132_(FOTTags.Items.WORMS);
    public static final Ingredient EARTHWORMS_FOOD = Ingredient.m_204132_(FOTTags.Items.EARTHWORMS_FOOD);
    public static final Ingredient GRUBS_FOOD = Ingredient.m_204132_(FOTTags.Items.GRUBS_FOOD);
    public static final Ingredient LEECHES_FOOD = Ingredient.m_204132_(FOTTags.Items.LEECHES_FOOD);
    public static final String OLD_VARIANT_TAG = "Variant";
    public static final String OLD_NAME_TAG = "Name";
    public static final String VARIANT_TAG = "variant";
    public static final String TROPHY_TAG = "Trophy";
    public static final String HAS_FED_TAG = "HasFed";
    public static final String NO_FLIP_TAG = "NoFlip";

    public T getVariant();

    public void setVariant(T var1);

    public Holder<T> getSpawnVariant(boolean var1);

    public Registry<T> getRegistry();

    public Consumer<Int2ObjectOpenHashMap<String>> getDataFix();

    public boolean isTrophy();

    public void setTrophy(boolean var1);

    public boolean hasFed();

    public void setHasFed(boolean var1);

    public boolean isFood(ItemStack var1);

    public void setNoFlip(boolean var1);

    public boolean isNoFlip();

    default public float getGlowBrightness(float ageInTicks) {
        return 1.0f;
    }

    default public void saveToBucket(CompoundTag compound) {
        ResourceLocation variant = this.getRegistry().m_7981_(this.getVariant());
        if (variant != null) {
            Int2ObjectOpenHashMap oldMap;
            Map<String, Integer> swapped;
            Integer customModelData;
            if (FishOfThieves.CONFIG.general.dropAndPickFishesWithVariant && (customModelData = (swapped = (oldMap = (Int2ObjectOpenHashMap)Util.m_137469_((Object)new Int2ObjectOpenHashMap(), this.getDataFix())).int2ObjectEntrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey))).get(variant.toString())) > 0) {
                compound.m_128405_("CustomModelData", customModelData.intValue());
            }
            compound.m_128359_(VARIANT_TAG, variant.toString());
        }
        if (this.isTrophy()) {
            compound.m_128379_(HAS_FED_TAG, this.hasFed());
            compound.m_128379_(TROPHY_TAG, this.isTrophy());
        }
        if (this.isNoFlip()) {
            compound.m_128379_(NO_FLIP_TAG, this.isNoFlip());
        }
    }

    default public void loadFromBucket(CompoundTag compound) {
        FishData variant;
        ThievesFish.fixData(compound, this.getDataFix());
        if (compound.m_128441_(VARIANT_TAG) && (variant = (FishData)this.getRegistry().m_7745_(ResourceLocation.m_135820_((String)compound.m_128461_(VARIANT_TAG)))) != null) {
            this.setVariant(variant);
        }
        if (compound.m_128441_(TROPHY_TAG)) {
            this.setTrophy(compound.m_128471_(TROPHY_TAG));
        }
        if (compound.m_128441_(HAS_FED_TAG)) {
            this.setHasFed(compound.m_128471_(HAS_FED_TAG));
        }
        if (compound.m_128441_(NO_FLIP_TAG)) {
            this.setNoFlip(compound.m_128471_(NO_FLIP_TAG));
        }
    }

    default public SpawnGroupData defaultFinalizeSpawn(LivingEntity livingEntity, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.BUCKET && dataTag != null && dataTag.m_128425_(VARIANT_TAG, 8)) {
            FishData variant = (FishData)this.getRegistry().m_7745_(ResourceLocation.m_135820_((String)dataTag.m_128461_(VARIANT_TAG)));
            if (variant != null) {
                this.setVariant(variant);
            }
            this.setTrophy(dataTag.m_128471_(TROPHY_TAG));
            return spawnData;
        }
        if (livingEntity.m_217043_().m_188501_() < FishOfThieves.CONFIG.spawnRate.trophyProbability) {
            this.setTrophy(true);
            livingEntity.m_21153_(FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
        this.setVariant((FishData)this.getSpawnVariant(reason == MobSpawnType.BUCKET).m_203334_());
        return spawnData;
    }

    default public Holder<T> getSpawnVariant(LivingEntity livingEntity, TagKey<T> tagKey, T defaultSpawn, boolean fromBucket) {
        return this.getRegistry().m_203431_(tagKey).flatMap(named -> named.m_213653_(livingEntity.m_217043_())).filter(variant -> fromBucket || ((FishData)variant.m_203334_()).getCondition().test(SpawnSelectors.get(livingEntity))).orElseGet(() -> Holder.m_205709_((Object)defaultSpawn));
    }

    public static void fixData(CompoundTag compound, Consumer<Int2ObjectOpenHashMap<String>> consumer) {
        if (compound.m_128425_(OLD_VARIANT_TAG, 3)) {
            int variant = compound.m_128451_(OLD_VARIANT_TAG);
            Int2ObjectOpenHashMap oldMap = (Int2ObjectOpenHashMap)Util.m_137469_((Object)new Int2ObjectOpenHashMap(), consumer);
            compound.m_128473_(OLD_VARIANT_TAG);
            compound.m_128359_(VARIANT_TAG, (String)oldMap.get(variant));
        }
        if (compound.m_128441_(OLD_NAME_TAG)) {
            compound.m_128473_(OLD_NAME_TAG);
        }
    }
}

