/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.forge.datagen;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.stevekung.fishofthieves.registry.FOTEntities;
import com.stevekung.fishofthieves.registry.FOTItems;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.VanillaBlockTagsProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="fishofthieves", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGeneratorFOT {
    private static final TagKey<Item> RAW_FISHES = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", "raw_fishes"));
    private static final TagKey<Item> COOKED_FISHES = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("forge", "cooked_fishes"));

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        dataGenerator.addProvider(event.includeServer(), (DataProvider)new ForgeItemTags(packOutput, provider, "fishofthieves", helper));
        dataGenerator.addProvider(event.includeServer(), (DataProvider)new FishingReal(packOutput, provider));
    }

    private static class ForgeItemTags
    extends ItemTagsProvider {
        public ForgeItemTags(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, provider, new VanillaBlockTagsProvider(output, provider).m_274426_(), modId, existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider provider) {
            Object[] rawFishes = new Item[]{FOTItems.SPLASHTAIL, FOTItems.PONDIE, FOTItems.ISLEHOPPER, FOTItems.ANCIENTSCALE, FOTItems.PLENTIFIN, FOTItems.WILDSPLASH, FOTItems.DEVILFISH, FOTItems.BATTLEGILL, FOTItems.WRECKER, FOTItems.STORMFISH};
            Object[] cookedFishes = new Item[]{FOTItems.COOKED_SPLASHTAIL, FOTItems.COOKED_PONDIE, FOTItems.COOKED_ISLEHOPPER, FOTItems.COOKED_ANCIENTSCALE, FOTItems.COOKED_PLENTIFIN, FOTItems.COOKED_WILDSPLASH, FOTItems.COOKED_DEVILFISH, FOTItems.COOKED_BATTLEGILL, FOTItems.COOKED_WRECKER, FOTItems.COOKED_STORMFISH};
            this.m_206424_(RAW_FISHES).m_255179_(rawFishes);
            this.m_206424_(COOKED_FISHES).m_255179_(cookedFishes);
        }
    }

    private static class FishingReal
    extends FishingRealProvider {
        public FishingReal(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
            super(output, provider);
        }

        @Override
        public void addFishingReal() {
            this.add(FOTItems.SPLASHTAIL, FOTEntities.SPLASHTAIL);
            this.add(FOTItems.PONDIE, FOTEntities.PONDIE);
            this.add(FOTItems.ISLEHOPPER, FOTEntities.ISLEHOPPER);
            this.add(FOTItems.ANCIENTSCALE, FOTEntities.ANCIENTSCALE);
            this.add(FOTItems.PLENTIFIN, FOTEntities.PLENTIFIN);
            this.add(FOTItems.WILDSPLASH, FOTEntities.WILDSPLASH);
            this.add(FOTItems.DEVILFISH, FOTEntities.DEVILFISH);
            this.add(FOTItems.BATTLEGILL, FOTEntities.BATTLEGILL);
            this.add(FOTItems.WRECKER, FOTEntities.WRECKER);
            this.add(FOTItems.STORMFISH, FOTEntities.STORMFISH);
        }
    }

    private static abstract class FishingRealProvider
    implements DataProvider {
        private final Map<ResourceLocation, FishingRealBuilder> builders = Maps.newLinkedHashMap();
        private final PackOutput output;
        private final CompletableFuture<HolderLookup.Provider> provider;

        public FishingRealProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
            this.output = output;
            this.provider = provider;
        }

        public abstract void addFishingReal();

        public void add(Item item, EntityType<?> entityType) {
            this.add(item, entityType, null);
        }

        public void add(Item item, EntityType<?> entityType, @Nullable CompoundTag compoundTag) {
            FishingRealBuilder builder = new FishingRealBuilder(item, entityType, compoundTag);
            this.builders.put(ForgeRegistries.ENTITY_TYPES.getKey(entityType), builder);
        }

        public CompletableFuture<?> m_213708_(CachedOutput cachedOutput) {
            return this.provider.thenCompose(provider -> {
                this.builders.clear();
                this.addFishingReal();
                return CompletableFuture.allOf((CompletableFuture[])this.builders.entrySet().stream().map(entry -> {
                    JsonObject jsonObject = ((FishingRealBuilder)entry.getValue()).serializeToJson();
                    Path path = this.getPath((ResourceLocation)entry.getKey());
                    return DataProvider.m_253162_((CachedOutput)cachedOutput, (JsonElement)jsonObject, (Path)path);
                }).toArray(CompletableFuture[]::new));
            });
        }

        public String m_6055_() {
            return "FishingReal";
        }

        private Path getPath(ResourceLocation id) {
            return this.output.m_245114_().resolve("data/fishingreal/fishing/" + id.m_135815_() + ".json");
        }

        record FishingRealBuilder(Item item, EntityType<?> entityType, @Nullable CompoundTag compoundTag) {
            public JsonObject serializeToJson() {
                JsonObject jsonObject = new JsonObject();
                JsonObject jsonItem = new JsonObject();
                JsonObject jsonResult = new JsonObject();
                jsonItem.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.item).toString());
                jsonResult.addProperty("id", ForgeRegistries.ENTITY_TYPES.getKey(this.entityType).toString());
                if (this.compoundTag != null) {
                    jsonResult.addProperty("nbt", this.compoundTag.toString());
                }
                jsonObject.add("input", (JsonElement)jsonItem);
                jsonObject.add("result", (JsonElement)jsonResult);
                return jsonObject;
            }
        }
    }
}

