/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.spawn;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.spawn.SpawnConditionContext;
import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;

public final class SpawnSelectors {
    public static Predicate<SpawnConditionContext> always() {
        return context -> true;
    }

    public static Predicate<SpawnConditionContext> dayAndSeeSky() {
        return context -> context.isDay() && context.seeSkyInWater();
    }

    public static Predicate<SpawnConditionContext> nightAndSeeSky() {
        return context -> context.isNight() && context.seeSkyInWater();
    }

    public static Predicate<SpawnConditionContext> rainingAndSeeSky() {
        return context -> context.isRaining() && context.seeSkyInWater();
    }

    public static Predicate<SpawnConditionContext> thunderingAndSeeSky() {
        return context -> context.isRaining() && context.isThundering() && context.seeSkyInWater();
    }

    public static Predicate<SpawnConditionContext> probability(float probability) {
        return context -> context.random().m_188501_() < probability;
    }

    public static Predicate<SpawnConditionContext> simpleSpawn(Predicate<SpawnConditionContext> complex) {
        return SpawnSelectors.simpleSpawn(false, complex);
    }

    public static Predicate<SpawnConditionContext> simpleSpawn(boolean nightTime, Predicate<SpawnConditionContext> complex) {
        return FishOfThieves.CONFIG.general.simpleSpawningCondition ? (nightTime ? SpawnSelectors.nightAndSeeSky() : SpawnSelectors.always()) : complex;
    }

    public static Predicate<SpawnConditionContext> simpleSpawn(float probability, Predicate<SpawnConditionContext> complex) {
        return FishOfThieves.CONFIG.general.simpleSpawningCondition ? SpawnSelectors.probability(probability) : complex;
    }

    public static Predicate<SpawnConditionContext> structureTag(TagKey<Structure> tagKey) {
        return context -> TerrainUtils.isInFeature(context.level(), context.blockPos(), tagKey);
    }

    public static Predicate<SpawnConditionContext> biomeTag(TagKey<Biome> tagKey) {
        return context -> context.biomeTag().m_203656_(tagKey);
    }

    public static Predicate<SpawnConditionContext> continentalness(Continentalness ... continentalnesses) {
        EnumSet<Continentalness> continentalnessSet = EnumSet.noneOf(Continentalness.class);
        Collections.addAll(continentalnessSet, continentalnesses);
        return context -> continentalnessSet.stream().anyMatch(continentalness -> context.continentalness() == continentalness);
    }

    public static SpawnConditionContext get(LivingEntity livingEntity) {
        ServerLevel level = (ServerLevel)livingEntity.m_9236_();
        BlockPos blockPos = livingEntity.m_20183_();
        return new SpawnConditionContext(level, blockPos, livingEntity.m_217043_(), level.m_46461_(), level.m_46462_(), level.m_46471_(), level.m_46470_(), level.m_46861_(blockPos), (Holder<Biome>)level.m_204166_(blockPos), TerrainUtils.getContinentalness(level, blockPos));
    }
}

