/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MaterialCache {
    private static final MaterialCache INSTANCE = new MaterialCache();
    protected final IdentityHashMap<BlockState, ItemStack> buildItemsForStates = new IdentityHashMap();
    protected final IdentityHashMap<BlockState, ItemStack> displayItemsForStates = new IdentityHashMap();
    protected final WorldSchematic tempWorld = SchematicWorldHandler.createSchematicWorld();
    protected final BlockPos checkPos = new BlockPos(8, 0, 8);
    protected boolean hasReadFromFile;
    protected boolean dirty;

    private MaterialCache() {
        WorldUtils.loadChunksSchematicWorld(this.tempWorld, this.checkPos, new Vector3i(1, 1, 1));
    }

    public static MaterialCache getInstance() {
        if (!MaterialCache.INSTANCE.hasReadFromFile) {
            INSTANCE.readFromFile();
        }
        return INSTANCE;
    }

    public void clearCache() {
        this.buildItemsForStates.clear();
    }

    public ItemStack getRequiredBuildItemForState(BlockState state) {
        return this.getRequiredBuildItemForState(state, this.tempWorld, this.checkPos);
    }

    public ItemStack getRequiredBuildItemForState(BlockState state, World world, BlockPos pos) {
        ItemStack stack = this.buildItemsForStates.get(state);
        if (stack == null) {
            stack = this.getItemForStateFromWorld(state, world, pos, true);
        }
        return stack;
    }

    public ItemStack getItemForDisplayNameForState(BlockState state) {
        ItemStack stack = this.displayItemsForStates.get(state);
        if (stack == null) {
            stack = this.getItemForStateFromWorld(state, this.tempWorld, this.checkPos, false);
        }
        return stack;
    }

    protected ItemStack getItemForStateFromWorld(BlockState state, World world, BlockPos pos, boolean isBuildItem) {
        ItemStack stack;
        ItemStack itemStack = stack = isBuildItem ? this.getStateToItemOverride(state) : null;
        if (stack == null) {
            world.func_180501_a(pos, state, 20);
            stack = state.func_177230_c().func_185473_a((IBlockReader)world, pos, state);
        }
        if (stack == null || stack.func_190926_b()) {
            stack = ItemStack.field_190927_a;
        } else {
            this.overrideStackSize(state, stack);
        }
        if (isBuildItem) {
            this.buildItemsForStates.put(state, stack);
        } else {
            this.displayItemsForStates.put(state, stack);
        }
        this.dirty = true;
        return stack;
    }

    public boolean requiresMultipleItems(BlockState state) {
        Block block = state.func_177230_c();
        return block instanceof FlowerPotBlock && block != Blocks.field_150457_bL;
    }

    public ImmutableList<ItemStack> getItems(BlockState state) {
        return this.getItems(state, this.tempWorld, this.checkPos);
    }

    public ImmutableList<ItemStack> getItems(BlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block instanceof FlowerPotBlock && block != Blocks.field_150457_bL) {
            return ImmutableList.of((Object)new ItemStack((IItemProvider)Blocks.field_150457_bL), (Object)block.func_185473_a((IBlockReader)world, pos, state));
        }
        return ImmutableList.of((Object)this.getRequiredBuildItemForState(state, world, pos));
    }

    @Nullable
    protected ItemStack getStateToItemOverride(BlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150332_K || block == Blocks.field_150427_aO || block == Blocks.field_150384_bq || block == Blocks.field_185775_db) {
            return ItemStack.field_190927_a;
        }
        if (block == Blocks.field_150458_ak) {
            return new ItemStack((IItemProvider)Blocks.field_150346_d);
        }
        if (block == Blocks.field_150420_aW) {
            return new ItemStack((IItemProvider)Blocks.field_150420_aW);
        }
        if (block == Blocks.field_150419_aX) {
            return new ItemStack((IItemProvider)Blocks.field_150419_aX);
        }
        if (block == Blocks.field_150353_l) {
            if ((Integer)state.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0) {
                return new ItemStack((IItemProvider)Items.field_151129_at);
            }
            return ItemStack.field_190927_a;
        }
        if (block == Blocks.field_150355_j) {
            if ((Integer)state.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0) {
                return new ItemStack((IItemProvider)Items.field_151131_as);
            }
            return ItemStack.field_190927_a;
        }
        if (block instanceof DoorBlock && state.func_177229_b((Property)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER) {
            return ItemStack.field_190927_a;
        }
        if (block instanceof BedBlock && state.func_177229_b((Property)BedBlock.field_176472_a) == BedPart.HEAD) {
            return ItemStack.field_190927_a;
        }
        if (block instanceof DoublePlantBlock && state.func_177229_b((Property)DoublePlantBlock.field_176492_b) == DoubleBlockHalf.UPPER) {
            return ItemStack.field_190927_a;
        }
        return null;
    }

    protected void overrideStackSize(BlockState state, ItemStack stack) {
        if (state.func_177230_c() instanceof SlabBlock && state.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.DOUBLE) {
            stack.func_190920_e(2);
        } else if (state.func_177230_c() == Blocks.field_150433_aE) {
            stack.func_190920_e(((Integer)state.func_177229_b((Property)SnowBlock.field_176315_a)).intValue());
        }
    }

    protected CompoundNBT writeToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("MaterialCache", (INBT)this.writeMapToNBT(this.buildItemsForStates));
        nbt.func_218657_a("DisplayMaterialCache", (INBT)this.writeMapToNBT(this.displayItemsForStates));
        return nbt;
    }

    protected ListNBT writeMapToNBT(IdentityHashMap<BlockState, ItemStack> map) {
        ListNBT list = new ListNBT();
        for (Map.Entry<BlockState, ItemStack> entry : map.entrySet()) {
            CompoundNBT tag = new CompoundNBT();
            CompoundNBT stateTag = NBTUtil.func_190009_a((BlockState)entry.getKey());
            tag.func_218657_a("Block", (INBT)stateTag);
            tag.func_218657_a("Item", (INBT)entry.getValue().func_77955_b(new CompoundNBT()));
            list.add((Object)tag);
        }
        return list;
    }

    protected void readFromNBT(CompoundNBT nbt) {
        this.buildItemsForStates.clear();
        this.displayItemsForStates.clear();
        this.readMapFromNBT(nbt, "MaterialCache", this.buildItemsForStates);
        this.readMapFromNBT(nbt, "DisplayMaterialCache", this.displayItemsForStates);
    }

    protected void readMapFromNBT(CompoundNBT nbt, String tagName, IdentityHashMap<BlockState, ItemStack> map) {
        if (nbt.func_150297_b(tagName, 9)) {
            ListNBT list = nbt.func_150295_c(tagName, 10);
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                BlockState state;
                CompoundNBT tag = list.func_150305_b(i);
                if (!tag.func_150297_b("Block", 10) || !tag.func_150297_b("Item", 10) || (state = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("Block"))) == null) continue;
                ItemStack stack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Item"));
                this.buildItemsForStates.put(state, stack);
            }
        }
    }

    protected File getCacheDir() {
        return new File(FileUtils.getConfigDirectory(), "litematica");
    }

    protected File getCacheFile() {
        return new File(this.getCacheDir(), "material_cache.nbt");
    }

    public boolean writeToFile() {
        if (!this.dirty) {
            return false;
        }
        File dir = this.getCacheDir();
        File file = this.getCacheFile();
        try {
            if (!dir.exists() && !dir.mkdirs()) {
                Litematica.logger.warn("Failed to write the material list cache to file '{}'", (Object)file.getAbsolutePath());
                return false;
            }
            FileOutputStream os = new FileOutputStream(file);
            CompressedStreamTools.func_74799_a((CompoundNBT)this.writeToNBT(), (OutputStream)os);
            os.close();
            this.dirty = false;
            return true;
        }
        catch (Exception e) {
            Litematica.logger.warn("Failed to write the material list cache to file '{}'", (Object)file.getAbsolutePath(), (Object)e);
            return false;
        }
    }

    public void readFromFile() {
        File file = this.getCacheFile();
        if (!file.exists() || !file.canRead()) {
            return;
        }
        try {
            FileInputStream is = new FileInputStream(file);
            CompoundNBT nbt = CompressedStreamTools.func_74796_a((InputStream)is);
            is.close();
            if (nbt != null) {
                this.readFromNBT(nbt);
                this.hasReadFromFile = true;
                this.dirty = false;
            }
        }
        catch (Exception e) {
            Litematica.logger.warn("Failed to read the material list cache from file '{}'", (Object)file.getAbsolutePath(), (Object)e);
        }
    }
}

