/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.litematica.util.ItemUtils;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.BlockUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class BlockInfo {
    private final String title;
    private final BlockState state;
    private final ItemStack stack;
    private final String blockRegistryname;
    private final String stackName;
    private final List<String> props;
    private final int totalWidth;
    private final int totalHeight;
    private final int columnWidth;

    public BlockInfo(BlockState state, String titleKey) {
        String pre = GuiBase.TXT_WHITE + GuiBase.TXT_BOLD;
        this.title = pre + StringUtils.translate((String)titleKey, (Object[])new Object[0]) + GuiBase.TXT_RST;
        this.state = state;
        this.stack = ItemUtils.getItemForState(this.state);
        ResourceLocation rl = Registry.field_212618_g.func_177774_c((Object)this.state.func_177230_c());
        this.blockRegistryname = rl != null ? rl.toString() : "<null>";
        this.stackName = this.stack.func_200301_q().getString();
        int w = StringUtils.getStringWidth((String)this.stackName) + 20;
        w = Math.max(w, StringUtils.getStringWidth((String)this.blockRegistryname));
        this.columnWidth = w = Math.max(w, StringUtils.getStringWidth((String)this.title));
        this.props = BlockUtils.getFormattedBlockStateProperties((BlockState)this.state, (String)" = ");
        this.totalWidth = this.columnWidth + 40;
        this.totalHeight = this.props.size() * (StringUtils.getFontHeight() + 2) + 60;
    }

    public int getTotalWidth() {
        return this.totalWidth;
    }

    public int getTotalHeight() {
        return this.totalHeight;
    }

    public void render(int x, int y, Minecraft mc, MatrixStack matrixStack) {
        if (this.state != null) {
            RenderSystem.pushMatrix();
            RenderUtils.drawOutlinedBox((int)x, (int)y, (int)this.totalWidth, (int)this.totalHeight, (int)-16777216, (int)-6710887);
            FontRenderer textRenderer = mc.field_71466_p;
            int x1 = x + 10;
            textRenderer.func_238421_b_(matrixStack, this.title, (float)x1, (float)(y += 4), -1);
            RenderSystem.disableLighting();
            RenderUtils.enableDiffuseLightingGui3D();
            RenderUtils.drawRect((int)x1, (int)(y += 12), (int)16, (int)16, (int)0x20FFFFFF);
            mc.func_175599_af().func_239390_c_(this.stack, x1, y);
            mc.func_175599_af().func_180453_a(textRenderer, this.stack, x1, y, null);
            RenderUtils.disableDiffuseLighting();
            textRenderer.func_238421_b_(matrixStack, this.stackName, (float)(x1 + 20), (float)(y + 4), -1);
            textRenderer.func_238421_b_(matrixStack, this.blockRegistryname, (float)x1, (float)(y += 20), -12558081);
            Objects.requireNonNull(textRenderer);
            RenderUtils.renderText((int)x1, (int)(y += 9 + 4), (int)-5197648, this.props, (MatrixStack)matrixStack);
            RenderSystem.popMatrix();
        }
    }
}

