/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.render.shader.ShaderProgram;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.opengl.GL20;

public class LitematicaRenderer {
    private static final LitematicaRenderer INSTANCE = new LitematicaRenderer();
    private static final ShaderProgram SHADER_ALPHA = new ShaderProgram("litematica", null, "shaders/alpha.frag");
    private Minecraft mc;
    private WorldRendererSchematic worldRenderer;
    private ClippingHelper frustum;
    private int frameCount;
    private int originalShaderProgram;
    private float translucencyAlpha;
    private long finishTimeNano;
    private boolean renderCollidingSchematicBlocks;
    private boolean renderPiecewise;
    private boolean renderPiecewiseSchematic;
    private boolean renderPiecewiseBlocks;
    private boolean translucentSchematic;

    private LitematicaRenderer() {
    }

    public static LitematicaRenderer getInstance() {
        return INSTANCE;
    }

    public WorldRendererSchematic getWorldRenderer() {
        if (this.worldRenderer == null) {
            this.mc = Minecraft.func_71410_x();
            this.worldRenderer = new WorldRendererSchematic(this.mc);
        }
        return this.worldRenderer;
    }

    public void loadRenderers() {
        this.getWorldRenderer().loadRenderers();
    }

    public void onSchematicWorldChanged(@Nullable WorldSchematic worldClient) {
        this.getWorldRenderer().setWorldAndLoadRenderers(worldClient);
    }

    private void calculateFinishTime() {
        long fpsTarget = 60L;
        this.finishTimeNano = Configs.Generic.RENDER_THREAD_NO_TIMEOUT.getBooleanValue() ? Long.MAX_VALUE : System.nanoTime() + Math.max(1000000000L / fpsTarget / 2L, 0L);
    }

    public void renderSchematicOverlay(MatrixStack matrices) {
        boolean invert = Hotkeys.INVERT_OVERLAY_RENDER_STATE.getKeybind().isKeybindHeld();
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue() != invert) {
            boolean renderThrough = Configs.Visuals.SCHEMATIC_OVERLAY_RENDER_THROUGH.getBooleanValue() || Hotkeys.RENDER_OVERLAY_THROUGH_BLOCKS.getKeybind().isKeybindHeld();
            float lineWidth = (float)(renderThrough ? Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH_THROUGH.getDoubleValue() : Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH.getDoubleValue());
            RenderSystem.disableTexture();
            RenderSystem.disableCull();
            RenderSystem.alphaFunc((int)516, (float)0.001f);
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)-0.4f, (float)-0.8f);
            RenderSystem.lineWidth((float)lineWidth);
            RenderUtils.setupBlend();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.glMultiTexCoord2f((int)33985, (float)240.0f, (float)240.0f);
            if (renderThrough) {
                RenderSystem.disableDepthTest();
            } else {
                RenderSystem.enableDepthTest();
            }
            this.getWorldRenderer().renderBlockOverlays(matrices, this.getCamera());
            RenderSystem.enableDepthTest();
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
            RenderSystem.enableCull();
            RenderSystem.enableTexture();
        }
    }

    private void setupAlphaShader() {
        this.translucentSchematic = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue();
        if (this.translucentSchematic) {
            this.originalShaderProgram = GlStateManager.func_227612_D_((int)35725);
            this.translucencyAlpha = (float)Configs.Visuals.GHOST_BLOCK_ALPHA.getDoubleValue();
            GlStateManager.func_227723_g_((int)SHADER_ALPHA.getProgram());
            GL20.glUniform1f((int)GlStateManager.func_227680_b_((int)SHADER_ALPHA.getProgram(), (CharSequence)"alpha_multiplier"), (float)this.translucencyAlpha);
        }
    }

    private void enableAlphaShader() {
        if (this.translucentSchematic) {
            GlStateManager.func_227723_g_((int)SHADER_ALPHA.getProgram());
        }
    }

    private void disableAlphaShader() {
        if (this.translucentSchematic) {
            GlStateManager.func_227723_g_((int)this.originalShaderProgram);
        }
    }

    public void piecewisePrepareAndUpdate(ClippingHelper frustum) {
        this.renderPiecewise = Configs.Generic.BETTER_RENDER_ORDER.getBooleanValue() && Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && this.mc.func_175606_aa() != null;
        this.renderPiecewiseSchematic = false;
        this.renderPiecewiseBlocks = false;
        WorldRendererSchematic worldRenderer = this.getWorldRenderer();
        if (this.renderPiecewise && frustum != null && worldRenderer.hasWorld()) {
            boolean invert = Hotkeys.INVERT_GHOST_BLOCK_RENDER_STATE.getKeybind().isKeybindHeld();
            this.renderPiecewiseSchematic = Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue() != invert;
            this.renderPiecewiseBlocks = this.renderPiecewiseSchematic && Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue();
            this.renderCollidingSchematicBlocks = Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue();
            this.mc.func_213239_aq().func_76320_a("litematica_culling");
            this.calculateFinishTime();
            this.mc.func_213239_aq().func_219895_b("litematica_terrain_setup");
            worldRenderer.setupTerrain(this.getCamera(), frustum, this.frameCount++, this.mc.field_71439_g.func_175149_v());
            this.mc.func_213239_aq().func_219895_b("litematica_update_chunks");
            worldRenderer.updateChunks(this.finishTimeNano);
            this.mc.func_213239_aq().func_76319_b();
            this.frustum = frustum;
        }
    }

    public void piecewiseRenderSolid(MatrixStack matrices) {
        if (this.renderPiecewiseBlocks) {
            this.mc.func_213239_aq().func_76320_a("litematica_blocks_solid");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            this.setupAlphaShader();
            this.getWorldRenderer().renderBlockLayer(RenderType.func_228639_c_(), matrices, this.getCamera());
            this.disableAlphaShader();
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.func_213239_aq().func_76319_b();
        }
    }

    public void piecewiseRenderCutoutMipped(MatrixStack matrices) {
        if (this.renderPiecewiseBlocks) {
            this.mc.func_213239_aq().func_76320_a("litematica_blocks_cutout_mipped");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            this.enableAlphaShader();
            this.getWorldRenderer().renderBlockLayer(RenderType.func_228641_d_(), matrices, this.getCamera());
            this.disableAlphaShader();
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.func_213239_aq().func_76319_b();
        }
    }

    public void piecewiseRenderCutout(MatrixStack matrices) {
        if (this.renderPiecewiseBlocks) {
            this.mc.func_213239_aq().func_76320_a("litematica_blocks_cutout");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            this.enableAlphaShader();
            this.getWorldRenderer().renderBlockLayer(RenderType.func_228643_e_(), matrices, this.getCamera());
            this.disableAlphaShader();
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.func_213239_aq().func_76319_b();
        }
    }

    public void piecewiseRenderTranslucent(MatrixStack matrices) {
        if (this.renderPiecewiseBlocks) {
            this.mc.func_213239_aq().func_76320_a("litematica_translucent");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            this.enableAlphaShader();
            this.getWorldRenderer().renderBlockLayer(RenderType.func_228645_f_(), matrices, this.getCamera());
            this.disableAlphaShader();
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.func_213239_aq().func_76319_b();
        }
    }

    public void piecewiseRenderOverlay(MatrixStack matrices) {
        if (this.renderPiecewiseSchematic) {
            Framebuffer fb;
            this.mc.func_213239_aq().func_76320_a("litematica_overlay");
            Framebuffer framebuffer = fb = Minecraft.func_238218_y_() ? this.mc.field_71438_f.func_239228_q_() : null;
            if (fb != null) {
                fb.func_147610_a(false);
            }
            this.renderSchematicOverlay(matrices);
            if (fb != null) {
                this.mc.func_147110_a().func_147610_a(false);
            }
            this.mc.func_213239_aq().func_76319_b();
        }
        this.cleanup();
    }

    public void piecewiseRenderEntities(MatrixStack matrices, float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.func_213239_aq().func_76320_a("litematica_entities");
            RenderUtils.setupBlend();
            this.getWorldRenderer().renderEntities(this.getCamera(), this.frustum, matrices, partialTicks);
            RenderSystem.disableBlend();
            this.mc.func_213239_aq().func_76319_b();
        }
    }

    private ActiveRenderInfo getCamera() {
        return this.mc.field_71460_t.func_215316_n();
    }

    private void cleanup() {
        this.renderPiecewise = false;
        this.renderPiecewiseSchematic = false;
        this.renderPiecewiseBlocks = false;
    }

    static {
        int program = SHADER_ALPHA.getProgram();
        int oldProgram = GlStateManager.func_227612_D_((int)35725);
        GlStateManager.func_227723_g_((int)program);
        GlStateManager.func_227718_f_((int)GlStateManager.func_227680_b_((int)program, (CharSequence)"texture"), (int)0);
        GlStateManager.func_227723_g_((int)oldProgram);
    }
}

