/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import fi.dy.masa.litematica.world.FakeLightingProvider;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.lighting.WorldLightManager;

public class ChunkCacheSchematic
implements IBlockDisplayReader {
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected final ClientWorld worldClient;
    protected final FakeLightingProvider lightingProvider = new FakeLightingProvider();
    protected int chunkStartX;
    protected int chunkStartZ;
    protected Chunk[][] chunkArray;
    protected boolean empty;

    public ChunkCacheSchematic(World worldIn, ClientWorld clientWorld, BlockPos pos, int expand) {
        int cz;
        int cx;
        this.worldClient = clientWorld;
        this.chunkStartX = pos.func_177958_n() - expand >> 4;
        this.chunkStartZ = pos.func_177952_p() - expand >> 4;
        int chunkEndX = pos.func_177958_n() + expand + 15 >> 4;
        int chunkEndZ = pos.func_177952_p() + expand + 15 >> 4;
        this.chunkArray = new Chunk[chunkEndX - this.chunkStartX + 1][chunkEndZ - this.chunkStartZ + 1];
        this.empty = true;
        for (cx = this.chunkStartX; cx <= chunkEndX; ++cx) {
            for (cz = this.chunkStartZ; cz <= chunkEndZ; ++cz) {
                this.chunkArray[cx - this.chunkStartX][cz - this.chunkStartZ] = worldIn.func_212866_a_(cx, cz);
            }
        }
        block2: for (cx = pos.func_177958_n() >> 4; cx <= pos.func_177958_n() + 15 >> 4; ++cx) {
            for (cz = pos.func_177952_p() >> 4; cz <= pos.func_177952_p() + 15 >> 4; ++cz) {
                Chunk chunk = this.chunkArray[cx - this.chunkStartX][cz - this.chunkStartZ];
                if (chunk == null || chunk.func_76606_c(pos.func_177956_o(), pos.func_177956_o() + 15)) continue;
                this.empty = false;
                continue block2;
            }
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public BlockState func_180495_p(BlockPos pos) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            Chunk chunk;
            int cx = (pos.func_177958_n() >> 4) - this.chunkStartX;
            int cz = (pos.func_177952_p() >> 4) - this.chunkStartZ;
            if (cx >= 0 && cx < this.chunkArray.length && cz >= 0 && cz < this.chunkArray[cx].length && (chunk = this.chunkArray[cx][cz]) != null) {
                return chunk.func_180495_p(pos);
            }
        }
        return AIR;
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return this.getBlockEntity(pos, Chunk.CreateEntityType.CHECK);
    }

    @Nullable
    public TileEntity getBlockEntity(BlockPos pos, Chunk.CreateEntityType type) {
        int i = (pos.func_177958_n() >> 4) - this.chunkStartX;
        int j = (pos.func_177952_p() >> 4) - this.chunkStartZ;
        return this.chunkArray[i][j].func_177424_a(pos, type);
    }

    public int func_226658_a_(LightType var1, BlockPos var2) {
        return 15;
    }

    public FluidState func_204610_c(BlockPos pos) {
        return this.func_180495_p(pos).func_204520_s();
    }

    public WorldLightManager func_225524_e_() {
        return this.lightingProvider;
    }

    public int func_225525_a_(BlockPos pos, ColorResolver colorResolver) {
        return colorResolver.getColor(this.worldClient.func_226691_t_(pos), (double)pos.func_177958_n(), (double)pos.func_177952_p());
    }

    public float func_230487_a_(Direction direction, boolean bl) {
        return this.worldClient.func_230487_a_(direction, bl);
    }
}

