/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import fi.dy.masa.litematica.render.schematic.ChunkRendererSchematicVbo;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.tileentity.TileEntity;

public class ChunkRenderDataSchematic {
    public static final ChunkRenderDataSchematic EMPTY = new ChunkRenderDataSchematic(){

        @Override
        public void setBlockLayerUsed(RenderType layer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setBlockLayerStarted(RenderType layer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setOverlayTypeUsed(ChunkRendererSchematicVbo.OverlayRenderType layer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setOverlayTypeStarted(ChunkRendererSchematicVbo.OverlayRenderType layer) {
            throw new UnsupportedOperationException();
        }
    };
    private final Set<RenderType> blockLayersUsed = new ObjectArraySet();
    private final Set<RenderType> blockLayersStarted = new ObjectArraySet();
    private final List<TileEntity> blockEntities = new ArrayList<TileEntity>();
    private final boolean[] overlayLayersUsed = new boolean[ChunkRendererSchematicVbo.OverlayRenderType.values().length];
    private final boolean[] overlayLayersStarted = new boolean[ChunkRendererSchematicVbo.OverlayRenderType.values().length];
    private final Map<RenderType, BufferBuilder.State> blockBufferStates = new HashMap<RenderType, BufferBuilder.State>();
    private final BufferBuilder.State[] overlayBufferStates = new BufferBuilder.State[ChunkRendererSchematicVbo.OverlayRenderType.values().length];
    private boolean overlayEmpty = true;
    private boolean empty = true;
    private long timeBuilt;

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isBlockLayerEmpty(RenderType layer) {
        return !this.blockLayersUsed.contains(layer);
    }

    public void setBlockLayerUsed(RenderType layer) {
        this.blockLayersUsed.add(layer);
        this.empty = false;
    }

    public boolean isBlockLayerStarted(RenderType layer) {
        return this.blockLayersStarted.contains(layer);
    }

    public void setBlockLayerStarted(RenderType layer) {
        this.blockLayersStarted.add(layer);
    }

    public boolean isOverlayEmpty() {
        return this.overlayEmpty;
    }

    protected void setOverlayTypeUsed(ChunkRendererSchematicVbo.OverlayRenderType type) {
        this.overlayEmpty = false;
        this.overlayLayersUsed[type.ordinal()] = true;
    }

    public boolean isOverlayTypeEmpty(ChunkRendererSchematicVbo.OverlayRenderType type) {
        return !this.overlayLayersUsed[type.ordinal()];
    }

    public void setOverlayTypeStarted(ChunkRendererSchematicVbo.OverlayRenderType type) {
        this.overlayLayersStarted[type.ordinal()] = true;
    }

    public boolean isOverlayTypeStarted(ChunkRendererSchematicVbo.OverlayRenderType type) {
        return this.overlayLayersStarted[type.ordinal()];
    }

    public BufferBuilder.State getBlockBufferState(RenderType layer) {
        return this.blockBufferStates.get(layer);
    }

    public void setBlockBufferState(RenderType layer, BufferBuilder.State state) {
        this.blockBufferStates.put(layer, state);
    }

    public BufferBuilder.State getOverlayBufferState(ChunkRendererSchematicVbo.OverlayRenderType type) {
        return this.overlayBufferStates[type.ordinal()];
    }

    public void setOverlayBufferState(ChunkRendererSchematicVbo.OverlayRenderType type, BufferBuilder.State state) {
        this.overlayBufferStates[type.ordinal()] = state;
    }

    public List<TileEntity> getBlockEntities() {
        return this.blockEntities;
    }

    public void addBlockEntity(TileEntity be) {
        this.blockEntities.add(be);
    }

    public long getTimeBuilt() {
        return this.timeBuilt;
    }

    public void setTimeBuilt(long time) {
        this.timeBuilt = time;
    }
}

