/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.schematic.BlockModelRendererSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherLitematica;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRendererSchematicVbo;
import fi.dy.masa.litematica.render.schematic.IChunkRendererFactory;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class WorldRendererSchematic {
    private final Minecraft mc;
    private final EntityRendererManager entityRenderDispatcher;
    private final BlockRendererDispatcher blockRenderManager;
    private final BlockModelRendererSchematic blockModelRenderer;
    private final Set<TileEntity> blockEntities = new HashSet<TileEntity>();
    private final List<ChunkRendererSchematicVbo> renderInfos = new ArrayList<ChunkRendererSchematicVbo>(1024);
    private final RenderTypeBuffers bufferBuilders;
    private Set<ChunkRendererSchematicVbo> chunksToUpdate = new LinkedHashSet<ChunkRendererSchematicVbo>();
    private WorldSchematic world;
    private ChunkRenderDispatcherSchematic chunkRendererDispatcher;
    private double lastCameraChunkUpdateX = Double.MIN_VALUE;
    private double lastCameraChunkUpdateY = Double.MIN_VALUE;
    private double lastCameraChunkUpdateZ = Double.MIN_VALUE;
    private int cameraChunkX = Integer.MIN_VALUE;
    private int cameraChunkY = Integer.MIN_VALUE;
    private int cameraChunkZ = Integer.MIN_VALUE;
    private double lastCameraX = Double.MIN_VALUE;
    private double lastCameraY = Double.MIN_VALUE;
    private double lastCameraZ = Double.MIN_VALUE;
    private float lastCameraPitch = Float.MIN_VALUE;
    private float lastCameraYaw = Float.MIN_VALUE;
    private ChunkRenderDispatcherLitematica renderDispatcher;
    private final IChunkRendererFactory renderChunkFactory;
    private int renderDistanceChunks = -1;
    private int renderEntitiesStartupCounter = 2;
    private int countEntitiesTotal;
    private int countEntitiesRendered;
    private int countEntitiesHidden;
    private double lastTranslucentSortX;
    private double lastTranslucentSortY;
    private double lastTranslucentSortZ;
    private boolean displayListEntitiesDirty = true;

    public WorldRendererSchematic(Minecraft mc) {
        this.mc = mc;
        this.entityRenderDispatcher = mc.func_175598_ae();
        this.bufferBuilders = mc.func_228019_au_();
        this.renderChunkFactory = ChunkRendererSchematicVbo::new;
        this.blockRenderManager = Minecraft.func_71410_x().func_175602_ab();
        this.blockModelRenderer = new BlockModelRendererSchematic(mc.func_184125_al());
    }

    public void markNeedsUpdate() {
        this.displayListEntitiesDirty = true;
    }

    public boolean hasWorld() {
        return this.world != null;
    }

    public String getDebugInfoRenders() {
        int rcTotal = this.chunkRendererDispatcher != null ? this.chunkRendererDispatcher.renderers.length : 0;
        int rcRendered = this.chunkRendererDispatcher != null ? this.getRenderedChunks() : 0;
        return String.format("C: %d/%d %sD: %d, L: %d, %s", rcRendered, rcTotal, this.mc.field_175612_E ? "(s) " : "", this.renderDistanceChunks, 0, this.renderDispatcher == null ? "null" : this.renderDispatcher.getDebugInfo());
    }

    public String getDebugInfoEntities() {
        return "E: " + this.countEntitiesRendered + "/" + this.countEntitiesTotal + ", B: " + this.countEntitiesHidden;
    }

    protected int getRenderedChunks() {
        int count = 0;
        for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
            ChunkRenderDataSchematic data = chunkRenderer.chunkRenderData;
            if (data == ChunkRenderDataSchematic.EMPTY || data.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public void setWorldAndLoadRenderers(@Nullable WorldSchematic worldSchematic) {
        this.lastCameraChunkUpdateX = Double.MIN_VALUE;
        this.lastCameraChunkUpdateY = Double.MIN_VALUE;
        this.lastCameraChunkUpdateZ = Double.MIN_VALUE;
        this.cameraChunkX = Integer.MIN_VALUE;
        this.cameraChunkY = Integer.MIN_VALUE;
        this.cameraChunkZ = Integer.MIN_VALUE;
        this.world = worldSchematic;
        if (worldSchematic != null) {
            this.loadRenderers();
        } else {
            this.chunksToUpdate.clear();
            this.renderInfos.clear();
            if (this.chunkRendererDispatcher != null) {
                this.chunkRendererDispatcher.delete();
                this.chunkRendererDispatcher = null;
            }
            if (this.renderDispatcher != null) {
                this.renderDispatcher.stopWorkerThreads();
            }
            this.renderDispatcher = null;
            this.blockEntities.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRenderers() {
        if (this.hasWorld()) {
            if (this.renderDispatcher == null) {
                this.renderDispatcher = new ChunkRenderDispatcherLitematica();
            }
            this.displayListEntitiesDirty = true;
            this.renderDistanceChunks = this.mc.field_71474_y.field_151451_c;
            if (this.chunkRendererDispatcher != null) {
                this.chunkRendererDispatcher.delete();
            }
            this.stopChunkUpdates();
            Set<TileEntity> set = this.blockEntities;
            synchronized (set) {
                this.blockEntities.clear();
            }
            this.chunkRendererDispatcher = new ChunkRenderDispatcherSchematic(this.world, this.renderDistanceChunks, this, this.renderChunkFactory);
            Entity entity = this.mc.func_175606_aa();
            if (entity != null) {
                this.chunkRendererDispatcher.updateCameraPosition(entity.func_226277_ct_(), entity.func_226281_cx_());
            }
            this.renderEntitiesStartupCounter = 2;
        }
    }

    protected void stopChunkUpdates() {
        this.chunksToUpdate.clear();
        this.renderDispatcher.stopChunkUpdates();
    }

    public void setupTerrain(ActiveRenderInfo camera, ClippingHelper frustum, int frameCount, boolean playerSpectator) {
        Set<ChunkRendererSchematicVbo> set;
        Entity entity;
        this.world.func_217381_Z().func_76320_a("setup_terrain");
        if (this.chunkRendererDispatcher == null || this.mc.field_71474_y.field_151451_c != this.renderDistanceChunks) {
            this.loadRenderers();
        }
        if ((entity = this.mc.func_175606_aa()) == null) {
            entity = this.mc.field_71439_g;
        }
        this.world.func_217381_Z().func_76320_a("camera");
        double entityX = entity.func_226277_ct_();
        double entityY = entity.func_226278_cu_();
        double entityZ = entity.func_226281_cx_();
        double diffX = entityX - this.lastCameraChunkUpdateX;
        double diffY = entityY - this.lastCameraChunkUpdateY;
        double diffZ = entityZ - this.lastCameraChunkUpdateZ;
        if (this.cameraChunkX != entity.field_70176_ah || this.cameraChunkY != entity.field_70162_ai || this.cameraChunkZ != entity.field_70164_aj || diffX * diffX + diffY * diffY + diffZ * diffZ > 16.0) {
            this.lastCameraChunkUpdateX = entityX;
            this.lastCameraChunkUpdateY = entityY;
            this.lastCameraChunkUpdateZ = entityZ;
            this.cameraChunkX = entity.field_70176_ah;
            this.cameraChunkY = entity.field_70162_ai;
            this.cameraChunkZ = entity.field_70164_aj;
            this.chunkRendererDispatcher.updateCameraPosition(entityX, entityZ);
        }
        this.world.func_217381_Z().func_219895_b("renderlist_camera");
        Vector3d cameraPos = camera.func_216785_c();
        double cameraX = cameraPos.field_72450_a;
        double cameraY = cameraPos.field_72448_b;
        double cameraZ = cameraPos.field_72449_c;
        this.renderDispatcher.setCameraPosition(cameraPos);
        this.world.func_217381_Z().func_219895_b("culling");
        BlockPos viewPos = new BlockPos(cameraX, cameraY + (double)entity.func_70047_e(), cameraZ);
        int centerChunkX = viewPos.func_177958_n() >> 4;
        int centerChunkZ = viewPos.func_177952_p() >> 4;
        int renderDistance = this.mc.field_71474_y.field_151451_c;
        SubChunkPos viewSubChunk = new SubChunkPos(centerChunkX, viewPos.func_177956_o() >> 4, centerChunkZ);
        BlockPos viewPosSubChunk = new BlockPos(viewSubChunk.func_177958_n() << 4, viewSubChunk.func_177956_o() << 4, viewSubChunk.func_177952_p() << 4);
        this.displayListEntitiesDirty = this.displayListEntitiesDirty || !this.chunksToUpdate.isEmpty() || entityX != this.lastCameraX || entityY != this.lastCameraY || entityZ != this.lastCameraZ || entity.field_70125_A != this.lastCameraPitch || entity.field_70177_z != this.lastCameraYaw;
        this.lastCameraX = cameraX;
        this.lastCameraY = cameraY;
        this.lastCameraZ = cameraZ;
        this.lastCameraPitch = camera.func_216777_e();
        this.lastCameraYaw = camera.func_216778_f();
        this.world.func_217381_Z().func_219895_b("update");
        if (this.displayListEntitiesDirty) {
            this.world.func_217381_Z().func_76320_a("fetch");
            this.displayListEntitiesDirty = false;
            this.renderInfos.clear();
            set = DataManager.getSchematicPlacementManager().getAllTouchedSubChunks();
            ArrayList<ChunkRendererSchematicVbo> positions = new ArrayList<ChunkRendererSchematicVbo>(set.size());
            positions.addAll(set);
            positions.sort((Comparator<ChunkRendererSchematicVbo>)new SubChunkPos.DistanceComparator(viewSubChunk));
            this.world.func_217381_Z().func_219895_b("iteration");
            for (SubChunkPos subChunkPos : positions) {
                BlockPos subChunkCornerPos;
                ChunkRendererSchematicVbo chunkRenderer;
                if (Math.abs(subChunkPos.func_177958_n() - centerChunkX) > renderDistance || Math.abs(subChunkPos.func_177952_p() - centerChunkZ) > renderDistance || !this.world.getChunkProvider().func_73149_a(subChunkPos.func_177958_n(), subChunkPos.func_177952_p()) || (chunkRenderer = this.chunkRendererDispatcher.getChunkRenderer(subChunkCornerPos = new BlockPos(subChunkPos.func_177958_n() << 4, subChunkPos.func_177956_o() << 4, subChunkPos.func_177952_p() << 4))) == null || !frustum.func_228957_a_(chunkRenderer.getBoundingBox())) continue;
                if (chunkRenderer.needsUpdate() && subChunkCornerPos.equals((Object)viewPosSubChunk)) {
                    chunkRenderer.setNeedsUpdate(true);
                }
                this.renderInfos.add(chunkRenderer);
            }
            this.world.func_217381_Z().func_76319_b();
        }
        this.world.func_217381_Z().func_219895_b("rebuild_near");
        set = this.chunksToUpdate;
        this.chunksToUpdate = new LinkedHashSet<ChunkRendererSchematicVbo>();
        for (ChunkRendererSchematicVbo chunkRendererTmp : this.renderInfos) {
            boolean isNear;
            if (!chunkRendererTmp.needsUpdate() && !set.contains(chunkRendererTmp)) continue;
            this.displayListEntitiesDirty = true;
            BlockPos blockPos = chunkRendererTmp.getOrigin().func_177982_a(8, 8, 8);
            boolean bl = isNear = blockPos.func_177951_i((Vector3i)viewPos) < 1024.0;
            if (!chunkRendererTmp.needsImmediateUpdate() && !isNear) {
                this.chunksToUpdate.add(chunkRendererTmp);
                continue;
            }
            this.world.func_217381_Z().func_76320_a("build_near");
            this.renderDispatcher.updateChunkNow(chunkRendererTmp);
            chunkRendererTmp.clearNeedsUpdate();
            this.world.func_217381_Z().func_76319_b();
        }
        this.chunksToUpdate.addAll(set);
        this.world.func_217381_Z().func_76319_b();
        this.world.func_217381_Z().func_76319_b();
    }

    public void updateChunks(long finishTimeNano) {
        this.displayListEntitiesDirty |= this.renderDispatcher.runChunkUploads(finishTimeNano);
        if (!this.chunksToUpdate.isEmpty()) {
            ChunkRendererSchematicVbo renderChunk;
            boolean flag;
            Iterator<ChunkRendererSchematicVbo> iterator = this.chunksToUpdate.iterator();
            while (iterator.hasNext() && (flag = (renderChunk = iterator.next()).needsImmediateUpdate() ? this.renderDispatcher.updateChunkNow(renderChunk) : this.renderDispatcher.updateChunkLater(renderChunk))) {
                renderChunk.clearNeedsUpdate();
                iterator.remove();
                long i = finishTimeNano - System.nanoTime();
                if (i >= 0L) continue;
                break;
            }
        }
    }

    public int renderBlockLayer(RenderType renderLayer, MatrixStack matrices, ActiveRenderInfo camera) {
        this.world.func_217381_Z().func_76320_a("render_block_layer_" + renderLayer.toString());
        boolean isTranslucent = renderLayer == RenderType.func_228645_f_();
        renderLayer.func_228547_a_();
        Vector3d cameraPos = camera.func_216785_c();
        double x = cameraPos.field_72450_a;
        double y = cameraPos.field_72448_b;
        double z = cameraPos.field_72449_c;
        if (isTranslucent) {
            this.world.func_217381_Z().func_76320_a("translucent_sort");
            double diffX = x - this.lastTranslucentSortX;
            double diffY = y - this.lastTranslucentSortY;
            double diffZ = z - this.lastTranslucentSortZ;
            if (diffX * diffX + diffY * diffY + diffZ * diffZ > 1.0) {
                this.lastTranslucentSortX = x;
                this.lastTranslucentSortY = y;
                this.lastTranslucentSortZ = z;
                int i = 0;
                for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                    if (!chunkRenderer.getChunkRenderData().isBlockLayerStarted(renderLayer) && (chunkRenderer.getChunkRenderData() == ChunkRenderDataSchematic.EMPTY || !chunkRenderer.hasOverlay()) || i++ >= 15) continue;
                    this.renderDispatcher.updateTransparencyLater(chunkRenderer);
                }
            }
            this.world.func_217381_Z().func_76319_b();
        }
        this.world.func_217381_Z().func_76320_a("filter_empty");
        this.world.func_217381_Z().func_219895_b("render");
        boolean reverse = isTranslucent;
        int startIndex = reverse ? this.renderInfos.size() - 1 : 0;
        int stopIndex = reverse ? -1 : this.renderInfos.size();
        int increment = reverse ? -1 : 1;
        int count = 0;
        for (int i = startIndex; i != stopIndex; i += increment) {
            ChunkRendererSchematicVbo renderer = this.renderInfos.get(i);
            if (renderer.getChunkRenderData().isBlockLayerEmpty(renderLayer)) continue;
            BlockPos chunkOrigin = renderer.getOrigin();
            VertexBuffer buffer = renderer.getBlocksVertexBufferByLayer(renderLayer);
            matrices.func_227860_a_();
            matrices.func_227861_a_((double)chunkOrigin.func_177958_n() - x, (double)chunkOrigin.func_177956_o() - y, (double)chunkOrigin.func_177952_p() - z);
            buffer.func_177359_a();
            renderLayer.func_228663_p_().func_227892_a_(0L);
            buffer.func_227874_a_(matrices.func_227866_c_().func_227870_a_(), 7);
            matrices.func_227865_b_();
            ++count;
        }
        VertexBuffer.func_177361_b();
        RenderSystem.clearCurrentColor();
        renderLayer.func_228663_p_().func_227895_d_();
        renderLayer.func_228549_b_();
        this.world.func_217381_Z().func_76319_b();
        this.world.func_217381_Z().func_76319_b();
        return count;
    }

    public void renderBlockOverlays(MatrixStack matrices, ActiveRenderInfo camera) {
        this.renderBlockOverlay(ChunkRendererSchematicVbo.OverlayRenderType.OUTLINE, matrices, camera);
        this.renderBlockOverlay(ChunkRendererSchematicVbo.OverlayRenderType.QUAD, matrices, camera);
    }

    private void renderBlockOverlay(ChunkRendererSchematicVbo.OverlayRenderType type, MatrixStack matrices, ActiveRenderInfo camera) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Vector3d cameraPos = camera.func_216785_c();
        double x = cameraPos.field_72450_a;
        double y = cameraPos.field_72448_b;
        double z = cameraPos.field_72449_c;
        this.world.func_217381_Z().func_76320_a("overlay_" + type.name());
        this.world.func_217381_Z().func_219895_b("render");
        for (int i = this.renderInfos.size() - 1; i >= 0; --i) {
            ChunkRenderDataSchematic compiledChunk;
            ChunkRendererSchematicVbo renderer = this.renderInfos.get(i);
            if (renderer.getChunkRenderData() == ChunkRenderDataSchematic.EMPTY || !renderer.hasOverlay() || (compiledChunk = renderer.getChunkRenderData()).isOverlayTypeEmpty(type)) continue;
            BlockPos chunkOrigin = renderer.getOrigin();
            VertexBuffer buffer = renderer.getOverlayVertexBuffer(type);
            matrices.func_227860_a_();
            matrices.func_227861_a_((double)chunkOrigin.func_177958_n() - x, (double)chunkOrigin.func_177956_o() - y, (double)chunkOrigin.func_177952_p() - z);
            buffer.func_177359_a();
            DefaultVertexFormats.field_181706_f.func_227892_a_(0L);
            buffer.func_227874_a_(matrices.func_227866_c_().func_227870_a_(), type.getGlMode());
            matrices.func_227865_b_();
        }
        VertexBuffer.func_177361_b();
        RenderSystem.clearCurrentColor();
        DefaultVertexFormats.field_181706_f.func_227895_d_();
        RenderSystem.disableBlend();
        this.world.func_217381_Z().func_76319_b();
    }

    public boolean renderBlock(IBlockDisplayReader world, BlockState state, BlockPos pos, MatrixStack matrices, BufferBuilder bufferBuilderIn) {
        try {
            BlockRenderType renderType = state.func_185901_i();
            if (renderType == BlockRenderType.INVISIBLE) {
                return false;
            }
            switch (renderType) {
                case MODEL: {
                    return this.blockModelRenderer.renderModel(world, this.getModelForState(state), state, pos, matrices, (IVertexBuilder)bufferBuilderIn, state.func_209533_a(pos));
                }
                case ENTITYBLOCK_ANIMATED: {
                    return false;
                }
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)pos, (BlockState)state);
            throw new ReportedException(crashreport);
        }
    }

    public boolean renderFluid(IBlockDisplayReader world, FluidState state, BlockPos pos, BufferBuilder bufferBuilderIn) {
        return this.blockRenderManager.func_228794_a_(pos, world, (IVertexBuilder)bufferBuilderIn, state);
    }

    public IBakedModel getModelForState(BlockState state) {
        if (state.func_185901_i() == BlockRenderType.ENTITYBLOCK_ANIMATED) {
            return this.blockRenderManager.func_175023_a().func_178126_b().func_174951_a();
        }
        return this.blockRenderManager.func_184389_a(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderEntities(ActiveRenderInfo camera, ClippingHelper frustum, MatrixStack matrices, float partialTicks) {
        if (this.renderEntitiesStartupCounter > 0) {
            --this.renderEntitiesStartupCounter;
        } else {
            this.world.func_217381_Z().func_76320_a("prepare");
            double cameraX = camera.func_216785_c().field_72450_a;
            double cameraY = camera.func_216785_c().field_72448_b;
            double cameraZ = camera.func_216785_c().field_72449_c;
            TileEntityRendererDispatcher.field_147556_a.func_217665_a((World)this.world, this.mc.func_110434_K(), this.mc.field_71466_p, camera, this.mc.field_71476_x);
            this.entityRenderDispatcher.func_229088_a_((World)this.world, camera, this.mc.field_147125_j);
            this.countEntitiesTotal = 0;
            this.countEntitiesRendered = 0;
            this.countEntitiesHidden = 0;
            this.countEntitiesTotal = this.world.getRegularEntityCount();
            this.world.func_217381_Z().func_219895_b("regular_entities");
            IRenderTypeBuffer.Impl entityVertexConsumers = this.bufferBuilders.func_228487_b_();
            LayerRange layerRange = DataManager.getRenderLayerRange();
            for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                BlockPos pos = chunkRenderer.getOrigin();
                Chunk chunk = this.world.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
                ClassInheritanceMultiMap list = chunk.func_177429_s()[pos.func_177956_o() >> 4];
                if (list.isEmpty()) continue;
                for (Entity entityTmp : list) {
                    boolean shouldRender;
                    if (!layerRange.isPositionWithinRange((int)entityTmp.func_226277_ct_(), (int)entityTmp.func_226278_cu_(), (int)entityTmp.func_226281_cx_()) || !(shouldRender = this.entityRenderDispatcher.func_229086_a_(entityTmp, frustum, cameraX, cameraY, cameraZ))) continue;
                    double x = entityTmp.func_226277_ct_() - cameraX;
                    double y = entityTmp.func_226278_cu_() - cameraY;
                    double z = entityTmp.func_226281_cx_() - cameraZ;
                    this.entityRenderDispatcher.func_229084_a_(entityTmp, x, y, z, entityTmp.field_70177_z, partialTicks, matrices, (IRenderTypeBuffer)entityVertexConsumers, this.entityRenderDispatcher.func_229085_a_(entityTmp, partialTicks));
                    ++this.countEntitiesRendered;
                }
            }
            this.world.func_217381_Z().func_219895_b("block_entities");
            for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                ChunkRenderDataSchematic data = chunkRenderer.getChunkRenderData();
                List<TileEntity> tiles = data.getBlockEntities();
                if (tiles.isEmpty()) continue;
                BlockPos chunkOrigin = chunkRenderer.getOrigin();
                ChunkSchematic chunk = this.world.getChunkProvider().getChunk(chunkOrigin.func_177958_n() >> 4, chunkOrigin.func_177952_p() >> 4);
                if (chunk == null || !(data instanceof ChunkRenderDataSchematic) || data.getTimeBuilt() < chunk.getTimeCreated()) continue;
                for (TileEntity te : tiles) {
                    try {
                        BlockPos pos = te.func_174877_v();
                        matrices.func_227860_a_();
                        matrices.func_227861_a_((double)pos.func_177958_n() - cameraX, (double)pos.func_177956_o() - cameraY, (double)pos.func_177952_p() - cameraZ);
                        TileEntityRendererDispatcher.field_147556_a.func_228850_a_(te, partialTicks, matrices, (IRenderTypeBuffer)entityVertexConsumers);
                        matrices.func_227865_b_();
                    }
                    catch (Exception exception) {}
                }
            }
            Set<TileEntity> set = this.blockEntities;
            synchronized (set) {
                for (TileEntity te : this.blockEntities) {
                    try {
                        BlockPos pos = te.func_174877_v();
                        matrices.func_227860_a_();
                        matrices.func_227861_a_((double)pos.func_177958_n() - cameraX, (double)pos.func_177956_o() - cameraY, (double)pos.func_177952_p() - cameraZ);
                        TileEntityRendererDispatcher.field_147556_a.func_228850_a_(te, partialTicks, matrices, (IRenderTypeBuffer)entityVertexConsumers);
                        matrices.func_227865_b_();
                    }
                    catch (Exception exception) {}
                }
            }
            this.world.func_217381_Z().func_76319_b();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlockEntities(Collection<TileEntity> toRemove, Collection<TileEntity> toAdd) {
        Set<TileEntity> set = this.blockEntities;
        synchronized (set) {
            this.blockEntities.removeAll(toRemove);
            this.blockEntities.addAll(toAdd);
        }
    }

    public void scheduleChunkRenders(int chunkX, int chunkY, int chunkZ) {
        this.chunkRendererDispatcher.scheduleChunkRender(chunkX, chunkY, chunkZ, false);
    }
}

