/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import com.google.common.collect.ArrayListMultimap;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.infohud.IInfoHudRenderer;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public abstract class TaskPasteSchematicPerChunkBase
extends TaskBase
implements IInfoHudRenderer {
    protected final ArrayListMultimap<ChunkPos, IntBoundingBox> boxesInChunks = ArrayListMultimap.create();
    protected final List<ChunkPos> chunks = new ArrayList<ChunkPos>();
    private final HashSet<ChunkPos> individualChunks = new HashSet();
    private final Collection<SchematicPlacement> placements;
    private final LayerRange layerRange;
    protected final PositionUtils.ChunkPosComparator comparator;
    protected final boolean changedBlockOnly;
    protected final ReplaceBehavior replace;

    public TaskPasteSchematicPerChunkBase(Collection<SchematicPlacement> placements, LayerRange range, boolean changedBlocksOnly) {
        this.placements = placements;
        this.layerRange = range;
        this.changedBlockOnly = changedBlocksOnly;
        this.comparator = new PositionUtils.ChunkPosComparator();
        this.comparator.setClosestFirst(true);
        this.replace = (ReplaceBehavior)Configs.Generic.PASTE_REPLACE_BEHAVIOR.getOptionListValue();
        this.name = StringUtils.translate((String)"litematica.gui.label.task_name.paste", (Object[])new Object[0]);
    }

    @Override
    public void init() {
        for (SchematicPlacement placement : this.placements) {
            this.addPlacement(placement, this.layerRange);
        }
        this.chunks.addAll(this.individualChunks);
        this.sortChunkList();
        InfoHud.getInstance().addInfoHudRenderer(this, true);
        this.updateInfoHudLines();
    }

    protected void addPlacement(SchematicPlacement placement, LayerRange range) {
        Set<ChunkPos> touchedChunks = placement.getTouchedChunks();
        for (ChunkPos pos : touchedChunks) {
            int count = 0;
            for (IntBoundingBox box : placement.getBoxesWithinChunk(pos.field_77276_a, pos.field_77275_b).values()) {
                if ((box = this.getClampedBox(box, range)) == null) continue;
                this.boxesInChunks.put((Object)pos, (Object)box);
                ++count;
            }
            if (count <= 0) continue;
            this.individualChunks.add(pos);
            this.onChunkAddedForHandling(pos, placement);
        }
    }

    @Nullable
    public IntBoundingBox getClampedBox(IntBoundingBox box, LayerRange range) {
        return this.getClampedArea(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ, range);
    }

    @Nullable
    public IntBoundingBox getClampedArea(BlockPos posMin, BlockPos posMax, LayerRange range) {
        return this.getClampedArea(posMin.func_177958_n(), posMin.func_177956_o(), posMin.func_177952_p(), posMax.func_177958_n(), posMax.func_177956_o(), posMax.func_177952_p(), range);
    }

    @Nullable
    public IntBoundingBox getClampedArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, LayerRange range) {
        if (!range.intersectsBox(minX, minY, minZ, maxX, maxY, maxZ)) {
            return null;
        }
        switch (range.getAxis()) {
            case X: {
                int clampedMinX = Math.max(minX, range.getLayerMin());
                int clampedMaxX = Math.min(maxX, range.getLayerMax());
                return IntBoundingBox.createProper((int)clampedMinX, (int)minY, (int)minZ, (int)clampedMaxX, (int)maxY, (int)maxZ);
            }
            case Y: {
                int clampedMinY = Math.max(minY, range.getLayerMin());
                int clampedMaxY = Math.min(maxY, range.getLayerMax());
                return IntBoundingBox.createProper((int)minX, (int)clampedMinY, (int)minZ, (int)maxX, (int)clampedMaxY, (int)maxZ);
            }
            case Z: {
                int clampedMinZ = Math.max(minZ, range.getLayerMin());
                int clampedMaxZ = Math.min(maxZ, range.getLayerMax());
                return IntBoundingBox.createProper((int)minX, (int)minY, (int)clampedMinZ, (int)maxX, (int)maxY, (int)clampedMaxZ);
            }
        }
        return null;
    }

    protected void onChunkAddedForHandling(ChunkPos pos, SchematicPlacement placement) {
    }

    @Override
    public boolean canExecute() {
        return !this.chunks.isEmpty() && this.mc.field_71441_e != null && this.mc.field_71439_g != null && SchematicWorldHandler.getSchematicWorld() != null;
    }

    protected boolean canProcessChunk(ChunkPos pos, WorldSchematic worldSchematic, ClientWorld worldClient) {
        if (!worldSchematic.getChunkProvider().func_73149_a(pos.field_77276_a, pos.field_77275_b) || DataManager.getSchematicPlacementManager().hasPendingRebuildFor(pos)) {
            return false;
        }
        return this.areSurroundingChunksLoaded(pos, worldClient, 1);
    }

    protected void sortChunkList() {
        if (this.chunks.size() > 0) {
            if (this.mc.field_71439_g != null) {
                this.comparator.setReferencePosition(this.mc.field_71439_g.func_233580_cy_());
                this.chunks.sort(this.comparator);
            }
            this.onChunkListSorted();
        }
    }

    protected void onChunkListSorted() {
    }

    protected void updateInfoHudLines() {
        ArrayList<String> hudLines = new ArrayList<String>();
        String pre = GuiBase.TXT_WHITE + GuiBase.TXT_BOLD;
        String title = StringUtils.translate((String)"litematica.gui.label.schematic_paste.missing_chunks", (Object[])new Object[]{this.chunks.size()});
        hudLines.add(String.format("%s%s%s", pre, title, GuiBase.TXT_RST));
        int maxLines = Math.min(this.chunks.size(), Configs.InfoOverlays.INFO_HUD_MAX_LINES.getIntegerValue());
        for (int i = 0; i < maxLines; ++i) {
            ChunkPos pos = this.chunks.get(i);
            hudLines.add(String.format("cx: %5d, cz: %5d (x: %d, z: %d)", pos.field_77276_a, pos.field_77275_b, pos.field_77276_a << 4, pos.field_77275_b << 4));
        }
        this.infoHudLines = hudLines;
    }
}

