/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.conversion;

import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.conversion.IBlockReaderWithData;
import fi.dy.masa.litematica.schematic.conversion.SchematicConversionFixers;
import fi.dy.masa.litematica.schematic.conversion.SchematicConversionMaps;
import fi.dy.masa.litematica.schematic.conversion.WallStateFixer;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BannerBlock;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChorusPlantBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.MyceliumBlock;
import net.minecraft.block.NoteBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.block.SkullBlock;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.block.StainedGlassPaneBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.block.TripWireBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.WallBannerBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallSkullBlock;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class SchematicConverter {
    private final IdentityHashMap<Class<? extends Block>, SchematicConversionFixers.IStateFixer> fixersPerBlock = new IdentityHashMap();
    private IdentityHashMap<BlockState, SchematicConversionFixers.IStateFixer> postProcessingStateFixers = new IdentityHashMap();

    private SchematicConverter() {
    }

    public static SchematicConverter createForSchematica() {
        SchematicConverter converter = new SchematicConverter();
        converter.addPostUpdateBlocksSchematica();
        return converter;
    }

    public static SchematicConverter createForLitematica() {
        SchematicConverter converter = new SchematicConverter();
        converter.addPostUpdateBlocksLitematica();
        return converter;
    }

    public boolean getConvertedStatesForBlock(int schematicBlockId, String blockName, BlockState[] paletteOut) {
        int shiftedOldVanillaId = SchematicConversionMaps.getOldNameToShiftedBlockId(blockName);
        int successCount = 0;
        if (shiftedOldVanillaId >= 0) {
            for (int meta = 0; meta < 16; ++meta) {
                BlockState state = SchematicConversionMaps.get_1_13_2_StateForIdMeta(shiftedOldVanillaId & 0xFFF0 | meta);
                if (state == null) continue;
                paletteOut[schematicBlockId << 4 | meta] = state;
                ++successCount;
            }
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Failed to convert block with old name '" + blockName + "'"), (Object[])new Object[0]);
        }
        return successCount > 0;
    }

    public boolean getVanillaBlockPalette(BlockState[] paletteOut) {
        for (int idMeta = 0; idMeta < paletteOut.length; ++idMeta) {
            BlockState state = SchematicConversionMaps.get_1_13_2_StateForIdMeta(idMeta);
            if (state == null) continue;
            paletteOut[idMeta] = state;
        }
        return true;
    }

    public BlockState[] getBlockStatePaletteForBlockPalette(String[] blockPalette) {
        Object[] palette = new BlockState[blockPalette.length * 16];
        Arrays.fill(palette, Blocks.field_150350_a.func_176223_P());
        for (int schematicBlockId = 0; schematicBlockId < blockPalette.length; ++schematicBlockId) {
            String blockName = blockPalette[schematicBlockId];
            this.getConvertedStatesForBlock(schematicBlockId, blockName, (BlockState[])palette);
        }
        return palette;
    }

    public boolean createPostProcessStateFilter(BlockState[] palette) {
        return this.createPostProcessStateFilter(Arrays.asList(palette));
    }

    public boolean createPostProcessStateFilter(Collection<BlockState> palette) {
        boolean needsPostProcess = false;
        this.postProcessingStateFixers.clear();
        for (BlockState state : palette) {
            if (!this.needsPostProcess(state)) continue;
            this.postProcessingStateFixers.put(state, this.getFixerFor(state));
            needsPostProcess = true;
        }
        return needsPostProcess;
    }

    public IdentityHashMap<BlockState, SchematicConversionFixers.IStateFixer> getPostProcessStateFilter() {
        return this.postProcessingStateFixers;
    }

    private boolean needsPostProcess(BlockState state) {
        return !state.func_196958_f() && this.fixersPerBlock.containsKey(state.func_177230_c().getClass());
    }

    @Nullable
    private SchematicConversionFixers.IStateFixer getFixerFor(BlockState state) {
        return this.fixersPerBlock.get(state.func_177230_c().getClass());
    }

    public CompoundNBT fixTileEntityNBT(CompoundNBT tag, BlockState state) {
        return tag;
    }

    public static void postProcessBlocks(LitematicaBlockStateContainer container, @Nullable Map<BlockPos, CompoundNBT> tiles, IdentityHashMap<BlockState, SchematicConversionFixers.IStateFixer> postProcessingFilter) {
        int sizeX = container.getSize().func_177958_n();
        int sizeY = container.getSize().func_177956_o();
        int sizeZ = container.getSize().func_177952_p();
        BlockReaderLitematicaContainer reader = new BlockReaderLitematicaContainer(container, tiles);
        BlockPos.Mutable posMutable = new BlockPos.Mutable();
        for (int y = 0; y < sizeY; ++y) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int x = 0; x < sizeX; ++x) {
                    BlockState state = container.get(x, y, z);
                    SchematicConversionFixers.IStateFixer fixer = postProcessingFilter.get(state);
                    if (fixer == null) continue;
                    posMutable.func_181079_c(x, y, z);
                    BlockState stateFixed = fixer.fixState(reader, state, (BlockPos)posMutable);
                    if (stateFixed == state) continue;
                    container.set(x, y, z, stateFixed);
                }
            }
        }
    }

    private void addPostUpdateBlocksLitematica() {
        this.fixersPerBlock.put(RedstoneWireBlock.class, SchematicConversionFixers.FIXER_REDSTONE_WIRE);
        this.fixersPerBlock.put(WallBlock.class, WallStateFixer.INSTANCE);
        this.fixersPerBlock.put(BannerBlock.class, SchematicConversionFixers.FIXER_BANNER);
        this.fixersPerBlock.put(WallBannerBlock.class, SchematicConversionFixers.FIXER_BANNER_WALL);
        this.fixersPerBlock.put(BedBlock.class, SchematicConversionFixers.FIXER_BED);
        this.fixersPerBlock.put(FlowerPotBlock.class, SchematicConversionFixers.FIXER_FLOWER_POT);
        this.fixersPerBlock.put(NoteBlock.class, SchematicConversionFixers.FIXER_NOTE_BLOCK);
        this.fixersPerBlock.put(SkullBlock.class, SchematicConversionFixers.FIXER_SKULL);
        this.fixersPerBlock.put(WallSkullBlock.class, SchematicConversionFixers.FIXER_SKULL_WALL);
    }

    private void addPostUpdateBlocksSchematica() {
        this.fixersPerBlock.put(ChorusPlantBlock.class, SchematicConversionFixers.FIXER_CHRORUS_PLANT);
        this.fixersPerBlock.put(DoorBlock.class, SchematicConversionFixers.FIXER_DOOR);
        this.fixersPerBlock.put(FenceBlock.class, SchematicConversionFixers.FIXER_FENCE);
        this.fixersPerBlock.put(FenceGateBlock.class, SchematicConversionFixers.FIXER_FENCE_GATE);
        this.fixersPerBlock.put(FireBlock.class, SchematicConversionFixers.FIXER_FIRE);
        this.fixersPerBlock.put(GrassBlock.class, SchematicConversionFixers.FIXER_DIRT_SNOWY);
        this.fixersPerBlock.put(MyceliumBlock.class, SchematicConversionFixers.FIXER_DIRT_SNOWY);
        this.fixersPerBlock.put(PaneBlock.class, SchematicConversionFixers.FIXER_PANE);
        this.fixersPerBlock.put(RepeaterBlock.class, SchematicConversionFixers.FIXER_REDSTONE_REPEATER);
        this.fixersPerBlock.put(RedstoneWireBlock.class, SchematicConversionFixers.FIXER_REDSTONE_WIRE);
        this.fixersPerBlock.put(SnowyDirtBlock.class, SchematicConversionFixers.FIXER_DIRT_SNOWY);
        this.fixersPerBlock.put(StemBlock.class, SchematicConversionFixers.FIXER_STEM);
        this.fixersPerBlock.put(StainedGlassPaneBlock.class, SchematicConversionFixers.FIXER_PANE);
        this.fixersPerBlock.put(StairsBlock.class, SchematicConversionFixers.FIXER_STAIRS);
        this.fixersPerBlock.put(TallFlowerBlock.class, SchematicConversionFixers.FIXER_DOUBLE_PLANT);
        this.fixersPerBlock.put(DoublePlantBlock.class, SchematicConversionFixers.FIXER_DOUBLE_PLANT);
        this.fixersPerBlock.put(TripWireBlock.class, SchematicConversionFixers.FIXER_TRIPWIRE);
        this.fixersPerBlock.put(VineBlock.class, SchematicConversionFixers.FIXER_VINE);
        this.fixersPerBlock.put(WallBlock.class, WallStateFixer.INSTANCE);
        this.fixersPerBlock.put(BannerBlock.class, SchematicConversionFixers.FIXER_BANNER);
        this.fixersPerBlock.put(WallBannerBlock.class, SchematicConversionFixers.FIXER_BANNER_WALL);
        this.fixersPerBlock.put(BedBlock.class, SchematicConversionFixers.FIXER_BED);
        this.fixersPerBlock.put(FlowerPotBlock.class, SchematicConversionFixers.FIXER_FLOWER_POT);
        this.fixersPerBlock.put(NoteBlock.class, SchematicConversionFixers.FIXER_NOTE_BLOCK);
        this.fixersPerBlock.put(SkullBlock.class, SchematicConversionFixers.FIXER_SKULL);
        this.fixersPerBlock.put(WallSkullBlock.class, SchematicConversionFixers.FIXER_SKULL_WALL);
    }

    public static class BlockReaderLitematicaContainer
    implements IBlockReaderWithData {
        private final LitematicaBlockStateContainer container;
        private final Map<BlockPos, CompoundNBT> blockEntityData;
        private final Vector3i size;
        private final BlockState air;

        public BlockReaderLitematicaContainer(LitematicaBlockStateContainer container, @Nullable Map<BlockPos, CompoundNBT> blockEntityData) {
            this.container = container;
            this.blockEntityData = blockEntityData != null ? blockEntityData : new HashMap();
            this.size = container.getSize();
            this.air = Blocks.field_150350_a.func_176223_P();
        }

        public BlockState func_180495_p(BlockPos pos) {
            if (pos.func_177958_n() >= 0 && pos.func_177958_n() < this.size.func_177958_n() && pos.func_177956_o() >= 0 && pos.func_177956_o() < this.size.func_177956_o() && pos.func_177952_p() >= 0 && pos.func_177952_p() < this.size.func_177952_p()) {
                return this.container.get(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return this.air;
        }

        public FluidState func_204610_c(BlockPos pos) {
            return this.func_180495_p(pos).func_204520_s();
        }

        @Nullable
        public TileEntity func_175625_s(BlockPos pos) {
            return null;
        }

        @Override
        @Nullable
        public CompoundNBT getBlockEntityData(BlockPos pos) {
            return this.blockEntityData.get(pos);
        }
    }
}

