/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.verifier;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.infohud.IInfoHudRenderer;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.render.infohud.RenderPhase;
import fi.dy.masa.litematica.scheduler.TaskScheduler;
import fi.dy.masa.litematica.scheduler.tasks.TaskBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.util.BlockInfoListType;
import fi.dy.masa.litematica.util.ItemUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.interfaces.ICompletionListener;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class SchematicVerifier
extends TaskBase
implements IInfoHudRenderer {
    private static final MutablePair<BlockState, BlockState> MUTABLE_PAIR = new MutablePair();
    private static final BlockPos.Mutable MUTABLE_POS = new BlockPos.Mutable();
    private static final List<SchematicVerifier> ACTIVE_VERIFIERS = new ArrayList<SchematicVerifier>();
    private final ArrayListMultimap<Pair<BlockState, BlockState>, BlockPos> missingBlocksPositions = ArrayListMultimap.create();
    private final ArrayListMultimap<Pair<BlockState, BlockState>, BlockPos> extraBlocksPositions = ArrayListMultimap.create();
    private final ArrayListMultimap<Pair<BlockState, BlockState>, BlockPos> wrongBlocksPositions = ArrayListMultimap.create();
    private final ArrayListMultimap<Pair<BlockState, BlockState>, BlockPos> wrongStatesPositions = ArrayListMultimap.create();
    private final Object2IntOpenHashMap<BlockState> correctStateCounts = new Object2IntOpenHashMap();
    private final Object2ObjectOpenHashMap<BlockPos, BlockMismatch> blockMismatches = new Object2ObjectOpenHashMap();
    private final HashSet<Pair<BlockState, BlockState>> ignoredMismatches = new HashSet();
    private final List<BlockPos> missingBlocksPositionsClosest = new ArrayList<BlockPos>();
    private final List<BlockPos> extraBlocksPositionsClosest = new ArrayList<BlockPos>();
    private final List<BlockPos> mismatchedBlocksPositionsClosest = new ArrayList<BlockPos>();
    private final List<BlockPos> mismatchedStatesPositionsClosest = new ArrayList<BlockPos>();
    private final Set<MismatchType> selectedCategories = new HashSet<MismatchType>();
    private final HashMultimap<MismatchType, BlockMismatch> selectedEntries = HashMultimap.create();
    private final Set<ChunkPos> requiredChunks = new HashSet<ChunkPos>();
    private final Set<BlockPos> recheckQueue = new HashSet<BlockPos>();
    private final Minecraft mc = Minecraft.func_71410_x();
    private ClientWorld worldClient;
    private WorldSchematic worldSchematic;
    private SchematicPlacement schematicPlacement;
    private final List<MismatchRenderPos> mismatchPositionsForRender = new ArrayList<MismatchRenderPos>();
    private final List<BlockPos> mismatchBlockPositionsForRender = new ArrayList<BlockPos>();
    private SortCriteria sortCriteria = SortCriteria.NAME_EXPECTED;
    private boolean sortReverse;
    private boolean verificationStarted;
    private boolean verificationActive;
    private boolean shouldRenderInfoHud = true;
    private int totalRequiredChunks;
    private int schematicBlocks;
    private int clientBlocks;
    private int correctStatesCount;

    public SchematicVerifier() {
        this.name = StringUtils.translate((String)"litematica.gui.label.schematic_verifier.verifier", (Object[])new Object[0]);
    }

    public static void clearActiveVerifiers() {
        ACTIVE_VERIFIERS.clear();
    }

    public static void markVerifierBlockChanges(BlockPos pos) {
        for (SchematicVerifier activeVerifier : ACTIVE_VERIFIERS) {
            activeVerifier.markBlockChanged(pos);
        }
    }

    @Override
    public boolean getShouldRenderText(RenderPhase phase) {
        return this.shouldRenderInfoHud && phase == RenderPhase.POST && Configs.InfoOverlays.VERIFIER_OVERLAY_ENABLED.getBooleanValue();
    }

    public void toggleShouldRenderInfoHUD() {
        this.shouldRenderInfoHud = !this.shouldRenderInfoHud;
    }

    public boolean isActive() {
        return this.verificationActive;
    }

    public boolean isPaused() {
        return this.verificationStarted && !this.verificationActive && !this.finished;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public int getTotalChunks() {
        return this.totalRequiredChunks;
    }

    public int getUnseenChunks() {
        return this.requiredChunks.size();
    }

    public int getSchematicTotalBlocks() {
        return this.schematicBlocks;
    }

    public int getRealWorldTotalBlocks() {
        return this.clientBlocks;
    }

    public int getMissingBlocks() {
        return this.missingBlocksPositions.size();
    }

    public int getExtraBlocks() {
        return this.extraBlocksPositions.size();
    }

    public int getMismatchedBlocks() {
        return this.wrongBlocksPositions.size();
    }

    public int getMismatchedStates() {
        return this.wrongStatesPositions.size();
    }

    public int getCorrectStatesCount() {
        return this.correctStatesCount;
    }

    public int getTotalErrors() {
        return this.getMismatchedBlocks() + this.getMismatchedStates() + this.getExtraBlocks() + this.getMissingBlocks();
    }

    public SortCriteria getSortCriteria() {
        return this.sortCriteria;
    }

    public boolean getSortInReverse() {
        return this.sortReverse;
    }

    public void setSortCriteria(SortCriteria criteria) {
        if (this.sortCriteria == criteria) {
            this.sortReverse = !this.sortReverse;
        } else {
            this.sortCriteria = criteria;
            this.sortReverse = criteria != SortCriteria.COUNT;
        }
    }

    public void toggleMismatchCategorySelected(MismatchType type) {
        if (type == MismatchType.CORRECT_STATE) {
            return;
        }
        if (this.selectedCategories.contains((Object)type)) {
            this.selectedCategories.remove((Object)type);
        } else {
            this.selectedCategories.add(type);
            this.removeSelectedEntriesOfType(type);
        }
        this.updateMismatchOverlays();
    }

    public void toggleMismatchEntrySelected(BlockMismatch mismatch) {
        MismatchType type = mismatch.mismatchType;
        if (this.selectedEntries.containsValue((Object)mismatch)) {
            this.selectedEntries.remove((Object)type, (Object)mismatch);
            this.updateMismatchOverlays();
        } else {
            this.selectedCategories.remove((Object)type);
            this.selectedEntries.put((Object)type, (Object)mismatch);
            this.updateMismatchOverlays();
        }
    }

    private void removeSelectedEntriesOfType(MismatchType type) {
        this.selectedEntries.removeAll((Object)type);
    }

    public boolean isMismatchCategorySelected(MismatchType type) {
        return this.selectedCategories.contains((Object)type);
    }

    public boolean isMismatchEntrySelected(BlockMismatch mismatch) {
        return this.selectedEntries.containsValue((Object)mismatch);
    }

    private void clearActiveMismatchRenderPositions() {
        this.mismatchPositionsForRender.clear();
        this.mismatchBlockPositionsForRender.clear();
        this.infoHudLines.clear();
    }

    public List<MismatchRenderPos> getSelectedMismatchPositionsForRender() {
        return this.mismatchPositionsForRender;
    }

    public List<BlockPos> getSelectedMismatchBlockPositionsForRender() {
        return this.mismatchBlockPositionsForRender;
    }

    @Override
    public boolean canExecute() {
        return this.mc.field_71441_e != null;
    }

    @Override
    public boolean shouldRemove() {
        return !this.canExecute();
    }

    @Override
    public boolean execute() {
        this.verifyChunks();
        this.checkChangedPositions();
        return false;
    }

    @Override
    public void stop() {
    }

    public void startVerification(ClientWorld worldClient, WorldSchematic worldSchematic, SchematicPlacement schematicPlacement, ICompletionListener completionListener) {
        this.reset();
        this.worldClient = worldClient;
        this.worldSchematic = worldSchematic;
        this.schematicPlacement = schematicPlacement;
        this.setCompletionListener(completionListener);
        this.requiredChunks.addAll(schematicPlacement.getTouchedChunks());
        this.totalRequiredChunks = this.requiredChunks.size();
        this.verificationStarted = true;
        TaskScheduler.getInstanceClient().scheduleTask(this, 10);
        InfoHud.getInstance().addInfoHudRenderer(this, true);
        ACTIVE_VERIFIERS.add(this);
        this.verificationActive = true;
        this.updateRequiredChunksStringList();
    }

    public void resume() {
        if (this.verificationStarted) {
            this.verificationActive = true;
            this.updateRequiredChunksStringList();
        }
    }

    public void stopVerification() {
        this.verificationActive = false;
    }

    public void reset() {
        this.stopVerification();
        this.clearReferences();
        this.clearData();
    }

    private void clearReferences() {
        this.worldClient = null;
        this.worldSchematic = null;
        this.schematicPlacement = null;
    }

    private void clearData() {
        this.verificationActive = false;
        this.verificationStarted = false;
        this.finished = false;
        this.totalRequiredChunks = 0;
        this.correctStatesCount = 0;
        this.schematicBlocks = 0;
        this.clientBlocks = 0;
        this.requiredChunks.clear();
        this.recheckQueue.clear();
        this.missingBlocksPositions.clear();
        this.extraBlocksPositions.clear();
        this.wrongBlocksPositions.clear();
        this.wrongStatesPositions.clear();
        this.blockMismatches.clear();
        this.correctStateCounts.clear();
        this.selectedCategories.clear();
        this.selectedEntries.clear();
        this.mismatchBlockPositionsForRender.clear();
        this.mismatchPositionsForRender.clear();
        ACTIVE_VERIFIERS.remove(this);
        TaskScheduler.getInstanceClient().removeTask(this);
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        this.clearActiveMismatchRenderPositions();
    }

    public void markBlockChanged(BlockPos pos) {
        BlockMismatch mismatch;
        if (this.finished && (mismatch = (BlockMismatch)this.blockMismatches.get((Object)pos)) != null) {
            this.recheckQueue.add(pos.func_185334_h());
        }
    }

    private void checkChangedPositions() {
        if (this.finished && !this.recheckQueue.isEmpty()) {
            Iterator<BlockPos> iter = this.recheckQueue.iterator();
            while (iter.hasNext()) {
                BlockPos pos = iter.next();
                if (!this.worldClient.func_175667_e(pos) || !this.worldSchematic.func_175667_e(pos)) continue;
                BlockMismatch mismatch = (BlockMismatch)this.blockMismatches.get((Object)pos);
                if (mismatch != null) {
                    this.blockMismatches.remove((Object)pos);
                    BlockState stateFound = this.worldClient.func_180495_p(pos);
                    MUTABLE_PAIR.setLeft((Object)mismatch.stateExpected);
                    MUTABLE_PAIR.setRight((Object)mismatch.stateFound);
                    this.getMapForMismatchType(mismatch.mismatchType).remove(MUTABLE_PAIR, (Object)pos);
                    this.checkBlockStates(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), mismatch.stateExpected, stateFound);
                    if (!stateFound.func_196958_f() && mismatch.stateFound.func_196958_f()) {
                        ++this.clientBlocks;
                    }
                } else {
                    BlockState stateExpected = this.worldSchematic.func_180495_p(pos);
                    BlockState stateFound = this.worldClient.func_180495_p(pos);
                    this.checkBlockStates(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stateExpected, stateFound);
                }
                iter.remove();
            }
            if (this.recheckQueue.isEmpty()) {
                this.updateMismatchOverlays();
            }
        }
    }

    private ArrayListMultimap<Pair<BlockState, BlockState>, BlockPos> getMapForMismatchType(MismatchType mismatchType) {
        switch (mismatchType) {
            case MISSING: {
                return this.missingBlocksPositions;
            }
            case EXTRA: {
                return this.extraBlocksPositions;
            }
            case WRONG_BLOCK: {
                return this.wrongBlocksPositions;
            }
            case WRONG_STATE: {
                return this.wrongStatesPositions;
            }
        }
        return null;
    }

    private boolean verifyChunks() {
        if (this.verificationActive) {
            Iterator<ChunkPos> iter = this.requiredChunks.iterator();
            boolean checkedSome = false;
            while (iter.hasNext() && System.nanoTime() - DataManager.getClientTickStartTime() < 50000000L) {
                ChunkPos pos = iter.next();
                int count = 0;
                for (int cx = pos.field_77276_a - 1; cx <= pos.field_77276_a + 1; ++cx) {
                    for (int cz = pos.field_77275_b - 1; cz <= pos.field_77275_b + 1; ++cz) {
                        if (!WorldUtils.isClientChunkLoaded(this.worldClient, cx, cz)) continue;
                        ++count;
                    }
                }
                if (count != 9 || !this.worldSchematic.getChunkProvider().func_73149_a(pos.field_77276_a, pos.field_77275_b)) continue;
                Chunk chunkClient = this.worldClient.func_212866_a_(pos.field_77276_a, pos.field_77275_b);
                Chunk chunkSchematic = this.worldSchematic.func_212866_a_(pos.field_77276_a, pos.field_77275_b);
                ImmutableMap<String, IntBoundingBox> boxes = this.schematicPlacement.getBoxesWithinChunk(pos.field_77276_a, pos.field_77275_b);
                for (IntBoundingBox box : boxes.values()) {
                    this.verifyChunk((IChunk)chunkClient, (IChunk)chunkSchematic, box);
                }
                iter.remove();
                checkedSome = true;
            }
            if (checkedSome) {
                this.updateRequiredChunksStringList();
            }
            if (this.requiredChunks.isEmpty()) {
                this.verificationActive = false;
                this.verificationStarted = false;
                this.finished = true;
                this.notifyListener();
            }
        }
        return !this.verificationActive;
    }

    public void ignoreStateMismatch(BlockMismatch mismatch) {
        this.ignoreStateMismatch(mismatch, true);
    }

    private void ignoreStateMismatch(BlockMismatch mismatch, boolean updateOverlay) {
        Pair ignore = Pair.of((Object)mismatch.stateExpected, (Object)mismatch.stateFound);
        if (!this.ignoredMismatches.contains(ignore)) {
            this.ignoredMismatches.add((Pair<BlockState, BlockState>)ignore);
            this.getMapForMismatchType(mismatch.mismatchType).removeAll((Object)ignore);
            this.blockMismatches.entrySet().removeIf(entry -> ((BlockMismatch)entry.getValue()).equals(mismatch));
        }
        if (updateOverlay) {
            this.updateMismatchOverlays();
        }
    }

    public void addIgnoredStateMismatches(Collection<BlockMismatch> ignore) {
        for (BlockMismatch mismatch : ignore) {
            this.ignoreStateMismatch(mismatch, false);
        }
        this.updateMismatchOverlays();
    }

    public void resetIgnoredStateMismatches() {
        this.ignoredMismatches.clear();
    }

    public Set<Pair<BlockState, BlockState>> getIgnoredMismatches() {
        return this.ignoredMismatches;
    }

    public Object2IntOpenHashMap<BlockState> getCorrectStates() {
        return this.correctStateCounts;
    }

    @Nullable
    public BlockMismatch getMismatchForPosition(BlockPos pos) {
        return (BlockMismatch)this.blockMismatches.get((Object)pos);
    }

    public List<BlockMismatch> getMismatchOverviewFor(MismatchType type) {
        ArrayList<BlockMismatch> list = new ArrayList<BlockMismatch>();
        if (type == MismatchType.ALL) {
            return this.getMismatchOverviewCombined();
        }
        this.addCountFor(type, this.getMapForMismatchType(type), list);
        return list;
    }

    public List<BlockMismatch> getMismatchOverviewCombined() {
        ArrayList<BlockMismatch> list = new ArrayList<BlockMismatch>();
        this.addCountFor(MismatchType.MISSING, this.missingBlocksPositions, list);
        this.addCountFor(MismatchType.EXTRA, this.extraBlocksPositions, list);
        this.addCountFor(MismatchType.WRONG_BLOCK, this.wrongBlocksPositions, list);
        this.addCountFor(MismatchType.WRONG_STATE, this.wrongStatesPositions, list);
        Collections.sort(list);
        return list;
    }

    private void addCountFor(MismatchType mismatchType, ArrayListMultimap<Pair<BlockState, BlockState>, BlockPos> map, List<BlockMismatch> list) {
        for (Pair pair : map.keySet()) {
            list.add(new BlockMismatch(mismatchType, (BlockState)pair.getLeft(), (BlockState)pair.getRight(), map.get((Object)pair).size()));
        }
    }

    public List<Pair<BlockState, BlockState>> getIgnoredStateMismatchPairs(GuiBase gui) {
        ArrayList list = Lists.newArrayList(this.ignoredMismatches);
        try {
            list.sort((o1, o2) -> {
                String name2;
                String name1 = Registry.field_212618_g.func_177774_c((Object)((BlockState)o1.getLeft()).func_177230_c()).toString();
                int val = name1.compareTo(name2 = Registry.field_212618_g.func_177774_c((Object)((BlockState)o2.getLeft()).func_177230_c()).toString());
                if (val < 0) {
                    return -1;
                }
                if (val > 0) {
                    return 1;
                }
                name1 = Registry.field_212618_g.func_177774_c((Object)((BlockState)o1.getRight()).func_177230_c()).toString();
                name2 = Registry.field_212618_g.func_177774_c((Object)((BlockState)o2.getRight()).func_177230_c()).toString();
                return name1.compareTo(name2);
            });
        }
        catch (Exception e) {
            gui.addMessage(Message.MessageType.ERROR, "litematica.error.generic.failed_to_sort_list_of_ignored_states", new Object[0]);
        }
        return list;
    }

    private boolean verifyChunk(IChunk chunkClient, IChunk chunkSchematic, IntBoundingBox box) {
        LayerRange range = DataManager.getRenderLayerRange();
        Direction.Axis axis = range.getAxis();
        boolean ranged = this.schematicPlacement.getSchematicVerifierType() == BlockInfoListType.RENDER_LAYERS;
        int startX = ranged && axis == Direction.Axis.X ? Math.max(box.minX, range.getLayerMin()) : box.minX;
        int startY = ranged && axis == Direction.Axis.Y ? Math.max(box.minY, range.getLayerMin()) : box.minY;
        int startZ = ranged && axis == Direction.Axis.Z ? Math.max(box.minZ, range.getLayerMin()) : box.minZ;
        int endX = ranged && axis == Direction.Axis.X ? Math.min(box.maxX, range.getLayerMax()) : box.maxX;
        int endY = ranged && axis == Direction.Axis.Y ? Math.min(box.maxY, range.getLayerMax()) : box.maxY;
        int endZ = ranged && axis == Direction.Axis.Z ? Math.min(box.maxZ, range.getLayerMax()) : box.maxZ;
        for (int y = startY; y <= endY; ++y) {
            for (int z = startZ; z <= endZ; ++z) {
                for (int x = startX; x <= endX; ++x) {
                    MUTABLE_POS.func_181079_c(x, y, z);
                    BlockState stateClient = chunkClient.func_180495_p((BlockPos)MUTABLE_POS);
                    BlockState stateSchematic = chunkSchematic.func_180495_p((BlockPos)MUTABLE_POS);
                    this.checkBlockStates(x, y, z, stateSchematic, stateClient);
                    if (!stateSchematic.func_196958_f()) {
                        ++this.schematicBlocks;
                    }
                    if (stateClient.func_196958_f()) continue;
                    ++this.clientBlocks;
                }
            }
        }
        return true;
    }

    private void checkBlockStates(int x, int y, int z, BlockState stateSchematic, BlockState stateClient) {
        BlockPos pos = new BlockPos(x, y, z);
        if (!(stateClient == stateSchematic || stateClient.func_196958_f() && stateSchematic.func_196958_f())) {
            MUTABLE_PAIR.setLeft((Object)stateSchematic);
            MUTABLE_PAIR.setRight((Object)stateClient);
            if (!this.ignoredMismatches.contains(MUTABLE_PAIR)) {
                BlockMismatch mismatch = null;
                if (!stateSchematic.func_196958_f()) {
                    if (stateClient.func_196958_f()) {
                        mismatch = new BlockMismatch(MismatchType.MISSING, stateSchematic, stateClient, 1);
                        this.missingBlocksPositions.put((Object)Pair.of((Object)stateSchematic, (Object)stateClient), (Object)pos);
                    } else if (stateSchematic.func_177230_c() != stateClient.func_177230_c()) {
                        mismatch = new BlockMismatch(MismatchType.WRONG_BLOCK, stateSchematic, stateClient, 1);
                        this.wrongBlocksPositions.put((Object)Pair.of((Object)stateSchematic, (Object)stateClient), (Object)pos);
                    } else {
                        mismatch = new BlockMismatch(MismatchType.WRONG_STATE, stateSchematic, stateClient, 1);
                        this.wrongStatesPositions.put((Object)Pair.of((Object)stateSchematic, (Object)stateClient), (Object)pos);
                    }
                } else if (!Configs.Visuals.IGNORE_EXISTING_FLUIDS.getBooleanValue() || !stateClient.func_185904_a().func_76224_d()) {
                    mismatch = new BlockMismatch(MismatchType.EXTRA, stateSchematic, stateClient, 1);
                    this.extraBlocksPositions.put((Object)Pair.of((Object)stateSchematic, (Object)stateClient), (Object)pos);
                }
                if (mismatch != null) {
                    this.blockMismatches.put((Object)pos, (Object)mismatch);
                    ItemUtils.setItemForBlock((World)this.worldClient, pos, stateClient);
                    ItemUtils.setItemForBlock(this.worldSchematic, pos, stateSchematic);
                }
            }
        } else {
            ItemUtils.setItemForBlock((World)this.worldClient, pos, stateClient);
            this.correctStateCounts.addTo((Object)stateClient, 1);
            if (!stateSchematic.func_196958_f()) {
                ++this.correctStatesCount;
            }
        }
    }

    private void updateMismatchOverlays() {
        if (this.mc.field_71439_g != null) {
            int maxEntries = Configs.InfoOverlays.VERIFIER_ERROR_HILIGHT_MAX_POSITIONS.getIntegerValue();
            BlockPos centerPos = new BlockPos(this.mc.field_71439_g.func_213303_ch());
            this.updateClosestPositions(centerPos, maxEntries);
            this.combineClosestPositions(centerPos, maxEntries);
            if (this.selectedCategories.size() == 1 && this.selectedEntries.size() == 0) {
                MismatchType type = this.mismatchPositionsForRender.size() > 0 ? this.mismatchPositionsForRender.get((int)0).type : null;
                this.updateMismatchPositionStringList(type, this.mismatchPositionsForRender);
            } else {
                this.updateMismatchPositionStringList(null, this.mismatchPositionsForRender);
            }
        }
    }

    private void updateClosestPositions(BlockPos centerPos, int maxEntries) {
        PositionUtils.BLOCK_POS_COMPARATOR.setReferencePosition(centerPos);
        PositionUtils.BLOCK_POS_COMPARATOR.setClosestFirst(true);
        this.addAndSortPositions(MismatchType.WRONG_BLOCK, this.wrongBlocksPositions, this.mismatchedBlocksPositionsClosest, maxEntries);
        this.addAndSortPositions(MismatchType.WRONG_STATE, this.wrongStatesPositions, this.mismatchedStatesPositionsClosest, maxEntries);
        this.addAndSortPositions(MismatchType.EXTRA, this.extraBlocksPositions, this.extraBlocksPositionsClosest, maxEntries);
        this.addAndSortPositions(MismatchType.MISSING, this.missingBlocksPositions, this.missingBlocksPositionsClosest, maxEntries);
    }

    private void addAndSortPositions(MismatchType type, ArrayListMultimap<Pair<BlockState, BlockState>, BlockPos> sourceMap, List<BlockPos> listOut, int maxEntries) {
        listOut.clear();
        if (this.selectedCategories.contains((Object)type)) {
            listOut.addAll(sourceMap.values());
        } else {
            Set mismatches = this.selectedEntries.get((Object)type);
            for (BlockMismatch mismatch : mismatches) {
                MUTABLE_PAIR.setLeft((Object)mismatch.stateExpected);
                MUTABLE_PAIR.setRight((Object)mismatch.stateFound);
                listOut.addAll(sourceMap.get(MUTABLE_PAIR));
            }
        }
        listOut.sort(PositionUtils.BLOCK_POS_COMPARATOR);
    }

    private void combineClosestPositions(BlockPos centerPos, int maxEntries) {
        this.mismatchPositionsForRender.clear();
        this.mismatchBlockPositionsForRender.clear();
        ArrayList<MismatchRenderPos> tempList = new ArrayList<MismatchRenderPos>();
        this.getMismatchRenderPositionFor(MismatchType.WRONG_BLOCK, tempList);
        this.getMismatchRenderPositionFor(MismatchType.WRONG_STATE, tempList);
        this.getMismatchRenderPositionFor(MismatchType.EXTRA, tempList);
        this.getMismatchRenderPositionFor(MismatchType.MISSING, tempList);
        tempList.sort(new RenderPosComparator(centerPos, true));
        int max = Math.min(maxEntries, tempList.size());
        for (int i = 0; i < max; ++i) {
            MismatchRenderPos entry = (MismatchRenderPos)tempList.get(i);
            this.mismatchPositionsForRender.add(entry);
            this.mismatchBlockPositionsForRender.add(entry.pos);
        }
    }

    private void getMismatchRenderPositionFor(MismatchType type, List<MismatchRenderPos> listOut) {
        List<BlockPos> list = this.getClosestMismatchedPositionsFor(type);
        for (BlockPos pos : list) {
            listOut.add(new MismatchRenderPos(type, pos));
        }
    }

    private List<BlockPos> getClosestMismatchedPositionsFor(MismatchType type) {
        switch (type) {
            case MISSING: {
                return this.missingBlocksPositionsClosest;
            }
            case EXTRA: {
                return this.extraBlocksPositionsClosest;
            }
            case WRONG_BLOCK: {
                return this.mismatchedBlocksPositionsClosest;
            }
            case WRONG_STATE: {
                return this.mismatchedStatesPositionsClosest;
            }
        }
        return Collections.emptyList();
    }

    private void updateMismatchPositionStringList(@Nullable MismatchType mismatchType, List<MismatchRenderPos> positionList) {
        ArrayList<String> hudLines = new ArrayList<String>();
        if (!positionList.isEmpty()) {
            String rst = GuiBase.TXT_RST;
            if (mismatchType != null) {
                hudLines.add(String.format("%s%s%s", mismatchType.getFormattingCode(), mismatchType.getDisplayname(), rst));
            } else {
                String title = StringUtils.translate((String)"litematica.gui.title.schematic_verifier_errors", (Object[])new Object[0]);
                hudLines.add(String.format("%s%s%s", GuiBase.TXT_BOLD, title, rst));
            }
            int count = Math.min(positionList.size(), Configs.InfoOverlays.INFO_HUD_MAX_LINES.getIntegerValue());
            for (int i = 0; i < count; ++i) {
                MismatchRenderPos entry = positionList.get(i);
                BlockPos pos = entry.pos;
                String pre = entry.type.getColorCode();
                hudLines.add(String.format("%sx: %5d, y: %3d, z: %5d%s", pre, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), rst));
            }
        }
        this.infoHudLines = hudLines;
    }

    public void updateRequiredChunksStringList() {
        this.updateInfoHudLinesMissingChunks(this.requiredChunks);
    }

    public static enum SortCriteria {
        NAME_EXPECTED,
        NAME_FOUND,
        COUNT;

    }

    public static enum MismatchType {
        ALL(0xFF0000, "litematica.gui.label.schematic_verifier_display_type.all", GuiBase.TXT_WHITE),
        MISSING(65535, "litematica.gui.label.schematic_verifier_display_type.missing", GuiBase.TXT_AQUA),
        EXTRA(0xFF00CF, "litematica.gui.label.schematic_verifier_display_type.extra", GuiBase.TXT_LIGHT_PURPLE),
        WRONG_BLOCK(0xFF0000, "litematica.gui.label.schematic_verifier_display_type.wrong_blocks", GuiBase.TXT_RED),
        WRONG_STATE(0xFFAF00, "litematica.gui.label.schematic_verifier_display_type.wrong_state", GuiBase.TXT_GOLD),
        CORRECT_STATE(0x11FF11, "litematica.gui.label.schematic_verifier_display_type.correct_state", GuiBase.TXT_GREEN);

        private final String unlocName;
        private final String colorCode;
        private final Color4f color;

        private MismatchType(int color, String unlocName, String colorCode) {
            this.color = Color4f.fromColor((int)color, (float)1.0f);
            this.unlocName = unlocName;
            this.colorCode = colorCode;
        }

        public Color4f getColor() {
            return this.color;
        }

        public String getDisplayname() {
            return StringUtils.translate((String)this.unlocName, (Object[])new Object[0]);
        }

        public String getColorCode() {
            return this.colorCode;
        }

        public String getFormattingCode() {
            return this.colorCode + GuiBase.TXT_BOLD;
        }
    }

    public static class BlockMismatch
    implements Comparable<BlockMismatch> {
        public final MismatchType mismatchType;
        public final BlockState stateExpected;
        public final BlockState stateFound;
        public final int count;

        public BlockMismatch(MismatchType mismatchType, BlockState stateExpected, BlockState stateFound, int count) {
            this.mismatchType = mismatchType;
            this.stateExpected = stateExpected;
            this.stateFound = stateFound;
            this.count = count;
        }

        @Override
        public int compareTo(BlockMismatch other) {
            return Integer.compare(other.count, this.count);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mismatchType == null ? 0 : this.mismatchType.hashCode());
            result = 31 * result + (this.stateExpected == null ? 0 : this.stateExpected.hashCode());
            result = 31 * result + (this.stateFound == null ? 0 : this.stateFound.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BlockMismatch other = (BlockMismatch)obj;
            if (this.mismatchType != other.mismatchType) {
                return false;
            }
            if (this.stateExpected == null ? other.stateExpected != null : this.stateExpected != other.stateExpected) {
                return false;
            }
            if (this.stateFound == null) {
                return other.stateFound == null;
            }
            return this.stateFound == other.stateFound;
        }
    }

    public static class MismatchRenderPos {
        public final MismatchType type;
        public final BlockPos pos;

        public MismatchRenderPos(MismatchType type, BlockPos pos) {
            this.type = type;
            this.pos = pos;
        }
    }

    private static class RenderPosComparator
    implements Comparator<MismatchRenderPos> {
        private final BlockPos posReference;
        private final boolean closestFirst;

        public RenderPosComparator(BlockPos posReference, boolean closestFirst) {
            this.posReference = posReference;
            this.closestFirst = closestFirst;
        }

        @Override
        public int compare(MismatchRenderPos pos1, MismatchRenderPos pos2) {
            double dist2;
            double dist1 = pos1.pos.func_177951_i((Vector3i)this.posReference);
            if (dist1 == (dist2 = pos2.pos.func_177951_i((Vector3i)this.posReference))) {
                return 0;
            }
            return dist1 < dist2 == this.closestFirst ? -1 : 1;
        }
    }
}

