/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.util.ItemUtils;
import fi.dy.masa.malilib.gui.GuiBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class InventoryUtils {
    private static final List<Integer> PICK_BLOCKABLE_SLOTS = new ArrayList<Integer>();
    private static int nextPickSlotIndex;

    public static void setPickBlockableSlots(String configStr) {
        String[] parts;
        PICK_BLOCKABLE_SLOTS.clear();
        for (String str : parts = configStr.split(",")) {
            try {
                int slotNum = Integer.parseInt(str);
                if (!PlayerInventory.func_184435_e((int)slotNum) || PICK_BLOCKABLE_SLOTS.contains(slotNum)) continue;
                PICK_BLOCKABLE_SLOTS.add(slotNum);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static void setPickedItemToHand(ItemStack stack, Minecraft mc) {
        int slotNum = mc.field_71439_g.field_71071_by.func_184429_b(stack);
        InventoryUtils.setPickedItemToHand(slotNum, stack, mc);
    }

    public static void setPickedItemToHand(int sourceSlot, ItemStack stack, Minecraft mc) {
        ClientPlayerEntity player = mc.field_71439_g;
        if (PlayerInventory.func_184435_e((int)sourceSlot)) {
            player.field_71071_by.field_70461_c = sourceSlot;
        } else {
            if (PICK_BLOCKABLE_SLOTS.size() == 0) {
                return;
            }
            int hotbarSlot = sourceSlot;
            if (sourceSlot == -1 || !PlayerInventory.func_184435_e((int)sourceSlot)) {
                hotbarSlot = InventoryUtils.getEmptyPickBlockableHotbarSlot(player.field_71071_by);
            }
            if (hotbarSlot == -1) {
                hotbarSlot = InventoryUtils.getPickBlockTargetSlot((PlayerEntity)player);
            }
            if (hotbarSlot != -1) {
                PlayerInventory inventory = player.field_71071_by;
                inventory.field_70461_c = hotbarSlot;
                if (player.field_71075_bZ.field_75098_d) {
                    inventory.field_70462_a.set(hotbarSlot, (Object)stack.func_77946_l());
                } else {
                    fi.dy.masa.malilib.util.InventoryUtils.swapItemToMainHand((ItemStack)stack.func_77946_l(), (Minecraft)mc);
                }
            }
        }
    }

    public static void schematicWorldPickBlock(ItemStack stack, BlockPos pos, World schematicWorld, Minecraft mc) {
        if (!stack.func_190926_b()) {
            PlayerInventory inv = mc.field_71439_g.field_71071_by;
            stack = stack.func_77946_l();
            if (mc.field_71439_g.field_71075_bZ.field_75098_d) {
                TileEntity te = schematicWorld.func_175625_s(pos);
                if (GuiBase.isCtrlDown() && te != null && mc.field_71441_e.func_175623_d(pos)) {
                    ItemUtils.storeTEInStack(stack, te);
                }
                InventoryUtils.setPickedItemToHand(stack, mc);
                mc.field_71442_b.func_78761_a(mc.field_71439_g.func_184586_b(Hand.MAIN_HAND), 36 + inv.field_70461_c);
            } else {
                boolean shouldPick;
                int slot = inv.func_184429_b(stack);
                boolean bl = shouldPick = inv.field_70461_c != slot;
                if (shouldPick && slot != -1) {
                    InventoryUtils.setPickedItemToHand(stack, mc);
                } else if (slot == -1 && Configs.Generic.PICK_BLOCK_SHULKERS.getBooleanValue() && (slot = InventoryUtils.findSlotWithBoxWithItem((Container)mc.field_71439_g.field_71069_bz, stack, false)) != -1) {
                    ItemStack boxStack = ((Slot)mc.field_71439_g.field_71069_bz.field_75151_b.get(slot)).func_75211_c();
                    InventoryUtils.setPickedItemToHand(boxStack, mc);
                }
            }
        }
    }

    private static int getPickBlockTargetSlot(PlayerEntity player) {
        int slotNum;
        if (PICK_BLOCKABLE_SLOTS.contains(player.field_71071_by.field_70461_c + 1)) {
            slotNum = player.field_71071_by.field_70461_c;
        } else {
            if (nextPickSlotIndex >= PICK_BLOCKABLE_SLOTS.size()) {
                nextPickSlotIndex = 0;
            }
            slotNum = PICK_BLOCKABLE_SLOTS.get(nextPickSlotIndex) - 1;
            if (++nextPickSlotIndex >= PICK_BLOCKABLE_SLOTS.size()) {
                nextPickSlotIndex = 0;
            }
        }
        return slotNum;
    }

    private static int getEmptyPickBlockableHotbarSlot(PlayerInventory inventory) {
        for (Integer pickBlockableSlot : PICK_BLOCKABLE_SLOTS) {
            ItemStack stack;
            int slotNum = pickBlockableSlot - 1;
            if (slotNum < 0 || slotNum >= inventory.field_70462_a.size() || !(stack = (ItemStack)inventory.field_70462_a.get(slotNum)).func_190926_b()) continue;
            return slotNum;
        }
        return -1;
    }

    public static boolean doesShulkerBoxContainItem(ItemStack stack, ItemStack referenceItem) {
        NonNullList items = fi.dy.masa.malilib.util.InventoryUtils.getStoredItems((ItemStack)stack);
        if (items.size() > 0) {
            for (ItemStack item : items) {
                if (!fi.dy.masa.malilib.util.InventoryUtils.areStacksEqual((ItemStack)item, (ItemStack)referenceItem)) continue;
                return true;
            }
        }
        return false;
    }

    public static int findSlotWithBoxWithItem(Container container, ItemStack stackReference, boolean reverse) {
        int startSlot = reverse ? container.field_75151_b.size() - 1 : 0;
        int endSlot = reverse ? -1 : container.field_75151_b.size();
        int increment = reverse ? -1 : 1;
        boolean isPlayerInv = container instanceof PlayerContainer;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            Slot slot = (Slot)container.field_75151_b.get(slotNum);
            if (isPlayerInv && !fi.dy.masa.malilib.util.InventoryUtils.isRegularInventorySlot((int)slot.field_75222_d, (boolean)false) || !InventoryUtils.doesShulkerBoxContainItem(slot.func_75211_c(), stackReference)) continue;
            return slot.field_75222_d;
        }
        return -1;
    }
}

