/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import java.util.HashSet;
import java.util.IdentityHashMap;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ItemUtils {
    private static final IdentityHashMap<BlockState, ItemStack> ITEMS_FOR_STATES = new IdentityHashMap();

    public static boolean areTagsEqualIgnoreDamage(ItemStack stackReference, ItemStack stackToCheck) {
        CompoundNBT tagReference = stackReference.func_77978_p();
        CompoundNBT tagToCheck = stackToCheck.func_77978_p();
        if (tagReference != null && tagToCheck != null) {
            HashSet keysReference = new HashSet(tagReference.func_150296_c());
            for (String key : keysReference) {
                if (key.equals("Damage") || tagReference.func_74781_a(key).equals(tagToCheck.func_74781_a(key))) continue;
                return false;
            }
            return true;
        }
        return tagReference == null && tagToCheck == null;
    }

    public static ItemStack getItemForState(BlockState state) {
        ItemStack stack = ITEMS_FOR_STATES.get(state);
        return stack != null ? stack : ItemStack.field_190927_a;
    }

    public static void setItemForBlock(World world, BlockPos pos, BlockState state) {
        if (!ITEMS_FOR_STATES.containsKey(state)) {
            ITEMS_FOR_STATES.put(state, ItemUtils.getItemForBlock(world, pos, state, false));
        }
    }

    public static ItemStack getItemForBlock(World world, BlockPos pos, BlockState state, boolean checkCache) {
        ItemStack stack;
        if (checkCache && (stack = ITEMS_FOR_STATES.get(state)) != null) {
            return stack;
        }
        if (state.func_196958_f()) {
            return ItemStack.field_190927_a;
        }
        stack = ItemUtils.getStateToItemOverride(state);
        if (stack.func_190926_b()) {
            stack = state.func_177230_c().func_185473_a((IBlockReader)world, pos, state);
        }
        if (stack.func_190926_b()) {
            stack = ItemStack.field_190927_a;
        } else {
            ItemUtils.overrideStackSize(state, stack);
        }
        ITEMS_FOR_STATES.put(state, stack);
        return stack;
    }

    public static ItemStack getStateToItemOverride(BlockState state) {
        if (state.func_177230_c() == Blocks.field_150353_l) {
            return new ItemStack((IItemProvider)Items.field_151129_at);
        }
        if (state.func_177230_c() == Blocks.field_150355_j) {
            return new ItemStack((IItemProvider)Items.field_151131_as);
        }
        return ItemStack.field_190927_a;
    }

    private static void overrideStackSize(BlockState state, ItemStack stack) {
        if (state.func_177230_c() instanceof SlabBlock && state.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.DOUBLE) {
            stack.func_190920_e(2);
        }
    }

    public static ItemStack storeTEInStack(ItemStack stack, TileEntity te) {
        CompoundNBT nbt = te.func_189515_b(new CompoundNBT());
        if (nbt.func_74764_b("Owner") && stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() instanceof AbstractSkullBlock) {
            CompoundNBT tagOwner = nbt.func_74775_l("Owner");
            CompoundNBT tagSkull = new CompoundNBT();
            tagSkull.func_218657_a("SkullOwner", (INBT)tagOwner);
            stack.func_77982_d(tagSkull);
            return stack;
        }
        CompoundNBT tagLore = new CompoundNBT();
        ListNBT tagList = new ListNBT();
        tagList.add((Object)StringNBT.func_229705_a_((String)"(+NBT)"));
        tagLore.func_218657_a("Lore", (INBT)tagList);
        stack.func_77983_a("display", (INBT)tagLore);
        stack.func_77983_a("BlockEntityTag", (INBT)nbt);
        return stack;
    }

    public static String getStackString(ItemStack stack) {
        if (!stack.func_190926_b()) {
            ResourceLocation rl = Registry.field_212630_s.func_177774_c((Object)stack.func_77973_b());
            return String.format("[%s - display: %s - NBT: %s] (%s)", rl != null ? rl.toString() : "null", stack.func_200301_q().getString(), stack.func_77978_p() != null ? stack.func_77978_p().toString() : "<no NBT>", stack);
        }
        return "<empty>";
    }
}

