/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class SchematicPlacingUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean placeToWorldWithinChunk(World world, ChunkPos chunkPos, SchematicPlacement schematicPlacement, ReplaceBehavior replace, boolean notifyNeighbors) {
        LitematicaSchematic schematic = schematicPlacement.getSchematic();
        Set<String> regionsTouchingChunk = schematicPlacement.getRegionsTouchingChunk(chunkPos.field_77276_a, chunkPos.field_77275_b);
        BlockPos origin = schematicPlacement.getOrigin();
        boolean allSuccess = true;
        try {
            if (!notifyNeighbors) {
                WorldUtils.setShouldPreventBlockUpdates(world, true);
            }
            for (String regionName : regionsTouchingChunk) {
                LitematicaBlockStateContainer container = schematic.getSubRegionContainer(regionName);
                if (container == null) {
                    allSuccess = false;
                    continue;
                }
                SubRegionPlacement placement = schematicPlacement.getRelativeSubRegionPlacement(regionName);
                if (!placement.isEnabled()) continue;
                Map<BlockPos, CompoundNBT> blockEntityMap = schematic.getBlockEntityMapForRegion(regionName);
                if (!SchematicPlacingUtils.placeBlocksWithinChunk(world, chunkPos, regionName, container, blockEntityMap, origin, schematicPlacement, placement, replace, notifyNeighbors)) {
                    allSuccess = false;
                    Litematica.logger.warn("Invalid/missing schematic data in schematic '{}' for sub-region '{}'", (Object)schematic.getMetadata().getName(), (Object)regionName);
                }
                List<LitematicaSchematic.EntityInfo> entityList = schematic.getEntityListForRegion(regionName);
                if (schematicPlacement.ignoreEntities() || placement.ignoreEntities() || entityList == null) continue;
                SchematicPlacingUtils.placeEntitiesToWorldWithinChunk(world, chunkPos, entityList, origin, schematicPlacement, placement);
            }
        }
        finally {
            WorldUtils.setShouldPreventBlockUpdates(world, false);
        }
        return allSuccess;
    }

    public static boolean placeBlocksWithinChunk(World world, ChunkPos chunkPos, String regionName, LitematicaBlockStateContainer container, Map<BlockPos, CompoundNBT> blockEntityMap, BlockPos origin, SchematicPlacement schematicPlacement, SubRegionPlacement placement, ReplaceBehavior replace, boolean notifyNeighbors) {
        int x;
        int z;
        int y;
        IntBoundingBox bounds = schematicPlacement.getBoxWithinChunkForRegion(regionName, chunkPos.field_77276_a, chunkPos.field_77275_b);
        BlockPos regionSize = schematicPlacement.getSchematic().getAreaSize(regionName);
        if (bounds == null || container == null || blockEntityMap == null || regionSize == null) {
            return false;
        }
        BlockPos regionPos = placement.getPos();
        BlockPos posEndRel = new BlockPos((Vector3i)PositionUtils.getRelativeEndPositionFromAreaSize((Vector3i)regionSize)).func_177971_a((Vector3i)regionPos);
        BlockPos posMinRel = PositionUtils.getMinCorner(regionPos, posEndRel);
        BlockPos regionPosTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        BlockPos boxMinRel = new BlockPos(bounds.minX - origin.func_177958_n() - regionPosTransformed.func_177958_n(), 0, bounds.minZ - origin.func_177952_p() - regionPosTransformed.func_177952_p());
        BlockPos boxMaxRel = new BlockPos(bounds.maxX - origin.func_177958_n() - regionPosTransformed.func_177958_n(), 0, bounds.maxZ - origin.func_177952_p() - regionPosTransformed.func_177952_p());
        boxMinRel = PositionUtils.getReverseTransformedBlockPos(boxMinRel, placement.getMirror(), placement.getRotation());
        boxMaxRel = PositionUtils.getReverseTransformedBlockPos(boxMaxRel, placement.getMirror(), placement.getRotation());
        boxMinRel = PositionUtils.getReverseTransformedBlockPos(boxMinRel, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        boxMaxRel = PositionUtils.getReverseTransformedBlockPos(boxMaxRel, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        boxMinRel = boxMinRel.func_177973_b((Vector3i)posMinRel.func_177973_b((Vector3i)regionPos));
        boxMaxRel = boxMaxRel.func_177973_b((Vector3i)posMinRel.func_177973_b((Vector3i)regionPos));
        BlockPos posMin = PositionUtils.getMinCorner(boxMinRel, boxMaxRel);
        BlockPos posMax = PositionUtils.getMaxCorner(boxMinRel, boxMaxRel);
        int startX = posMin.func_177958_n();
        int startZ = posMin.func_177952_p();
        int endX = posMax.func_177958_n();
        int endZ = posMax.func_177952_p();
        boolean startY = false;
        int endY = Math.abs(regionSize.func_177956_o()) - 1;
        BlockPos.Mutable posMutable = new BlockPos.Mutable();
        if (startX < 0 || startZ < 0 || endX >= container.getSize().func_177958_n() || endZ >= container.getSize().func_177952_p()) {
            System.out.printf("DEBUG ============= OUT OF BOUNDS - region: %s, sx: %d, sz: %d, ex: %d, ez: %d - size x: %d z: %d =============\n", regionName, startX, startZ, endX, endZ, container.getSize().func_177958_n(), container.getSize().func_177952_p());
            return false;
        }
        Rotation rotationCombined = schematicPlacement.getRotation().func_185830_a(placement.getRotation());
        Mirror mirrorMain = schematicPlacement.getMirror();
        BlockState barrier = Blocks.field_180401_cv.func_176223_P();
        Mirror mirrorSub = placement.getMirror();
        boolean ignoreInventories = Configs.Generic.PASTE_IGNORE_INVENTORY.getBooleanValue();
        if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
            mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        }
        for (y = 0; y <= endY; ++y) {
            for (z = startZ; z <= endZ; ++z) {
                for (x = startX; x <= endX; ++x) {
                    TileEntity te;
                    BlockState state = container.get(x, y, z);
                    if (state.func_177230_c() == Blocks.field_189881_dj) continue;
                    posMutable.func_181079_c(x, y, z);
                    CompoundNBT teNBT = blockEntityMap.get(posMutable);
                    posMutable.func_181079_c(posMinRel.func_177958_n() + x - regionPos.func_177958_n(), posMinRel.func_177956_o() + y - regionPos.func_177956_o(), posMinRel.func_177952_p() + z - regionPos.func_177952_p());
                    BlockPos pos = PositionUtils.getTransformedPlacementPosition((BlockPos)posMutable, schematicPlacement, placement);
                    pos = pos.func_177971_a((Vector3i)regionPosTransformed).func_177971_a((Vector3i)origin);
                    BlockState stateOld = world.func_180495_p(pos);
                    if (replace == ReplaceBehavior.NONE && stateOld.func_185904_a() != Material.field_151579_a || replace == ReplaceBehavior.WITH_NON_AIR && state.func_185904_a() == Material.field_151579_a) continue;
                    if (mirrorMain != Mirror.NONE) {
                        state = state.func_185902_a(mirrorMain);
                    }
                    if (mirrorSub != Mirror.NONE) {
                        state = state.func_185902_a(mirrorSub);
                    }
                    if (rotationCombined != Rotation.NONE) {
                        state = state.func_185907_a(rotationCombined);
                    }
                    if ((te = world.func_175625_s(pos)) != null) {
                        if (te instanceof IInventory) {
                            ((IInventory)te).func_174888_l();
                        }
                        world.func_180501_a(pos, barrier, 20);
                    }
                    if (!world.func_180501_a(pos, state, 18) || teNBT == null || (te = world.func_175625_s(pos)) == null) continue;
                    teNBT = teNBT.func_74737_b();
                    teNBT.func_74768_a("x", pos.func_177958_n());
                    teNBT.func_74768_a("y", pos.func_177956_o());
                    teNBT.func_74768_a("z", pos.func_177952_p());
                    if (ignoreInventories) {
                        teNBT.func_82580_o("Items");
                    }
                    try {
                        te.func_230337_a_(state, teNBT);
                        if (!ignoreInventories || !(te instanceof IInventory)) continue;
                        ((IInventory)te).func_174888_l();
                        continue;
                    }
                    catch (Exception e) {
                        Litematica.logger.warn("Failed to load BlockEntity data for {} @ {}", (Object)state, (Object)pos);
                    }
                }
            }
        }
        if (notifyNeighbors) {
            for (y = 0; y <= endY; ++y) {
                for (z = startZ; z <= endZ; ++z) {
                    for (x = startX; x <= endX; ++x) {
                        posMutable.func_181079_c(posMinRel.func_177958_n() + x - regionPos.func_177958_n(), posMinRel.func_177956_o() + y - regionPos.func_177956_o(), posMinRel.func_177952_p() + z - regionPos.func_177952_p());
                        BlockPos pos = PositionUtils.getTransformedPlacementPosition((BlockPos)posMutable, schematicPlacement, placement).func_177971_a((Vector3i)origin);
                        world.func_230547_a_(pos, world.func_180495_p(pos).func_177230_c());
                    }
                }
            }
        }
        return true;
    }

    public static void placeEntitiesToWorldWithinChunk(World world, ChunkPos chunkPos, List<LitematicaSchematic.EntityInfo> entityList, BlockPos origin, SchematicPlacement schematicPlacement, SubRegionPlacement placement) {
        BlockPos regionPos = placement.getPos();
        if (entityList == null) {
            return;
        }
        BlockPos regionPosRelTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        int offX = regionPosRelTransformed.func_177958_n() + origin.func_177958_n();
        int offY = regionPosRelTransformed.func_177956_o() + origin.func_177956_o();
        int offZ = regionPosRelTransformed.func_177952_p() + origin.func_177952_p();
        double minX = chunkPos.field_77276_a << 4;
        double minZ = chunkPos.field_77275_b << 4;
        double maxX = (chunkPos.field_77276_a << 4) + 16;
        double maxZ = (chunkPos.field_77275_b << 4) + 16;
        Rotation rotationCombined = schematicPlacement.getRotation().func_185830_a(placement.getRotation());
        Mirror mirrorMain = schematicPlacement.getMirror();
        Mirror mirrorSub = placement.getMirror();
        if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
            mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        }
        for (LitematicaSchematic.EntityInfo info : entityList) {
            Entity entity = EntityUtils.createEntityAndPassengersFromNBT(info.nbt, world);
            if (entity == null) continue;
            Vector3d pos = info.posVec;
            pos = PositionUtils.getTransformedPosition(pos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
            pos = PositionUtils.getTransformedPosition(pos, placement.getMirror(), placement.getRotation());
            double x = pos.field_72450_a + (double)offX;
            double y = pos.field_72448_b + (double)offY;
            double z = pos.field_72449_c + (double)offZ;
            if (!(x >= minX) || !(x < maxX) || !(z >= minZ) || !(z < maxZ)) continue;
            SchematicPlacingUtils.rotateEntity(entity, x, y, z, rotationCombined, mirrorMain, mirrorSub);
            EntityUtils.spawnEntityAndPassengersInWorld(entity, world);
        }
    }

    public static void rotateEntity(Entity entity, double x, double y, double z, Rotation rotationCombined, Mirror mirrorMain, Mirror mirrorSub) {
        float rotationYaw = entity.field_70177_z;
        if (mirrorMain != Mirror.NONE) {
            rotationYaw = entity.func_184217_a(mirrorMain);
        }
        if (mirrorSub != Mirror.NONE) {
            rotationYaw = entity.func_184217_a(mirrorSub);
        }
        if (rotationCombined != Rotation.NONE) {
            rotationYaw += entity.field_70177_z - entity.func_184229_a(rotationCombined);
        }
        entity.func_70012_b(x, y, z, rotationYaw, entity.field_70125_A);
        EntityUtils.setEntityRotations(entity, rotationYaw, entity.field_70125_A);
    }
}

