/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.interfaces.IRangeChangeListener;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class SchematicWorldRefresher
implements IRangeChangeListener {
    public static final SchematicWorldRefresher INSTANCE = new SchematicWorldRefresher();
    private final Minecraft mc = Minecraft.func_71410_x();

    public void updateAll() {
        this.updateBetweenY(0, 255);
    }

    public void updateBetweenX(int minX, int maxX) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null) {
            int xMin = Math.min(minX, maxX);
            int xMax = Math.max(minX, maxX);
            int cxMin = xMin >> 4;
            int cxMax = xMax >> 4;
            Long2ObjectMap<ChunkSchematic> schematicChunks = world.getChunkProvider().getLoadedChunks();
            for (ChunkSchematic chunk : schematicChunks.values()) {
                ChunkPos pos = chunk.func_76632_l();
                if (pos.field_77276_a < cxMin || pos.field_77276_a > cxMax || chunk.func_76621_g() || !WorldUtils.isClientChunkLoaded(this.mc.field_71441_e, pos.field_77276_a, pos.field_77275_b)) continue;
                minX = Math.max(pos.field_77276_a << 4, xMin);
                maxX = Math.min((pos.field_77276_a << 4) + 15, xMax);
                world.scheduleChunkRenders(minX, 0, pos.field_77275_b << 4, maxX, 255, (pos.field_77275_b << 4) + 15);
            }
        }
    }

    public void updateBetweenY(int minY, int maxY) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null) {
            Long2ObjectMap<ChunkSchematic> schematicChunks = world.getChunkProvider().getLoadedChunks();
            for (ChunkSchematic chunk : schematicChunks.values()) {
                ChunkPos pos = chunk.func_76632_l();
                if (chunk.func_76621_g() || !WorldUtils.isClientChunkLoaded(this.mc.field_71441_e, pos.field_77276_a, pos.field_77275_b)) continue;
                world.scheduleChunkRenders(pos.field_77276_a << 4, minY, pos.field_77275_b << 4, (pos.field_77276_a << 4) + 15, maxY, (pos.field_77275_b << 4) + 15);
            }
        }
    }

    public void updateBetweenZ(int minZ, int maxZ) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null) {
            int zMin = Math.min(minZ, maxZ);
            int zMax = Math.max(minZ, maxZ);
            int czMin = zMin >> 4;
            int czMax = zMax >> 4;
            Long2ObjectMap<ChunkSchematic> schematicChunks = world.getChunkProvider().getLoadedChunks();
            for (ChunkSchematic chunk : schematicChunks.values()) {
                ChunkPos pos = chunk.func_76632_l();
                if (pos.field_77275_b < czMin || pos.field_77275_b > czMax || chunk.func_76621_g() || !WorldUtils.isClientChunkLoaded(this.mc.field_71441_e, pos.field_77276_a, pos.field_77275_b)) continue;
                minZ = Math.max(pos.field_77275_b << 4, zMin);
                maxZ = Math.min((pos.field_77275_b << 4) + 15, zMax);
                world.scheduleChunkRenders(pos.field_77276_a << 4, 0, minZ, (pos.field_77276_a << 4) + 15, 255, maxZ);
            }
        }
    }

    public void markSchematicChunksForRenderUpdate(int chunkX, int chunkZ) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null && world.getChunkProvider().func_73149_a(chunkX, chunkZ) && WorldUtils.isClientChunkLoaded(this.mc.field_71441_e, chunkX, chunkZ)) {
            world.scheduleChunkRenders(chunkX, chunkZ);
        }
    }

    public void markSchematicChunksForRenderUpdate(int chunkX, int chunkY, int chunkZ) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null && world.getChunkProvider().func_73149_a(chunkX, chunkZ) && WorldUtils.isClientChunkLoaded(this.mc.field_71441_e, chunkX, chunkZ)) {
            world.scheduleBlockRenders(chunkX, chunkY, chunkZ);
        }
    }

    public void markSchematicChunkForRenderUpdate(BlockPos pos) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null) {
            int chunkX = pos.func_177958_n() >> 4;
            int chunkZ = pos.func_177952_p() >> 4;
            if (world.getChunkProvider().func_73149_a(chunkX, chunkZ) && WorldUtils.isClientChunkLoaded(this.mc.field_71441_e, chunkX, chunkZ)) {
                world.scheduleBlockRenders(chunkX, pos.func_177956_o() >> 4, chunkZ);
            }
        }
    }
}

