/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.world.ChunkManagerSchematic;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.profiler.IProfiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EmptyTickList;
import net.minecraft.world.ITickList;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.storage.ISpawnWorldInfo;
import net.minecraft.world.storage.MapData;

public class WorldSchematic
extends World {
    private static final RegistryKey<World> REGISTRY_KEY = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("litematica", "schematic_world"));
    private final Minecraft mc;
    private final WorldRendererSchematic worldRenderer;
    private final ChunkManagerSchematic chunkManagerSchematic;
    private final Int2ObjectOpenHashMap<Entity> regularEntities = new Int2ObjectOpenHashMap();
    private int nextEntityId;

    protected WorldSchematic(ISpawnWorldInfo mutableWorldProperties, DimensionType dimensionType, Supplier<IProfiler> supplier) {
        super(mutableWorldProperties, REGISTRY_KEY, dimensionType, supplier, true, true, 0L);
        this.mc = Minecraft.func_71410_x();
        this.worldRenderer = LitematicaRenderer.getInstance().getWorldRenderer();
        this.chunkManagerSchematic = new ChunkManagerSchematic(this);
    }

    public ChunkManagerSchematic getChunkProvider() {
        return this.chunkManagerSchematic;
    }

    public ChunkManagerSchematic getChunkManager() {
        return this.chunkManagerSchematic;
    }

    public ITickList<Block> func_205220_G_() {
        return EmptyTickList.func_205388_a();
    }

    public ITickList<Fluid> func_205219_F_() {
        return EmptyTickList.func_205388_a();
    }

    public int getRegularEntityCount() {
        return this.regularEntities.size();
    }

    public Chunk func_175726_f(BlockPos pos) {
        return this.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public Chunk func_212866_a_(int chunkX, int chunkZ) {
        return this.chunkManagerSchematic.getChunk(chunkX, chunkZ);
    }

    public IChunk func_217353_a(int chunkX, int chunkZ, ChunkStatus status, boolean required) {
        return this.func_212866_a_(chunkX, chunkZ);
    }

    public Biome func_225604_a_(int biomeX, int biomeY, int biomeZ) {
        return BiomeRegistry.field_244200_a;
    }

    public boolean func_180501_a(BlockPos pos, BlockState newState, int flags) {
        if (pos.func_177956_o() < 0 || pos.func_177956_o() >= 256) {
            return false;
        }
        return this.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4).func_177436_a(pos, newState, false) != null;
    }

    public boolean func_217376_c(Entity entityIn) {
        return this.spawnEntityBase(entityIn);
    }

    private boolean spawnEntityBase(Entity entity) {
        int cz;
        int cx = MathHelper.func_76128_c((double)(entity.func_226277_ct_() / 16.0));
        if (!this.chunkManagerSchematic.func_73149_a(cx, cz = MathHelper.func_76128_c((double)(entity.func_226281_cx_() / 16.0)))) {
            return false;
        }
        entity.func_145769_d(this.nextEntityId++);
        int id = entity.func_145782_y();
        this.removeEntity(id);
        this.regularEntities.put(id, (Object)entity);
        this.chunkManagerSchematic.getChunk(MathHelper.func_76128_c((double)(entity.func_226277_ct_() / 16.0)), MathHelper.func_76128_c((double)(entity.func_226281_cx_() / 16.0))).func_76612_a(entity);
        return true;
    }

    public void removeEntity(int id) {
        Entity entity = (Entity)this.regularEntities.remove(id);
        if (entity != null) {
            entity.func_70106_y();
            entity.func_213319_R();
            if (entity.field_70175_ag) {
                this.func_212866_a_(entity.field_70176_ah, entity.field_70164_aj).func_76622_b(entity);
            }
        }
    }

    @Nullable
    public Entity func_73045_a(int id) {
        return (Entity)this.regularEntities.get(id);
    }

    public List<? extends PlayerEntity> func_217369_A() {
        return ImmutableList.of();
    }

    public void unloadBlockEntities(Collection<TileEntity> blockEntities) {
        Set remove = Collections.newSetFromMap(new IdentityHashMap());
        remove.addAll(blockEntities);
        this.field_175730_i.removeAll(remove);
        this.field_147482_g.removeAll(remove);
    }

    public long func_82737_E() {
        return this.mc.field_71441_e != null ? this.mc.field_71441_e.func_82737_E() : 0L;
    }

    @Nullable
    public MapData func_217406_a(String id) {
        return null;
    }

    public void func_217399_a(MapData mapState) {
    }

    public int func_217395_y() {
        return 0;
    }

    public Scoreboard func_96441_U() {
        return this.mc.field_71441_e != null ? this.mc.field_71441_e.func_96441_U() : null;
    }

    public RecipeManager func_199532_z() {
        return this.mc.field_71441_e != null ? this.mc.field_71441_e.func_199532_z() : null;
    }

    public ITagCollectionSupplier func_205772_D() {
        return this.mc.field_71441_e != null ? this.mc.field_71441_e.func_205772_D() : null;
    }

    public void func_225319_b(BlockPos pos, BlockState stateOld, BlockState stateNew) {
        this.scheduleBlockRenders(pos.func_177958_n() >> 4, pos.func_177956_o() >> 4, pos.func_177952_p() >> 4);
    }

    public void scheduleBlockRenders(int chunkX, int chunkY, int chunkZ) {
        if (chunkY >= 0 && chunkY < 16) {
            this.worldRenderer.scheduleChunkRenders(chunkX, chunkY, chunkZ);
        }
    }

    public void scheduleChunkRenders(int chunkX, int chunkZ) {
        for (int chunkY = 0; chunkY < 16; ++chunkY) {
            this.worldRenderer.scheduleChunkRenders(chunkX, chunkY, chunkZ);
        }
    }

    public void scheduleChunkRenders(int minBlockX, int minBlockY, int minBlockZ, int maxBlockX, int maxBlockY, int maxBlockZ) {
        int minChunkX = Math.min(minBlockX, maxBlockX) >> 4;
        int minChunkY = MathHelper.func_76125_a((int)(Math.min(minBlockY, maxBlockY) >> 4), (int)0, (int)15);
        int minChunkZ = Math.min(minBlockZ, maxBlockZ) >> 4;
        int maxChunkX = Math.max(minBlockX, maxBlockX) >> 4;
        int maxChunkY = MathHelper.func_76125_a((int)(Math.max(minBlockY, maxBlockY) >> 4), (int)0, (int)15);
        int maxChunkZ = Math.max(minBlockZ, maxBlockZ) >> 4;
        for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
            for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
                for (int cy = minChunkY; cy <= maxChunkY; ++cy) {
                    this.worldRenderer.scheduleChunkRenders(cx, cy, cz);
                }
            }
        }
    }

    public float func_230487_a_(Direction direction, boolean shaded) {
        return 0.0f;
    }

    public int func_226658_a_(LightType type, BlockPos pos) {
        return 15;
    }

    public int func_226659_b_(BlockPos pos, int defaultValue) {
        return 15;
    }

    public void func_184138_a(BlockPos blockPos_1, BlockState blockState_1, BlockState blockState_2, int flags) {
    }

    public void func_175715_c(int entityId, BlockPos pos, int progress) {
    }

    public void func_175669_a(int eventId, BlockPos pos, int data) {
    }

    public void func_217378_a(@Nullable PlayerEntity entity, int id, BlockPos pos, int data) {
    }

    public void func_195594_a(IParticleData particleParameters_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void func_195590_a(IParticleData particleParameters_1, boolean boolean_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void func_195589_b(IParticleData particleParameters_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void func_217404_b(IParticleData particleParameters_1, boolean boolean_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void func_184134_a(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
    }

    public void func_184133_a(PlayerEntity player, BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
    }

    public void func_184148_a(PlayerEntity player, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
    }

    public void func_217384_a(@Nullable PlayerEntity player, Entity entity, SoundEvent sound, SoundCategory category, float volume, float pitch) {
    }

    public DynamicRegistries func_241828_r() {
        return this.mc.field_71441_e.func_241828_r();
    }
}

