/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import fi.dy.masa.malilib.interfaces.IRenderDispatcher;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.item.ItemStack;

public class RenderEventHandler
implements IRenderDispatcher {
    private static final RenderEventHandler INSTANCE = new RenderEventHandler();
    private final List<IRenderer> overlayRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> tooltipLastRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> worldLastRenderers = new ArrayList<IRenderer>();

    public static IRenderDispatcher getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerGameOverlayRenderer(IRenderer renderer) {
        if (!this.overlayRenderers.contains(renderer)) {
            this.overlayRenderers.add(renderer);
        }
    }

    @Override
    public void registerTooltipLastRenderer(IRenderer renderer) {
        if (!this.tooltipLastRenderers.contains(renderer)) {
            this.tooltipLastRenderers.add(renderer);
        }
    }

    @Override
    public void registerWorldLastRenderer(IRenderer renderer) {
        if (!this.worldLastRenderers.contains(renderer)) {
            this.worldLastRenderers.add(renderer);
        }
    }

    public void onRenderGameOverlayPost(Minecraft mc, float partialTicks, MatrixStack matrixStack) {
        mc.func_213239_aq().func_76320_a("malilib_rendergameoverlaypost");
        if (!this.overlayRenderers.isEmpty()) {
            for (IRenderer renderer : this.overlayRenderers) {
                mc.func_213239_aq().func_194340_a(renderer.getProfilerSectionSupplier());
                renderer.onRenderGameOverlayPost(partialTicks, matrixStack);
                mc.func_213239_aq().func_76319_b();
            }
        }
        mc.func_213239_aq().func_76320_a("malilib_ingamemessages");
        InfoUtils.renderInGameMessages(matrixStack);
        mc.func_213239_aq().func_76319_b();
        mc.func_213239_aq().func_76319_b();
    }

    public void onRenderTooltipLast(MatrixStack matrixStack, ItemStack stack, int x, int y) {
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                renderer.onRenderTooltipLast(stack, x, y);
            }
        }
    }

    public void onRenderWorldLast(MatrixStack matrixStack, Minecraft mc, float partialTicks) {
        if (!this.worldLastRenderers.isEmpty()) {
            Framebuffer fb;
            mc.func_213239_aq().func_219895_b("malilib_renderworldlast");
            Framebuffer framebuffer = fb = Minecraft.func_238218_y_() ? mc.field_71438_f.func_239228_q_() : null;
            if (fb != null) {
                fb.func_147610_a(false);
            }
            for (IRenderer renderer : this.worldLastRenderers) {
                mc.func_213239_aq().func_194340_a(renderer.getProfilerSectionSupplier());
                renderer.onRenderWorldLast(partialTicks, matrixStack);
                mc.func_213239_aq().func_76319_b();
            }
            if (fb != null) {
                mc.func_147110_a().func_147610_a(false);
            }
        }
    }
}

