/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiDialogBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;

public abstract class GuiTextInputBase
extends GuiDialogBase {
    protected final GuiTextFieldGeneric textField;
    protected final String originalText;

    public GuiTextInputBase(int maxTextLength, String titleKey, String defaultText, @Nullable Screen parent) {
        this.setParent(parent);
        this.title = StringUtils.translate(titleKey, new Object[0]);
        this.useTitleHierarchy = false;
        this.originalText = defaultText;
        this.setWidthAndHeight(260, 100);
        this.centerOnScreen();
        int width = Math.min(maxTextLength * 10, 240);
        this.textField = new GuiTextFieldGeneric(this.dialogLeft + 12, this.dialogTop + 40, width, 20, this.textRenderer);
        this.textField.func_146203_f(maxTextLength);
        this.textField.func_230996_d_(true);
        this.textField.func_146180_a(this.originalText);
        this.func_230926_e_(1);
    }

    @Override
    public void initGui() {
        int x = this.dialogLeft + 10;
        int y = this.dialogTop + 70;
        x += this.createButton(x, y, ButtonType.OK) + 2;
        x += this.createButton(x, y, ButtonType.RESET) + 2;
        x += this.createButton(x, y, ButtonType.CANCEL) + 2;
        this.mc.field_195559_v.func_197967_a(true);
    }

    protected int createButton(int x, int y, ButtonType type) {
        ButtonGeneric button = new ButtonGeneric(x, y, -1, 20, type.getDisplayName(), new String[0]);
        button.setWidth(Math.max(40, button.getWidth()));
        return this.addButton(button, this.createActionListener(type)).getWidth();
    }

    @Override
    public boolean func_231177_au__() {
        return this.getParent() != null && this.getParent().func_231177_au__();
    }

    @Override
    public void drawContents(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.getParent() != null) {
            this.getParent().func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)this.func_230927_p_());
        RenderUtils.drawOutlinedBox(this.dialogLeft, this.dialogTop, this.dialogWidth, this.dialogHeight, -536870912, -6710887);
        this.drawStringWithShadow(matrixStack, this.getTitleString(), this.dialogLeft + 10, this.dialogTop + 4, -1);
        this.textField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.drawButtons(mouseX, mouseY, partialTicks, matrixStack);
        RenderSystem.popMatrix();
    }

    @Override
    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            if (this.applyValue(this.textField.func_146179_b())) {
                GuiBase.openGui(this.getParent());
            }
            return true;
        }
        if (keyCode == 256) {
            GuiBase.openGui(this.getParent());
            return true;
        }
        if (this.textField.func_230999_j_()) {
            return this.textField.func_231046_a_(keyCode, scanCode, modifiers);
        }
        return super.onKeyTyped(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean onCharTyped(char charIn, int modifiers) {
        if (this.textField.func_230999_j_()) {
            return this.textField.func_231042_a_(charIn, modifiers);
        }
        return super.onCharTyped(charIn, modifiers);
    }

    @Override
    public boolean onMouseClicked(int mouseX, int mouseY, int button) {
        if (this.textField.func_231044_a_(mouseX, mouseY, button)) {
            return true;
        }
        return super.onMouseClicked(mouseX, mouseY, button);
    }

    protected ButtonListener createActionListener(ButtonType type) {
        return new ButtonListener(type, this);
    }

    protected abstract boolean applyValue(String var1);

    protected static enum ButtonType {
        OK("malilib.gui.button.ok"),
        CANCEL("malilib.gui.button.cancel"),
        RESET("malilib.gui.button.reset");

        private final String labelKey;

        private ButtonType(String labelKey) {
            this.labelKey = labelKey;
        }

        public String getDisplayName() {
            return StringUtils.translate(this.labelKey, new Object[0]);
        }
    }

    protected static class ButtonListener
    implements IButtonActionListener {
        private final GuiTextInputBase gui;
        private final ButtonType type;

        public ButtonListener(ButtonType type, GuiTextInputBase gui) {
            this.type = type;
            this.gui = gui;
        }

        @Override
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            if (this.type == ButtonType.OK) {
                if (this.gui.applyValue(this.gui.textField.func_146179_b())) {
                    GuiBase.openGui(this.gui.getParent());
                }
            } else if (this.type == ButtonType.CANCEL) {
                GuiBase.openGui(this.gui.getParent());
            } else if (this.type == ButtonType.RESET) {
                this.gui.textField.func_146180_a(this.gui.originalText);
                this.gui.textField.func_230996_d_(true);
            }
        }
    }
}

