/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.LeftRight;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetIcon;
import fi.dy.masa.malilib.render.RenderUtils;
import net.minecraft.util.SharedConstants;

public class WidgetSearchBar
extends WidgetBase {
    protected final WidgetIcon iconSearch;
    protected final LeftRight iconAlignment;
    protected final GuiTextFieldGeneric searchBox;
    protected boolean searchOpen;

    public WidgetSearchBar(int x, int y, int width, int height, int searchBarOffsetX, IGuiIcon iconSearch, LeftRight iconAlignment) {
        super(x, y, width, height);
        int iw = iconSearch.getWidth();
        int ix = iconAlignment == LeftRight.RIGHT ? x + width - iw - 1 : x + 2;
        int tx = iconAlignment == LeftRight.RIGHT ? x - searchBarOffsetX + 1 : x + iw + 6 + searchBarOffsetX;
        this.iconSearch = new WidgetIcon(ix, y + 1, iconSearch);
        this.iconAlignment = iconAlignment;
        this.searchBox = new GuiTextFieldGeneric(tx, y, width - iw - 7 - Math.abs(searchBarOffsetX), height, this.textRenderer);
        this.searchBox.setZLevel(this.zLevel);
    }

    public String getFilter() {
        return this.searchOpen ? this.searchBox.func_146179_b() : "";
    }

    public boolean hasFilter() {
        return this.searchOpen && !this.searchBox.func_146179_b().isEmpty();
    }

    public boolean isSearchOpen() {
        return this.searchOpen;
    }

    public void setSearchOpen(boolean isOpen) {
        this.searchOpen = isOpen;
        if (this.searchOpen) {
            this.searchBox.func_230996_d_(true);
        }
    }

    @Override
    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        if (this.searchOpen && this.searchBox.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.iconSearch.isMouseOver(mouseX, mouseY)) {
            this.setSearchOpen(!this.searchOpen);
            return true;
        }
        return false;
    }

    @Override
    protected boolean onKeyTypedImpl(int keyCode, int scanCode, int modifiers) {
        if (this.searchOpen) {
            if (this.searchBox.func_231046_a_(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (keyCode == 256) {
                if (GuiBase.isShiftDown()) {
                    this.mc.field_71462_r.func_231175_as__();
                }
                this.searchOpen = false;
                this.searchBox.func_230996_d_(false);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean onCharTypedImpl(char charIn, int modifiers) {
        if (this.searchOpen) {
            if (this.searchBox.func_231042_a_(charIn, modifiers)) {
                return true;
            }
        } else if (SharedConstants.func_71566_a((char)charIn)) {
            this.searchOpen = true;
            this.searchBox.func_230996_d_(true);
            this.searchBox.func_146180_a("");
            this.searchBox.func_231042_a_(charIn, modifiers);
            return true;
        }
        return false;
    }

    @Override
    public void render(int mouseX, int mouseY, boolean selected, MatrixStack matrixStack) {
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.iconSearch.render(false, this.iconSearch.isMouseOver(mouseX, mouseY));
        if (this.searchOpen) {
            this.searchBox.func_230430_a_(matrixStack, mouseX, mouseY, 0.0f);
        }
    }
}

