/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.hotkeys;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.IF3KeyStateSetter;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.KeyCodes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import org.lwjgl.glfw.GLFW;

public class KeybindMulti
implements IKeybind {
    private static final ArrayList<Integer> PRESSED_KEYS = new ArrayList();
    private static int triggeredCount;
    private final String defaultStorageString;
    private final KeybindSettings defaultSettings;
    private List<Integer> keyCodes = new ArrayList<Integer>(4);
    private KeybindSettings settings;
    private boolean pressed;
    private boolean pressedLast;
    private int heldTime;
    @Nullable
    private IHotkeyCallback callback;

    private KeybindMulti(String defaultStorageString, KeybindSettings settings) {
        this.defaultStorageString = defaultStorageString;
        this.defaultSettings = settings;
        this.settings = settings;
    }

    @Override
    public KeybindSettings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(KeybindSettings settings) {
        this.settings = settings;
    }

    @Override
    public void setCallback(@Nullable IHotkeyCallback callback) {
        this.callback = callback;
    }

    @Override
    public boolean isValid() {
        return !this.keyCodes.isEmpty() || this.settings.getAllowEmpty();
    }

    @Override
    public boolean isPressed() {
        return this.pressed && !this.pressedLast && this.heldTime == 0;
    }

    @Override
    public boolean isKeybindHeld() {
        return this.pressed || this.settings.getAllowEmpty() && this.keyCodes.isEmpty();
    }

    @Override
    public boolean updateIsPressed() {
        int sizeRequired;
        if (this.keyCodes.isEmpty() || this.settings.getContext() != KeybindSettings.Context.ANY && this.settings.getContext() == KeybindSettings.Context.INGAME != (GuiUtils.getCurrentScreen() == null)) {
            this.pressed = false;
            return false;
        }
        boolean allowExtraKeys = this.settings.getAllowExtraKeys();
        boolean allowOutOfOrder = !this.settings.isOrderSensitive();
        boolean pressedLast = this.pressed;
        int sizePressed = PRESSED_KEYS.size();
        if (sizePressed >= (sizeRequired = this.keyCodes.size()) && (allowExtraKeys || sizePressed == sizeRequired)) {
            int keyCodeIndex = 0;
            this.pressed = PRESSED_KEYS.containsAll(this.keyCodes);
            for (int i = 0; i < sizePressed; ++i) {
                Integer keyCodeObj = PRESSED_KEYS.get(i);
                if (this.keyCodes.get(keyCodeIndex).equals(keyCodeObj)) {
                    if (++keyCodeIndex < sizeRequired) continue;
                } else {
                    if ((allowOutOfOrder || keyCodeIndex <= 0 && sizePressed != sizeRequired) && (this.keyCodes.contains(keyCodeObj) || allowExtraKeys)) continue;
                    this.pressed = false;
                }
                break;
            }
        } else {
            this.pressed = false;
        }
        KeyAction activateOn = this.settings.getActivateOn();
        if (!(this.pressed == pressedLast || triggeredCount != 0 && this.settings.isExclusive() || activateOn != KeyAction.BOTH && this.pressed != (activateOn == KeyAction.PRESS))) {
            boolean cancel;
            boolean bl = cancel = this.triggerKeyAction(pressedLast) && this.settings.shouldCancel();
            if (cancel) {
                ++triggeredCount;
            }
            return cancel;
        }
        return false;
    }

    private boolean triggerKeyAction(boolean pressedLast) {
        boolean cancel = false;
        if (!this.pressed) {
            this.heldTime = 0;
            KeyAction activateOn = this.settings.getActivateOn();
            if (pressedLast && this.callback != null && (activateOn == KeyAction.RELEASE || activateOn == KeyAction.BOTH)) {
                cancel = this.callback.onKeyAction(KeyAction.RELEASE, this);
            }
        } else if (!pressedLast && this.heldTime == 0) {
            if (this.keyCodes.contains(292)) {
                ((IF3KeyStateSetter)Minecraft.func_71410_x().field_195559_v).setF3KeyState(true);
            }
            KeyAction activateOn = this.settings.getActivateOn();
            if (this.callback != null && (activateOn == KeyAction.PRESS || activateOn == KeyAction.BOTH)) {
                cancel = this.callback.onKeyAction(KeyAction.PRESS, this);
            }
        }
        return cancel;
    }

    @Override
    public void clearKeys() {
        this.keyCodes.clear();
        this.pressed = false;
        this.heldTime = 0;
    }

    @Override
    public void addKey(int keyCode) {
        if (!this.keyCodes.contains(keyCode)) {
            this.keyCodes.add(keyCode);
        }
    }

    @Override
    public void tick() {
        if (this.pressed) {
            ++this.heldTime;
        }
        this.pressedLast = this.pressed;
    }

    @Override
    public void removeKey(int keyCode) {
        this.keyCodes.remove(keyCode);
    }

    @Override
    public List<Integer> getKeys() {
        return this.keyCodes;
    }

    @Override
    public String getKeysDisplayString() {
        return this.getStringValue().replaceAll(",", " + ");
    }

    @Override
    public boolean isModified() {
        return !this.getStringValue().equals(this.defaultStorageString);
    }

    @Override
    public boolean isModified(String newValue) {
        return !this.defaultStorageString.equals(newValue);
    }

    @Override
    public void resetToDefault() {
        this.setValueFromString(this.defaultStorageString);
    }

    @Override
    public boolean areSettingsModified() {
        return !this.settings.equals(this.defaultSettings);
    }

    @Override
    public void resetSettingsToDefaults() {
        this.settings = this.defaultSettings;
    }

    @Override
    public String getStringValue() {
        StringBuilder sb = new StringBuilder(32);
        for (int i = 0; i < this.keyCodes.size(); ++i) {
            int keyCode;
            String name;
            if (i > 0) {
                sb.append(",");
            }
            if ((name = KeybindMulti.getStorageStringForKeyCode(keyCode = this.keyCodes.get(i).intValue())) == null) continue;
            sb.append(name);
        }
        return sb.toString();
    }

    @Override
    public String getDefaultStringValue() {
        return this.defaultStorageString;
    }

    @Override
    public void setValueFromString(String str) {
        String[] keys;
        this.clearKeys();
        for (String keyName : keys = str.split(",")) {
            int keyCode;
            if ((keyName = keyName.trim()).isEmpty() || (keyCode = KeyCodes.getKeyCodeFromName(keyName)) == -1) continue;
            this.addKey(keyCode);
        }
    }

    @Override
    public boolean matches(int keyCode) {
        return this.keyCodes.size() == 1 && this.keyCodes.get(0) == keyCode;
    }

    public static int getKeyCode(KeyBinding keybind) {
        InputMappings.Input input = InputMappings.func_197955_a((String)keybind.func_197982_m());
        return input.func_197938_b() == InputMappings.Type.MOUSE ? input.func_197937_c() - 100 : input.func_197937_c();
    }

    public static boolean hotkeyMatchesKeybind(IHotkey hotkey, KeyBinding keybind) {
        int keyCode = KeybindMulti.getKeyCode(keybind);
        return hotkey.getKeybind().matches(keyCode);
    }

    @Override
    public boolean overlaps(IKeybind other) {
        if (other == this || other.getKeys().size() > this.getKeys().size()) {
            return false;
        }
        if (this.contextOverlaps(other)) {
            KeybindSettings settingsOther = other.getSettings();
            boolean o1 = this.settings.isOrderSensitive();
            boolean o2 = settingsOther.isOrderSensitive();
            List<Integer> keys1 = this.getKeys();
            List<Integer> keys2 = other.getKeys();
            int l1 = keys1.size();
            int l2 = keys2.size();
            if (l1 == 0 || l2 == 0) {
                return false;
            }
            if (!this.settings.getAllowExtraKeys() && l1 < l2 && keys1.get(0) != keys2.get(0) || !settingsOther.getAllowExtraKeys() && l2 < l1 && keys1.get(0) != keys2.get(0)) {
                return false;
            }
            if (o1 && o2) {
                return l1 < l2 ? Collections.indexOfSubList(keys2, keys1) != -1 : Collections.indexOfSubList(keys1, keys2) != -1;
            }
            return l1 <= l2 ? keys2.containsAll(keys1) : keys1.containsAll(keys2);
        }
        return false;
    }

    public boolean contextOverlaps(IKeybind other) {
        KeybindSettings settingsOther = other.getSettings();
        KeybindSettings.Context c1 = this.settings.getContext();
        KeybindSettings.Context c2 = settingsOther.getContext();
        if (c1 == KeybindSettings.Context.ANY || c2 == KeybindSettings.Context.ANY || c1 == c2) {
            KeyAction a1 = this.settings.getActivateOn();
            KeyAction a2 = settingsOther.getActivateOn();
            if (a1 == KeyAction.BOTH || a2 == KeyAction.BOTH || a1 == a2) {
                return true;
            }
        }
        return false;
    }

    public static KeybindMulti fromStorageString(String str, KeybindSettings settings) {
        KeybindMulti keybind = new KeybindMulti(str, settings);
        keybind.setValueFromString(str);
        return keybind;
    }

    public static boolean isKeyDown(int keyCode) {
        long window = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
        if (keyCode >= 0) {
            return GLFW.glfwGetKey((long)window, (int)keyCode) == 1;
        }
        return (keyCode += 100) >= 0 && GLFW.glfwGetMouseButton((long)window, (int)keyCode) == 1;
    }

    public static void onKeyInputPre(int keyCode, int scanCode, boolean state) {
        Integer valObj = keyCode;
        if (state) {
            List<Integer> ignored;
            if (!(PRESSED_KEYS.contains(valObj) || (ignored = MaLiLibConfigs.Generic.IGNORED_KEYS.getKeybind().getKeys()).size() != 0 && ignored.contains(valObj))) {
                PRESSED_KEYS.add(valObj);
            }
        } else {
            PRESSED_KEYS.remove(valObj);
        }
        if (MaLiLibConfigs.Debug.KEYBIND_DEBUG.getBooleanValue()) {
            KeybindMulti.printKeybindDebugMessage(keyCode, scanCode, state);
        }
    }

    public static void reCheckPressedKeys() {
        Iterator<Integer> iter = PRESSED_KEYS.iterator();
        while (iter.hasNext()) {
            int keyCode = iter.next();
            if (KeybindMulti.isKeyDown(keyCode)) continue;
            iter.remove();
        }
        if (PRESSED_KEYS.size() == 0) {
            triggeredCount = 0;
        }
    }

    private static void printKeybindDebugMessage(int keyCode, int scanCode, boolean keyState) {
        String keyName = keyCode != -1 ? KeyCodes.getNameForKey(keyCode) : "<unknown>";
        String type = keyState ? "PRESS" : "RELEASE";
        String held = KeybindMulti.getActiveKeysString();
        String msg = String.format("%s %s (%d), held keys: %s", type, keyName, keyCode, held);
        MaLiLib.logger.info(msg);
        if (MaLiLibConfigs.Debug.KEYBIND_DEBUG_ACTIONBAR.getBooleanValue()) {
            InfoUtils.printActionbarMessage(msg, new Object[0]);
        }
    }

    public static String getActiveKeysString() {
        if (!PRESSED_KEYS.isEmpty()) {
            StringBuilder sb = new StringBuilder(128);
            int i = 0;
            for (int key : PRESSED_KEYS) {
                String name;
                if (i > 0) {
                    sb.append(" + ");
                }
                if ((name = KeybindMulti.getStorageStringForKeyCode(key)) != null) {
                    sb.append(String.format("%s (%d)", name, key));
                }
                ++i;
            }
            return sb.toString();
        }
        return "<none>";
    }

    @Nullable
    public static String getStorageStringForKeyCode(int keyCode) {
        return KeyCodes.getNameForKey(keyCode);
    }

    public static int getTriggeredCount() {
        return triggeredCount;
    }
}

