/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;

public class RenderUtils {
    public static final ResourceLocation TEXTURE_MAP_BACKGROUND = new ResourceLocation("textures/map/map_background.png");
    private static final Random RAND = new Random();

    public static void setupBlend() {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    public static void setupBlendSimple() {
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    public static void bindTexture(ResourceLocation texture) {
        RenderUtils.mc().func_110434_K().func_110577_a(texture);
    }

    public static void color(float r, float g, float b, float a) {
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
    }

    public static void disableDiffuseLighting() {
        RenderHelper.func_74518_a();
    }

    public static void enableDiffuseLightingForLevel(MatrixStack matrixStack) {
        RenderHelper.func_237533_a_((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
    }

    public static void enableDiffuseLightingGui3D() {
        RenderHelper.func_227784_d_();
    }

    public static void drawOutlinedBox(int x, int y, int width, int height, int colorBg, int colorBorder) {
        RenderUtils.drawOutlinedBox(x, y, width, height, colorBg, colorBorder, 0.0f);
    }

    public static void drawOutlinedBox(int x, int y, int width, int height, int colorBg, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, width, height, colorBg, zLevel);
        RenderUtils.drawOutline(x - 1, y - 1, width + 2, height + 2, colorBorder, zLevel);
    }

    public static void drawOutline(int x, int y, int width, int height, int colorBorder) {
        RenderUtils.drawOutline(x, y, width, height, colorBorder, 0.0f);
    }

    public static void drawOutline(int x, int y, int width, int height, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, 1, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + width - 1, y, 1, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + 1, y, width - 2, 1, colorBorder, zLevel);
        RenderUtils.drawRect(x + 1, y + height - 1, width - 2, 1, colorBorder, zLevel);
    }

    public static void drawOutline(int x, int y, int width, int height, int borderWidth, int colorBorder) {
        RenderUtils.drawOutline(x, y, width, height, borderWidth, colorBorder, 0.0f);
    }

    public static void drawOutline(int x, int y, int width, int height, int borderWidth, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, borderWidth, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + width - borderWidth, y, borderWidth, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + borderWidth, y, width - 2 * borderWidth, borderWidth, colorBorder, zLevel);
        RenderUtils.drawRect(x + borderWidth, y + height - borderWidth, width - 2 * borderWidth, borderWidth, colorBorder, zLevel);
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height) {
        RenderUtils.drawTexturedRect(x, y, u, v, width, height, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color) {
        RenderUtils.drawRect(x, y, width, height, color, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color, float zLevel) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        RenderSystem.disableTexture();
        RenderUtils.setupBlend();
        RenderUtils.color(r, g, b, a);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_225582_a_((double)x, (double)y, (double)zLevel).func_181675_d();
        buffer.func_225582_a_((double)x, (double)(y + height), (double)zLevel).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), (double)zLevel).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, (double)zLevel).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height, float zLevel) {
        float pixelWidth = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        RenderUtils.setupBlend();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)x, (double)(y + height), (double)zLevel).func_225583_a_((float)u * pixelWidth, (float)(v + height) * pixelWidth).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), (double)zLevel).func_225583_a_((float)(u + width) * pixelWidth, (float)(v + height) * pixelWidth).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, (double)zLevel).func_225583_a_((float)(u + width) * pixelWidth, (float)v * pixelWidth).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, (double)zLevel).func_225583_a_((float)u * pixelWidth, (float)v * pixelWidth).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, BufferBuilder buffer) {
        RenderUtils.drawTexturedRectBatched(x, y, u, v, width, height, 0.0f, buffer);
    }

    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, float zLevel, BufferBuilder buffer) {
        float pixelWidth = 0.00390625f;
        buffer.func_225582_a_((double)x, (double)(y + height), (double)zLevel).func_225583_a_((float)u * pixelWidth, (float)(v + height) * pixelWidth).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), (double)zLevel).func_225583_a_((float)(u + width) * pixelWidth, (float)(v + height) * pixelWidth).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, (double)zLevel).func_225583_a_((float)(u + width) * pixelWidth, (float)v * pixelWidth).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, (double)zLevel).func_225583_a_((float)u * pixelWidth, (float)v * pixelWidth).func_181675_d();
    }

    public static void drawHoverText(int x, int y, List<String> textLines, MatrixStack matrixStack) {
        Minecraft mc = RenderUtils.mc();
        if (!textLines.isEmpty() && GuiUtils.getCurrentScreen() != null) {
            FontRenderer font = mc.field_71466_p;
            RenderSystem.disableRescaleNormal();
            RenderUtils.disableDiffuseLighting();
            RenderSystem.disableLighting();
            RenderSystem.disableDepthTest();
            int maxLineLength = 0;
            int maxWidth = GuiUtils.getCurrentScreen().field_230708_k_;
            ArrayList<String> linesNew = new ArrayList<String>();
            for (String lineOrig : textLines) {
                String[] lines;
                for (String line : lines = lineOrig.split("\\n")) {
                    int length = font.func_78256_a(line);
                    if (length > maxLineLength) {
                        maxLineLength = length;
                    }
                    linesNew.add(line);
                }
            }
            textLines = linesNew;
            Objects.requireNonNull(font);
            int lineHeight = 9 + 1;
            int textHeight = textLines.size() * lineHeight - 2;
            int textStartX = x + 4;
            int textStartY = Math.max(8, y - textHeight - 6);
            if (textStartX + maxLineLength + 6 > maxWidth) {
                textStartX = Math.max(2, maxWidth - maxLineLength - 8);
            }
            double zLevel = 300.0;
            int borderColor = -267386864;
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 4, textStartX + maxLineLength + 3, textStartY - 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY + textHeight + 3, textStartX + maxLineLength + 3, textStartY + textHeight + 4, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 4, textStartY - 3, textStartX - 3, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX + maxLineLength + 3, textStartY - 3, textStartX + maxLineLength + 4, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            int fillColor1 = 0x505000FF;
            int fillColor2 = 1344798847;
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3 + 1, textStartX - 3 + 1, textStartY + textHeight + 3 - 1, zLevel, fillColor1, fillColor2);
            RenderUtils.drawGradientRect(textStartX + maxLineLength + 2, textStartY - 3 + 1, textStartX + maxLineLength + 3, textStartY + textHeight + 3 - 1, zLevel, fillColor1, fillColor2);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY - 3 + 1, zLevel, fillColor1, fillColor1);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY + textHeight + 2, textStartX + maxLineLength + 3, textStartY + textHeight + 3, zLevel, fillColor2, fillColor2);
            for (int i = 0; i < textLines.size(); ++i) {
                String str = textLines.get(i);
                font.func_238405_a_(matrixStack, str, (float)textStartX, (float)textStartY, -1);
                textStartY += lineHeight;
            }
            RenderSystem.enableLighting();
            RenderSystem.enableDepthTest();
            RenderUtils.enableDiffuseLightingGui3D();
            RenderSystem.enableRescaleNormal();
        }
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, double zLevel, int startColor, int endColor) {
        int sa = startColor >> 24 & 0xFF;
        int sr = startColor >> 16 & 0xFF;
        int sg = startColor >> 8 & 0xFF;
        int sb = startColor & 0xFF;
        int ea = endColor >> 24 & 0xFF;
        int er = endColor >> 16 & 0xFF;
        int eg = endColor >> 8 & 0xFF;
        int eb = endColor & 0xFF;
        RenderSystem.disableTexture();
        RenderSystem.disableAlphaTest();
        RenderUtils.setupBlend();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_((double)right, (double)top, zLevel).func_225586_a_(sr, sg, sb, sa).func_181675_d();
        buffer.func_225582_a_((double)left, (double)top, zLevel).func_225586_a_(sr, sg, sb, sa).func_181675_d();
        buffer.func_225582_a_((double)left, (double)bottom, zLevel).func_225586_a_(er, eg, eb, ea).func_181675_d();
        buffer.func_225582_a_((double)right, (double)bottom, zLevel).func_225586_a_(er, eg, eb, ea).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void drawCenteredString(int x, int y, int color, String text, MatrixStack matrixStack) {
        FontRenderer textRenderer = RenderUtils.mc().field_71466_p;
        textRenderer.func_238405_a_(matrixStack, text, (float)(x - textRenderer.func_78256_a(text) / 2), (float)y, color);
    }

    public static void drawHorizontalLine(int x, int y, int width, int color) {
        RenderUtils.drawRect(x, y, width, 1, color);
    }

    public static void drawVerticalLine(int x, int y, int height, int color) {
        RenderUtils.drawRect(x, y, 1, height, color);
    }

    public static void renderSprite(int x, int y, int width, int height, ResourceLocation atlas, ResourceLocation texture, MatrixStack matrixStack) {
        if (texture != null) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)RenderUtils.mc().func_228015_a_(atlas).apply(texture);
            RenderSystem.disableLighting();
            AbstractGui.func_238470_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)0, (int)width, (int)height, (TextureAtlasSprite)sprite);
        }
    }

    public static void renderText(int x, int y, int color, String text, MatrixStack matrixStack) {
        String[] parts = text.split("\\\\n");
        FontRenderer textRenderer = RenderUtils.mc().field_71466_p;
        for (String line : parts) {
            textRenderer.func_238405_a_(matrixStack, line, (float)x, (float)y, color);
            Objects.requireNonNull(textRenderer);
            y += 9 + 1;
        }
    }

    public static void renderText(int x, int y, int color, List<String> lines, MatrixStack matrixStack) {
        if (!lines.isEmpty()) {
            FontRenderer textRenderer = RenderUtils.mc().field_71466_p;
            for (String line : lines) {
                textRenderer.func_238421_b_(matrixStack, line, (float)x, (float)y, color);
                Objects.requireNonNull(textRenderer);
                y += 9 + 2;
            }
        }
    }

    public static int renderText(int xOff, int yOff, double scale, int textColor, int bgColor, HudAlignment alignment, boolean useBackground, boolean useShadow, List<String> lines, MatrixStack matrixStack) {
        FontRenderer fontRenderer = RenderUtils.mc().field_71466_p;
        int scaledWidth = GuiUtils.getScaledWindowWidth();
        Objects.requireNonNull(fontRenderer);
        int lineHeight = 9 + 2;
        int contentHeight = lines.size() * lineHeight - 2;
        int bgMargin = 2;
        if (scale == 0.0) {
            return 0;
        }
        if (scale != 1.0) {
            if (scale != 0.0) {
                xOff = (int)((double)xOff * scale);
                yOff = (int)((double)yOff * scale);
            }
            RenderSystem.pushMatrix();
            RenderSystem.scaled((double)scale, (double)scale, (double)0.0);
        }
        double posX = xOff + 2;
        double posY = yOff + 2;
        posY = RenderUtils.getHudPosY((int)posY, yOff, contentHeight, scale, alignment);
        posY += (double)RenderUtils.getHudOffsetForPotions(alignment, scale, (PlayerEntity)RenderUtils.mc().field_71439_g);
        for (String line : lines) {
            int width = fontRenderer.func_78256_a(line);
            switch (alignment) {
                case TOP_RIGHT: 
                case BOTTOM_RIGHT: {
                    posX = (double)scaledWidth / scale - (double)width - (double)xOff - 2.0;
                    break;
                }
                case CENTER: {
                    posX = (double)scaledWidth / scale / 2.0 - (double)(width / 2) - (double)xOff;
                    break;
                }
            }
            int x = (int)posX;
            int y = (int)posY;
            posY += (double)lineHeight;
            if (useBackground) {
                Objects.requireNonNull(fontRenderer);
                RenderUtils.drawRect(x - 2, y - 2, width + 2, 2 + 9, bgColor);
            }
            if (useShadow) {
                fontRenderer.func_238405_a_(matrixStack, line, (float)x, (float)y, textColor);
                continue;
            }
            fontRenderer.func_238421_b_(matrixStack, line, (float)x, (float)y, textColor);
        }
        if (scale != 1.0) {
            RenderSystem.popMatrix();
        }
        return contentHeight + 4;
    }

    public static int getHudOffsetForPotions(HudAlignment alignment, double scale, PlayerEntity player) {
        if (alignment == HudAlignment.TOP_RIGHT) {
            if (scale == 0.0) {
                return 0;
            }
            Collection effects = player.func_70651_bq();
            if (!effects.isEmpty()) {
                int y1 = 0;
                int y2 = 0;
                for (EffectInstance effectInstance : effects) {
                    Effect effect = effectInstance.func_188419_a();
                    if (!effectInstance.func_188418_e() || !effectInstance.func_205348_f()) continue;
                    if (effect.func_188408_i()) {
                        y1 = 26;
                        continue;
                    }
                    y2 = 52;
                    break;
                }
                return (int)((double)Math.max(y1, y2) / scale);
            }
        }
        return 0;
    }

    public static int getHudPosY(int yOrig, int yOffset, int contentHeight, double scale, HudAlignment alignment) {
        int scaledHeight = GuiUtils.getScaledWindowHeight();
        int posY = yOrig;
        switch (alignment) {
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: {
                posY = (int)((double)scaledHeight / scale - (double)contentHeight - (double)yOffset);
                break;
            }
            case CENTER: {
                posY = (int)((double)scaledHeight / scale / 2.0 - (double)contentHeight / 2.0 + (double)yOffset);
                break;
            }
        }
        return posY;
    }

    public static void drawBlockBoundingBoxSidesBatchedQuads(BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        double minX = (double)pos.func_177958_n() - expand;
        double minY = (double)pos.func_177956_o() - expand;
        double minZ = (double)pos.func_177952_p() - expand;
        double maxX = (double)pos.func_177958_n() + expand + 1.0;
        double maxY = (double)pos.func_177956_o() + expand + 1.0;
        double maxZ = (double)pos.func_177952_p() + expand + 1.0;
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(BlockPos pos, Color4f color, double expand, BufferBuilder buffer) {
        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines(pos, Vector3d.field_186680_a, color, expand, buffer);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(BlockPos pos, Vector3d cameraPos, Color4f color, double expand, BufferBuilder buffer) {
        double minX = (double)pos.func_177958_n() - expand - cameraPos.field_72450_a;
        double minY = (double)pos.func_177956_o() - expand - cameraPos.field_72448_b;
        double minZ = (double)pos.func_177952_p() - expand - cameraPos.field_72449_c;
        double maxX = (double)pos.func_177958_n() + expand - cameraPos.field_72450_a + 1.0;
        double maxY = (double)pos.func_177956_o() + expand - cameraPos.field_72448_b + 1.0;
        double maxZ = (double)pos.func_177952_p() + expand - cameraPos.field_72449_c + 1.0;
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBoxAllSidesBatchedQuads(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color, BufferBuilder buffer) {
        RenderUtils.drawBoxHorizontalSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxTopBatchedQuads(minX, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxBottomBatchedQuads(minX, minY, minZ, maxX, maxZ, color, buffer);
    }

    public static void drawBoxWithEdgesBatched(BlockPos posMin, BlockPos posMax, Color4f colorLines, Color4f colorSides, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        RenderUtils.drawBoxWithEdgesBatched(posMin, posMax, Vector3d.field_186680_a, colorLines, colorSides, bufferQuads, bufferLines);
    }

    public static void drawBoxWithEdgesBatched(BlockPos posMin, BlockPos posMax, Vector3d cameraPos, Color4f colorLines, Color4f colorSides, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        double x1 = (double)posMin.func_177958_n() - cameraPos.field_72450_a;
        double y1 = (double)posMin.func_177956_o() - cameraPos.field_72448_b;
        double z1 = (double)posMin.func_177952_p() - cameraPos.field_72449_c;
        double x2 = (double)(posMax.func_177958_n() + 1) - cameraPos.field_72450_a;
        double y2 = (double)(posMax.func_177956_o() + 1) - cameraPos.field_72448_b;
        double z2 = (double)(posMax.func_177952_p() + 1) - cameraPos.field_72449_c;
        RenderUtils.drawBoxAllSidesBatchedQuads(x1, y1, z1, x2, y2, z2, colorSides, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(x1, y1, z1, x2, y2, z2, colorLines, bufferLines);
    }

    public static void drawBoxHorizontalSidesBatchedQuads(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color, BufferBuilder buffer) {
        buffer.func_225582_a_(minX, minY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, minY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, maxY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, maxY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, minY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, minY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, maxY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, maxY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, minY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, minY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, maxY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, maxY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, minY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, minY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, maxY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, maxY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
    }

    public static void drawBoxTopBatchedQuads(double minX, double minZ, double maxX, double maxY, double maxZ, Color4f color, BufferBuilder buffer) {
        buffer.func_225582_a_(minX, maxY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, maxY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, maxY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, maxY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
    }

    public static void drawBoxBottomBatchedQuads(double minX, double minY, double minZ, double maxX, double maxZ, Color4f color, BufferBuilder buffer) {
        buffer.func_225582_a_(maxX, minY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, minY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, minY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, minY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
    }

    public static void drawBoxAllEdgesBatchedLines(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color, BufferBuilder buffer) {
        buffer.func_225582_a_(minX, minY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, minY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, minY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, maxY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, maxY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, maxY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, maxY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, minY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, minY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, minY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, minY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, maxY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, maxY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, maxY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, maxY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, minY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, minY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, minY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, maxY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, maxY, minZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, minY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, minY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(maxX, maxY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
        buffer.func_225582_a_(minX, maxY, maxZ).func_227885_a_(color.r, color.g, color.b, color.a).func_181675_d();
    }

    public static void drawBox(IntBoundingBox bb, Vector3d cameraPos, Color4f color, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        double minX = (double)bb.minX - cameraPos.field_72450_a;
        double minY = (double)bb.minY - cameraPos.field_72448_b;
        double minZ = (double)bb.minZ - cameraPos.field_72449_c;
        double maxX = (double)(bb.maxX + 1) - cameraPos.field_72450_a;
        double maxY = (double)(bb.maxY + 1) - cameraPos.field_72448_b;
        double maxZ = (double)(bb.maxZ + 1) - cameraPos.field_72449_c;
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, bufferLines);
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float scale, MatrixStack matrixStack) {
        Entity entity = RenderUtils.mc().func_175606_aa();
        if (entity != null) {
            RenderUtils.drawTextPlate(text, x, y, z, entity.field_70177_z, entity.field_70125_A, scale, -1, 0x40000000, true, matrixStack);
        }
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float yaw, float pitch, float scale, int textColor, int bgColor, boolean disableDepth, MatrixStack matrixStack) {
        FontRenderer textRenderer = RenderUtils.mc().field_71466_p;
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)x), (float)((float)y), (float)((float)z));
        RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.scalef((float)(-scale), (float)(-scale), (float)scale);
        RenderSystem.disableLighting();
        RenderSystem.disableCull();
        if (disableDepth) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableDepthTest();
        }
        RenderUtils.setupBlend();
        RenderSystem.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        int maxLineLen = 0;
        for (String line : text) {
            maxLineLen = Math.max(maxLineLen, textRenderer.func_78256_a(line));
        }
        int strLenHalf = maxLineLen / 2;
        Objects.requireNonNull(textRenderer);
        int textHeight = 9 * text.size() - 1;
        int bga = bgColor >>> 24 & 0xFF;
        int bgr = bgColor >>> 16 & 0xFF;
        int bgg = bgColor >>> 8 & 0xFF;
        int bgb = bgColor & 0xFF;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_((double)(-strLenHalf - 1), -1.0, 0.0).func_225586_a_(bgr, bgg, bgb, bga).func_181675_d();
        buffer.func_225582_a_((double)(-strLenHalf - 1), (double)textHeight, 0.0).func_225586_a_(bgr, bgg, bgb, bga).func_181675_d();
        buffer.func_225582_a_((double)strLenHalf, (double)textHeight, 0.0).func_225586_a_(bgr, bgg, bgb, bga).func_181675_d();
        buffer.func_225582_a_((double)strLenHalf, -1.0, 0.0).func_225586_a_(bgr, bgg, bgb, bga).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        int textY = 0;
        if (!disableDepth) {
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)-0.6f, (float)-1.2f);
        }
        for (String line : text) {
            if (disableDepth) {
                RenderSystem.depthMask((boolean)false);
                RenderSystem.disableDepthTest();
            }
            textRenderer.func_238421_b_(matrixStack, line, (float)(-strLenHalf), (float)textY, 0x20000000 | textColor & 0xFFFFFF);
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            textRenderer.func_238421_b_(matrixStack, line, (float)(-strLenHalf), (float)textY, textColor);
            Objects.requireNonNull(textRenderer);
            textY += 9;
        }
        if (!disableDepth) {
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
        }
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
    }

    public static void renderBlockTargetingOverlay(Entity entity, BlockPos pos, Direction side, Vector3d hitVec, Color4f color, MatrixStack matrixStack, Minecraft mc) {
        Direction playerFacing = entity.func_174811_aO();
        PositionUtils.HitPart part = PositionUtils.getHitPart(side, playerFacing, pos, hitVec);
        Vector3d cameraPos = mc.field_71460_t.func_215316_n().func_216785_c();
        double x = (double)pos.func_177958_n() + 0.5 - cameraPos.field_72450_a;
        double y = (double)pos.func_177956_o() + 0.5 - cameraPos.field_72448_b;
        double z = (double)pos.func_177952_p() + 0.5 - cameraPos.field_72449_c;
        RenderSystem.pushMatrix();
        MatrixStack matrixStackTmp = new MatrixStack();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing, matrixStackTmp);
        RenderSystem.multMatrix((Matrix4f)matrixStackTmp.func_227866_c_().func_227870_a_());
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        int quadAlpha = 45;
        int hr = (int)(color.r * 255.0f);
        int hg = (int)(color.g * 255.0f);
        int hb = (int)(color.b * 255.0f);
        int ha = (int)(color.a * 255.0f);
        int c = 255;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_(x - 0.5, y - 0.5, z).func_225586_a_(c, c, c, quadAlpha).func_181675_d();
        buffer.func_225582_a_(x + 0.5, y - 0.5, z).func_225586_a_(c, c, c, quadAlpha).func_181675_d();
        buffer.func_225582_a_(x + 0.5, y + 0.5, z).func_225586_a_(c, c, c, quadAlpha).func_181675_d();
        buffer.func_225582_a_(x - 0.5, y + 0.5, z).func_225586_a_(c, c, c, quadAlpha).func_181675_d();
        switch (part) {
            case CENTER: {
                buffer.func_225582_a_(x - 0.25, y - 0.25, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                buffer.func_225582_a_(x + 0.25, y - 0.25, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                buffer.func_225582_a_(x + 0.25, y + 0.25, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                buffer.func_225582_a_(x - 0.25, y + 0.25, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                break;
            }
            case LEFT: {
                buffer.func_225582_a_(x - 0.5, y - 0.5, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                buffer.func_225582_a_(x - 0.25, y - 0.25, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                buffer.func_225582_a_(x - 0.25, y + 0.25, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                buffer.func_225582_a_(x - 0.5, y + 0.5, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                break;
            }
            case RIGHT: {
                buffer.func_225582_a_(x + 0.5, y - 0.5, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                buffer.func_225582_a_(x + 0.25, y - 0.25, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                buffer.func_225582_a_(x + 0.25, y + 0.25, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                buffer.func_225582_a_(x + 0.5, y + 0.5, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                break;
            }
            case TOP: {
                buffer.func_225582_a_(x - 0.5, y + 0.5, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                buffer.func_225582_a_(x - 0.25, y + 0.25, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                buffer.func_225582_a_(x + 0.25, y + 0.25, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                buffer.func_225582_a_(x + 0.5, y + 0.5, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                break;
            }
            case BOTTOM: {
                buffer.func_225582_a_(x - 0.5, y - 0.5, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                buffer.func_225582_a_(x - 0.25, y - 0.25, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                buffer.func_225582_a_(x + 0.25, y - 0.25, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                buffer.func_225582_a_(x + 0.5, y - 0.5, z).func_225586_a_(hr, hg, hb, ha).func_181675_d();
                break;
            }
        }
        tessellator.func_78381_a();
        RenderSystem.lineWidth((float)1.6f);
        buffer.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_(x - 0.25, y - 0.25, z).func_225586_a_(c, c, c, c).func_181675_d();
        buffer.func_225582_a_(x + 0.25, y - 0.25, z).func_225586_a_(c, c, c, c).func_181675_d();
        buffer.func_225582_a_(x + 0.25, y + 0.25, z).func_225586_a_(c, c, c, c).func_181675_d();
        buffer.func_225582_a_(x - 0.25, y + 0.25, z).func_225586_a_(c, c, c, c).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_(x - 0.5, y - 0.5, z).func_225586_a_(c, c, c, c).func_181675_d();
        buffer.func_225582_a_(x - 0.25, y - 0.25, z).func_225586_a_(c, c, c, c).func_181675_d();
        buffer.func_225582_a_(x - 0.5, y + 0.5, z).func_225586_a_(c, c, c, c).func_181675_d();
        buffer.func_225582_a_(x - 0.25, y + 0.25, z).func_225586_a_(c, c, c, c).func_181675_d();
        buffer.func_225582_a_(x + 0.5, y - 0.5, z).func_225586_a_(c, c, c, c).func_181675_d();
        buffer.func_225582_a_(x + 0.25, y - 0.25, z).func_225586_a_(c, c, c, c).func_181675_d();
        buffer.func_225582_a_(x + 0.5, y + 0.5, z).func_225586_a_(c, c, c, c).func_181675_d();
        buffer.func_225582_a_(x + 0.25, y + 0.25, z).func_225586_a_(c, c, c, c).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.popMatrix();
    }

    public static void renderBlockTargetingOverlaySimple(Entity entity, BlockPos pos, Direction side, Color4f color, MatrixStack matrixStack, Minecraft mc) {
        Direction playerFacing = entity.func_174811_aO();
        Vector3d cameraPos = mc.field_71460_t.func_215316_n().func_216785_c();
        double x = (double)pos.func_177958_n() + 0.5 - cameraPos.field_72450_a;
        double y = (double)pos.func_177956_o() + 0.5 - cameraPos.field_72448_b;
        double z = (double)pos.func_177952_p() + 0.5 - cameraPos.field_72449_c;
        RenderSystem.pushMatrix();
        MatrixStack matrixStackTmp = new MatrixStack();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing, matrixStackTmp);
        RenderSystem.multMatrix((Matrix4f)matrixStackTmp.func_227866_c_().func_227870_a_());
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        int a = (int)(color.a * 255.0f);
        int r = (int)(color.r * 255.0f);
        int g = (int)(color.g * 255.0f);
        int b = (int)(color.b * 255.0f);
        int c = 255;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_(x - 0.5, y - 0.5, z).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(x + 0.5, y - 0.5, z).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(x + 0.5, y + 0.5, z).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_225582_a_(x - 0.5, y + 0.5, z).func_225586_a_(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.lineWidth((float)1.6f);
        buffer.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        buffer.func_225582_a_(x - 0.375, y - 0.375, z).func_225586_a_(c, c, c, c).func_181675_d();
        buffer.func_225582_a_(x + 0.375, y - 0.375, z).func_225586_a_(c, c, c, c).func_181675_d();
        buffer.func_225582_a_(x + 0.375, y + 0.375, z).func_225586_a_(c, c, c, c).func_181675_d();
        buffer.func_225582_a_(x - 0.375, y + 0.375, z).func_225586_a_(c, c, c, c).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.popMatrix();
    }

    private static void blockTargetingOverlayTranslations(double x, double y, double z, Direction side, Direction playerFacing, MatrixStack matrixStack) {
        matrixStack.func_227861_a_(x, y, z);
        switch (side) {
            case DOWN: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - playerFacing.func_185119_l()));
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                break;
            }
            case UP: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - playerFacing.func_185119_l()));
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                break;
            }
            case NORTH: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                break;
            }
            case EAST: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            }
        }
        matrixStack.func_227861_a_(-x, -y, -z + 0.51);
    }

    public static void renderMapPreview(ItemStack stack, int x, int y, int dimensions) {
        if (stack.func_77973_b() instanceof FilledMapItem && GuiBase.isShiftDown()) {
            RenderSystem.pushMatrix();
            RenderSystem.disableLighting();
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            int y1 = y - dimensions - 20;
            int y2 = y1 + dimensions;
            int x1 = x + 8;
            int x2 = x1 + dimensions;
            int z = 300;
            RenderUtils.bindTexture(TEXTURE_MAP_BACKGROUND);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_225582_a_((double)x1, (double)y2, (double)z).func_225583_a_(0.0f, 1.0f).func_181675_d();
            buffer.func_225582_a_((double)x2, (double)y2, (double)z).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buffer.func_225582_a_((double)x2, (double)y1, (double)z).func_225583_a_(1.0f, 0.0f).func_181675_d();
            buffer.func_225582_a_((double)x1, (double)y1, (double)z).func_225583_a_(0.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
            MapData mapdata = FilledMapItem.func_219994_a((ItemStack)stack, (World)RenderUtils.mc().field_71441_e);
            if (mapdata != null) {
                z = 310;
                double scale = (double)(dimensions - 16) / 128.0;
                RenderSystem.translatef((float)(x1 += 8), (float)(y1 += 8), (float)z);
                RenderSystem.scaled((double)scale, (double)scale, (double)0.0);
                RenderUtils.mc().field_71460_t.func_147701_i().func_228086_a_(new MatrixStack(), (IRenderTypeBuffer)Minecraft.func_71410_x().func_228019_au_().func_228487_b_(), mapdata, false, 0xF000F0);
            }
            RenderSystem.enableLighting();
            RenderSystem.popMatrix();
        }
    }

    public static void renderShulkerBoxPreview(ItemStack stack, int x, int y, boolean useBgColors) {
        if (stack.func_77942_o()) {
            NonNullList<ItemStack> items = InventoryUtils.getStoredItems(stack, -1);
            if (items.size() == 0) {
                return;
            }
            RenderSystem.pushMatrix();
            RenderUtils.disableDiffuseLighting();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)400.0f);
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(stack);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, items.size());
            x += 8;
            y -= props.height + 18;
            if (stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() instanceof ShulkerBoxBlock) {
                RenderUtils.setShulkerboxBackgroundTintColor((ShulkerBoxBlock)((BlockItem)stack.func_77973_b()).func_179223_d(), useBgColors);
            } else {
                RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            }
            InventoryOverlay.renderInventoryBackground(type, x, y, props.slotsPerRow, items.size(), RenderUtils.mc());
            RenderUtils.enableDiffuseLightingGui3D();
            RenderSystem.enableDepthTest();
            RenderSystem.enableRescaleNormal();
            IInventory inv = InventoryUtils.getAsInventory(items);
            InventoryOverlay.renderInventoryStacks(type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, -1, RenderUtils.mc());
            RenderSystem.disableDepthTest();
            RenderSystem.popMatrix();
        }
    }

    public static void setShulkerboxBackgroundTintColor(@Nullable ShulkerBoxBlock block, boolean useBgColors) {
        if (block != null && useBgColors) {
            DyeColor dye = block.func_190956_e() != null ? block.func_190956_e() : DyeColor.PURPLE;
            float[] colors = dye.func_193349_f();
            RenderUtils.color(colors[0], colors[1], colors[2], 1.0f);
        } else {
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static void renderModelInGui(int x, int y, IBakedModel model, BlockState state, float zLevel) {
        if (state.func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderUtils.bindTexture(PlayerContainer.field_226615_c_);
        RenderUtils.mc().func_110434_K().func_229267_b_(PlayerContainer.field_226615_c_).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.enableBlend();
        RenderUtils.setupBlendSimple();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderUtils.setupGuiTransform(x, y, model.func_177556_c(), zLevel);
        RenderSystem.rotatef((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.rotatef((float)225.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.scalef((float)0.625f, (float)0.625f, (float)0.625f);
        RenderUtils.renderModel(model, state);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableLighting();
        RenderSystem.popMatrix();
    }

    public static void setupGuiTransform(int xPosition, int yPosition, boolean isGui3d, float zLevel) {
        RenderSystem.translatef((float)xPosition, (float)yPosition, (float)(100.0f + zLevel));
        RenderSystem.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        RenderSystem.scalef((float)16.0f, (float)16.0f, (float)16.0f);
        if (isGui3d) {
            RenderSystem.enableLighting();
        } else {
            RenderSystem.disableLighting();
        }
    }

    private static void renderModel(IBakedModel model, BlockState state) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        int color = -1;
        if (!model.func_188618_c()) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            for (Direction face : Direction.values()) {
                RAND.setSeed(0L);
                RenderUtils.renderQuads(bufferbuilder, model.func_200117_a(state, face, RAND), state, color);
            }
            RAND.setSeed(0L);
            RenderUtils.renderQuads(bufferbuilder, model.func_200117_a(state, null, RAND), state, color);
            tessellator.func_78381_a();
        }
        RenderSystem.popMatrix();
    }

    private static void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, BlockState state, int color) {
        int quadCount = quads.size();
        for (int i = 0; i < quadCount; ++i) {
            BakedQuad quad = quads.get(i);
            RenderUtils.renderQuad(renderer, quad, state, -1);
        }
    }

    private static void renderQuad(BufferBuilder buffer, BakedQuad quad, BlockState state, int color) {
    }

    private static Minecraft mc() {
        return Minecraft.func_71410_x();
    }
}

