/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiTextFieldDouble;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.GuiTextFieldInteger;
import fi.dy.masa.malilib.gui.MaLiLibIcons;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.interfaces.ICoordinateValueModifier;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.StringUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class GuiUtils {
    public static int getScaledWindowWidth() {
        return Minecraft.func_71410_x().func_228018_at_().func_198107_o();
    }

    public static int getScaledWindowHeight() {
        return Minecraft.func_71410_x().func_228018_at_().func_198087_p();
    }

    public static int getDisplayWidth() {
        return Minecraft.func_71410_x().func_228018_at_().func_198105_m();
    }

    public static int getDisplayHeight() {
        return Minecraft.func_71410_x().func_228018_at_().func_198083_n();
    }

    @Nullable
    public static Screen getCurrentScreen() {
        return Minecraft.func_71410_x().field_71462_r;
    }

    public static void createBlockPosInputsVertical(int x, int y, int textFieldWidth, BlockPos pos, ICoordinateValueModifier modifier, boolean addButton, GuiBase gui) {
        GuiUtils.createBlockPosInput(x, y, textFieldWidth, PositionUtils.CoordinateType.X, pos, modifier, addButton, gui);
        GuiUtils.createBlockPosInput(x, y + 17, textFieldWidth, PositionUtils.CoordinateType.Y, pos, modifier, addButton, gui);
        GuiUtils.createBlockPosInput(x, y + 34, textFieldWidth, PositionUtils.CoordinateType.Z, pos, modifier, addButton, gui);
    }

    public static void createVec3dInputsVertical(int x, int y, int textFieldWidth, Vector3d pos, ICoordinateValueModifier modifier, boolean addButton, GuiBase gui) {
        GuiUtils.createVec3dInput(x, y, textFieldWidth, PositionUtils.CoordinateType.X, pos, modifier, addButton, gui);
        GuiUtils.createVec3dInput(x, y + 17, textFieldWidth, PositionUtils.CoordinateType.Y, pos, modifier, addButton, gui);
        GuiUtils.createVec3dInput(x, y + 34, textFieldWidth, PositionUtils.CoordinateType.Z, pos, modifier, addButton, gui);
    }

    public static void createBlockPosInput(int x, int y, int textFieldWidth, PositionUtils.CoordinateType type, BlockPos pos, ICoordinateValueModifier modifier, boolean addButton, GuiBase gui) {
        x = GuiUtils.addLabel(x, y, type, gui);
        GuiTextFieldInteger textField = new GuiTextFieldInteger(x, y + 1, textFieldWidth, 14, Minecraft.func_71410_x().field_71466_p);
        textField.func_146180_a(GuiUtils.getCoordinateValueString(type, pos));
        GuiUtils.addTextFieldAndButton(x + textFieldWidth + 4, y, type, modifier, textField, addButton, gui);
    }

    public static void createVec3dInput(int x, int y, int textFieldWidth, PositionUtils.CoordinateType type, Vector3d pos, ICoordinateValueModifier modifier, boolean addButton, GuiBase gui) {
        x = GuiUtils.addLabel(x, y, type, gui);
        GuiTextFieldDouble textField = new GuiTextFieldDouble(x, y + 1, textFieldWidth, 14, Minecraft.func_71410_x().field_71466_p);
        textField.func_146180_a(GuiUtils.getCoordinateValueString(type, pos));
        GuiUtils.addTextFieldAndButton(x + textFieldWidth + 4, y, type, modifier, textField, addButton, gui);
    }

    protected static void addTextFieldAndButton(int x, int y, PositionUtils.CoordinateType type, ICoordinateValueModifier modifier, GuiTextFieldGeneric textField, boolean addButton, GuiBase gui) {
        gui.addTextField(textField, new TextFieldListenerCoordinateInput(type, modifier));
        if (addButton) {
            String hover = StringUtils.translate("malilib.gui.button.hover.plus_minus_tip", new Object[0]);
            ButtonGeneric button = new ButtonGeneric(x, y, MaLiLibIcons.BTN_PLUSMINUS_16, hover);
            gui.addButton(button, new ButtonListenerCoordinateInput(type, modifier));
        }
    }

    public static String getCoordinateValueString(PositionUtils.CoordinateType type, BlockPos pos) {
        switch (type) {
            case X: {
                return String.valueOf(pos.func_177958_n());
            }
            case Y: {
                return String.valueOf(pos.func_177956_o());
            }
            case Z: {
                return String.valueOf(pos.func_177952_p());
            }
        }
        return "";
    }

    public static String getCoordinateValueString(PositionUtils.CoordinateType type, Vector3d pos) {
        switch (type) {
            case X: {
                return String.valueOf(pos.field_72450_a);
            }
            case Y: {
                return String.valueOf(pos.field_72448_b);
            }
            case Z: {
                return String.valueOf(pos.field_72449_c);
            }
        }
        return "";
    }

    protected static int addLabel(int x, int y, PositionUtils.CoordinateType type, GuiBase gui) {
        String label = type.name() + ":";
        int labelWidth = 0;
        for (PositionUtils.CoordinateType t : PositionUtils.CoordinateType.values()) {
            labelWidth = Math.max(labelWidth, StringUtils.getStringWidth(t.name() + ":") + 4);
        }
        gui.addLabel(x, y, labelWidth, 20, -1, label);
        return x += labelWidth;
    }

    public static class TextFieldListenerCoordinateInput
    implements ITextFieldListener<GuiTextFieldGeneric> {
        protected final ICoordinateValueModifier modifier;
        protected final PositionUtils.CoordinateType type;

        public TextFieldListenerCoordinateInput(PositionUtils.CoordinateType type, ICoordinateValueModifier modifier) {
            this.modifier = modifier;
            this.type = type;
        }

        @Override
        public boolean onTextChange(GuiTextFieldGeneric textField) {
            this.modifier.setValueFromString(this.type, textField.func_146179_b());
            return false;
        }
    }

    public static class ButtonListenerCoordinateInput
    implements IButtonActionListener {
        protected final ICoordinateValueModifier modifier;
        protected final PositionUtils.CoordinateType type;

        public ButtonListenerCoordinateInput(PositionUtils.CoordinateType type, ICoordinateValueModifier modifier) {
            this.modifier = modifier;
            this.type = type;
        }

        @Override
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            int amount;
            int n = amount = mouseButton == 1 ? -1 : 1;
            if (GuiBase.isShiftDown()) {
                amount *= 8;
            }
            if (GuiBase.isAltDown()) {
                amount *= 4;
            }
            this.modifier.modifyValue(this.type, amount);
        }

        public static enum Type {
            NUDGE_COORD_X,
            NUDGE_COORD_Y,
            NUDGE_COORD_Z;

        }
    }
}

