/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IMessageConsumer;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetLabel;
import fi.dy.masa.malilib.gui.wrappers.TextFieldWrapper;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.render.MessageRenderer;
import fi.dy.masa.malilib.render.RenderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class GuiBase
extends Screen
implements IMessageConsumer,
IStringConsumer {
    public static final String TXT_AQUA = ChatFormatting.AQUA.toString();
    public static final String TXT_BLACK = ChatFormatting.BLACK.toString();
    public static final String TXT_BLUE = ChatFormatting.BLUE.toString();
    public static final String TXT_GOLD = ChatFormatting.GOLD.toString();
    public static final String TXT_GRAY = ChatFormatting.GRAY.toString();
    public static final String TXT_GREEN = ChatFormatting.GREEN.toString();
    public static final String TXT_RED = ChatFormatting.RED.toString();
    public static final String TXT_WHITE = ChatFormatting.WHITE.toString();
    public static final String TXT_YELLOW = ChatFormatting.YELLOW.toString();
    public static final String TXT_BOLD = ChatFormatting.BOLD.toString();
    public static final String TXT_ITALIC = ChatFormatting.ITALIC.toString();
    public static final String TXT_RST = ChatFormatting.RESET.toString();
    public static final String TXT_STRIKETHROUGH = ChatFormatting.STRIKETHROUGH.toString();
    public static final String TXT_UNDERLINE = ChatFormatting.UNDERLINE.toString();
    public static final String TXT_DARK_AQUA = ChatFormatting.DARK_AQUA.toString();
    public static final String TXT_DARK_BLUE = ChatFormatting.DARK_BLUE.toString();
    public static final String TXT_DARK_GRAY = ChatFormatting.DARK_GRAY.toString();
    public static final String TXT_DARK_GREEN = ChatFormatting.DARK_GREEN.toString();
    public static final String TXT_DARK_PURPLE = ChatFormatting.DARK_PURPLE.toString();
    public static final String TXT_DARK_RED = ChatFormatting.DARK_RED.toString();
    public static final String TXT_LIGHT_PURPLE = ChatFormatting.LIGHT_PURPLE.toString();
    protected static final String BUTTON_LABEL_ADD = TXT_DARK_GREEN + "+" + TXT_RST;
    protected static final String BUTTON_LABEL_REMOVE = TXT_DARK_RED + "-" + TXT_RST;
    public static final int COLOR_WHITE = -1;
    public static final int TOOLTIP_BACKGROUND = -1342177280;
    public static final int COLOR_HORIZONTAL_BAR = -6710887;
    protected static final int LEFT = 20;
    protected static final int TOP = 10;
    public final Minecraft mc = Minecraft.m_91087_();
    public final Font textRenderer;
    public final int fontHeight;
    private final List<ButtonBase> buttons;
    private final List<WidgetBase> widgets;
    private final List<TextFieldWrapper<? extends GuiTextFieldGeneric>> textFields;
    private final MessageRenderer messageRenderer;
    protected WidgetBase hoveredWidget;
    protected String title;
    protected boolean useTitleHierarchy;
    private int keyInputCount;
    private double mouseWheelDeltaSum;
    @Nullable
    private Screen parent;

    protected GuiBase() {
        super((Component)new TextComponent(""));
        this.textRenderer = this.mc.f_91062_;
        Objects.requireNonNull(this.textRenderer);
        this.fontHeight = 9;
        this.buttons = new ArrayList<ButtonBase>();
        this.widgets = new ArrayList<WidgetBase>();
        this.textFields = new ArrayList<TextFieldWrapper<? extends GuiTextFieldGeneric>>();
        this.messageRenderer = new MessageRenderer(-587202560, -6710887);
        this.hoveredWidget = null;
        this.title = "";
        this.useTitleHierarchy = true;
    }

    public GuiBase setParent(@Nullable Screen parent) {
        if (parent == null || parent.getClass() != this.getClass()) {
            this.parent = parent;
        }
        return this;
    }

    @Nullable
    public Screen getParent() {
        return this.parent;
    }

    public String getTitleString() {
        return this.useTitleHierarchy && this.parent instanceof GuiBase ? ((GuiBase)this.parent).getTitleString() + " => " + this.title : this.title;
    }

    public Component m_96636_() {
        return new TextComponent(this.getTitleString());
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void m_7861_() {
        this.mc.f_91068_.m_90926_(false);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_6574_(Minecraft mc, int width, int height) {
        if (this.getParent() != null) {
            this.getParent().m_6574_(mc, width, height);
        }
        super.m_6574_(mc, width, height);
    }

    public void m_7856_() {
        super.m_7856_();
        this.initGui();
    }

    public void initGui() {
        this.clearElements();
    }

    protected void closeGui(boolean showParent) {
        if (showParent) {
            this.mc.m_91152_(this.parent);
        } else {
            this.m_7379_();
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.drawScreenBackground(mouseX, mouseY);
        this.drawTitle(matrixStack, mouseX, mouseY, partialTicks);
        this.drawWidgets(mouseX, mouseY, matrixStack);
        this.drawTextFields(mouseX, mouseY, matrixStack);
        this.drawButtons(mouseX, mouseY, partialTicks, matrixStack);
        this.drawContents(matrixStack, mouseX, mouseY, partialTicks);
        this.drawButtonHoverTexts(mouseX, mouseY, partialTicks, matrixStack);
        this.drawHoveredWidget(mouseX, mouseY, matrixStack);
        this.drawGuiMessages(matrixStack);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.mouseWheelDeltaSum != 0.0 && Math.signum(amount) != Math.signum(this.mouseWheelDeltaSum)) {
            this.mouseWheelDeltaSum = 0.0;
        }
        this.mouseWheelDeltaSum += amount;
        amount = (int)this.mouseWheelDeltaSum;
        if (amount != 0.0) {
            this.mouseWheelDeltaSum -= amount;
            if (this.onMouseScrolled((int)mouseX, (int)mouseY, amount)) {
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (!this.onMouseClicked((int)mouseX, (int)mouseY, mouseButton)) {
            return super.m_6375_(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        if (!this.onMouseReleased((int)mouseX, (int)mouseY, mouseButton)) {
            return super.m_6348_(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        ++this.keyInputCount;
        if (this.onKeyTyped(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char charIn, int modifiers) {
        if (this.keyInputCount <= 0) {
            return true;
        }
        if (this.onCharTyped(charIn, modifiers)) {
            return true;
        }
        return super.m_5534_(charIn, modifiers);
    }

    public boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        for (ButtonBase button : this.buttons) {
            if (!button.onMouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        boolean handled = false;
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> entry : this.textFields) {
            if (!entry.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            handled = true;
        }
        if (!handled) {
            for (WidgetBase widget : this.widgets) {
                if (!widget.isMouseOver(mouseX, mouseY) || !widget.onMouseClicked(mouseX, mouseY, mouseButton)) continue;
                handled = true;
                break;
            }
        }
        return handled;
    }

    public boolean onMouseReleased(int mouseX, int mouseY, int mouseButton) {
        for (WidgetBase widget : this.widgets) {
            widget.onMouseReleased(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean onMouseScrolled(int mouseX, int mouseY, double mouseWheelDelta) {
        for (ButtonBase button : this.buttons) {
            if (!button.onMouseScrolled(mouseX, mouseY, mouseWheelDelta)) continue;
            return true;
        }
        for (WidgetBase widget : this.widgets) {
            if (!widget.onMouseScrolled(mouseX, mouseY, mouseWheelDelta)) continue;
            return true;
        }
        return false;
    }

    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        boolean handled = false;
        int selected = -1;
        for (int i = 0; i < this.textFields.size(); ++i) {
            TextFieldWrapper<? extends GuiTextFieldGeneric> entry = this.textFields.get(i);
            if (!entry.isFocused()) continue;
            if (keyCode == 258) {
                entry.setFocused(false);
                selected = i;
            } else {
                entry.onKeyTyped(keyCode, scanCode, modifiers);
            }
            handled = keyCode != 256;
            break;
        }
        if (!handled) {
            for (WidgetBase widget : this.widgets) {
                if (!widget.onKeyTyped(keyCode, scanCode, modifiers)) continue;
                handled = true;
                break;
            }
        }
        if (!handled && keyCode == 256) {
            this.closeGui(!GuiBase.isShiftDown());
            return true;
        }
        if (selected >= 0) {
            selected = GuiBase.isShiftDown() ? (selected > 0 ? selected - 1 : this.textFields.size() - 1) : (selected + 1) % this.textFields.size();
            this.textFields.get(selected).setFocused(true);
        }
        return handled;
    }

    public boolean onCharTyped(char charIn, int modifiers) {
        boolean handled = false;
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> entry : this.textFields) {
            if (!entry.onCharTyped(charIn, modifiers)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            for (WidgetBase widget : this.widgets) {
                if (!widget.onCharTyped(charIn, modifiers)) continue;
                handled = true;
                break;
            }
        }
        return handled;
    }

    @Override
    public void setString(String string) {
        this.messageRenderer.addMessage(3000, string, new Object[0]);
    }

    @Override
    public void addMessage(Message.MessageType type, String messageKey, Object ... args) {
        this.addGuiMessage(type, 5000, messageKey, args);
    }

    @Override
    public void addMessage(Message.MessageType type, int lifeTime, String messageKey, Object ... args) {
        this.addGuiMessage(type, lifeTime, messageKey, args);
    }

    public void addGuiMessage(Message.MessageType type, int displayTimeMs, String messageKey, Object ... args) {
        this.messageRenderer.addMessage(type, displayTimeMs, messageKey, args);
    }

    public void setNextMessageType(Message.MessageType type) {
        this.messageRenderer.setNextMessageType(type);
    }

    protected void drawGuiMessages(PoseStack matrixStack) {
        this.messageRenderer.drawMessages(this.f_96543_ / 2, this.f_96544_ / 2, matrixStack);
    }

    public void bindTexture(ResourceLocation texture) {
        RenderUtils.bindTexture(texture);
    }

    public <T extends ButtonBase> T addButton(T button, IButtonActionListener listener) {
        button.setActionListener(listener);
        this.buttons.add(button);
        return button;
    }

    public <T extends GuiTextFieldGeneric> TextFieldWrapper<T> addTextField(T textField, @Nullable ITextFieldListener<T> listener) {
        TextFieldWrapper<T> wrapper = new TextFieldWrapper<T>(textField, listener);
        this.textFields.add(wrapper);
        return wrapper;
    }

    public <T extends WidgetBase> T addWidget(T widget) {
        this.widgets.add(widget);
        return widget;
    }

    public WidgetLabel addLabel(int x, int y, int width, int height, int textColor, String ... lines) {
        return this.addLabel(x, y, width, height, textColor, Arrays.asList(lines));
    }

    public WidgetLabel addLabel(int x, int y, int width, int height, int textColor, List<String> lines) {
        if (lines.size() > 0 && width == -1) {
            for (String line : lines) {
                width = Math.max(width, this.getStringWidth(line));
            }
        }
        return this.addWidget(new WidgetLabel(x, y, width, height, textColor, lines));
    }

    protected boolean removeWidget(WidgetBase widget) {
        if (widget != null && this.widgets.contains(widget)) {
            this.widgets.remove(widget);
            return true;
        }
        return false;
    }

    protected void clearElements() {
        this.clearWidgets();
        this.clearButtons();
        this.clearTextFields();
    }

    protected void clearWidgets() {
        this.widgets.clear();
    }

    protected void clearButtons() {
        this.buttons.clear();
    }

    protected void clearTextFields() {
        this.textFields.clear();
    }

    protected void drawScreenBackground(int mouseX, int mouseY) {
        RenderUtils.drawRect(0, 0, this.f_96543_, this.f_96544_, -1342177280);
    }

    protected void drawTitle(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.drawString(matrixStack, this.getTitleString(), 20, 10, -1);
    }

    protected void drawContents(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
    }

    protected void drawButtons(int mouseX, int mouseY, float partialTicks, PoseStack matrixStack) {
        for (ButtonBase button : this.buttons) {
            button.render(mouseX, mouseY, button.isMouseOver(), matrixStack);
        }
    }

    protected void drawTextFields(int mouseX, int mouseY, PoseStack matrixStack) {
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> entry : this.textFields) {
            entry.draw(mouseX, mouseY, matrixStack);
        }
    }

    protected void drawWidgets(int mouseX, int mouseY, PoseStack matrixStack) {
        this.hoveredWidget = null;
        if (!this.widgets.isEmpty()) {
            for (WidgetBase widget : this.widgets) {
                widget.render(mouseX, mouseY, false, matrixStack);
                if (!widget.isMouseOver(mouseX, mouseY)) continue;
                this.hoveredWidget = widget;
            }
        }
    }

    protected void drawButtonHoverTexts(int mouseX, int mouseY, float partialTicks, PoseStack matrixStack) {
        for (ButtonBase button : this.buttons) {
            if (!button.hasHoverText() || !button.isMouseOver()) continue;
            RenderUtils.drawHoverText(mouseX, mouseY, button.getHoverStrings(), matrixStack);
        }
        RenderUtils.disableDiffuseLighting();
    }

    protected void drawHoveredWidget(int mouseX, int mouseY, PoseStack matrixStack) {
        if (this.hoveredWidget != null) {
            this.hoveredWidget.postRenderHovered(mouseX, mouseY, false, matrixStack);
            RenderUtils.disableDiffuseLighting();
        }
    }

    public static boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public int getStringWidth(String text) {
        return this.textRenderer.m_92895_(text);
    }

    public void drawString(PoseStack matrixStack, String text, int x, int y, int color) {
        this.textRenderer.m_92883_(matrixStack, text, (float)x, (float)y, color);
    }

    public void drawStringWithShadow(PoseStack matrixStack, String text, int x, int y, int color) {
        this.textRenderer.m_92750_(matrixStack, text, (float)x, (float)y, color);
    }

    public int getMaxPrettyNameLength(List<? extends IConfigBase> configs) {
        int width = 0;
        for (IConfigBase iConfigBase : configs) {
            width = Math.max(width, this.getStringWidth(iConfigBase.getPrettyName()));
        }
        return width;
    }

    public static void openGui(Screen gui) {
        Minecraft.m_91087_().m_91152_(gui);
    }

    public static boolean isShiftDown() {
        return GuiBase.m_96638_();
    }

    public static boolean isCtrlDown() {
        return GuiBase.m_96637_();
    }

    public static boolean isAltDown() {
        return GuiBase.m_96639_();
    }
}

