/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSplitter {
    public static final int MAX_TOTAL_PER_PACKET_S2C = 0x100000;
    public static final int MAX_PAYLOAD_PER_PACKET_S2C = 1048571;
    public static final int MAX_TOTAL_PER_PACKET_C2S = Short.MAX_VALUE;
    public static final int MAX_PAYLOAD_PER_PACKET_C2S = 32762;
    public static final int DEFAULT_MAX_RECEIVE_SIZE_C2S = 0x100000;
    public static final int DEFAULT_MAX_RECEIVE_SIZE_S2C = 0x4000000;
    private static final Map<Pair<PacketListener, ResourceLocation>, ReadingSession> READING_SESSIONS = new HashMap<Pair<PacketListener, ResourceLocation>, ReadingSession>();

    public static void send(ServerGamePacketListenerImpl networkHandler, ResourceLocation channel, FriendlyByteBuf packet) {
        PacketSplitter.send(packet, 1048571, (FriendlyByteBuf buf) -> networkHandler.m_141995_((Packet)new ClientboundCustomPayloadPacket(channel, buf)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void send(ClientPacketListener networkHandler, ResourceLocation channel, FriendlyByteBuf packet) {
        PacketSplitter.send(packet, 32762, (FriendlyByteBuf buf) -> networkHandler.m_104955_((Packet)new ServerboundCustomPayloadPacket(channel, buf)));
    }

    private static void send(FriendlyByteBuf packet, int payloadLimit, Consumer<FriendlyByteBuf> sender) {
        int len = packet.writerIndex();
        packet.resetReaderIndex();
        for (int offset = 0; offset < len; offset += payloadLimit) {
            int thisLen = Math.min(len - offset, payloadLimit);
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer((int)thisLen));
            buf.resetWriterIndex();
            if (offset == 0) {
                buf.m_130130_(len);
            }
            buf.writeBytes((ByteBuf)packet, thisLen);
            sender.accept(buf);
        }
        packet.release();
    }

    @Nullable
    public static FriendlyByteBuf receive(ClientGamePacketListener networkHandler, ClientboundCustomPayloadPacket message) {
        return PacketSplitter.receive(networkHandler, message, 0x4000000);
    }

    @Nullable
    private static FriendlyByteBuf receive(ClientGamePacketListener networkHandler, ClientboundCustomPayloadPacket message, int maxLength) {
        Pair key = Pair.of((Object)networkHandler, (Object)message.m_132042_());
        return READING_SESSIONS.computeIfAbsent((Pair<PacketListener, ResourceLocation>)key, ReadingSession::new).receive(message.m_132045_(), maxLength);
    }

    private static class ReadingSession {
        private final Pair<PacketListener, ResourceLocation> key;
        private int expectedSize = -1;
        private FriendlyByteBuf received;

        private ReadingSession(Pair<PacketListener, ResourceLocation> key) {
            this.key = key;
        }

        @Nullable
        private FriendlyByteBuf receive(FriendlyByteBuf data, int maxLength) {
            if (this.expectedSize < 0) {
                this.expectedSize = data.m_130242_();
                if (this.expectedSize > maxLength) {
                    throw new IllegalArgumentException("Payload too large");
                }
                this.received = new FriendlyByteBuf(Unpooled.buffer((int)this.expectedSize));
            }
            this.received.writeBytes(data.readBytes(data.readableBytes()));
            if (this.received.writerIndex() >= this.expectedSize) {
                READING_SESSIONS.remove(this.key);
                return this.received;
            }
            return null;
        }
    }
}

