/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IRangeChangeListener;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.LayerMode;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.SubChunkPos;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class LayerRange {
    protected final IRangeChangeListener refresher;
    protected LayerMode layerMode = LayerMode.ALL;
    protected Direction.Axis axis = Direction.Axis.Y;
    protected int layerSingle = 0;
    protected int layerAbove = 0;
    protected int layerBelow = 0;
    protected int layerRangeMin = 0;
    protected int layerRangeMax = 0;
    protected boolean hotkeyRangeMin;
    protected boolean hotkeyRangeMax;

    public LayerRange(IRangeChangeListener refresher) {
        this.refresher = refresher;
    }

    public LayerMode getLayerMode() {
        return this.layerMode;
    }

    public Direction.Axis getAxis() {
        return this.axis;
    }

    public boolean getMoveLayerRangeMin() {
        return this.hotkeyRangeMin;
    }

    public boolean getMoveLayerRangeMax() {
        return this.hotkeyRangeMax;
    }

    public void toggleHotkeyMoveRangeMin() {
        this.hotkeyRangeMin = !this.hotkeyRangeMin;
    }

    public void toggleHotkeyMoveRangeMax() {
        this.hotkeyRangeMax = !this.hotkeyRangeMax;
    }

    public int getLayerSingle() {
        return this.layerSingle;
    }

    public int getLayerAbove() {
        return this.layerAbove;
    }

    public int getLayerBelow() {
        return this.layerBelow;
    }

    public int getLayerRangeMin() {
        return this.layerRangeMin;
    }

    public int getLayerRangeMax() {
        return this.layerRangeMax;
    }

    public int getLayerMin() {
        switch (this.layerMode) {
            case ALL: 
            case ALL_BELOW: {
                return Integer.MIN_VALUE;
            }
            case SINGLE_LAYER: {
                return this.layerSingle;
            }
            case ALL_ABOVE: {
                return this.layerAbove;
            }
            case LAYER_RANGE: {
                return this.layerRangeMin;
            }
        }
        return 0;
    }

    public int getLayerMax() {
        switch (this.layerMode) {
            case ALL: 
            case ALL_ABOVE: {
                return Integer.MAX_VALUE;
            }
            case SINGLE_LAYER: {
                return this.layerSingle;
            }
            case ALL_BELOW: {
                return this.layerBelow;
            }
            case LAYER_RANGE: {
                return this.layerRangeMax;
            }
        }
        return 0;
    }

    public int getCurrentLayerValue(boolean isSecondValue) {
        switch (this.layerMode) {
            case SINGLE_LAYER: {
                return this.layerSingle;
            }
            case ALL_ABOVE: {
                return this.layerAbove;
            }
            case ALL_BELOW: {
                return this.layerBelow;
            }
            case LAYER_RANGE: {
                return isSecondValue ? this.layerRangeMax : this.layerRangeMin;
            }
        }
        return 0;
    }

    public void setLayerMode(LayerMode mode) {
        this.setLayerMode(mode, true);
    }

    public void setLayerMode(LayerMode mode, boolean printMessage) {
        this.layerMode = mode;
        this.refresher.updateAll();
        if (printMessage) {
            String val = GuiBase.TXT_GREEN + mode.getDisplayName();
            InfoUtils.printActionbarMessage("malilib.message.set_layer_mode_to", val);
        }
    }

    public void setAxis(Direction.Axis axis) {
        this.axis = axis;
        this.refresher.updateAll();
        String val = GuiBase.TXT_GREEN + axis.m_122477_();
        InfoUtils.printActionbarMessage("malilib.message.set_layer_axis_to", val);
    }

    public void setLayerSingle(int layer) {
        int old = this.layerSingle;
        if (layer != old) {
            this.layerSingle = layer;
            this.updateLayersBetween(old, old);
            this.updateLayersBetween(layer, layer);
        }
    }

    public void setLayerAbove(int layer) {
        int old = this.layerAbove;
        if (layer != old) {
            this.layerAbove = layer;
            this.updateLayersBetween(old, layer);
        }
    }

    public void setLayerBelow(int layer) {
        int old = this.layerBelow;
        if (layer != old) {
            this.layerBelow = layer;
            this.updateLayersBetween(old, layer);
        }
    }

    public boolean setLayerRangeMin(int layer) {
        return this.setLayerRangeMin(layer, false);
    }

    public boolean setLayerRangeMax(int layer) {
        return this.setLayerRangeMax(layer, false);
    }

    protected boolean setLayerRangeMin(int layer, boolean force) {
        int old = this.layerRangeMin;
        if (!force) {
            layer = Math.min(layer, this.layerRangeMax);
        }
        if (layer != old) {
            this.layerRangeMin = layer;
            this.updateLayersBetween(old, layer);
        }
        return layer != old;
    }

    protected int getPositionFromEntity(Entity entity) {
        switch (this.axis) {
            case X: {
                return Mth.m_14107_((double)entity.m_20185_());
            }
            case Y: {
                return Mth.m_14107_((double)entity.m_20186_());
            }
            case Z: {
                return Mth.m_14107_((double)entity.m_20189_());
            }
        }
        return 0;
    }

    protected boolean setLayerRangeMax(int layer, boolean force) {
        int old = this.layerRangeMax;
        if (!force) {
            layer = Math.max(layer, this.layerRangeMin);
        }
        if (layer != old) {
            this.layerRangeMax = layer;
            this.updateLayersBetween(old, layer);
        }
        return layer != old;
    }

    public void setSingleBoundaryToPosition(Entity entity) {
        int pos = this.getPositionFromEntity(entity);
        this.setSingleBoundaryToPosition(pos);
    }

    protected void setSingleBoundaryToPosition(int pos) {
        switch (this.layerMode) {
            case SINGLE_LAYER: {
                this.setLayerSingle(pos);
                break;
            }
            case ALL_ABOVE: {
                this.setLayerAbove(pos);
                break;
            }
            case ALL_BELOW: {
                this.setLayerBelow(pos);
                break;
            }
        }
    }

    public void setToPosition(Entity entity) {
        this.setSingleBoundaryToPosition(entity);
    }

    protected void markAffectedLayersForRenderUpdate(IntBoundingBox limits) {
        int val2;
        int val1;
        switch (this.layerMode) {
            case ALL: {
                this.refresher.updateAll();
                return;
            }
            case SINGLE_LAYER: {
                val1 = this.layerSingle;
                val2 = this.layerSingle;
                break;
            }
            case ALL_ABOVE: {
                val1 = this.layerAbove;
                val2 = limits.getMaxValueForAxis(this.axis);
                break;
            }
            case ALL_BELOW: {
                val1 = limits.getMinValueForAxis(this.axis);
                val2 = this.layerBelow;
                break;
            }
            case LAYER_RANGE: {
                val1 = this.layerRangeMin;
                val2 = this.layerRangeMax;
                break;
            }
            default: {
                return;
            }
        }
        this.updateLayersBetween(val1, val2);
    }

    protected void updateLayersBetween(int layer1, int layer2) {
        int layerMin = Math.min(layer1, layer2);
        int layerMax = Math.max(layer1, layer2);
        switch (this.axis) {
            case X: {
                this.refresher.updateBetweenX(layerMin, layerMax);
                break;
            }
            case Y: {
                this.refresher.updateBetweenY(layerMin, layerMax);
                break;
            }
            case Z: {
                this.refresher.updateBetweenZ(layerMin, layerMax);
            }
        }
    }

    public boolean moveLayer(int amount) {
        String axisName = this.axis.m_122477_().toLowerCase();
        String strTo = GuiBase.TXT_GREEN + axisName + " = ";
        switch (this.layerMode) {
            case ALL: {
                return false;
            }
            case SINGLE_LAYER: {
                this.setLayerSingle(this.layerSingle + amount);
                String val = strTo + this.layerSingle;
                InfoUtils.printActionbarMessage("malilib.message.set_layer_to", val);
                break;
            }
            case ALL_ABOVE: {
                this.setLayerAbove(this.layerAbove + amount);
                String val = strTo + this.layerAbove;
                InfoUtils.printActionbarMessage("malilib.message.moved_min_layer_to", val);
                break;
            }
            case ALL_BELOW: {
                this.setLayerBelow(this.layerBelow + amount);
                String val = strTo + this.layerBelow;
                InfoUtils.printActionbarMessage("malilib.message.moved_max_layer_to", val);
                break;
            }
            case LAYER_RANGE: {
                Entity entity = EntityUtils.getCameraEntity();
                if (entity == null) break;
                boolean minBoundaryClosest = this.layerRangeIsMinClosest(entity);
                this.moveLayerRange(amount, minBoundaryClosest);
                break;
            }
        }
        return true;
    }

    protected void moveLayerRange(int amount, boolean minBoundaryClosest) {
        boolean force;
        boolean moveMin = this.getMoveMin(minBoundaryClosest);
        boolean moveMax = this.getMoveMax(minBoundaryClosest);
        boolean moved = false;
        boolean bl = force = moveMin && moveMax;
        if (moveMin) {
            moved |= this.setLayerRangeMin(this.layerRangeMin + amount, force);
        }
        if (moveMax) {
            moved |= this.setLayerRangeMax(this.layerRangeMax + amount, force);
        }
        if (moved) {
            String axisName = this.axis.m_122477_().toLowerCase();
            if (moveMin && moveMax) {
                InfoUtils.printActionbarMessage("malilib.message.moved_layer_range", String.valueOf(amount), axisName);
            } else {
                String val1 = moveMin ? StringUtils.translate("malilib.message.layer_range.range_min", new Object[0]) : StringUtils.translate("malilib.message.layer_range.range_max", new Object[0]);
                InfoUtils.printActionbarMessage("malilib.message.moved_layer_range_boundary", val1, String.valueOf(amount), axisName);
            }
        }
    }

    protected boolean getMoveMax(boolean minBoundaryClosest) {
        return this.hotkeyRangeMax || !minBoundaryClosest && !this.hotkeyRangeMin;
    }

    protected boolean getMoveMin(boolean minBoundaryClosest) {
        return this.hotkeyRangeMin || minBoundaryClosest && !this.hotkeyRangeMax;
    }

    protected boolean layerRangeIsMinClosest(Entity entity) {
        double playerPos = this.axis == Direction.Axis.Y ? entity.m_20186_() : (this.axis == Direction.Axis.X ? entity.m_20185_() : entity.m_20189_());
        double min = (double)this.layerRangeMin + 0.5;
        double max = (double)this.layerRangeMax + 0.5;
        return playerPos < min || Math.abs(playerPos - min) < Math.abs(playerPos - max);
    }

    public String getCurrentLayerString() {
        switch (this.layerMode) {
            case SINGLE_LAYER: {
                return String.valueOf(this.layerSingle);
            }
            case ALL_ABOVE: {
                return String.valueOf(this.layerAbove);
            }
            case ALL_BELOW: {
                return String.valueOf(this.layerBelow);
            }
            case LAYER_RANGE: {
                return String.format("%d ... %s", this.layerRangeMin, this.layerRangeMax);
            }
        }
        return "";
    }

    protected int getWorldLimitsClampedValue(int value, IntBoundingBox limits) {
        return Mth.m_14045_((int)value, (int)limits.getMinValueForAxis(this.axis), (int)limits.getMaxValueForAxis(this.axis));
    }

    public boolean isPositionWithinRange(BlockPos pos) {
        return this.isPositionWithinRange(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public boolean isPositionWithinRange(int x, int y, int z) {
        switch (this.layerMode) {
            case ALL: {
                return true;
            }
            case SINGLE_LAYER: {
                return this.isPositionWithinSingleLayerRange(x, y, z);
            }
            case ALL_ABOVE: {
                return this.isPositionWithinAboveRange(x, y, z);
            }
            case ALL_BELOW: {
                return this.isPositionWithinBelowRange(x, y, z);
            }
            case LAYER_RANGE: {
                return this.isPositionWithinLayerRangeRange(x, y, z);
            }
        }
        return false;
    }

    protected boolean isPositionWithinSingleLayerRange(int x, int y, int z) {
        switch (this.axis) {
            case X: {
                return x == this.layerSingle;
            }
            case Y: {
                return y == this.layerSingle;
            }
            case Z: {
                return z == this.layerSingle;
            }
        }
        return false;
    }

    protected boolean isPositionWithinAboveRange(int x, int y, int z) {
        switch (this.axis) {
            case X: {
                return x >= this.layerAbove;
            }
            case Y: {
                return y >= this.layerAbove;
            }
            case Z: {
                return z >= this.layerAbove;
            }
        }
        return false;
    }

    protected boolean isPositionWithinBelowRange(int x, int y, int z) {
        switch (this.axis) {
            case X: {
                return x <= this.layerBelow;
            }
            case Y: {
                return y <= this.layerBelow;
            }
            case Z: {
                return z <= this.layerBelow;
            }
        }
        return false;
    }

    protected boolean isPositionWithinLayerRangeRange(int x, int y, int z) {
        switch (this.axis) {
            case X: {
                return x >= this.layerRangeMin && x <= this.layerRangeMax;
            }
            case Y: {
                return y >= this.layerRangeMin && y <= this.layerRangeMax;
            }
            case Z: {
                return z >= this.layerRangeMin && z <= this.layerRangeMax;
            }
        }
        return false;
    }

    public boolean isPositionAtRenderEdgeOnSide(BlockPos pos, Direction side) {
        switch (this.axis) {
            case X: {
                return side == Direction.WEST && pos.m_123341_() == this.getLayerMin() || side == Direction.EAST && pos.m_123341_() == this.getLayerMax();
            }
            case Y: {
                return side == Direction.DOWN && pos.m_123342_() == this.getLayerMin() || side == Direction.UP && pos.m_123342_() == this.getLayerMax();
            }
            case Z: {
                return side == Direction.NORTH && pos.m_123343_() == this.getLayerMin() || side == Direction.SOUTH && pos.m_123343_() == this.getLayerMax();
            }
        }
        return false;
    }

    public boolean intersects(SubChunkPos pos) {
        switch (this.axis) {
            case X: {
                int xMin = pos.m_123341_() << 4;
                int xMax = (pos.m_123341_() << 4) + 15;
                return !(xMax < this.getLayerMin() || xMin > this.getLayerMax());
            }
            case Y: {
                int yMin = pos.m_123342_() << 4;
                int yMax = (pos.m_123342_() << 4) + 15;
                return !(yMax < this.getLayerMin() || yMin > this.getLayerMax());
            }
            case Z: {
                int zMin = pos.m_123343_() << 4;
                int zMax = (pos.m_123343_() << 4) + 15;
                return !(zMax < this.getLayerMin() || zMin > this.getLayerMax());
            }
        }
        return false;
    }

    public boolean intersects(IntBoundingBox box) {
        return this.intersectsBox(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ);
    }

    public boolean intersectsBox(BlockPos posMin, BlockPos posMax) {
        return this.intersectsBox(posMin.m_123341_(), posMin.m_123342_(), posMin.m_123343_(), posMax.m_123341_(), posMax.m_123342_(), posMax.m_123343_());
    }

    public boolean intersectsBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        switch (this.axis) {
            case X: {
                return !(maxX < this.getLayerMin() || minX > this.getLayerMax());
            }
            case Y: {
                return !(maxY < this.getLayerMin() || minY > this.getLayerMax());
            }
            case Z: {
                return !(maxZ < this.getLayerMin() || minZ > this.getLayerMax());
            }
        }
        return false;
    }

    public int getClampedValue(int value, Direction.Axis axis) {
        if (this.axis == axis) {
            return Mth.m_14045_((int)value, (int)this.getLayerMin(), (int)this.getLayerMax());
        }
        return value;
    }

    @Nullable
    public IntBoundingBox getClampedRenderBoundingBox(IntBoundingBox box) {
        if (!this.intersects(box)) {
            return null;
        }
        switch (this.axis) {
            case X: {
                int xMin = Math.max(box.minX, this.getLayerMin());
                int xMax = Math.min(box.maxX, this.getLayerMax());
                return IntBoundingBox.createProper(xMin, box.minY, box.minZ, xMax, box.maxY, box.maxZ);
            }
            case Y: {
                int yMin = Math.max(box.minY, this.getLayerMin());
                int yMax = Math.min(box.maxY, this.getLayerMax());
                return IntBoundingBox.createProper(box.minX, yMin, box.minZ, box.maxX, yMax, box.maxZ);
            }
            case Z: {
                int zMin = Math.max(box.minZ, this.getLayerMin());
                int zMax = Math.min(box.maxZ, this.getLayerMax());
                return IntBoundingBox.createProper(box.minX, box.minY, zMin, box.maxX, box.maxY, zMax);
            }
        }
        return null;
    }

    @Nullable
    public IntBoundingBox getClampedArea(BlockPos posMin, BlockPos posMax) {
        return this.getClampedArea(posMin.m_123341_(), posMin.m_123342_(), posMin.m_123343_(), posMax.m_123341_(), posMax.m_123342_(), posMax.m_123343_());
    }

    @Nullable
    public IntBoundingBox getClampedArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (!this.intersectsBox(minX, minY, minZ, maxX, maxY, maxZ)) {
            return null;
        }
        switch (this.axis) {
            case X: {
                int xMin = Math.max(minX, this.getLayerMin());
                int xMax = Math.min(maxX, this.getLayerMax());
                return IntBoundingBox.createProper(xMin, minY, minZ, xMax, maxY, maxZ);
            }
            case Y: {
                int yMin = Math.max(minY, this.getLayerMin());
                int yMax = Math.min(maxY, this.getLayerMax());
                return IntBoundingBox.createProper(minX, yMin, minZ, maxX, yMax, maxZ);
            }
            case Z: {
                int zMin = Math.max(minZ, this.getLayerMin());
                int zMax = Math.min(maxZ, this.getLayerMax());
                return IntBoundingBox.createProper(minX, minY, zMin, maxX, maxY, zMax);
            }
        }
        return null;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("mode", (JsonElement)new JsonPrimitive(this.layerMode.name()));
        obj.add("axis", (JsonElement)new JsonPrimitive(this.axis.name()));
        obj.add("layer_single", (JsonElement)new JsonPrimitive((Number)this.layerSingle));
        obj.add("layer_above", (JsonElement)new JsonPrimitive((Number)this.layerAbove));
        obj.add("layer_below", (JsonElement)new JsonPrimitive((Number)this.layerBelow));
        obj.add("layer_range_min", (JsonElement)new JsonPrimitive((Number)this.layerRangeMin));
        obj.add("layer_range_max", (JsonElement)new JsonPrimitive((Number)this.layerRangeMax));
        obj.add("hotkey_range_min", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.hotkeyRangeMin)));
        obj.add("hotkey_range_max", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.hotkeyRangeMax)));
        return obj;
    }

    public static LayerRange createFromJson(JsonObject obj, IRangeChangeListener refresher) {
        LayerRange range = new LayerRange(refresher);
        range.fromJson(obj);
        return range;
    }

    public void fromJson(JsonObject obj) {
        this.layerMode = LayerMode.fromStringStatic(JsonUtils.getString(obj, "mode"));
        this.axis = Direction.Axis.m_122473_((String)JsonUtils.getString(obj, "axis"));
        if (this.axis == null) {
            this.axis = Direction.Axis.Y;
        }
        this.layerSingle = JsonUtils.getInteger(obj, "layer_single");
        this.layerAbove = JsonUtils.getInteger(obj, "layer_above");
        this.layerBelow = JsonUtils.getInteger(obj, "layer_below");
        this.layerRangeMin = JsonUtils.getInteger(obj, "layer_range_min");
        this.layerRangeMax = JsonUtils.getInteger(obj, "layer_range_max");
        this.hotkeyRangeMin = JsonUtils.getBoolean(obj, "hotkey_range_min");
        this.hotkeyRangeMax = JsonUtils.getBoolean(obj, "hotkey_range_max");
    }
}

