/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class MaterialCache {
    private static final MaterialCache INSTANCE = new MaterialCache();
    protected final IdentityHashMap<BlockState, ItemStack> buildItemsForStates = new IdentityHashMap();
    protected final IdentityHashMap<BlockState, ItemStack> displayItemsForStates = new IdentityHashMap();
    protected final WorldSchematic tempWorld = SchematicWorldHandler.createSchematicWorld();
    protected final BlockPos checkPos = new BlockPos(8, 0, 8);
    protected boolean hasReadFromFile;
    protected boolean dirty;

    private MaterialCache() {
        WorldUtils.loadChunksSchematicWorld(this.tempWorld, this.checkPos, new Vec3i(1, 1, 1));
    }

    public static MaterialCache getInstance() {
        if (!MaterialCache.INSTANCE.hasReadFromFile) {
            INSTANCE.readFromFile();
        }
        return INSTANCE;
    }

    public void clearCache() {
        this.buildItemsForStates.clear();
    }

    public ItemStack getRequiredBuildItemForState(BlockState state) {
        return this.getRequiredBuildItemForState(state, this.tempWorld, this.checkPos);
    }

    public ItemStack getRequiredBuildItemForState(BlockState state, Level world, BlockPos pos) {
        ItemStack stack = this.buildItemsForStates.get(state);
        if (stack == null) {
            stack = this.getItemForStateFromWorld(state, world, pos, true);
        }
        return stack;
    }

    public ItemStack getItemForDisplayNameForState(BlockState state) {
        ItemStack stack = this.displayItemsForStates.get(state);
        if (stack == null) {
            stack = this.getItemForStateFromWorld(state, this.tempWorld, this.checkPos, false);
        }
        return stack;
    }

    protected ItemStack getItemForStateFromWorld(BlockState state, Level world, BlockPos pos, boolean isBuildItem) {
        ItemStack stack;
        ItemStack itemStack = stack = isBuildItem ? this.getStateToItemOverride(state) : null;
        if (stack == null) {
            world.m_7731_(pos, state, 20);
            stack = state.m_60734_().m_7397_((BlockGetter)world, pos, state);
        }
        if (stack == null || stack.m_41619_()) {
            stack = ItemStack.f_41583_;
        } else {
            this.overrideStackSize(state, stack);
        }
        if (isBuildItem) {
            this.buildItemsForStates.put(state, stack);
        } else {
            this.displayItemsForStates.put(state, stack);
        }
        this.dirty = true;
        return stack;
    }

    public boolean requiresMultipleItems(BlockState state) {
        Block block = state.m_60734_();
        return block instanceof FlowerPotBlock && block != Blocks.f_50276_;
    }

    public ImmutableList<ItemStack> getItems(BlockState state) {
        return this.getItems(state, this.tempWorld, this.checkPos);
    }

    public ImmutableList<ItemStack> getItems(BlockState state, Level world, BlockPos pos) {
        Block block = state.m_60734_();
        if (block instanceof FlowerPotBlock && block != Blocks.f_50276_) {
            return ImmutableList.of((Object)new ItemStack((ItemLike)Blocks.f_50276_), (Object)block.m_7397_((BlockGetter)world, pos, state));
        }
        return ImmutableList.of((Object)this.getRequiredBuildItemForState(state, world, pos));
    }

    @Nullable
    protected ItemStack getStateToItemOverride(BlockState state) {
        Block block = state.m_60734_();
        if (block == Blocks.f_50040_ || block == Blocks.f_50040_ || block == Blocks.f_50142_ || block == Blocks.f_50257_ || block == Blocks.f_50446_) {
            return ItemStack.f_41583_;
        }
        if (block == Blocks.f_50093_) {
            return new ItemStack((ItemLike)Blocks.f_50493_);
        }
        if (block == Blocks.f_50180_) {
            return new ItemStack((ItemLike)Blocks.f_50180_);
        }
        if (block == Blocks.f_50181_) {
            return new ItemStack((ItemLike)Blocks.f_50181_);
        }
        if (block == Blocks.f_49991_) {
            if ((Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0) {
                return new ItemStack((ItemLike)Items.f_42448_);
            }
            return ItemStack.f_41583_;
        }
        if (block == Blocks.f_49990_) {
            if ((Integer)state.m_61143_((Property)LiquidBlock.f_54688_) == 0) {
                return new ItemStack((ItemLike)Items.f_42447_);
            }
            return ItemStack.f_41583_;
        }
        if (block instanceof DoorBlock && state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER) {
            return ItemStack.f_41583_;
        }
        if (block instanceof BedBlock && state.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD) {
            return ItemStack.f_41583_;
        }
        if (block instanceof DoublePlantBlock && state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER) {
            return ItemStack.f_41583_;
        }
        return null;
    }

    protected void overrideStackSize(BlockState state, ItemStack stack) {
        if (state.m_60734_() instanceof SlabBlock && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.DOUBLE) {
            stack.m_41764_(2);
        } else if (state.m_60734_() == Blocks.f_50125_) {
            stack.m_41764_(((Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_)).intValue());
        }
    }

    protected CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("MaterialCache", (Tag)this.writeMapToNBT(this.buildItemsForStates));
        nbt.m_128365_("DisplayMaterialCache", (Tag)this.writeMapToNBT(this.displayItemsForStates));
        return nbt;
    }

    protected ListTag writeMapToNBT(IdentityHashMap<BlockState, ItemStack> map) {
        ListTag list = new ListTag();
        for (Map.Entry<BlockState, ItemStack> entry : map.entrySet()) {
            CompoundTag tag = new CompoundTag();
            CompoundTag stateTag = NbtUtils.m_129202_((BlockState)entry.getKey());
            tag.m_128365_("Block", (Tag)stateTag);
            tag.m_128365_("Item", (Tag)entry.getValue().m_41739_(new CompoundTag()));
            list.add((Object)tag);
        }
        return list;
    }

    protected void readFromNBT(CompoundTag nbt) {
        this.buildItemsForStates.clear();
        this.displayItemsForStates.clear();
        this.readMapFromNBT(nbt, "MaterialCache", this.buildItemsForStates);
        this.readMapFromNBT(nbt, "DisplayMaterialCache", this.displayItemsForStates);
    }

    protected void readMapFromNBT(CompoundTag nbt, String tagName, IdentityHashMap<BlockState, ItemStack> map) {
        if (nbt.m_128425_(tagName, 9)) {
            ListTag list = nbt.m_128437_(tagName, 10);
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                BlockState state;
                CompoundTag tag = list.m_128728_(i);
                if (!tag.m_128425_("Block", 10) || !tag.m_128425_("Item", 10) || (state = NbtUtils.m_129241_((CompoundTag)tag.m_128469_("Block"))) == null) continue;
                ItemStack stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
                this.buildItemsForStates.put(state, stack);
            }
        }
    }

    protected File getCacheDir() {
        return new File(FileUtils.getConfigDirectory(), "litematica");
    }

    protected File getCacheFile() {
        return new File(this.getCacheDir(), "material_cache.nbt");
    }

    public boolean writeToFile() {
        if (!this.dirty) {
            return false;
        }
        File dir = this.getCacheDir();
        File file = this.getCacheFile();
        try {
            if (!dir.exists() && !dir.mkdirs()) {
                Litematica.logger.warn("Failed to write the material list cache to file '{}'", (Object)file.getAbsolutePath());
                return false;
            }
            FileOutputStream os = new FileOutputStream(file);
            NbtIo.m_128947_((CompoundTag)this.writeToNBT(), (OutputStream)os);
            os.close();
            this.dirty = false;
            return true;
        }
        catch (Exception e) {
            Litematica.logger.warn("Failed to write the material list cache to file '{}'", (Object)file.getAbsolutePath(), (Object)e);
            return false;
        }
    }

    public void readFromFile() {
        File file = this.getCacheFile();
        if (!file.exists() || !file.canRead()) {
            return;
        }
        try {
            FileInputStream is = new FileInputStream(file);
            CompoundTag nbt = NbtIo.m_128939_((InputStream)is);
            is.close();
            if (nbt != null) {
                this.readFromNBT(nbt);
                this.hasReadFromFile = true;
                this.dirty = false;
            }
        }
        catch (Exception e) {
            Litematica.logger.warn("Failed to read the material list cache from file '{}'", (Object)file.getAbsolutePath(), (Object)e);
        }
    }
}

