/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials;

import fi.dy.masa.litematica.materials.MaterialCache;
import fi.dy.masa.litematica.materials.MaterialListEntry;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.ItemType;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class MaterialListUtils {
    public static List<MaterialListEntry> createMaterialListFor(LitematicaSchematic schematic) {
        return MaterialListUtils.createMaterialListFor(schematic, schematic.getAreas().keySet());
    }

    public static List<MaterialListEntry> createMaterialListFor(LitematicaSchematic schematic, Collection<String> subRegions) {
        Object2IntOpenHashMap countsTotal = new Object2IntOpenHashMap();
        for (String regionName : subRegions) {
            LitematicaBlockStateContainer container = schematic.getSubRegionContainer(regionName);
            if (container == null) continue;
            Vec3i size = container.getSize();
            int sizeX = size.m_123341_();
            int sizeY = size.m_123342_();
            int sizeZ = size.m_123343_();
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    for (int x = 0; x < sizeX; ++x) {
                        BlockState state = container.get(x, y, z);
                        countsTotal.addTo((Object)state, 1);
                    }
                }
            }
        }
        Minecraft mc = Minecraft.m_91087_();
        return MaterialListUtils.getMaterialList((Object2IntOpenHashMap<BlockState>)countsTotal, (Object2IntOpenHashMap<BlockState>)countsTotal, (Object2IntOpenHashMap<BlockState>)new Object2IntOpenHashMap(), (Player)mc.f_91074_);
    }

    public static List<MaterialListEntry> getMaterialList(Object2IntOpenHashMap<BlockState> countsTotal, Object2IntOpenHashMap<BlockState> countsMissing, Object2IntOpenHashMap<BlockState> countsMismatch, Player player) {
        ArrayList<MaterialListEntry> list = new ArrayList<MaterialListEntry>();
        if (!countsTotal.isEmpty()) {
            MaterialCache cache = MaterialCache.getInstance();
            Object2IntOpenHashMap itemTypesTotal = new Object2IntOpenHashMap();
            Object2IntOpenHashMap itemTypesMissing = new Object2IntOpenHashMap();
            Object2IntOpenHashMap itemTypesMismatch = new Object2IntOpenHashMap();
            MaterialListUtils.convertStatesToStacks(countsTotal, (Object2IntOpenHashMap<ItemType>)itemTypesTotal, cache);
            MaterialListUtils.convertStatesToStacks(countsMissing, (Object2IntOpenHashMap<ItemType>)itemTypesMissing, cache);
            MaterialListUtils.convertStatesToStacks(countsMismatch, (Object2IntOpenHashMap<ItemType>)itemTypesMismatch, cache);
            Object2IntOpenHashMap playerInvItems = InventoryUtils.getInventoryItemCounts((Container)player.m_150109_());
            for (ItemType type : itemTypesTotal.keySet()) {
                list.add(new MaterialListEntry(type.getStack().m_41777_(), itemTypesTotal.getInt((Object)type), itemTypesMissing.getInt((Object)type), itemTypesMismatch.getInt((Object)type), playerInvItems.getInt((Object)type)));
            }
        }
        return list;
    }

    private static void convertStatesToStacks(Object2IntOpenHashMap<BlockState> blockStatesIn, Object2IntOpenHashMap<ItemType> itemTypesOut, MaterialCache cache) {
        for (BlockState state : blockStatesIn.keySet()) {
            if (cache.requiresMultipleItems(state)) {
                for (ItemStack stack : cache.getItems(state)) {
                    ItemType type = new ItemType(stack, false, true);
                    itemTypesOut.addTo((Object)type, blockStatesIn.getInt((Object)state) * stack.m_41613_());
                }
                continue;
            }
            ItemStack stack = cache.getRequiredBuildItemForState(state);
            if (stack.m_41619_()) continue;
            ItemType type = new ItemType(stack, false, true);
            itemTypesOut.addTo((Object)type, blockStatesIn.getInt((Object)state) * stack.m_41613_());
        }
    }

    public static void updateAvailableCounts(List<MaterialListEntry> list, Player player) {
        Object2IntOpenHashMap playerInvItems = InventoryUtils.getInventoryItemCounts((Container)player.m_150109_());
        for (MaterialListEntry entry : list) {
            ItemType type = new ItemType(entry.getStack(), false, true);
            int countAvailable = playerInvItems.getInt((Object)type);
            entry.setCountAvailable(countAvailable);
        }
    }
}

