/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.gui.widgets.WidgetSchematicVerificationResult;
import fi.dy.masa.litematica.render.BlockInfo;
import fi.dy.masa.litematica.render.RenderUtils;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.schematic.projects.SchematicProject;
import fi.dy.masa.litematica.schematic.verifier.SchematicVerifier;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.selection.SelectionManager;
import fi.dy.masa.litematica.util.BlockInfoAlignment;
import fi.dy.masa.litematica.util.ItemUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.LeftRight;
import fi.dy.masa.malilib.util.BlockUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class OverlayRenderer {
    private static final OverlayRenderer INSTANCE = new OverlayRenderer();
    public static final int[] KELLY_COLORS = new int[]{16757504, 8404597, 16738304, 10927575, 12648480, 13541986, 8482918, 32052, 16152206, 21386, 16743004, 5453690, 16748032, 11741265, 16041984, 8329229, 9677312, 5845781, 15809043, 2305046};
    private final Minecraft mc;
    private final Map<SchematicPlacement, ImmutableMap<String, Box>> placements = new HashMap<SchematicPlacement, ImmutableMap<String, Box>>();
    private Color4f colorPos1 = new Color4f(1.0f, 0.0625f, 0.0625f);
    private Color4f colorPos2 = new Color4f(0.0625f, 0.0625f, 1.0f);
    private Color4f colorOverlapping = new Color4f(1.0f, 0.0625f, 1.0f);
    private Color4f colorX = new Color4f(1.0f, 0.25f, 0.25f);
    private Color4f colorY = new Color4f(0.25f, 1.0f, 0.25f);
    private Color4f colorZ = new Color4f(0.25f, 0.25f, 1.0f);
    private Color4f colorArea = new Color4f(1.0f, 1.0f, 1.0f);
    private Color4f colorBoxPlacementSelected = new Color4f(0.08627451f, 1.0f, 1.0f);
    private Color4f colorSelectedCorner = new Color4f(0.0f, 1.0f, 1.0f);
    private Color4f colorAreaOrigin = new Color4f(1.0f, 0.5647059f, 0.0627451f);
    private long infoUpdateTime;
    private List<String> blockInfoLines = new ArrayList<String>();
    private int blockInfoX;
    private int blockInfoY;

    private OverlayRenderer() {
        this.mc = Minecraft.m_91087_();
    }

    public static OverlayRenderer getInstance() {
        return INSTANCE;
    }

    public void updatePlacementCache() {
        this.placements.clear();
        List<SchematicPlacement> list = DataManager.getSchematicPlacementManager().getAllSchematicsPlacements();
        for (SchematicPlacement placement : list) {
            if (!placement.isEnabled()) continue;
            this.placements.put(placement, placement.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED));
        }
    }

    public void renderBoxes(PoseStack matrices) {
        float lineWidthArea;
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection currentSelection = sm.getCurrentSelection();
        boolean renderAreas = currentSelection != null && Configs.Visuals.ENABLE_AREA_SELECTION_RENDERING.getBooleanValue();
        boolean renderPlacements = !this.placements.isEmpty() && Configs.Visuals.ENABLE_PLACEMENT_BOXES_RENDERING.getBooleanValue();
        boolean isProjectMode = DataManager.getSchematicProjectsManager().hasProjectOpen();
        float expand = 0.001f;
        float lineWidthBlockBox = 2.0f;
        float f = lineWidthArea = isProjectMode ? 3.0f : 1.5f;
        if (renderAreas || renderPlacements || isProjectMode) {
            SchematicProject project;
            fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            fi.dy.masa.malilib.render.RenderUtils.setupBlend();
            RenderSystem.m_69482_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69472_();
            if (renderAreas) {
                RenderSystem.m_69486_();
                RenderSystem.m_69863_((float)-1.2f, (float)-0.2f);
                Box currentBox = currentSelection.getSelectedSubRegionBox();
                for (Box box : currentSelection.getAllSubRegionBoxes()) {
                    BoxType type = box == currentBox ? BoxType.AREA_SELECTED : BoxType.AREA_UNSELECTED;
                    this.renderSelectionBox(box, type, expand, lineWidthBlockBox, lineWidthArea, null, matrices);
                }
                BlockPos origin = currentSelection.getExplicitOrigin();
                if (origin != null) {
                    if (currentSelection.isOriginSelected()) {
                        Color4f colorTmp = Color4f.fromColor((Color4f)this.colorAreaOrigin, (float)0.4f);
                        RenderUtils.renderAreaSides(origin, origin, colorTmp, matrices, this.mc);
                    }
                    Color4f color = currentSelection.isOriginSelected() ? this.colorSelectedCorner : this.colorAreaOrigin;
                    RenderUtils.renderBlockOutline(origin, expand, lineWidthBlockBox, color, this.mc);
                }
                RenderSystem.m_69863_((float)0.0f, (float)0.0f);
                RenderSystem.m_69469_();
            }
            if (renderPlacements) {
                SchematicPlacementManager spm = DataManager.getSchematicPlacementManager();
                SchematicPlacement currentPlacement = spm.getSelectedSchematicPlacement();
                for (Map.Entry<SchematicPlacement, ImmutableMap<String, Box>> entry : this.placements.entrySet()) {
                    SchematicPlacement schematicPlacement = entry.getKey();
                    ImmutableMap<String, Box> boxMap = entry.getValue();
                    boolean origin = schematicPlacement.getSelectedSubRegionPlacement() == null;
                    for (Map.Entry entryBox : boxMap.entrySet()) {
                        String boxName = (String)entryBox.getKey();
                        boolean boxSelected = schematicPlacement == currentPlacement && (origin || boxName.equals(schematicPlacement.getSelectedSubRegionName()));
                        BoxType type = boxSelected ? BoxType.PLACEMENT_SELECTED : BoxType.PLACEMENT_UNSELECTED;
                        this.renderSelectionBox((Box)entryBox.getValue(), type, expand, 1.0f, 1.0f, schematicPlacement, matrices);
                    }
                    Color4f color = schematicPlacement == currentPlacement && origin ? this.colorSelectedCorner : schematicPlacement.getBoxesBBColor();
                    RenderUtils.renderBlockOutline(schematicPlacement.getOrigin(), expand, lineWidthBlockBox, color, this.mc);
                    if (!Configs.Visuals.RENDER_PLACEMENT_ENCLOSING_BOX.getBooleanValue()) continue;
                    Box box = schematicPlacement.getEclosingBox();
                    if (!schematicPlacement.shouldRenderEnclosingBox() || box == null) continue;
                    RenderUtils.renderAreaOutline(box.getPos1(), box.getPos2(), 1.0f, color, color, color, this.mc);
                    if (!Configs.Visuals.RENDER_PLACEMENT_ENCLOSING_BOX_SIDES.getBooleanValue()) continue;
                    float alpha = (float)Configs.Visuals.PLACEMENT_BOX_SIDE_ALPHA.getDoubleValue();
                    color = new Color4f(color.r, color.g, color.b, alpha);
                    RenderUtils.renderAreaSides(box.getPos1(), box.getPos2(), color, matrices, this.mc);
                }
            }
            if (isProjectMode && (project = DataManager.getSchematicProjectsManager().getCurrentProject()) != null) {
                RenderUtils.renderBlockOutline(project.getOrigin(), expand, 4.0f, this.colorOverlapping, this.mc);
            }
            RenderSystem.m_69493_();
            RenderSystem.m_69458_((boolean)true);
        }
    }

    public void renderSelectionBox(Box box, BoxType boxType, float expand, float lineWidthBlockBox, float lineWidthArea, @Nullable SchematicPlacement placement, PoseStack matrices) {
        Color4f sideColor;
        Color4f color2;
        Color4f color1;
        Color4f colorZ;
        Color4f colorY;
        Color4f colorX;
        BlockPos pos1 = box.getPos1();
        BlockPos pos2 = box.getPos2();
        if (pos1 == null && pos2 == null) {
            return;
        }
        switch (boxType) {
            case AREA_SELECTED: {
                colorX = this.colorX;
                colorY = this.colorY;
                colorZ = this.colorZ;
                break;
            }
            case AREA_UNSELECTED: {
                colorX = this.colorArea;
                colorY = this.colorArea;
                colorZ = this.colorArea;
                break;
            }
            case PLACEMENT_SELECTED: {
                colorX = this.colorBoxPlacementSelected;
                colorY = this.colorBoxPlacementSelected;
                colorZ = this.colorBoxPlacementSelected;
                break;
            }
            case PLACEMENT_UNSELECTED: {
                Color4f color;
                colorX = color = placement.getBoxesBBColor();
                colorY = color;
                colorZ = color;
                break;
            }
            default: {
                return;
            }
        }
        if (boxType == BoxType.PLACEMENT_SELECTED) {
            color2 = color1 = this.colorBoxPlacementSelected;
            alpha = (float)Configs.Visuals.PLACEMENT_BOX_SIDE_ALPHA.getDoubleValue();
            sideColor = new Color4f(color1.r, color1.g, color1.b, alpha);
        } else if (boxType == BoxType.PLACEMENT_UNSELECTED) {
            color2 = color1 = placement.getBoxesBBColor();
            alpha = (float)Configs.Visuals.PLACEMENT_BOX_SIDE_ALPHA.getDoubleValue();
            sideColor = new Color4f(color1.r, color1.g, color1.b, alpha);
        } else {
            color1 = box.getSelectedCorner() == PositionUtils.Corner.CORNER_1 ? this.colorSelectedCorner : this.colorPos1;
            color2 = box.getSelectedCorner() == PositionUtils.Corner.CORNER_2 ? this.colorSelectedCorner : this.colorPos2;
            sideColor = Color4f.fromColor((int)Configs.Colors.AREA_SELECTION_BOX_SIDE_COLOR.getIntegerValue());
        }
        if (pos1 != null && pos2 != null) {
            if (!pos1.equals((Object)pos2)) {
                RenderUtils.renderAreaOutlineNoCorners(pos1, pos2, lineWidthArea, colorX, colorY, colorZ, this.mc);
                if ((boxType == BoxType.AREA_SELECTED || boxType == BoxType.AREA_UNSELECTED) && Configs.Visuals.RENDER_AREA_SELECTION_BOX_SIDES.getBooleanValue() || (boxType == BoxType.PLACEMENT_SELECTED || boxType == BoxType.PLACEMENT_UNSELECTED) && Configs.Visuals.RENDER_PLACEMENT_BOX_SIDES.getBooleanValue()) {
                    RenderUtils.renderAreaSides(pos1, pos2, sideColor, matrices, this.mc);
                }
                if (box.getSelectedCorner() == PositionUtils.Corner.CORNER_1) {
                    Color4f color = Color4f.fromColor((Color4f)this.colorPos1, (float)0.4f);
                    RenderUtils.renderAreaSides(pos1, pos1, color, matrices, this.mc);
                } else if (box.getSelectedCorner() == PositionUtils.Corner.CORNER_2) {
                    Color4f color = Color4f.fromColor((Color4f)this.colorPos2, (float)0.4f);
                    RenderUtils.renderAreaSides(pos2, pos2, color, matrices, this.mc);
                }
                RenderUtils.renderBlockOutline(pos1, expand, lineWidthBlockBox, color1, this.mc);
                RenderUtils.renderBlockOutline(pos2, expand, lineWidthBlockBox, color2, this.mc);
            } else {
                RenderUtils.renderBlockOutlineOverlapping(pos1, expand, lineWidthBlockBox, color1, color2, this.colorOverlapping, matrices, this.mc);
            }
        } else {
            if (pos1 != null) {
                RenderUtils.renderBlockOutline(pos1, expand, lineWidthBlockBox, color1, this.mc);
            }
            if (pos2 != null) {
                RenderUtils.renderBlockOutline(pos2, expand, lineWidthBlockBox, color2, this.mc);
            }
        }
    }

    public void renderSchematicVerifierMismatches(PoseStack matrices) {
        SchematicVerifier verifier;
        List<SchematicVerifier.MismatchRenderPos> list;
        SchematicPlacement placement = DataManager.getSchematicPlacementManager().getSelectedSchematicPlacement();
        if (placement != null && placement.hasVerifier() && !(list = (verifier = placement.getSchematicVerifier()).getSelectedMismatchPositionsForRender()).isEmpty()) {
            Entity entity = EntityUtils.getCameraEntity();
            List<BlockPos> posList = verifier.getSelectedMismatchBlockPositionsForRender();
            BlockHitResult trace = RayTraceUtils.traceToPositions(posList, entity, 128.0);
            BlockPos posLook = trace != null && trace.m_6662_() == HitResult.Type.BLOCK ? trace.m_82425_() : null;
            this.renderSchematicMismatches(list, posLook, matrices);
        }
    }

    private void renderSchematicMismatches(List<SchematicVerifier.MismatchRenderPos> posList, @Nullable BlockPos lookPos, PoseStack matrices) {
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69832_((float)2.0f);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderUtils.startDrawingLines(buffer);
        SchematicVerifier.MismatchRenderPos lookedEntry = null;
        SchematicVerifier.MismatchRenderPos prevEntry = null;
        boolean connections = Configs.Visuals.RENDER_ERROR_MARKER_CONNECTIONS.getBooleanValue();
        for (SchematicVerifier.MismatchRenderPos entry : posList) {
            Color4f color = entry.type.getColor();
            if (!entry.pos.equals((Object)lookPos)) {
                RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines(entry.pos, color, 0.002, buffer, this.mc);
            } else {
                lookedEntry = entry;
            }
            if (connections && prevEntry != null) {
                RenderUtils.drawConnectingLineBatchedLines(prevEntry.pos, entry.pos, false, color, buffer, this.mc);
            }
            prevEntry = entry;
        }
        if (lookedEntry != null) {
            if (connections && prevEntry != null) {
                RenderUtils.drawConnectingLineBatchedLines(prevEntry.pos, lookedEntry.pos, false, lookedEntry.type.getColor(), buffer, this.mc);
            }
            tessellator.m_85914_();
            RenderUtils.startDrawingLines(buffer);
            RenderSystem.m_69832_((float)6.0f);
            RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines(lookPos, lookedEntry.type.getColor(), 0.002, buffer, this.mc);
        }
        tessellator.m_85914_();
        if (Configs.Visuals.RENDER_ERROR_MARKER_SIDES.getBooleanValue()) {
            RenderSystem.m_69478_();
            RenderSystem.m_69464_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            float alpha = (float)Configs.InfoOverlays.VERIFIER_ERROR_HILIGHT_ALPHA.getDoubleValue();
            for (SchematicVerifier.MismatchRenderPos entry : posList) {
                Color4f color = entry.type.getColor();
                color = new Color4f(color.r, color.g, color.b, alpha);
                RenderUtils.renderAreaSidesBatched(entry.pos, entry.pos, color, 0.002, buffer, this.mc);
            }
            tessellator.m_85914_();
            RenderSystem.m_69461_();
        }
        RenderSystem.m_69481_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
    }

    public void renderHoverInfo(Minecraft mc, PoseStack matrixStack) {
        if (mc.f_91073_ != null && mc.f_91074_ != null) {
            boolean infoOverlayKeyActive = Hotkeys.RENDER_INFO_OVERLAY.getKeybind().isKeybindHeld();
            boolean verifierOverlayRendered = false;
            if (infoOverlayKeyActive && Configs.InfoOverlays.VERIFIER_OVERLAY_ENABLED.getBooleanValue()) {
                verifierOverlayRendered = this.renderVerifierOverlay(mc, matrixStack);
            }
            boolean renderBlockInfoLines = Configs.InfoOverlays.BLOCK_INFO_LINES_ENABLED.getBooleanValue();
            boolean renderBlockInfoOverlay = !verifierOverlayRendered && infoOverlayKeyActive && Configs.InfoOverlays.BLOCK_INFO_OVERLAY_ENABLED.getBooleanValue();
            RayTraceUtils.RayTraceWrapper traceWrapper = null;
            if (renderBlockInfoLines || renderBlockInfoOverlay) {
                Entity entity = EntityUtils.getCameraEntity();
                boolean targetFluids = Configs.InfoOverlays.INFO_OVERLAYS_TARGET_FLUIDS.getBooleanValue();
                traceWrapper = RayTraceUtils.getGenericTrace((Level)mc.f_91073_, entity, 10.0, true, targetFluids, false);
            }
            if (traceWrapper != null && (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.VANILLA_BLOCK || traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK)) {
                if (renderBlockInfoLines) {
                    this.renderBlockInfoLines(traceWrapper, mc, matrixStack);
                }
                if (renderBlockInfoOverlay) {
                    this.renderBlockInfoOverlay(traceWrapper, mc, matrixStack);
                }
            }
        }
    }

    private void renderBlockInfoLines(RayTraceUtils.RayTraceWrapper traceWrapper, Minecraft mc, PoseStack matrixStack) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.infoUpdateTime >= 50L) {
            this.updateBlockInfoLines(traceWrapper, mc);
            this.infoUpdateTime = currentTime;
        }
        int x = Configs.InfoOverlays.BLOCK_INFO_LINES_OFFSET_X.getIntegerValue();
        int y = Configs.InfoOverlays.BLOCK_INFO_LINES_OFFSET_Y.getIntegerValue();
        double fontScale = Configs.InfoOverlays.BLOCK_INFO_LINES_FONT_SCALE.getDoubleValue();
        int textColor = -1;
        int bgColor = -1605349296;
        HudAlignment alignment = (HudAlignment)Configs.InfoOverlays.BLOCK_INFO_LINES_ALIGNMENT.getOptionListValue();
        boolean useBackground = true;
        boolean useShadow = false;
        fi.dy.masa.malilib.render.RenderUtils.renderText((int)x, (int)y, (double)fontScale, (int)textColor, (int)bgColor, (HudAlignment)alignment, (boolean)useBackground, (boolean)useShadow, this.blockInfoLines, (PoseStack)matrixStack);
    }

    private boolean renderVerifierOverlay(Minecraft mc, PoseStack matrixStack) {
        SchematicPlacement placement = DataManager.getSchematicPlacementManager().getSelectedSchematicPlacement();
        if (placement != null && placement.hasVerifier()) {
            Entity entity = EntityUtils.getCameraEntity();
            SchematicVerifier verifier = placement.getSchematicVerifier();
            List<BlockPos> posList = verifier.getSelectedMismatchBlockPositionsForRender();
            BlockHitResult trace = RayTraceUtils.traceToPositions(posList, entity, 128.0);
            if (trace != null && trace.m_6662_() == HitResult.Type.BLOCK) {
                SchematicVerifier.BlockMismatch mismatch = verifier.getMismatchForPosition(trace.m_82425_());
                WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
                if (mismatch != null && worldSchematic != null) {
                    WidgetSchematicVerificationResult.BlockMismatchInfo info = new WidgetSchematicVerificationResult.BlockMismatchInfo(mismatch.stateExpected, mismatch.stateFound);
                    BlockInfoAlignment align = (BlockInfoAlignment)Configs.InfoOverlays.BLOCK_INFO_OVERLAY_ALIGNMENT.getOptionListValue();
                    int offY = Configs.InfoOverlays.BLOCK_INFO_OVERLAY_OFFSET_Y.getIntegerValue();
                    BlockPos pos = trace.m_82425_();
                    int invHeight = RenderUtils.renderInventoryOverlays(align, offY, worldSchematic, (Level)mc.f_91073_, pos, mc);
                    this.getOverlayPosition(align, info.getTotalWidth(), info.getTotalHeight(), offY, invHeight, mc);
                    info.render(this.blockInfoX, this.blockInfoY, mc, matrixStack);
                    return true;
                }
            }
        }
        return false;
    }

    private void renderBlockInfoOverlay(RayTraceUtils.RayTraceWrapper traceWrapper, Minecraft mc, PoseStack matrixStack) {
        BlockState air = Blocks.f_50016_.m_49966_();
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        Level worldClient = WorldUtils.getBestWorld((Minecraft)mc);
        BlockPos pos = traceWrapper.getBlockHitResult().m_82425_();
        BlockState stateClient = mc.f_91073_.m_8055_(pos);
        BlockState stateSchematic = worldSchematic.m_8055_(pos);
        boolean hasInvClient = InventoryUtils.getInventory((Level)worldClient, (BlockPos)pos) != null;
        boolean hasInvSchematic = InventoryUtils.getInventory((Level)worldSchematic, (BlockPos)pos) != null;
        int invHeight = 0;
        int offY = Configs.InfoOverlays.BLOCK_INFO_OVERLAY_OFFSET_Y.getIntegerValue();
        BlockInfoAlignment align = (BlockInfoAlignment)Configs.InfoOverlays.BLOCK_INFO_OVERLAY_ALIGNMENT.getOptionListValue();
        ItemUtils.setItemForBlock(worldSchematic, pos, stateSchematic);
        ItemUtils.setItemForBlock((Level)mc.f_91073_, pos, stateClient);
        if (hasInvClient && hasInvSchematic) {
            invHeight = RenderUtils.renderInventoryOverlays(align, offY, worldSchematic, worldClient, pos, mc);
        } else if (hasInvClient) {
            invHeight = RenderUtils.renderInventoryOverlay(align, LeftRight.RIGHT, offY, worldClient, pos, mc);
        } else if (hasInvSchematic) {
            invHeight = RenderUtils.renderInventoryOverlay(align, LeftRight.LEFT, offY, worldSchematic, pos, mc);
        }
        if (stateSchematic != stateClient && stateClient != air && stateSchematic != air) {
            WidgetSchematicVerificationResult.BlockMismatchInfo info = new WidgetSchematicVerificationResult.BlockMismatchInfo(stateSchematic, stateClient);
            this.getOverlayPosition(align, info.getTotalWidth(), info.getTotalHeight(), offY, invHeight, mc);
            info.render(this.blockInfoX, this.blockInfoY, mc, matrixStack);
        } else if (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.VANILLA_BLOCK) {
            BlockInfo info = new BlockInfo(stateClient, "litematica.gui.label.block_info.state_client");
            this.getOverlayPosition(align, info.getTotalWidth(), info.getTotalHeight(), offY, invHeight, mc);
            info.render(this.blockInfoX, this.blockInfoY, mc, matrixStack);
        } else if (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            BlockInfo info = new BlockInfo(stateSchematic, "litematica.gui.label.block_info.state_schematic");
            this.getOverlayPosition(align, info.getTotalWidth(), info.getTotalHeight(), offY, invHeight, mc);
            info.render(this.blockInfoX, this.blockInfoY, mc, matrixStack);
        }
    }

    protected void getOverlayPosition(BlockInfoAlignment align, int width, int height, int offY, int invHeight, Minecraft mc) {
        switch (align) {
            case CENTER: {
                this.blockInfoX = GuiUtils.getScaledWindowWidth() / 2 - width / 2;
                this.blockInfoY = GuiUtils.getScaledWindowHeight() / 2 + offY;
                break;
            }
            case TOP_CENTER: {
                this.blockInfoX = GuiUtils.getScaledWindowWidth() / 2 - width / 2;
                this.blockInfoY = invHeight + offY + (invHeight > 0 ? offY : 0);
            }
        }
    }

    private void updateBlockInfoLines(RayTraceUtils.RayTraceWrapper traceWrapper, Minecraft mc) {
        this.blockInfoLines.clear();
        BlockPos pos = traceWrapper.getBlockHitResult().m_82425_();
        BlockState stateClient = mc.f_91073_.m_8055_(pos);
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        BlockState stateSchematic = worldSchematic.m_8055_(pos);
        String ul = GuiBase.TXT_UNDERLINE;
        if (stateSchematic != stateClient && !stateClient.m_60795_() && !stateSchematic.m_60795_()) {
            this.blockInfoLines.add(ul + "Schematic:");
            this.addBlockInfoLines(stateSchematic);
            this.blockInfoLines.add("");
            this.blockInfoLines.add(ul + "Client:");
            this.addBlockInfoLines(stateClient);
        } else if (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            this.blockInfoLines.add(ul + "Schematic:");
            this.addBlockInfoLines(stateSchematic);
        }
    }

    private void addBlockInfoLines(BlockState state) {
        this.blockInfoLines.add(String.valueOf(Registry.f_122824_.m_7981_((Object)state.m_60734_())));
        this.blockInfoLines.addAll(BlockUtils.getFormattedBlockStateProperties((BlockState)state));
    }

    public void renderSchematicRebuildTargetingOverlay(PoseStack matrixStack) {
        RayTraceUtils.RayTraceWrapper traceWrapper = null;
        Color4f color = null;
        boolean direction = false;
        Entity entity = EntityUtils.getCameraEntity();
        if (Hotkeys.SCHEMATIC_REBUILD_BREAK_ALL.getKeybind().isKeybindHeld()) {
            traceWrapper = RayTraceUtils.getGenericTrace((Level)this.mc.f_91073_, entity, 20.0);
            color = Configs.Colors.REBUILD_BREAK_OVERLAY_COLOR.getColor();
        } else if (Hotkeys.SCHEMATIC_REBUILD_BREAK_ALL_EXCEPT.getKeybind().isKeybindHeld()) {
            traceWrapper = RayTraceUtils.getGenericTrace((Level)this.mc.f_91073_, entity, 20.0);
            color = Configs.Colors.REBUILD_BREAK_EXCEPT_OVERLAY_COLOR.getColor();
        } else if (Hotkeys.SCHEMATIC_REBUILD_BREAK_DIRECTION.getKeybind().isKeybindHeld()) {
            traceWrapper = RayTraceUtils.getGenericTrace((Level)this.mc.f_91073_, entity, 20.0);
            color = Configs.Colors.REBUILD_BREAK_OVERLAY_COLOR.getColor();
            direction = true;
        } else if (Hotkeys.SCHEMATIC_REBUILD_REPLACE_ALL.getKeybind().isKeybindHeld()) {
            traceWrapper = RayTraceUtils.getGenericTrace((Level)this.mc.f_91073_, entity, 20.0);
            color = Configs.Colors.REBUILD_REPLACE_OVERLAY_COLOR.getColor();
        } else if (Hotkeys.SCHEMATIC_REBUILD_REPLACE_DIRECTION.getKeybind().isKeybindHeld()) {
            traceWrapper = RayTraceUtils.getGenericTrace((Level)this.mc.f_91073_, entity, 20.0);
            color = Configs.Colors.REBUILD_REPLACE_OVERLAY_COLOR.getColor();
            direction = true;
        }
        if (traceWrapper != null && traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            BlockHitResult trace = traceWrapper.getBlockHitResult();
            BlockPos pos = trace.m_82425_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69464_();
            RenderSystem.m_69472_();
            fi.dy.masa.malilib.render.RenderUtils.setupBlend();
            RenderSystem.m_69486_();
            RenderSystem.m_69863_((float)-0.8f, (float)-1.8f);
            if (direction) {
                fi.dy.masa.malilib.render.RenderUtils.renderBlockTargetingOverlay((Entity)entity, (BlockPos)pos, (Direction)trace.m_82434_(), (Vec3)trace.m_82450_(), (Color4f)color, (PoseStack)matrixStack, (Minecraft)this.mc);
            } else {
                fi.dy.masa.malilib.render.RenderUtils.renderBlockTargetingOverlaySimple((Entity)entity, (BlockPos)pos, (Direction)trace.m_82434_(), (Color4f)color, (PoseStack)matrixStack, (Minecraft)this.mc);
            }
            RenderSystem.m_69469_();
            RenderSystem.m_69493_();
            RenderSystem.m_69461_();
            RenderSystem.m_69481_();
            RenderSystem.m_69458_((boolean)true);
        }
    }

    public void renderPreviewFrame(Minecraft mc) {
        int height;
        int width = GuiUtils.getScaledWindowWidth();
        int x = width >= (height = GuiUtils.getScaledWindowHeight()) ? (width - height) / 2 : 0;
        int y = height >= width ? (height - width) / 2 : 0;
        int longerSide = Math.min(width, height);
        fi.dy.masa.malilib.render.RenderUtils.drawOutline((int)x, (int)y, (int)longerSide, (int)longerSide, (int)2, (int)-1);
    }

    private static enum BoxType {
        AREA_SELECTED,
        AREA_UNSELECTED,
        PLACEMENT_SELECTED,
        PLACEMENT_UNSELECTED;

    }
}

