/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import fi.dy.masa.litematica.world.FakeLightingProvider;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class ChunkCacheSchematic
implements BlockAndTintGetter,
LightChunkGetter {
    private static final BlockState AIR = Blocks.f_50016_.m_49966_();
    protected final Level world;
    protected final ClientLevel worldClient;
    protected final FakeLightingProvider lightingProvider;
    protected int chunkStartX;
    protected int chunkStartZ;
    protected LevelChunk[][] chunkArray;
    protected boolean empty;

    public ChunkCacheSchematic(Level worldIn, ClientLevel clientWorld, BlockPos pos, int expand) {
        int cz;
        int cx;
        this.world = worldIn;
        this.lightingProvider = new FakeLightingProvider(this);
        this.worldClient = clientWorld;
        this.chunkStartX = pos.m_123341_() - expand >> 4;
        this.chunkStartZ = pos.m_123343_() - expand >> 4;
        int chunkEndX = pos.m_123341_() + expand + 15 >> 4;
        int chunkEndZ = pos.m_123343_() + expand + 15 >> 4;
        this.chunkArray = new LevelChunk[chunkEndX - this.chunkStartX + 1][chunkEndZ - this.chunkStartZ + 1];
        this.empty = true;
        for (cx = this.chunkStartX; cx <= chunkEndX; ++cx) {
            for (cz = this.chunkStartZ; cz <= chunkEndZ; ++cz) {
                this.chunkArray[cx - this.chunkStartX][cz - this.chunkStartZ] = worldIn.m_6325_(cx, cz);
            }
        }
        block2: for (cx = pos.m_123341_() >> 4; cx <= pos.m_123341_() + 15 >> 4; ++cx) {
            for (cz = pos.m_123343_() >> 4; cz <= pos.m_123343_() + 15 >> 4; ++cz) {
                LevelChunk chunk = this.chunkArray[cx - this.chunkStartX][cz - this.chunkStartZ];
                if (chunk == null || chunk.m_5566_(pos.m_123342_(), pos.m_123342_() + 15)) continue;
                this.empty = false;
                continue block2;
            }
        }
    }

    public BlockGetter m_7653_() {
        return this.world;
    }

    @Nullable
    public BlockGetter m_6196_(int chunkX, int chunkZ) {
        return null;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public BlockState m_8055_(BlockPos pos) {
        LevelChunk chunk;
        int cx = (pos.m_123341_() >> 4) - this.chunkStartX;
        int cz = (pos.m_123343_() >> 4) - this.chunkStartZ;
        if (cx >= 0 && cx < this.chunkArray.length && cz >= 0 && cz < this.chunkArray[cx].length && (chunk = this.chunkArray[cx][cz]) != null) {
            return chunk.m_8055_(pos);
        }
        return AIR;
    }

    @javax.annotation.Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        return this.getBlockEntity(pos, LevelChunk.EntityCreationType.CHECK);
    }

    @javax.annotation.Nullable
    public BlockEntity getBlockEntity(BlockPos pos, LevelChunk.EntityCreationType type) {
        int i = (pos.m_123341_() >> 4) - this.chunkStartX;
        int j = (pos.m_123343_() >> 4) - this.chunkStartZ;
        return this.chunkArray[i][j].m_5685_(pos, type);
    }

    public int m_45517_(LightLayer var1, BlockPos var2) {
        return 15;
    }

    public FluidState m_6425_(BlockPos pos) {
        return this.m_8055_(pos).m_60819_();
    }

    public LevelLightEngine m_5518_() {
        return this.lightingProvider;
    }

    public int m_6171_(BlockPos pos, ColorResolver colorResolver) {
        return colorResolver.m_130045_(this.worldClient.m_46857_(pos), (double)pos.m_123341_(), (double)pos.m_123343_());
    }

    public float m_7717_(Direction direction, boolean bl) {
        return this.worldClient.m_7717_(direction, bl);
    }

    public int m_141928_() {
        return this.world.m_141928_();
    }

    public int m_141937_() {
        return this.world.m_141937_();
    }
}

