/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskProcessChunkBase;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TaskFillArea
extends TaskProcessChunkBase {
    protected final BlockState fillState;
    @Nullable
    protected final BlockState replaceState;
    protected final String blockString;
    protected final boolean removeEntities;
    protected int chunkCount;

    public TaskFillArea(List<Box> boxes, BlockState fillState, @Nullable BlockState replaceState, boolean removeEntities) {
        this(boxes, fillState, replaceState, removeEntities, "litematica.gui.label.task_name.fill");
    }

    protected TaskFillArea(List<Box> boxes, BlockState fillState, @Nullable BlockState replaceState, boolean removeEntities, String nameOnHud) {
        super(nameOnHud);
        this.fillState = fillState;
        this.replaceState = replaceState;
        this.removeEntities = removeEntities;
        Object blockString = BlockStateParser.m_116769_((BlockState)fillState);
        if (replaceState != null) {
            blockString = (String)blockString + " replace " + BlockStateParser.m_116769_((BlockState)replaceState);
        }
        this.blockString = blockString;
        this.addBoxesPerChunks(boxes);
        this.updateInfoHudLinesMissingChunks(this.requiredChunks);
    }

    @Override
    public boolean canExecute() {
        return super.canExecute() && this.blockString != null;
    }

    @Override
    protected boolean canProcessChunk(ChunkPos pos) {
        return this.mc.f_91074_ != null && this.areSurroundingChunksLoaded(pos, this.clientWorld, 1);
    }

    @Override
    protected boolean processChunk(ChunkPos pos) {
        for (IntBoundingBox box : this.getBoxesInChunk(pos)) {
            if (this.isClientWorld) {
                this.fillBoxCommands(box, this.removeEntities);
                continue;
            }
            this.fillBoxDirect(box, this.removeEntities);
        }
        ++this.chunkCount;
        return true;
    }

    protected void fillBoxDirect(IntBoundingBox box, boolean removeEntities) {
        if (removeEntities) {
            AABB aabb = new AABB((double)box.minX, (double)box.minY, (double)box.minZ, (double)(box.maxX + 1), (double)(box.maxY + 1), (double)(box.maxZ + 1));
            List entities = this.world.m_6249_((Entity)this.mc.f_91074_, aabb, EntityUtils.NOT_PLAYER);
            for (Entity entity : entities) {
                if (entity instanceof Player) continue;
                entity.m_146870_();
            }
        }
        WorldUtils.setShouldPreventBlockUpdates(this.world, true);
        BlockState barrier = Blocks.f_50375_.m_49966_();
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        for (int z = box.minZ; z <= box.maxZ; ++z) {
            for (int x = box.minX; x <= box.maxX; ++x) {
                for (int y = box.maxY; y >= box.minY; --y) {
                    posMutable.m_122178_(x, y, z);
                    BlockState oldState = this.world.m_8055_((BlockPos)posMutable);
                    if ((this.replaceState != null || oldState == this.fillState) && oldState != this.replaceState) continue;
                    BlockEntity te = this.world.m_7702_((BlockPos)posMutable);
                    if (te instanceof Container) {
                        ((Container)te).m_6211_();
                        this.world.m_7731_((BlockPos)posMutable, barrier, 18);
                    }
                    this.world.m_7731_((BlockPos)posMutable, this.fillState, 18);
                }
            }
        }
        WorldUtils.setShouldPreventBlockUpdates(this.world, false);
    }

    protected void fillBoxCommands(IntBoundingBox box, boolean removeEntities) {
        AABB aabb;
        if (removeEntities && this.world.m_6249_((Entity)this.mc.f_91074_, aabb = new AABB((double)box.minX, (double)box.minY, (double)box.minZ, (double)(box.maxX + 1), (double)(box.maxY + 1), (double)(box.maxZ + 1)), EntityUtils.NOT_PLAYER).size() > 0) {
            String killCmd = String.format("/kill @e[type=!player,x=%d,y=%d,z=%d,dx=%d,dy=%d,dz=%d]", box.minX, box.minY, box.minZ, box.maxX - box.minX + 1, box.maxY - box.minY + 1, box.maxZ - box.minZ + 1);
            this.mc.f_91074_.m_108739_(killCmd);
        }
        String fillCmd = String.format("/fill %d %d %d %d %d %d %s", box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ, this.blockString);
        this.mc.f_91074_.m_108739_(fillCmd);
    }

    @Override
    protected void onStop() {
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        this.printCompletionMessage();
        this.notifyListener();
    }

    protected void printCompletionMessage() {
        if (this.finished) {
            if (this.printCompletionMessage) {
                InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.area_filled", (Object[])new Object[0]);
            }
        } else {
            InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.area_fill_fail", (Object[])new Object[0]);
        }
    }
}

