/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.infohud.IInfoHudRenderer;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;

public abstract class TaskPasteSchematicPerChunkBase
extends TaskBase
implements IInfoHudRenderer {
    protected final ImmutableList<SchematicPlacement> placements;
    protected final ArrayListMultimap<ChunkPos, IntBoundingBox> boxesInChunks = ArrayListMultimap.create();
    protected final List<ChunkPos> pendingChunks = new ArrayList<ChunkPos>();
    protected final PositionUtils.ChunkPosComparator comparator;
    protected final WorldSchematic schematicWorld;
    protected final LayerRange layerRange;
    protected final ReplaceBehavior replace;
    protected final boolean changedBlockOnly;
    private final HashSet<ChunkPos> allChunksSet = new HashSet();

    public TaskPasteSchematicPerChunkBase(Collection<SchematicPlacement> placements, LayerRange range, boolean changedBlocksOnly) {
        this.placements = ImmutableList.copyOf(placements);
        this.layerRange = range;
        this.changedBlockOnly = changedBlocksOnly;
        this.comparator = new PositionUtils.ChunkPosComparator();
        this.comparator.setClosestFirst(true);
        this.replace = (ReplaceBehavior)Configs.Generic.PASTE_REPLACE_BEHAVIOR.getOptionListValue();
        this.name = StringUtils.translate((String)"litematica.gui.label.task_name.paste", (Object[])new Object[0]);
        this.schematicWorld = SchematicWorldHandler.getSchematicWorld();
    }

    @Override
    public void init() {
        for (SchematicPlacement placement : this.placements) {
            this.addPlacement(placement, this.layerRange);
        }
        this.pendingChunks.addAll(this.allChunksSet);
        this.sortChunkList();
        InfoHud.getInstance().addInfoHudRenderer(this, true);
        this.updateInfoHudLines();
    }

    @Override
    public boolean canExecute() {
        return super.canExecute() && this.mc.f_91074_ != null && this.schematicWorld != null && !this.pendingChunks.isEmpty();
    }

    protected void addPlacement(SchematicPlacement placement, LayerRange range) {
        Set<ChunkPos> touchedChunks = placement.getTouchedChunks();
        for (ChunkPos pos : touchedChunks) {
            int count = 0;
            for (IntBoundingBox box : placement.getBoxesWithinChunk(pos.f_45578_, pos.f_45579_).values()) {
                if ((box = this.getClampedBox(box, range)) == null) continue;
                this.boxesInChunks.put((Object)pos, (Object)box);
                ++count;
            }
            if (count <= 0) continue;
            this.allChunksSet.add(pos);
            this.onChunkAddedForHandling(pos, placement);
        }
    }

    @Nullable
    public IntBoundingBox getClampedBox(IntBoundingBox box, LayerRange range) {
        return this.getClampedArea(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ, range);
    }

    @Nullable
    public IntBoundingBox getClampedArea(BlockPos posMin, BlockPos posMax, LayerRange range) {
        return this.getClampedArea(posMin.m_123341_(), posMin.m_123342_(), posMin.m_123343_(), posMax.m_123341_(), posMax.m_123342_(), posMax.m_123343_(), range);
    }

    @Nullable
    public IntBoundingBox getClampedArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, LayerRange range) {
        if (!range.intersectsBox(minX, minY, minZ, maxX, maxY, maxZ)) {
            return null;
        }
        switch (range.getAxis()) {
            case X: {
                int clampedMinX = Math.max(minX, range.getLayerMin());
                int clampedMaxX = Math.min(maxX, range.getLayerMax());
                return IntBoundingBox.createProper((int)clampedMinX, (int)minY, (int)minZ, (int)clampedMaxX, (int)maxY, (int)maxZ);
            }
            case Y: {
                int clampedMinY = Math.max(minY, range.getLayerMin());
                int clampedMaxY = Math.min(maxY, range.getLayerMax());
                return IntBoundingBox.createProper((int)minX, (int)clampedMinY, (int)minZ, (int)maxX, (int)clampedMaxY, (int)maxZ);
            }
            case Z: {
                int clampedMinZ = Math.max(minZ, range.getLayerMin());
                int clampedMaxZ = Math.min(maxZ, range.getLayerMax());
                return IntBoundingBox.createProper((int)minX, (int)minY, (int)clampedMinZ, (int)maxX, (int)maxY, (int)clampedMaxZ);
            }
        }
        return null;
    }

    protected void onChunkAddedForHandling(ChunkPos pos, SchematicPlacement placement) {
    }

    protected boolean canProcessChunk(ChunkPos pos, WorldSchematic worldSchematic, ClientLevel worldClient) {
        if (!worldSchematic.getChunkProvider().m_5563_(pos.f_45578_, pos.f_45579_) || DataManager.getSchematicPlacementManager().hasPendingRebuildFor(pos)) {
            return false;
        }
        return this.areSurroundingChunksLoaded(pos, worldClient, 1);
    }

    protected void sortChunkList() {
        if (this.pendingChunks.size() > 0) {
            if (this.mc.f_91074_ != null) {
                this.comparator.setReferencePosition(this.mc.f_91074_.m_142538_());
                this.pendingChunks.sort(this.comparator);
            }
            this.onChunkListSorted();
        }
    }

    protected void onChunkListSorted() {
    }

    protected void updateInfoHudLines() {
        ArrayList<String> hudLines = new ArrayList<String>();
        String pre = GuiBase.TXT_WHITE + GuiBase.TXT_BOLD;
        String title = StringUtils.translate((String)"litematica.gui.label.schematic_paste.missing_chunks", (Object[])new Object[]{this.pendingChunks.size()});
        hudLines.add(String.format("%s%s%s", pre, title, GuiBase.TXT_RST));
        int maxLines = Math.min(this.pendingChunks.size(), Configs.InfoOverlays.INFO_HUD_MAX_LINES.getIntegerValue());
        for (int i = 0; i < maxLines; ++i) {
            ChunkPos pos = this.pendingChunks.get(i);
            hudLines.add(String.format("cx: %5d, cz: %5d (x: %d, z: %d)", pos.f_45578_, pos.f_45579_, pos.f_45578_ << 4, pos.f_45579_ << 4));
        }
        this.infoHudLines = hudLines;
    }
}

