/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicPerChunkBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PasteNbtBehavior;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class TaskPasteSchematicPerChunkCommand
extends TaskPasteSchematicPerChunkBase {
    protected final PasteNbtBehavior nbtBehavior;
    protected final String setBlockCommand;
    protected final Consumer<Component> gameRuleListener;
    protected final boolean ignoreBlocks;
    protected final boolean ignoreEntities;
    protected TaskPhase phase = TaskPhase.INIT;
    @Nullable
    protected ChunkPos currentChunk;
    @Nullable
    protected IntBoundingBox currentBox;
    @Nullable
    protected Iterator<Entity> entityIterator;
    @Nullable
    protected Iterator<BlockPos> positionIterator;
    protected int maxCommandsPerTick = Configs.Generic.PASTE_COMMAND_LIMIT.getIntegerValue();
    protected int processedChunksThisTick;
    protected int sentCommandsThisTick;
    protected int sentCommandsTotal;
    protected int sentSetblockCommands;
    protected long gameRuleProbeTimeout;
    protected long maxGameRuleProbeTime = 2000000000L;
    protected boolean shouldEnableFeedback;

    public TaskPasteSchematicPerChunkCommand(Collection<SchematicPlacement> placements, LayerRange range, boolean changedBlocksOnly) {
        super(placements, range, changedBlocksOnly);
        this.ignoreBlocks = false;
        this.ignoreEntities = Configs.Generic.PASTE_IGNORE_ENTITIES.getBooleanValue();
        this.setBlockCommand = Configs.Generic.PASTE_COMMAND_SETBLOCK.getStringValue();
        this.nbtBehavior = (PasteNbtBehavior)Configs.Generic.PASTE_NBT_BEHAVIOR.getOptionListValue();
        this.gameRuleListener = this::checkGameRuleState;
    }

    @Override
    public boolean execute() {
        if (this.ignoreBlocks && this.ignoreEntities) {
            return true;
        }
        if (this.phase == TaskPhase.INIT) {
            if (Configs.Generic.PASTE_DISABLE_FEEDBACK.getBooleanValue()) {
                DataManager.addChatListener(this.gameRuleListener);
                this.mc.f_91074_.m_108739_("/gamerule sendCommandFeedback");
                this.gameRuleProbeTimeout = Util.m_137569_() + this.maxGameRuleProbeTime;
                this.phase = TaskPhase.GAMERULE_PROBE;
            } else {
                this.shouldEnableFeedback = false;
                this.phase = TaskPhase.WAIT_FOR_CHUNKS;
            }
        }
        if (this.phase == TaskPhase.GAMERULE_PROBE) {
            if (Util.m_137569_() > this.gameRuleProbeTimeout) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (int)8000, (String)"litematica.message.error.schematic_paste_failed.game_rule_probe_timeout", (Object[])new Object[0]);
                this.finished = false;
                return true;
            }
            return false;
        }
        this.sentCommandsThisTick = 0;
        this.processedChunksThisTick = 0;
        if (this.currentChunk != null && !this.canProcessChunk(this.currentChunk, this.schematicWorld, this.mc.f_91073_)) {
            return false;
        }
        int commandsLast = -1;
        ChunkPos lastChunk = this.currentChunk;
        while (!(this.sentCommandsThisTick >= this.maxCommandsPerTick || this.sentCommandsThisTick <= commandsLast && Objects.equals(lastChunk, this.currentChunk))) {
            commandsLast = this.sentCommandsThisTick;
            lastChunk = this.currentChunk;
            if (this.phase == TaskPhase.WAIT_FOR_CHUNKS) {
                this.fetchNextChunk();
            }
            if (this.phase == TaskPhase.PROCESS_BOX_BLOCKS) {
                this.processBlocksInBox(this.currentChunk, this.currentBox);
            }
            if (this.phase == TaskPhase.PROCESS_BOX_ENTITIES) {
                this.processEntitiesInBox(this.currentBox);
            }
            if (this.phase != TaskPhase.FINISHED) continue;
            this.finished = true;
            return true;
        }
        if (this.processedChunksThisTick > 0) {
            this.updateInfoHudLines();
        }
        return false;
    }

    public void checkGameRuleState(Component message) {
        TranslatableComponent translatableText;
        if (message instanceof TranslatableComponent && "commands.gamerule.query".equals((translatableText = (TranslatableComponent)message).m_131328_())) {
            this.shouldEnableFeedback = translatableText.getString().contains("true");
            this.phase = TaskPhase.WAIT_FOR_CHUNKS;
            if (this.shouldEnableFeedback) {
                this.mc.f_91074_.m_108739_("/gamerule sendCommandFeedback false");
            }
        }
    }

    protected void fetchNextChunk() {
        if (!this.pendingChunks.isEmpty()) {
            this.sortChunkList();
            ChunkPos pos = (ChunkPos)this.pendingChunks.get(0);
            if (this.canProcessChunk(pos, this.schematicWorld, this.mc.f_91073_)) {
                this.currentChunk = pos;
                this.startNextBox(pos);
            }
        } else {
            this.phase = TaskPhase.FINISHED;
            this.finished = true;
        }
    }

    protected void fetchNextBoxForChunk(ChunkPos pos) {
        List list = this.boxesInChunks.get((Object)pos);
        if (!list.isEmpty()) {
            this.currentBox = (IntBoundingBox)list.get(0);
            if (!this.ignoreBlocks) {
                IntBoundingBox box = this.currentBox;
                this.positionIterator = BlockPos.m_121976_((int)box.minX, (int)box.minY, (int)box.minZ, (int)box.maxX, (int)box.maxY, (int)box.maxZ).iterator();
            }
        } else {
            this.currentBox = null;
            this.phase = TaskPhase.WAIT_FOR_CHUNKS;
        }
    }

    protected void startNextBox(ChunkPos chunkPos) {
        List list = this.boxesInChunks.get((Object)chunkPos);
        if (!list.isEmpty()) {
            this.currentBox = (IntBoundingBox)list.get(0);
            if (!this.ignoreBlocks) {
                this.startSettingBlocks(this.currentBox);
            } else {
                this.startSummoningEntities(this.currentBox);
            }
        } else {
            this.currentBox = null;
            this.phase = TaskPhase.WAIT_FOR_CHUNKS;
        }
    }

    protected void startSettingBlocks(IntBoundingBox box) {
        this.positionIterator = BlockPos.m_121976_((int)box.minX, (int)box.minY, (int)box.minZ, (int)box.maxX, (int)box.maxY, (int)box.maxZ).iterator();
        this.phase = TaskPhase.PROCESS_BOX_BLOCKS;
    }

    protected void startSummoningEntities(IntBoundingBox box) {
        AABB bb = new AABB((double)box.minX, (double)box.minY, (double)box.minZ, (double)(box.maxX + 1), (double)(box.maxY + 1), (double)(box.maxZ + 1));
        this.entityIterator = this.schematicWorld.m_6249_(null, bb, e -> true).iterator();
        this.phase = TaskPhase.PROCESS_BOX_ENTITIES;
    }

    protected void onFinishedProcessingBox(ChunkPos chunkPos, IntBoundingBox box) {
        this.boxesInChunks.remove((Object)chunkPos, (Object)box);
        this.currentBox = null;
        this.entityIterator = null;
        this.positionIterator = null;
        if (this.boxesInChunks.get((Object)chunkPos).isEmpty()) {
            this.pendingChunks.remove(chunkPos);
            this.currentChunk = null;
            ++this.processedChunksThisTick;
            this.phase = TaskPhase.WAIT_FOR_CHUNKS;
            this.fetchNextChunk();
        } else {
            this.startNextBox(chunkPos);
        }
    }

    protected void processBlocksInBox(ChunkPos chunkPos, IntBoundingBox box) {
        ChunkSchematic schematicChunk = this.schematicWorld.getChunkProvider().getChunk(chunkPos.f_45578_, chunkPos.f_45579_);
        LevelChunk clientChunk = this.mc.f_91073_.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        while (this.sentCommandsThisTick < this.maxCommandsPerTick && this.positionIterator.hasNext()) {
            BlockPos pos = this.positionIterator.next();
            this.pasteBlock(pos, schematicChunk, (ChunkAccess)clientChunk);
        }
        if (!this.positionIterator.hasNext()) {
            if (this.ignoreEntities) {
                this.onFinishedProcessingBox(this.currentChunk, box);
            } else {
                this.startSummoningEntities(box);
            }
        }
    }

    protected void processEntitiesInBox(IntBoundingBox box) {
        while (this.sentCommandsThisTick < this.maxCommandsPerTick && this.entityIterator.hasNext()) {
            this.summonEntity(this.entityIterator.next());
        }
        if (!this.entityIterator.hasNext()) {
            this.onFinishedProcessingBox(this.currentChunk, box);
        }
    }

    protected void pasteBlock(BlockPos pos, LevelChunk schematicChunk, ChunkAccess clientChunk) {
        BlockState stateSchematic = schematicChunk.m_8055_(pos);
        BlockState stateClient = clientChunk.m_8055_(pos);
        if (!(stateSchematic.m_60795_() && stateClient.m_60795_() || this.changedBlockOnly && stateClient == stateSchematic)) {
            if (this.replace == ReplaceBehavior.NONE && !stateClient.m_60795_() || this.replace == ReplaceBehavior.WITH_NON_AIR && stateSchematic.m_60795_()) {
                return;
            }
            LocalPlayer player = this.mc.f_91074_;
            PasteNbtBehavior nbtBehavior = this.nbtBehavior;
            BlockEntity be = schematicChunk.m_7702_(pos);
            if (be != null && nbtBehavior != PasteNbtBehavior.NONE) {
                Level schematicWorld = schematicChunk.m_62953_();
                ClientLevel clientWorld = this.mc.f_91073_;
                if (nbtBehavior == PasteNbtBehavior.PLACE_MODIFY) {
                    this.setDataViaDataModify(pos, stateSchematic, be, schematicWorld, clientWorld, player);
                } else if (nbtBehavior == PasteNbtBehavior.PLACE_CLONE) {
                    this.placeBlockViaClone(pos, stateSchematic, be, schematicWorld, clientWorld, player);
                } else if (nbtBehavior == PasteNbtBehavior.TELEPORT_PLACE) {
                    this.placeBlockDirectly(pos, stateSchematic, be, schematicWorld, clientWorld, player);
                }
            } else {
                this.sendSetBlockCommand(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), stateSchematic, player);
            }
        }
    }

    protected void summonEntity(Entity entity) {
        String id = EntityUtils.getEntityId(entity);
        if (id != null) {
            String command = String.format(Locale.ROOT, "summon %s %f %f %f", id, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            if (entity instanceof ItemFrame) {
                ItemFrame itemFrame = (ItemFrame)entity;
                command = this.getSummonCommandForItemFrame(itemFrame, command);
            }
            this.sendCommand(command, this.mc.f_91074_);
        }
    }

    protected String getSummonCommandForItemFrame(ItemFrame itemFrame, String originalCommand) {
        ItemStack stack = itemFrame.m_31822_();
        if (!stack.m_41619_()) {
            ResourceLocation itemId = Registry.f_122827_.m_7981_((Object)stack.m_41720_());
            int facingId = itemFrame.m_6350_().m_122411_();
            String nbtStr = String.format(" {Facing:%db,Item:{id:\"%s\",Count:1b}}", facingId, itemId);
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                String itemNbt = tag.toString();
                String tmp = String.format(" {Facing:%db,Item:{id:\"%s\",Count:1b,tag:%s}}", facingId, itemId, itemNbt);
                if (originalCommand.length() + tmp.length() < 255) {
                    nbtStr = tmp;
                }
            }
            return originalCommand + nbtStr;
        }
        return originalCommand;
    }

    protected void sendSetBlockCommand(int x, int y, int z, BlockState state, LocalPlayer player) {
        String cmdName = this.setBlockCommand;
        String blockString = BlockStateParser.m_116769_((BlockState)state);
        String strCommand = String.format("%s %d %d %d %s", cmdName, x, y, z, blockString);
        this.sendCommand(strCommand, player);
        ++this.sentSetblockCommands;
    }

    protected void setDataViaDataModify(BlockPos pos, BlockState state, BlockEntity be, Level schematicWorld, ClientLevel clientWorld, LocalPlayer player) {
        BlockPos placementPos = TaskPasteSchematicPerChunkCommand.findEmptyNearbyPosition((Level)clientWorld, player.m_142538_(), 3);
        if (placementPos != null && this.preparePickedStack(pos, state, be, schematicWorld, player)) {
            Vec3 posVec = new Vec3((double)placementPos.m_123341_() + 0.5, (double)placementPos.m_123342_() + 1.0, (double)placementPos.m_123343_() + 0.5);
            BlockHitResult hitResult = new BlockHitResult(posVec, Direction.UP, placementPos, false);
            this.mc.f_91072_.m_105262_(player, clientWorld, InteractionHand.OFF_HAND, hitResult);
            this.sendSetBlockCommand(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), state, player);
            try {
                HashSet keys = new HashSet(be.m_6945_(new CompoundTag()).m_128431_());
                keys.remove("id");
                keys.remove("x");
                keys.remove("y");
                keys.remove("z");
                for (String key : keys) {
                    String command = String.format("data modify block %d %d %d %s set from block %d %d %d %s", pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), key, placementPos.m_123341_(), placementPos.m_123342_(), placementPos.m_123343_(), key);
                    this.sendCommand(command, player);
                }
            }
            catch (Exception keys) {
                // empty catch block
            }
            String cmdName = this.setBlockCommand;
            String command = String.format("%s %d %d %d air", cmdName, placementPos.m_123341_(), placementPos.m_123342_(), placementPos.m_123343_());
            this.sendCommand(command, player);
        }
    }

    protected void placeBlockViaClone(BlockPos pos, BlockState state, BlockEntity be, Level schematicWorld, ClientLevel clientWorld, LocalPlayer player) {
        BlockPos placementPos = TaskPasteSchematicPerChunkCommand.findEmptyNearbyPosition((Level)clientWorld, player.m_142538_(), 3);
        if (placementPos != null && this.preparePickedStack(pos, state, be, schematicWorld, player)) {
            Vec3 posVec = new Vec3((double)placementPos.m_123341_() + 0.5, (double)placementPos.m_123342_() + 1.0, (double)placementPos.m_123343_() + 0.5);
            BlockHitResult hitResult = new BlockHitResult(posVec, Direction.UP, placementPos, false);
            this.mc.f_91072_.m_105262_(player, clientWorld, InteractionHand.OFF_HAND, hitResult);
            String command = String.format("clone %d %d %d %d %d %d %d %d %d", placementPos.m_123341_(), placementPos.m_123342_(), placementPos.m_123343_(), placementPos.m_123341_(), placementPos.m_123342_(), placementPos.m_123343_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            this.sendCommand(command, player);
            String cmdName = this.setBlockCommand;
            command = String.format("%s %d %d %d air", cmdName, placementPos.m_123341_(), placementPos.m_123342_(), placementPos.m_123343_());
            this.sendCommand(command, player);
        }
    }

    protected void placeBlockDirectly(BlockPos pos, BlockState state, BlockEntity be, Level schematicWorld, ClientLevel clientWorld, LocalPlayer player) {
        if (this.preparePickedStack(pos, state, be, schematicWorld, player)) {
            player.m_20343_((double)pos.m_123341_(), (double)(pos.m_123342_() + 2), (double)pos.m_123343_());
            String command = String.format("tp @p %d %d %d", pos.m_123341_(), pos.m_123342_() + 2, pos.m_123343_());
            this.sendCommand(command, player);
            Vec3 posVec = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5);
            BlockHitResult hitResult = new BlockHitResult(posVec, Direction.UP, pos, false);
            this.mc.f_91072_.m_105262_(player, clientWorld, InteractionHand.OFF_HAND, hitResult);
        }
    }

    protected void sendCommand(String command, LocalPlayer player) {
        this.sendCommandToServer(command, player);
        ++this.sentCommandsThisTick;
        ++this.sentCommandsTotal;
    }

    protected void sendCommandToServer(String command, LocalPlayer player) {
        if (command.length() > 0 && command.charAt(0) != '/') {
            player.m_108739_("/" + command);
        } else {
            player.m_108739_(command);
        }
    }

    @Nullable
    public static BlockPos findEmptyNearbyPosition(Level world, BlockPos centerPos, int radius) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos sidePos = new BlockPos.MutableBlockPos();
        for (int y = centerPos.m_123342_(); y <= centerPos.m_123342_() + radius; ++y) {
            for (int z = centerPos.m_123343_() - radius; z <= centerPos.m_123343_() + radius; ++z) {
                for (int x = centerPos.m_123341_() - radius; x <= centerPos.m_123341_() + radius; ++x) {
                    pos.m_122178_(x, y, z);
                    if (!TaskPasteSchematicPerChunkCommand.isPositionAndSidesEmpty(world, pos, sidePos)) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    public static boolean isPositionAndSidesEmpty(Level world, BlockPos.MutableBlockPos centerPos, BlockPos.MutableBlockPos pos) {
        if (!world.m_46859_((BlockPos)centerPos)) {
            return false;
        }
        for (Direction side : PositionUtils.ALL_DIRECTIONS) {
            if (world.m_46859_((BlockPos)pos.m_122159_((Vec3i)centerPos, side))) continue;
            return false;
        }
        return true;
    }

    protected boolean preparePickedStack(BlockPos pos, BlockState state, BlockEntity be, Level world, LocalPlayer player) {
        ItemStack stack = state.m_60734_().m_7397_((BlockGetter)world, pos, state);
        if (!stack.m_41619_()) {
            TaskPasteSchematicPerChunkCommand.addBlockEntityNbt(stack, be);
            player.m_150109_().f_35976_.set(0, (Object)stack);
            this.mc.f_91072_.m_105241_(stack, 45);
            return true;
        }
        return false;
    }

    public static void addBlockEntityNbt(ItemStack stack, BlockEntity be) {
        CompoundTag tag = be.m_6945_(new CompoundTag());
        if (stack.m_41720_() instanceof PlayerHeadItem && tag.m_128441_("SkullOwner")) {
            CompoundTag ownerTag = tag.m_128469_("SkullOwner");
            stack.m_41784_().m_128365_("SkullOwner", (Tag)ownerTag);
        } else {
            stack.m_41700_("BlockEntityTag", (Tag)tag);
        }
    }

    @Override
    public void stop() {
        if (this.finished) {
            if (this.printCompletionMessage) {
                InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.schematic_pasted_using_setblock", (Object[])new Object[]{this.sentSetblockCommands});
            }
        } else {
            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.schematic_paste_failed", (Object[])new Object[0]);
        }
        if (this.mc.f_91074_ != null && this.shouldEnableFeedback) {
            this.mc.f_91074_.m_108739_("/gamerule sendCommandFeedback true");
        }
        DataManager.removeChatListener(this.gameRuleListener);
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        super.stop();
    }

    public static enum TaskPhase {
        INIT,
        GAMERULE_PROBE,
        WAIT_FOR_CHUNKS,
        PROCESS_BOX_BLOCKS,
        PROCESS_BOX_ENTITIES,
        FINISHED;

    }
}

