/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import com.google.common.collect.ArrayListMultimap;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicPerChunkBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.util.SchematicPlacingUtils;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.WorldUtils;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class TaskPasteSchematicPerChunkDirect
extends TaskPasteSchematicPerChunkBase {
    private final ArrayListMultimap<ChunkPos, SchematicPlacement> placementsPerChunk = ArrayListMultimap.create();

    public TaskPasteSchematicPerChunkDirect(Collection<SchematicPlacement> placements, LayerRange range, boolean changedBlocksOnly) {
        super(placements, range, changedBlocksOnly);
    }

    @Override
    protected void onChunkAddedForHandling(ChunkPos pos, SchematicPlacement placement) {
        super.onChunkAddedForHandling(pos, placement);
        this.placementsPerChunk.put((Object)pos, (Object)placement);
    }

    @Override
    public boolean canExecute() {
        if (!super.canExecute() || !this.mc.m_91091_()) {
            return false;
        }
        Level world = WorldUtils.getBestWorld((Minecraft)this.mc);
        return world != null && !world.f_46443_;
    }

    @Override
    public boolean execute() {
        long currentTime;
        long elapsedTickTime;
        Level world = WorldUtils.getBestWorld((Minecraft)this.mc);
        IntegratedServer server = this.mc.m_91092_();
        long vanillaTickTime = server.f_129748_[server.m_129921_() % 100];
        long timeStart = Util.m_137569_();
        int processed = 0;
        this.sortChunkList();
        for (int chunkIndex = 0; chunkIndex < this.pendingChunks.size() && (elapsedTickTime = vanillaTickTime + ((currentTime = Util.m_137569_()) - timeStart)) < 60000000L; ++chunkIndex) {
            ChunkPos pos = (ChunkPos)this.pendingChunks.get(chunkIndex);
            if (!this.canProcessChunk(pos, this.schematicWorld, this.mc.f_91073_)) continue;
            ArrayList placements = new ArrayList(this.placementsPerChunk.get((Object)pos));
            for (SchematicPlacement placement : placements) {
                if (!SchematicPlacingUtils.placeToWorldWithinChunk(world, pos, placement, this.replace, false)) continue;
                this.placementsPerChunk.remove((Object)pos, (Object)placement);
                ++processed;
            }
            if (this.placementsPerChunk.containsKey((Object)pos)) continue;
            this.pendingChunks.remove(chunkIndex);
            --chunkIndex;
        }
        if (this.pendingChunks.isEmpty()) {
            this.finished = true;
            return true;
        }
        if (processed > 0) {
            this.updateInfoHudLines();
        }
        return false;
    }

    @Override
    public void stop() {
        if (this.finished) {
            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.schematic_pasted", (Object[])new Object[0]);
        } else {
            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.schematic_paste_failed", (Object[])new Object[0]);
        }
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        super.stop();
    }
}

