/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import com.google.common.collect.ArrayListMultimap;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskBase;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public abstract class TaskProcessChunkBase
extends TaskBase {
    protected final ArrayListMultimap<ChunkPos, IntBoundingBox> boxesInChunks = ArrayListMultimap.create();
    protected final Set<ChunkPos> requiredChunks = new HashSet<ChunkPos>();
    protected final ClientLevel clientWorld;
    protected final Level world;
    protected final boolean isClientWorld;

    protected TaskProcessChunkBase(String nameOnHud) {
        this.clientWorld = this.mc.f_91073_;
        this.world = WorldUtils.getBestWorld((Minecraft)this.mc);
        this.isClientWorld = this.world == this.mc.f_91073_;
        this.name = StringUtils.translate((String)nameOnHud, (Object[])new Object[0]);
        InfoHud.getInstance().addInfoHudRenderer(this, true);
    }

    @Override
    public boolean execute() {
        if (this.clientWorld != null) {
            Iterator<ChunkPos> iterator = this.requiredChunks.iterator();
            int processed = 0;
            while (iterator.hasNext()) {
                ChunkPos pos = iterator.next();
                if (!this.canProcessChunk(pos)) continue;
                this.processChunk(pos);
                iterator.remove();
                ++processed;
            }
            if (processed > 0) {
                this.updateInfoHudLinesMissingChunks(this.requiredChunks);
            }
        }
        this.finished = this.requiredChunks.isEmpty();
        return this.finished;
    }

    @Override
    public void stop() {
        if (this.isClientWorld) {
            this.onStop();
        } else {
            this.mc.execute(this::onStop);
        }
    }

    protected void onStop() {
        this.notifyListener();
    }

    protected abstract boolean canProcessChunk(ChunkPos var1);

    protected abstract boolean processChunk(ChunkPos var1);

    protected void addBoxesPerChunks(Collection<Box> allBoxes) {
        this.boxesInChunks.clear();
        this.requiredChunks.clear();
        this.requiredChunks.addAll(PositionUtils.getTouchedChunksForBoxes(allBoxes));
        for (ChunkPos pos : this.requiredChunks) {
            this.boxesInChunks.putAll((Object)pos, PositionUtils.getBoxesWithinChunk(pos.f_45578_, pos.f_45579_, allBoxes));
        }
    }

    protected List<IntBoundingBox> getBoxesInChunk(ChunkPos pos) {
        return this.boxesInChunks.get((Object)pos);
    }
}

