/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.container;

import fi.dy.masa.litematica.schematic.container.ILitematicaBlockStatePalette;
import fi.dy.masa.litematica.schematic.container.ILitematicaBlockStatePaletteResizer;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.CrudeIncrementalIntIdentityHashBiMap;
import net.minecraft.world.level.block.state.BlockState;

public class LitematicaBlockStatePaletteHashMap
implements ILitematicaBlockStatePalette {
    private final CrudeIncrementalIntIdentityHashBiMap<BlockState> statePaletteMap;
    private final ILitematicaBlockStatePaletteResizer paletteResizer;
    private final int bits;

    public LitematicaBlockStatePaletteHashMap(int bitsIn, ILitematicaBlockStatePaletteResizer paletteResizer) {
        this.bits = bitsIn;
        this.paletteResizer = paletteResizer;
        this.statePaletteMap = new CrudeIncrementalIntIdentityHashBiMap(1 << bitsIn);
    }

    @Override
    public int idFor(BlockState state) {
        int i = this.statePaletteMap.m_7447_((Object)state);
        if (i == -1 && (i = this.statePaletteMap.m_13569_((Object)state)) >= 1 << this.bits) {
            i = this.paletteResizer.onResize(this.bits + 1, state);
        }
        return i;
    }

    @Override
    @Nullable
    public BlockState getBlockState(int indexKey) {
        return (BlockState)this.statePaletteMap.m_7942_(indexKey);
    }

    @Override
    public int getPaletteSize() {
        return this.statePaletteMap.m_13562_();
    }

    private void requestNewId(BlockState state) {
        int newId;
        int origId = this.statePaletteMap.m_13569_((Object)state);
        if (origId >= 1 << this.bits && (newId = this.paletteResizer.onResize(this.bits + 1, LitematicaBlockStateContainer.AIR_BLOCK_STATE)) <= origId) {
            this.statePaletteMap.m_13569_((Object)state);
        }
    }

    @Override
    public void readFromNBT(ListTag tagList) {
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = tagList.m_128728_(i);
            BlockState state = NbtUtils.m_129241_((CompoundTag)tag);
            if (i <= 0 && state == LitematicaBlockStateContainer.AIR_BLOCK_STATE) continue;
            this.requestNewId(state);
        }
    }

    @Override
    public ListTag writeToNBT() {
        ListTag tagList = new ListTag();
        for (int id = 0; id < this.statePaletteMap.m_13562_(); ++id) {
            BlockState state = (BlockState)this.statePaletteMap.m_7942_(id);
            if (state == null) {
                state = LitematicaBlockStateContainer.AIR_BLOCK_STATE;
            }
            CompoundTag tag = NbtUtils.m_129202_((BlockState)state);
            tagList.add((Object)tag);
        }
        return tagList;
    }

    @Override
    public boolean setMapping(List<BlockState> list) {
        this.statePaletteMap.m_13554_();
        for (BlockState blockState : list) {
            this.statePaletteMap.m_13569_((Object)blockState);
        }
        return true;
    }
}

