/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import com.google.common.base.Splitter;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockUtils {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);

    public static Optional<BlockState> getBlockStateFromString(String str) {
        int index = str.indexOf("[");
        String blockName = index != -1 ? str.substring(0, index) : str;
        try {
            ResourceLocation id = new ResourceLocation(blockName);
            if (Registry.f_122824_.m_7804_(id)) {
                Block block = (Block)Registry.f_122824_.m_7745_(id);
                BlockState state = block.m_49966_();
                if (index != -1 && str.length() > index + 4 && str.charAt(str.length() - 1) == ']') {
                    StateDefinition stateManager = block.m_49965_();
                    String propStr = str.substring(index + 1, str.length() - 1);
                    for (String propAndVal : COMMA_SPLITTER.split((CharSequence)propStr)) {
                        Object val;
                        Property prop;
                        Iterator valIter = EQUAL_SPLITTER.split((CharSequence)propAndVal).iterator();
                        if (!valIter.hasNext() || (prop = stateManager.m_61081_((String)valIter.next())) == null || !valIter.hasNext() || (val = BlockUtils.getPropertyValueByName(prop, (String)valIter.next())) == null) continue;
                        state = BlockUtils.getBlockStateWithProperty(state, prop, val);
                    }
                }
                return Optional.of(state);
            }
        }
        catch (Exception e) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static <T extends Comparable<T>> BlockState getBlockStateWithProperty(BlockState state, Property<T> prop, Comparable<?> value) {
        return (BlockState)state.m_61124_(prop, value);
    }

    @Nullable
    public static <T extends Comparable<T>> T getPropertyValueByName(Property<T> prop, String valStr) {
        return (T)((Comparable)prop.m_6215_(valStr).orElse(null));
    }
}

