/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.ItemUtils;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.gui.GuiBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class InventoryUtils {
    private static final List<Integer> PICK_BLOCKABLE_SLOTS = new ArrayList<Integer>();
    private static int nextPickSlotIndex;

    public static void setPickBlockableSlots(String configStr) {
        String[] parts;
        PICK_BLOCKABLE_SLOTS.clear();
        for (String str : parts = configStr.split(",")) {
            try {
                int slotNum = Integer.parseInt(str);
                if (!Inventory.m_36045_((int)slotNum) || PICK_BLOCKABLE_SLOTS.contains(slotNum)) continue;
                PICK_BLOCKABLE_SLOTS.add(slotNum);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static void setPickedItemToHand(ItemStack stack, Minecraft mc) {
        int slotNum = mc.f_91074_.m_150109_().m_36030_(stack);
        InventoryUtils.setPickedItemToHand(slotNum, stack, mc);
    }

    public static void setPickedItemToHand(int sourceSlot, ItemStack stack, Minecraft mc) {
        LocalPlayer player = mc.f_91074_;
        Inventory inventory = player.m_150109_();
        if (Inventory.m_36045_((int)sourceSlot)) {
            inventory.f_35977_ = sourceSlot;
        } else {
            if (PICK_BLOCKABLE_SLOTS.size() == 0) {
                return;
            }
            int hotbarSlot = sourceSlot;
            if (sourceSlot == -1 || !Inventory.m_36045_((int)sourceSlot)) {
                hotbarSlot = InventoryUtils.getEmptyPickBlockableHotbarSlot(inventory);
            }
            if (hotbarSlot == -1) {
                hotbarSlot = InventoryUtils.getPickBlockTargetSlot((Player)player);
            }
            if (hotbarSlot != -1) {
                inventory.f_35977_ = hotbarSlot;
                if (EntityUtils.isCreativeMode((Player)player)) {
                    inventory.f_35974_.set(hotbarSlot, (Object)stack.m_41777_());
                } else {
                    fi.dy.masa.malilib.util.InventoryUtils.swapItemToMainHand((ItemStack)stack.m_41777_(), (Minecraft)mc);
                }
                WorldUtils.setEasyPlaceLastPickBlockTime();
            }
        }
    }

    public static void schematicWorldPickBlock(ItemStack stack, BlockPos pos, Level schematicWorld, Minecraft mc) {
        if (!stack.m_41619_()) {
            Inventory inv = mc.f_91074_.m_150109_();
            stack = stack.m_41777_();
            if (EntityUtils.isCreativeMode((Player)mc.f_91074_)) {
                BlockEntity te = schematicWorld.m_7702_(pos);
                if (GuiBase.isCtrlDown() && te != null && mc.f_91073_.m_46859_(pos)) {
                    ItemUtils.storeTEInStack(stack, te);
                }
                InventoryUtils.setPickedItemToHand(stack, mc);
                mc.f_91072_.m_105241_(mc.f_91074_.m_21120_(InteractionHand.MAIN_HAND), 36 + inv.f_35977_);
            } else {
                boolean shouldPick;
                int slot = inv.m_36030_(stack);
                boolean bl = shouldPick = inv.f_35977_ != slot;
                if (shouldPick && slot != -1) {
                    InventoryUtils.setPickedItemToHand(stack, mc);
                } else if (slot == -1 && Configs.Generic.PICK_BLOCK_SHULKERS.getBooleanValue() && (slot = InventoryUtils.findSlotWithBoxWithItem((AbstractContainerMenu)mc.f_91074_.f_36095_, stack, false)) != -1) {
                    ItemStack boxStack = ((Slot)mc.f_91074_.f_36095_.f_38839_.get(slot)).m_7993_();
                    InventoryUtils.setPickedItemToHand(boxStack, mc);
                }
            }
        }
    }

    private static int getPickBlockTargetSlot(Player player) {
        int slotNum;
        if (PICK_BLOCKABLE_SLOTS.contains(player.m_150109_().f_35977_ + 1)) {
            slotNum = player.m_150109_().f_35977_;
        } else {
            if (nextPickSlotIndex >= PICK_BLOCKABLE_SLOTS.size()) {
                nextPickSlotIndex = 0;
            }
            slotNum = PICK_BLOCKABLE_SLOTS.get(nextPickSlotIndex) - 1;
            if (++nextPickSlotIndex >= PICK_BLOCKABLE_SLOTS.size()) {
                nextPickSlotIndex = 0;
            }
        }
        return slotNum;
    }

    private static int getEmptyPickBlockableHotbarSlot(Inventory inventory) {
        for (int i = 0; i < PICK_BLOCKABLE_SLOTS.size(); ++i) {
            ItemStack stack;
            int slotNum = PICK_BLOCKABLE_SLOTS.get(i) - 1;
            if (slotNum < 0 || slotNum >= inventory.f_35974_.size() || !(stack = (ItemStack)inventory.f_35974_.get(slotNum)).m_41619_()) continue;
            return slotNum;
        }
        return -1;
    }

    public static boolean doesShulkerBoxContainItem(ItemStack stack, ItemStack referenceItem) {
        NonNullList items = fi.dy.masa.malilib.util.InventoryUtils.getStoredItems((ItemStack)stack);
        if (items.size() > 0) {
            for (ItemStack item : items) {
                if (!fi.dy.masa.malilib.util.InventoryUtils.areStacksEqual((ItemStack)item, (ItemStack)referenceItem)) continue;
                return true;
            }
        }
        return false;
    }

    public static int findSlotWithBoxWithItem(AbstractContainerMenu container, ItemStack stackReference, boolean reverse) {
        int startSlot = reverse ? container.f_38839_.size() - 1 : 0;
        int endSlot = reverse ? -1 : container.f_38839_.size();
        int increment = reverse ? -1 : 1;
        boolean isPlayerInv = container instanceof InventoryMenu;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            Slot slot = (Slot)container.f_38839_.get(slotNum);
            if (isPlayerInv && !fi.dy.masa.malilib.util.InventoryUtils.isRegularInventorySlot((int)slot.f_40219_, (boolean)false) || !InventoryUtils.doesShulkerBoxContainItem(slot.m_7993_(), stackReference)) continue;
            return slot.f_40219_;
        }
        return -1;
    }
}

