/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import java.util.HashSet;
import java.util.IdentityHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class ItemUtils {
    private static final IdentityHashMap<BlockState, ItemStack> ITEMS_FOR_STATES = new IdentityHashMap();

    public static boolean areTagsEqualIgnoreDamage(ItemStack stackReference, ItemStack stackToCheck) {
        CompoundTag tagReference = stackReference.m_41783_();
        CompoundTag tagToCheck = stackToCheck.m_41783_();
        if (tagReference != null && tagToCheck != null) {
            HashSet keysReference = new HashSet(tagReference.m_128431_());
            for (String key : keysReference) {
                if (key.equals("Damage") || tagReference.m_128423_(key).equals(tagToCheck.m_128423_(key))) continue;
                return false;
            }
            return true;
        }
        return tagReference == null && tagToCheck == null;
    }

    public static ItemStack getItemForState(BlockState state) {
        ItemStack stack = ITEMS_FOR_STATES.get(state);
        return stack != null ? stack : ItemStack.f_41583_;
    }

    public static void setItemForBlock(Level world, BlockPos pos, BlockState state) {
        if (!ITEMS_FOR_STATES.containsKey(state)) {
            ITEMS_FOR_STATES.put(state, ItemUtils.getItemForBlock(world, pos, state, false));
        }
    }

    public static ItemStack getItemForBlock(Level world, BlockPos pos, BlockState state, boolean checkCache) {
        ItemStack stack;
        if (checkCache && (stack = ITEMS_FOR_STATES.get(state)) != null) {
            return stack;
        }
        if (state.m_60795_()) {
            return ItemStack.f_41583_;
        }
        stack = ItemUtils.getStateToItemOverride(state);
        if (stack.m_41619_()) {
            stack = state.m_60734_().m_7397_((BlockGetter)world, pos, state);
        }
        if (stack.m_41619_()) {
            stack = ItemStack.f_41583_;
        } else {
            ItemUtils.overrideStackSize(state, stack);
        }
        ITEMS_FOR_STATES.put(state, stack);
        return stack;
    }

    public static ItemStack getStateToItemOverride(BlockState state) {
        if (state.m_60734_() == Blocks.f_49991_) {
            return new ItemStack((ItemLike)Items.f_42448_);
        }
        if (state.m_60734_() == Blocks.f_49990_) {
            return new ItemStack((ItemLike)Items.f_42447_);
        }
        return ItemStack.f_41583_;
    }

    private static void overrideStackSize(BlockState state, ItemStack stack) {
        if (state.m_60734_() instanceof SlabBlock && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.DOUBLE) {
            stack.m_41764_(2);
        }
    }

    public static ItemStack storeTEInStack(ItemStack stack, BlockEntity te) {
        CompoundTag nbt = te.m_6945_(new CompoundTag());
        if (nbt.m_128441_("Owner") && stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() instanceof AbstractSkullBlock) {
            CompoundTag tagOwner = nbt.m_128469_("Owner");
            CompoundTag tagSkull = new CompoundTag();
            tagSkull.m_128365_("SkullOwner", (Tag)tagOwner);
            stack.m_41751_(tagSkull);
            return stack;
        }
        CompoundTag tagLore = new CompoundTag();
        ListTag tagList = new ListTag();
        tagList.add((Object)StringTag.m_129297_((String)"(+NBT)"));
        tagLore.m_128365_("Lore", (Tag)tagList);
        stack.m_41700_("display", (Tag)tagLore);
        stack.m_41700_("BlockEntityTag", (Tag)nbt);
        return stack;
    }

    public static String getStackString(ItemStack stack) {
        if (!stack.m_41619_()) {
            ResourceLocation rl = Registry.f_122827_.m_7981_((Object)stack.m_41720_());
            return String.format("[%s - display: %s - NBT: %s] (%s)", rl != null ? rl.toString() : "null", stack.m_41786_().getString(), stack.m_41783_() != null ? stack.m_41783_().toString() : "<no NBT>", stack);
        }
        return "<empty>";
    }
}

