/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.data.SchematicHolder;
import fi.dy.masa.litematica.gui.GuiSchematicSave;
import fi.dy.masa.litematica.scheduler.TaskScheduler;
import fi.dy.masa.litematica.scheduler.tasks.TaskDeleteArea;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicPerChunkBase;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicPerChunkCommand;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicPerChunkDirect;
import fi.dy.masa.litematica.scheduler.tasks.TaskSaveSchematic;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.SchematicMetadata;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.schematic.projects.SchematicProject;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.SelectionManager;
import fi.dy.masa.litematica.tool.ToolMode;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.util.SchematicWorldRefresher;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiTextInput;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.interfaces.IRangeChangeListener;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.interfaces.IStringConsumerFeedback;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class SchematicUtils {
    private static long areaMovedTime;

    public static boolean saveSchematic(boolean inMemoryOnly) {
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        if (area != null) {
            if (DataManager.getSchematicProjectsManager().hasProjectOpen()) {
                String title = "litematica.gui.title.schematic_projects.save_new_version";
                SchematicProject project = DataManager.getSchematicProjectsManager().getCurrentProject();
                GuiTextInput gui = new GuiTextInput(512, title, project.getCurrentVersionName(), GuiUtils.getCurrentScreen(), (IStringConsumerFeedback)new SchematicVersionCreator());
                GuiBase.openGui((Screen)gui);
            } else if (inMemoryOnly) {
                String title = "litematica.gui.title.create_in_memory_schematic";
                GuiTextInput gui = new GuiTextInput(512, title, area.getName(), GuiUtils.getCurrentScreen(), (IStringConsumer)new GuiSchematicSave.InMemorySchematicCreator(area));
                GuiBase.openGui((Screen)gui);
            } else {
                GuiSchematicSave gui = new GuiSchematicSave();
                gui.setParent(GuiUtils.getCurrentScreen());
                GuiBase.openGui((Screen)gui);
            }
            return true;
        }
        return false;
    }

    public static void unloadCurrentlySelectedSchematic() {
        SchematicPlacement placement = DataManager.getSchematicPlacementManager().getSelectedSchematicPlacement();
        if (placement != null) {
            SchematicHolder.getInstance().removeSchematic(placement.getSchematic());
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_placement_selected", (Object[])new Object[0]);
        }
    }

    public static boolean breakSchematicBlock(Minecraft mc) {
        return SchematicUtils.setTargetedSchematicBlockState(mc, Blocks.f_50016_.m_49966_());
    }

    public static boolean placeSchematicBlock(Minecraft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            BlockPos pos = info.pos.m_142300_(info.side);
            if (DataManager.getRenderLayerRange().isPositionWithinRange(pos)) {
                return SchematicUtils.setTargetedSchematicBlockState(pos, info.stateNew);
            }
        }
        return false;
    }

    public static boolean replaceSchematicBlocksInDirection(Minecraft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            Direction playerFacingH = mc.f_91074_.m_6350_();
            Direction direction = fi.dy.masa.malilib.util.PositionUtils.getTargetedDirection((Direction)info.side, (Direction)playerFacingH, (BlockPos)info.pos, (Vec3)info.hitVec);
            if (direction == info.side) {
                direction = direction.m_122424_();
            }
            BlockPos posEnd = SchematicUtils.getReplacementBoxEndPos(info.pos, direction);
            return SchematicUtils.setSchematicBlockStates(info.pos, posEnd, info.stateNew);
        }
        return false;
    }

    public static boolean replaceAllIdenticalSchematicBlocks(Minecraft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            return SchematicUtils.setAllIdenticalSchematicBlockStates(info.pos, info.stateOriginal, info.stateNew, (Level)mc.f_91073_);
        }
        return false;
    }

    public static boolean breakSchematicBlocks(Minecraft mc) {
        Entity entity = fi.dy.masa.malilib.util.EntityUtils.getCameraEntity();
        RayTraceUtils.RayTraceWrapper wrapper = RayTraceUtils.getSchematicWorldTraceWrapperIfClosest((Level)mc.f_91073_, entity, 10.0);
        if (wrapper != null && wrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            BlockHitResult trace = wrapper.getBlockHitResult();
            BlockPos pos = trace.m_82425_();
            Direction playerFacingH = mc.f_91074_.m_6350_();
            Direction direction = fi.dy.masa.malilib.util.PositionUtils.getTargetedDirection((Direction)trace.m_82434_(), (Direction)playerFacingH, (BlockPos)pos, (Vec3)trace.m_82450_());
            if (direction == trace.m_82434_()) {
                direction = direction.m_122424_();
            }
            BlockPos posEnd = SchematicUtils.getReplacementBoxEndPos(pos, direction);
            return SchematicUtils.setSchematicBlockStates(pos, posEnd, Blocks.f_50016_.m_49966_());
        }
        return false;
    }

    public static boolean breakAllIdenticalSchematicBlocks(Minecraft mc) {
        Entity entity = fi.dy.masa.malilib.util.EntityUtils.getCameraEntity();
        RayTraceUtils.RayTraceWrapper wrapper = RayTraceUtils.getSchematicWorldTraceWrapperIfClosest((Level)mc.f_91073_, entity, 10.0);
        if (wrapper != null && wrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            BlockHitResult trace = wrapper.getBlockHitResult();
            BlockPos pos = trace.m_82425_();
            BlockState stateOriginal = SchematicWorldHandler.getSchematicWorld().m_8055_(pos);
            return SchematicUtils.setAllIdenticalSchematicBlockStates(pos, stateOriginal, Blocks.f_50016_.m_49966_(), (Level)mc.f_91073_);
        }
        return false;
    }

    public static boolean placeSchematicBlocksInDirection(Minecraft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null && mc.f_91074_ != null) {
            Direction playerFacingH = mc.f_91074_.m_6350_();
            Direction direction = fi.dy.masa.malilib.util.PositionUtils.getTargetedDirection((Direction)info.side, (Direction)playerFacingH, (BlockPos)info.pos, (Vec3)info.hitVec);
            BlockPos posStart = info.pos.m_142300_(info.side);
            if (SchematicWorldHandler.getSchematicWorld().m_8055_(posStart).m_60795_()) {
                BlockPos posEnd = SchematicUtils.getReplacementBoxEndPos(posStart, direction);
                return SchematicUtils.setSchematicBlockStates(posStart, posEnd, info.stateNew);
            }
        }
        return false;
    }

    public static boolean breakAllSchematicBlocksExceptTargeted(Minecraft mc) {
        Entity entity = fi.dy.masa.malilib.util.EntityUtils.getCameraEntity();
        RayTraceUtils.RayTraceWrapper wrapper = RayTraceUtils.getSchematicWorldTraceWrapperIfClosest((Level)mc.f_91073_, entity, 10.0);
        if (wrapper != null && wrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            BlockHitResult trace = wrapper.getBlockHitResult();
            BlockPos pos = trace.m_82425_();
            BlockState stateOriginal = SchematicWorldHandler.getSchematicWorld().m_8055_(pos);
            return SchematicUtils.setAllStatesToAirExcept(pos, stateOriginal, (Level)mc.f_91073_);
        }
        return false;
    }

    public static boolean fillAirWithBlocks(Minecraft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            BlockPos posStart = info.pos.m_142300_(info.side);
            if (SchematicWorldHandler.getSchematicWorld().m_8055_(posStart).m_60795_()) {
                return SchematicUtils.setAllIdenticalSchematicBlockStates(posStart, Blocks.f_50016_.m_49966_(), info.stateNew, (Level)mc.f_91073_);
            }
        }
        return false;
    }

    @Nullable
    private static ReplacementInfo getTargetInfo(Minecraft mc) {
        ItemStack stack = mc.f_91074_.m_21205_();
        if (!stack.m_41619_() && stack.m_41720_() instanceof BlockItem || stack.m_41619_() && ToolMode.REBUILD.getPrimaryBlock() != null) {
            WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
            Entity entity = fi.dy.masa.malilib.util.EntityUtils.getCameraEntity();
            RayTraceUtils.RayTraceWrapper traceWrapper = RayTraceUtils.getGenericTrace((Level)mc.f_91073_, entity, 10.0);
            if (worldSchematic != null && traceWrapper != null && traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
                BlockHitResult trace = traceWrapper.getBlockHitResult();
                Direction side = trace.m_82434_();
                Vec3 hitVec = trace.m_82450_();
                BlockPos pos = trace.m_82425_();
                BlockState stateOriginal = worldSchematic.m_8055_(pos);
                BlockState stateNew = Blocks.f_50016_.m_49966_();
                if (stack.m_41720_() instanceof BlockItem) {
                    Level worldClient = mc.f_91074_.f_19853_;
                    mc.f_91074_.f_19853_ = worldSchematic;
                    BlockHitResult hit = new BlockHitResult(trace.m_82450_(), side, pos.m_142300_(side), false);
                    BlockPlaceContext ctx = new BlockPlaceContext(new UseOnContext((Player)mc.f_91074_, InteractionHand.MAIN_HAND, hit));
                    mc.f_91074_.f_19853_ = worldClient;
                    stateNew = ((BlockItem)stack.m_41720_()).m_40614_().m_5573_(ctx);
                } else if (ToolMode.REBUILD.getPrimaryBlock() != null) {
                    stateNew = ToolMode.REBUILD.getPrimaryBlock();
                }
                return new ReplacementInfo(pos, side, hitVec, stateOriginal, stateNew);
            }
        }
        return null;
    }

    private static BlockPos getReplacementBoxEndPos(BlockPos startPos, Direction direction) {
        return SchematicUtils.getReplacementBoxEndPos(startPos, direction, 10000);
    }

    private static BlockPos getReplacementBoxEndPos(BlockPos startPos, Direction direction, int maxBlocks) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        LayerRange range = DataManager.getRenderLayerRange();
        BlockState stateStart = world.m_8055_(startPos);
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        posMutable.m_122190_((Vec3i)startPos);
        while (maxBlocks-- > 0) {
            posMutable.m_122173_(direction);
            if (range.isPositionWithinRange((BlockPos)posMutable) && world.getChunkProvider().m_5563_(posMutable.m_123341_() >> 4, posMutable.m_123343_() >> 4) && world.m_8055_((BlockPos)posMutable) == stateStart) continue;
            posMutable.m_122173_(direction.m_122424_());
            break;
        }
        return posMutable.m_7949_();
    }

    public static boolean setTargetedSchematicBlockState(Minecraft mc, BlockState state) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        Entity entity = fi.dy.masa.malilib.util.EntityUtils.getCameraEntity();
        RayTraceUtils.RayTraceWrapper traceWrapper = RayTraceUtils.getGenericTrace((Level)mc.f_91073_, entity, 6.0);
        if (world != null && traceWrapper != null && traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            BlockHitResult trace = traceWrapper.getBlockHitResult();
            BlockPos pos = trace.m_82425_();
            return SchematicUtils.setTargetedSchematicBlockState(pos, state);
        }
        return false;
    }

    private static boolean setTargetedSchematicBlockState(BlockPos pos, BlockState state) {
        if (pos != null) {
            SubChunkPos cpos = new SubChunkPos(pos);
            List<SchematicPlacementManager.PlacementPart> list = DataManager.getSchematicPlacementManager().getAllPlacementsTouchingSubChunk(cpos);
            if (!list.isEmpty()) {
                for (SchematicPlacementManager.PlacementPart part : list) {
                    if (!part.getBox().containsPos((Vec3i)pos)) continue;
                    SchematicPlacement placement = part.getPlacement();
                    String regionName = part.getSubRegionName();
                    LitematicaBlockStateContainer container = placement.getSchematic().getSubRegionContainer(regionName);
                    BlockPos posSchematic = SchematicUtils.getSchematicContainerPositionFromWorldPosition(pos, placement.getSchematic(), regionName, placement, placement.getRelativeSubRegionPlacement(regionName), container);
                    if (posSchematic != null) {
                        state = SchematicUtils.getUntransformedBlockState(state, placement, regionName);
                        BlockState stateOriginal = container.get(posSchematic.m_123341_(), posSchematic.m_123342_(), posSchematic.m_123343_());
                        int totalBlocks = part.getPlacement().getSchematic().getMetadata().getTotalBlocks();
                        int increment = 0;
                        increment = !stateOriginal.m_60795_() ? (!state.m_60795_() ? 0 : -1) : (!state.m_60795_() ? 1 : 0);
                        container.set(posSchematic.m_123341_(), posSchematic.m_123342_(), posSchematic.m_123343_(), state);
                        SchematicMetadata metadata = part.getPlacement().getSchematic().getMetadata();
                        metadata.setTotalBlocks(totalBlocks += increment);
                        metadata.setTimeModifiedToNow();
                        metadata.setModifiedSinceSaved();
                        DataManager.getSchematicPlacementManager().markChunkForRebuild(new ChunkPos(cpos.m_123341_(), cpos.m_123343_()));
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean setSchematicBlockStates(BlockPos posStart, BlockPos posEnd, BlockState state) {
        if (posStart != null && posEnd != null) {
            SubChunkPos cpos = new SubChunkPos(posStart);
            List<SchematicPlacementManager.PlacementPart> list = DataManager.getSchematicPlacementManager().getAllPlacementsTouchingSubChunk(cpos);
            if (!list.isEmpty()) {
                for (SchematicPlacementManager.PlacementPart part : list) {
                    if (!part.getBox().containsPos((Vec3i)posStart)) continue;
                    SchematicPlacement placement = part.getPlacement();
                    String regionName = part.getSubRegionName();
                    LitematicaBlockStateContainer container = placement.getSchematic().getSubRegionContainer(regionName);
                    BlockPos posStartSchematic = SchematicUtils.getSchematicContainerPositionFromWorldPosition(posStart, placement.getSchematic(), regionName, placement, placement.getRelativeSubRegionPlacement(regionName), container);
                    BlockPos posEndSchematic = SchematicUtils.getSchematicContainerPositionFromWorldPosition(posEnd, placement.getSchematic(), regionName, placement, placement.getRelativeSubRegionPlacement(regionName), container);
                    if (posStartSchematic != null && posEndSchematic != null) {
                        BlockPos posMin = PositionUtils.getMinCorner(posStartSchematic, posEndSchematic);
                        BlockPos posMax = PositionUtils.getMaxCorner(posStartSchematic, posEndSchematic);
                        int minX = Math.max(posMin.m_123341_(), 0);
                        int minY = Math.max(posMin.m_123342_(), 0);
                        int minZ = Math.max(posMin.m_123343_(), 0);
                        int maxX = Math.min(posMax.m_123341_(), container.getSize().m_123341_() - 1);
                        int maxY = Math.min(posMax.m_123342_(), container.getSize().m_123342_() - 1);
                        int maxZ = Math.min(posMax.m_123343_(), container.getSize().m_123343_() - 1);
                        int totalBlocks = part.getPlacement().getSchematic().getMetadata().getTotalBlocks();
                        int increment = 0;
                        state = SchematicUtils.getUntransformedBlockState(state, placement, regionName);
                        for (int y = minY; y <= maxY; ++y) {
                            for (int z = minZ; z <= maxZ; ++z) {
                                for (int x = minX; x <= maxX; ++x) {
                                    BlockState stateOriginal = container.get(x, y, z);
                                    increment = !stateOriginal.m_60795_() ? (!state.m_60795_() ? 0 : -1) : (!state.m_60795_() ? 1 : 0);
                                    totalBlocks += increment;
                                    container.set(x, y, z, state);
                                }
                            }
                        }
                        SchematicMetadata metadata = part.getPlacement().getSchematic().getMetadata();
                        metadata.setTotalBlocks(totalBlocks);
                        metadata.setTimeModifiedToNow();
                        metadata.setModifiedSinceSaved();
                        DataManager.getSchematicPlacementManager().markAllPlacementsOfSchematicForRebuild(placement.getSchematic());
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean setAllIdenticalSchematicBlockStates(BlockPos posStart, BlockState stateOriginal, BlockState stateNew, Level world) {
        if (posStart != null) {
            SubChunkPos cpos = new SubChunkPos(posStart);
            SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
            List<SchematicPlacementManager.PlacementPart> list = manager.getAllPlacementsTouchingSubChunk(cpos);
            if (!list.isEmpty()) {
                for (SchematicPlacementManager.PlacementPart part : list) {
                    if (!part.getBox().containsPos((Vec3i)posStart)) continue;
                    if (SchematicUtils.replaceAllIdenticalBlocks(manager, part, stateOriginal, stateNew, world)) {
                        manager.markAllPlacementsOfSchematicForRebuild(part.getPlacement().getSchematic());
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean setAllStatesToAirExcept(BlockPos pos, BlockState state, Level world) {
        if (pos != null) {
            SubChunkPos cpos = new SubChunkPos(pos);
            SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
            List<SchematicPlacementManager.PlacementPart> list = manager.getAllPlacementsTouchingSubChunk(cpos);
            if (!list.isEmpty()) {
                for (SchematicPlacementManager.PlacementPart part : list) {
                    if (!part.getBox().containsPos((Vec3i)pos)) continue;
                    if (SchematicUtils.setAllStatesToAirExcept(manager, part, state, world)) {
                        manager.markAllPlacementsOfSchematicForRebuild(part.getPlacement().getSchematic());
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean setAllStatesToAirExcept(SchematicPlacementManager manager, SchematicPlacementManager.PlacementPart part, BlockState state, Level world) {
        SchematicPlacement schematicPlacement = part.getPlacement();
        String selected = schematicPlacement.getSelectedSubRegionName();
        ArrayList<String> regions = new ArrayList<String>();
        BlockState air = Blocks.f_50016_.m_49966_();
        if (selected != null) {
            regions.add(selected);
        } else if (manager.getSelectedSchematicPlacement() == schematicPlacement) {
            regions.addAll((Collection<String>)schematicPlacement.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED).keySet());
        } else {
            InfoUtils.showInGameMessage((Message.MessageType)Message.MessageType.WARNING, (int)20000, (String)"litematica.message.warn.schematic_rebuild_placement_not_selected", (Object[])new Object[0]);
            return false;
        }
        LayerRange range = DataManager.getRenderLayerRange();
        int totalBlocks = schematicPlacement.getSchematic().getMetadata().getTotalBlocks();
        for (String regionName : regions) {
            LitematicaBlockStateContainer container = schematicPlacement.getSchematic().getSubRegionContainer(regionName);
            SubRegionPlacement placement = schematicPlacement.getRelativeSubRegionPlacement(regionName);
            if (container == null || placement == null) continue;
            int minX = range.getClampedValue(-30000000, Direction.Axis.X);
            int minZ = range.getClampedValue(-30000000, Direction.Axis.Z);
            int maxX = range.getClampedValue(30000000, Direction.Axis.X);
            int maxZ = range.getClampedValue(30000000, Direction.Axis.Z);
            int minY = range.getClampedValue(world.m_141937_(), Direction.Axis.Y);
            int maxY = range.getClampedValue(world.m_151558_() - 1, Direction.Axis.Y);
            BlockPos posStart = new BlockPos(minX, minY, minZ);
            BlockPos posEnd = new BlockPos(maxX, maxY, maxZ);
            BlockPos pos1 = SchematicUtils.getReverserTransformedWorldPosition(posStart, schematicPlacement.getSchematic(), regionName, schematicPlacement, schematicPlacement.getRelativeSubRegionPlacement(regionName));
            BlockPos pos2 = SchematicUtils.getReverserTransformedWorldPosition(posEnd, schematicPlacement.getSchematic(), regionName, schematicPlacement, schematicPlacement.getRelativeSubRegionPlacement(regionName));
            if (pos1 == null || pos2 == null) {
                return false;
            }
            BlockPos posStartWorld = PositionUtils.getMinCorner(pos1, pos2);
            BlockPos posEndWorld = PositionUtils.getMaxCorner(pos1, pos2);
            Vec3i size = container.getSize();
            int startX = Math.max(posStartWorld.m_123341_(), 0);
            int startY = Math.max(posStartWorld.m_123342_(), 0);
            int startZ = Math.max(posStartWorld.m_123343_(), 0);
            int endX = Math.min(posEndWorld.m_123341_(), size.m_123341_() - 1);
            int endY = Math.min(posEndWorld.m_123342_(), size.m_123342_() - 1);
            int endZ = Math.min(posEndWorld.m_123343_(), size.m_123343_() - 1);
            if (endX >= size.m_123341_() || endY >= size.m_123342_() || endZ >= size.m_123343_()) {
                System.out.printf("OUT OF BOUNDS == region: %s, sx: %d, sy: %s, sz: %d, ex: %d, ey: %d, ez: %d - size x: %d y: %d z: %d =============\n", regionName, startX, startY, startZ, endX, endY, endZ, size.m_123341_(), size.m_123342_(), size.m_123343_());
                return false;
            }
            BlockState stateOriginal = SchematicUtils.getUntransformedBlockState(state, schematicPlacement, regionName);
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    for (int x = startX; x <= endX; ++x) {
                        BlockState oldState = container.get(x, y, z);
                        if (oldState == stateOriginal || oldState.m_60795_()) continue;
                        container.set(x, y, z, air);
                        --totalBlocks;
                    }
                }
            }
        }
        schematicPlacement.getSchematic().getMetadata().setTotalBlocks(totalBlocks);
        return true;
    }

    private static boolean replaceAllIdenticalBlocks(SchematicPlacementManager manager, SchematicPlacementManager.PlacementPart part, BlockState stateOriginalIn, BlockState stateNewIn, Level world) {
        SchematicPlacement schematicPlacement = part.getPlacement();
        String selected = schematicPlacement.getSelectedSubRegionName();
        ArrayList<String> regions = new ArrayList<String>();
        if (selected != null) {
            regions.add(selected);
        } else if (manager.getSelectedSchematicPlacement() == schematicPlacement) {
            regions.addAll((Collection<String>)schematicPlacement.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED).keySet());
        } else {
            InfoUtils.showInGameMessage((Message.MessageType)Message.MessageType.WARNING, (int)20000, (String)"litematica.message.warn.schematic_rebuild_placement_not_selected", (Object[])new Object[0]);
            return false;
        }
        LayerRange range = DataManager.getRenderLayerRange();
        int totalBlocks = schematicPlacement.getSchematic().getMetadata().getTotalBlocks();
        int increment = 0;
        increment = !stateOriginalIn.m_60795_() ? (!stateNewIn.m_60795_() ? 0 : -1) : (!stateNewIn.m_60795_() ? 1 : 0);
        for (String regionName : regions) {
            LitematicaBlockStateContainer container = schematicPlacement.getSchematic().getSubRegionContainer(regionName);
            SubRegionPlacement placement = schematicPlacement.getRelativeSubRegionPlacement(regionName);
            if (container == null || placement == null) continue;
            int minX = range.getClampedValue(-30000000, Direction.Axis.X);
            int minZ = range.getClampedValue(-30000000, Direction.Axis.Z);
            int maxX = range.getClampedValue(30000000, Direction.Axis.X);
            int maxZ = range.getClampedValue(30000000, Direction.Axis.Z);
            int minY = range.getClampedValue(world.m_141937_(), Direction.Axis.Y);
            int maxY = range.getClampedValue(world.m_151558_() - 1, Direction.Axis.Y);
            BlockPos posStart = new BlockPos(minX, minY, minZ);
            BlockPos posEnd = new BlockPos(maxX, maxY, maxZ);
            BlockPos pos1 = SchematicUtils.getReverserTransformedWorldPosition(posStart, schematicPlacement.getSchematic(), regionName, schematicPlacement, schematicPlacement.getRelativeSubRegionPlacement(regionName));
            BlockPos pos2 = SchematicUtils.getReverserTransformedWorldPosition(posEnd, schematicPlacement.getSchematic(), regionName, schematicPlacement, schematicPlacement.getRelativeSubRegionPlacement(regionName));
            if (pos1 == null || pos2 == null) {
                return false;
            }
            BlockPos posStartWorld = PositionUtils.getMinCorner(pos1, pos2);
            BlockPos posEndWorld = PositionUtils.getMaxCorner(pos1, pos2);
            Vec3i size = container.getSize();
            int startX = Math.max(posStartWorld.m_123341_(), 0);
            int startY = Math.max(posStartWorld.m_123342_(), 0);
            int startZ = Math.max(posStartWorld.m_123343_(), 0);
            int endX = Math.min(posEndWorld.m_123341_(), size.m_123341_() - 1);
            int endY = Math.min(posEndWorld.m_123342_(), size.m_123342_() - 1);
            int endZ = Math.min(posEndWorld.m_123343_(), size.m_123343_() - 1);
            if (startX < 0 || startY < 0 || startZ < 0 || endX >= size.m_123341_() || endY >= size.m_123342_() || endZ >= size.m_123343_()) {
                System.out.printf("OUT OF BOUNDS == region: %s, sx: %d, sy: %s, sz: %d, ex: %d, ey: %d, ez: %d - size x: %d y: %d z: %d =============\n", regionName, startX, startY, startZ, endX, endY, endZ, size.m_123341_(), size.m_123342_(), size.m_123343_());
                return false;
            }
            BlockState stateOriginal = SchematicUtils.getUntransformedBlockState(stateOriginalIn, schematicPlacement, regionName);
            BlockState stateNew = SchematicUtils.getUntransformedBlockState(stateNewIn, schematicPlacement, regionName);
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    for (int x = startX; x <= endX; ++x) {
                        if (container.get(x, y, z) != stateOriginal) continue;
                        container.set(x, y, z, stateNew);
                        totalBlocks += increment;
                    }
                }
            }
        }
        SchematicMetadata metadata = part.getPlacement().getSchematic().getMetadata();
        metadata.setTotalBlocks(totalBlocks);
        metadata.setTimeModifiedToNow();
        metadata.setModifiedSinceSaved();
        return true;
    }

    public static void moveCurrentlySelectedWorldRegionToLookingDirection(int amount, Entity entity, Minecraft mc) {
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        if (area != null && area.getAllSubRegionBoxes().size() > 0) {
            BlockPos pos = area.getEffectiveOrigin().m_5484_(EntityUtils.getClosestLookingDirection(entity), amount);
            SchematicUtils.moveCurrentlySelectedWorldRegionTo(pos, mc);
        }
    }

    public static void moveCurrentlySelectedWorldRegionTo(BlockPos pos, Minecraft mc) {
        if (mc.f_91074_ == null || !EntityUtils.isCreativeMode((Player)mc.f_91074_)) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.generic.creative_mode_only", (Object[])new Object[0]);
            return;
        }
        TaskScheduler scheduler = TaskScheduler.getServerInstanceIfExistsOrClient();
        long currentTime = System.currentTimeMillis();
        if (currentTime - areaMovedTime < 400L || scheduler.hasTask(TaskSaveSchematic.class) || scheduler.hasTask(TaskDeleteArea.class) || scheduler.hasTask(TaskPasteSchematicPerChunkCommand.class) || scheduler.hasTask(TaskPasteSchematicPerChunkDirect.class)) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.move.pending_tasks", (Object[])new Object[0]);
            return;
        }
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        if (area != null && area.getAllSubRegionBoxes().size() > 0) {
            LitematicaSchematic schematic = LitematicaSchematic.createEmptySchematic(area, "");
            LitematicaSchematic.SchematicSaveInfo info = new LitematicaSchematic.SchematicSaveInfo(false, false);
            TaskSaveSchematic taskSave = new TaskSaveSchematic(schematic, area, info);
            taskSave.disableCompletionMessage();
            areaMovedTime = System.currentTimeMillis();
            taskSave.setCompletionListener(() -> {
                SchematicPlacement placement = SchematicPlacement.createFor(schematic, pos, "-", true, true);
                DataManager.getSchematicPlacementManager().addSchematicPlacement(placement, false);
                TaskDeleteArea taskDelete = new TaskDeleteArea(area.getAllSubRegionBoxes(), true);
                taskDelete.disableCompletionMessage();
                areaMovedTime = System.currentTimeMillis();
                taskDelete.setCompletionListener(() -> {
                    LayerRange range = new LayerRange((IRangeChangeListener)SchematicWorldRefresher.INSTANCE);
                    TaskPasteSchematicPerChunkBase taskPaste = mc.m_91091_() ? new TaskPasteSchematicPerChunkDirect(Collections.singletonList(placement), range, false) : new TaskPasteSchematicPerChunkCommand(Collections.singletonList(placement), range, false);
                    taskPaste.disableCompletionMessage();
                    areaMovedTime = System.currentTimeMillis();
                    taskPaste.setCompletionListener(() -> {
                        SchematicHolder.getInstance().removeSchematic(schematic);
                        area.moveEntireSelectionTo(pos, false);
                        areaMovedTime = System.currentTimeMillis();
                    });
                    scheduler.scheduleTask(taskPaste, 1);
                });
                scheduler.scheduleTask(taskDelete, 1);
            });
            scheduler.scheduleTask(taskSave, 1);
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_area_selected", (Object[])new Object[0]);
        }
    }

    public static void cloneSelectionArea(Minecraft mc) {
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        if (area != null && area.getAllSubRegionBoxes().size() > 0) {
            LitematicaSchematic schematic = LitematicaSchematic.createEmptySchematic(area, mc.f_91074_.m_7755_().getString());
            LitematicaSchematic.SchematicSaveInfo info = new LitematicaSchematic.SchematicSaveInfo(false, false);
            TaskSaveSchematic taskSave = new TaskSaveSchematic(schematic, area, info);
            taskSave.disableCompletionMessage();
            Entity entity = fi.dy.masa.malilib.util.EntityUtils.getCameraEntity();
            BlockPos originTmp = RayTraceUtils.getTargetedPosition((Level)mc.f_91073_, entity, 6.0, false);
            if (originTmp == null) {
                originTmp = fi.dy.masa.malilib.util.PositionUtils.getEntityBlockPos((Entity)entity);
            }
            BlockPos origin = originTmp;
            String name = schematic.getMetadata().getName();
            taskSave.setCompletionListener(() -> {
                SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
                SchematicPlacement placement = SchematicPlacement.createFor(schematic, origin, name, true, true);
                manager.addSchematicPlacement(placement, false);
                manager.setSelectedSchematicPlacement(placement);
                if (EntityUtils.isCreativeMode((Player)mc.f_91074_)) {
                    DataManager.setToolMode(ToolMode.PASTE_SCHEMATIC);
                }
            });
            TaskScheduler.getServerInstanceIfExistsOrClient().scheduleTask(taskSave, 10);
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_area_selected", (Object[])new Object[0]);
        }
    }

    @Nullable
    public static BlockPos getSchematicContainerPositionFromWorldPosition(BlockPos worldPos, LitematicaSchematic schematic, String regionName, SchematicPlacement schematicPlacement, SubRegionPlacement regionPlacement, LitematicaBlockStateContainer container) {
        BlockPos boxMinRel = SchematicUtils.getReverserTransformedWorldPosition(worldPos, schematic, regionName, schematicPlacement, regionPlacement);
        if (boxMinRel == null) {
            return null;
        }
        int startX = boxMinRel.m_123341_();
        int startY = boxMinRel.m_123342_();
        int startZ = boxMinRel.m_123343_();
        Vec3i size = container.getSize();
        return new BlockPos(Mth.m_14045_((int)startX, (int)0, (int)(size.m_123341_() - 1)), Mth.m_14045_((int)startY, (int)0, (int)(size.m_123342_() - 1)), Mth.m_14045_((int)startZ, (int)0, (int)(size.m_123343_() - 1)));
    }

    @Nullable
    private static BlockPos getReverserTransformedWorldPosition(BlockPos worldPos, LitematicaSchematic schematic, String regionName, SchematicPlacement schematicPlacement, SubRegionPlacement regionPlacement) {
        BlockPos origin = schematicPlacement.getOrigin();
        BlockPos regionPos = regionPlacement.getPos();
        BlockPos regionSize = schematic.getAreaSize(regionName);
        if (regionSize == null) {
            return null;
        }
        BlockPos posEndRel = PositionUtils.getRelativeEndPositionFromAreaSize((Vec3i)regionSize).m_141952_((Vec3i)regionPos);
        BlockPos posMinRel = PositionUtils.getMinCorner(regionPos, posEndRel);
        BlockPos regionPosTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        BlockPos relPos = new BlockPos(worldPos.m_123341_() - origin.m_123341_() - regionPosTransformed.m_123341_(), worldPos.m_123342_() - origin.m_123342_() - regionPosTransformed.m_123342_(), worldPos.m_123343_() - origin.m_123343_() - regionPosTransformed.m_123343_());
        relPos = PositionUtils.getReverseTransformedBlockPos(relPos, regionPlacement.getMirror(), regionPlacement.getRotation());
        relPos = PositionUtils.getReverseTransformedBlockPos(relPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        relPos = relPos.m_141950_((Vec3i)posMinRel.m_141950_((Vec3i)regionPos));
        return relPos;
    }

    public static BlockState getUntransformedBlockState(BlockState state, SchematicPlacement schematicPlacement, String subRegionName) {
        SubRegionPlacement placement = schematicPlacement.getRelativeSubRegionPlacement(subRegionName);
        if (placement != null) {
            Rotation rotationCombined = PositionUtils.getReverseRotation(schematicPlacement.getRotation().m_55952_(placement.getRotation()));
            Mirror mirrorMain = schematicPlacement.getMirror();
            Mirror mirrorSub = placement.getMirror();
            if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
                Mirror mirror = mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
            }
            if (rotationCombined != Rotation.NONE) {
                state = state.m_60717_(rotationCombined);
            }
            if (mirrorSub != Mirror.NONE) {
                state = state.m_60715_(mirrorSub);
            }
            if (mirrorMain != Mirror.NONE) {
                state = state.m_60715_(mirrorMain);
            }
        }
        return state;
    }

    public static class SchematicVersionCreator
    implements IStringConsumerFeedback {
        public boolean setString(String string) {
            return DataManager.getSchematicProjectsManager().commitNewVersion(string);
        }
    }

    private static class ReplacementInfo {
        public final BlockPos pos;
        public final Direction side;
        public final Vec3 hitVec;
        public final BlockState stateOriginal;
        public final BlockState stateNew;

        public ReplacementInfo(BlockPos pos, Direction side, Vec3 hitVec, BlockState stateOriginal, BlockState stateNew) {
            this.pos = pos;
            this.side = side;
            this.hitVec = hitVec;
            this.stateOriginal = stateOriginal;
            this.stateNew = stateNew;
        }
    }
}

