/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.interfaces.IRangeChangeListener;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;

public class SchematicWorldRefresher
implements IRangeChangeListener {
    public static final SchematicWorldRefresher INSTANCE = new SchematicWorldRefresher();
    private final Minecraft mc = Minecraft.m_91087_();

    public void updateAll() {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null) {
            int minY = world.m_141937_();
            int maxY = world.m_151558_() - 1;
            this.updateBetweenY(minY, maxY);
        }
    }

    public void updateBetweenX(int minX, int maxX) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null && this.mc.f_91073_ != null) {
            int xMin = Math.min(minX, maxX);
            int xMax = Math.max(minX, maxX);
            int cxMin = xMin >> 4;
            int cxMax = xMax >> 4;
            int minY = world.m_141937_();
            int maxY = world.m_151558_() - 1;
            Long2ObjectMap<ChunkSchematic> schematicChunks = world.getChunkProvider().getLoadedChunks();
            for (ChunkSchematic chunk : schematicChunks.values()) {
                ChunkPos pos = chunk.m_7697_();
                if (pos.f_45578_ < cxMin || pos.f_45578_ > cxMax || chunk.m_6430_() || !WorldUtils.isClientChunkLoaded(this.mc.f_91073_, pos.f_45578_, pos.f_45579_)) continue;
                minX = Math.max(pos.f_45578_ << 4, xMin);
                maxX = Math.min((pos.f_45578_ << 4) + 15, xMax);
                world.scheduleChunkRenders(minX, minY, pos.f_45579_ << 4, maxX, maxY, (pos.f_45579_ << 4) + 15);
            }
        }
    }

    public void updateBetweenY(int minY, int maxY) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null && this.mc.f_91073_ != null) {
            Long2ObjectMap<ChunkSchematic> schematicChunks = world.getChunkProvider().getLoadedChunks();
            for (ChunkSchematic chunk : schematicChunks.values()) {
                ChunkPos pos = chunk.m_7697_();
                if (chunk.m_6430_() || !WorldUtils.isClientChunkLoaded(this.mc.f_91073_, pos.f_45578_, pos.f_45579_)) continue;
                world.scheduleChunkRenders(pos.f_45578_ << 4, minY, pos.f_45579_ << 4, (pos.f_45578_ << 4) + 15, maxY, (pos.f_45579_ << 4) + 15);
            }
        }
    }

    public void updateBetweenZ(int minZ, int maxZ) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null && this.mc.f_91073_ != null) {
            int zMin = Math.min(minZ, maxZ);
            int zMax = Math.max(minZ, maxZ);
            int czMin = zMin >> 4;
            int czMax = zMax >> 4;
            int minY = world.m_141937_();
            int maxY = world.m_151558_() - 1;
            Long2ObjectMap<ChunkSchematic> schematicChunks = world.getChunkProvider().getLoadedChunks();
            for (ChunkSchematic chunk : schematicChunks.values()) {
                ChunkPos pos = chunk.m_7697_();
                if (pos.f_45579_ < czMin || pos.f_45579_ > czMax || chunk.m_6430_() || !WorldUtils.isClientChunkLoaded(this.mc.f_91073_, pos.f_45578_, pos.f_45579_)) continue;
                minZ = Math.max(pos.f_45579_ << 4, zMin);
                maxZ = Math.min((pos.f_45579_ << 4) + 15, zMax);
                world.scheduleChunkRenders(pos.f_45578_ << 4, minY, minZ, (pos.f_45578_ << 4) + 15, maxY, maxZ);
            }
        }
    }

    public void markSchematicChunksForRenderUpdate(int chunkX, int chunkZ) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null && this.mc.f_91073_ != null && world.getChunkProvider().m_5563_(chunkX, chunkZ) && WorldUtils.isClientChunkLoaded(this.mc.f_91073_, chunkX, chunkZ)) {
            world.scheduleChunkRenders(chunkX, chunkZ);
        }
    }

    public void markSchematicChunksForRenderUpdate(int chunkX, int chunkY, int chunkZ) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null && this.mc.f_91073_ != null && world.getChunkProvider().m_5563_(chunkX, chunkZ) && WorldUtils.isClientChunkLoaded(this.mc.f_91073_, chunkX, chunkZ)) {
            world.scheduleBlockRenders(chunkX, chunkY, chunkZ);
        }
    }

    public void markSchematicChunkForRenderUpdate(BlockPos pos) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null && this.mc.f_91073_ != null) {
            int chunkX = pos.m_123341_() >> 4;
            int chunkZ = pos.m_123343_() >> 4;
            if (world.getChunkProvider().m_5563_(chunkX, chunkZ) && WorldUtils.isClientChunkLoaded(this.mc.f_91073_, chunkX, chunkZ)) {
                world.scheduleBlockRenders(chunkX, pos.m_123342_() >> 4, chunkZ);
            }
        }
    }
}

