/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.world.WorldSchematic;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.biome.BiomeZoomer;
import net.minecraft.world.level.biome.NearestNeighborBiomeZoomer;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;

public class SchematicWorldHandler {
    @Nullable
    private static WorldSchematic world;
    public static final DimensionType DIMENSIONTYPE;

    @Nullable
    public static WorldSchematic getSchematicWorld() {
        return world;
    }

    public static WorldSchematic createSchematicWorld() {
        ClientLevel.ClientLevelData levelInfo = new ClientLevel.ClientLevelData(Difficulty.PEACEFUL, false, true);
        return new WorldSchematic((WritableLevelData)levelInfo, DIMENSIONTYPE, () -> ((Minecraft)Minecraft.m_91087_()).m_91307_());
    }

    public static void recreateSchematicWorld(boolean remove) {
        if (remove) {
            if (Configs.Generic.DEBUG_LOGGING.getBooleanValue()) {
                Litematica.logger.info("Removing the schematic world...");
            }
            world = null;
        } else {
            if (Configs.Generic.DEBUG_LOGGING.getBooleanValue()) {
                Litematica.logger.info("(Re-)creating the schematic world...");
            }
            world = SchematicWorldHandler.createSchematicWorld();
            if (Configs.Generic.DEBUG_LOGGING.getBooleanValue()) {
                Litematica.logger.info("Schematic world created: {}", (Object)world);
            }
        }
        LitematicaRenderer.getInstance().onSchematicWorldChanged(world);
    }

    static {
        DIMENSIONTYPE = DimensionType.m_156699_((OptionalLong)OptionalLong.of(6000L), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (double)1.0, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)-64, (int)384, (int)384, (BiomeZoomer)NearestNeighborBiomeZoomer.INSTANCE, (ResourceLocation)BlockTags.f_13060_.m_6979_(), (ResourceLocation)DimensionType.f_63840_, (float)0.0f);
    }
}

