/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.gui.widgets;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.gui.GuiSchematicBrowserBase;
import fi.dy.masa.litematica.gui.Icons;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.SchematicMetadata;
import fi.dy.masa.malilib.gui.interfaces.IFileBrowserIconProvider;
import fi.dy.masa.malilib.gui.interfaces.ISelectionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetFileBrowserBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.tuple.Pair;

public class WidgetSchematicBrowser
extends WidgetFileBrowserBase {
    protected static final FileFilter SCHEMATIC_FILTER = new FileFilterSchematics();
    protected final Map<File, SchematicMetadata> cachedMetadata = new HashMap<File, SchematicMetadata>();
    protected final Map<File, Pair<ResourceLocation, DynamicTexture>> cachedPreviewImages = new HashMap<File, Pair<ResourceLocation, DynamicTexture>>();
    protected final GuiSchematicBrowserBase parent;
    protected final int infoWidth;
    protected final int infoHeight;

    public WidgetSchematicBrowser(int x, int y, int width, int height, GuiSchematicBrowserBase parent, @Nullable ISelectionListener<WidgetFileBrowserBase.DirectoryEntry> selectionListener) {
        super(x, y, width, height, DataManager.getDirectoryCache(), parent.getBrowserContext(), parent.getDefaultDirectory(), selectionListener, (IFileBrowserIconProvider)Icons.FILE_ICON_LITEMATIC);
        this.title = StringUtils.translate((String)"litematica.gui.title.schematic_browser", (Object[])new Object[0]);
        this.infoWidth = 170;
        this.infoHeight = 290;
        this.parent = parent;
    }

    protected int getBrowserWidthForTotalWidth(int width) {
        return super.getBrowserWidthForTotalWidth(width) - this.infoWidth;
    }

    public void m_7379_() {
        super.m_7379_();
        this.clearPreviewImages();
    }

    protected File getRootDirectory() {
        return DataManager.getSchematicsBaseDirectory();
    }

    protected FileFilter getFileFilter() {
        return SCHEMATIC_FILTER;
    }

    protected void drawAdditionalContents(int mouseX, int mouseY, PoseStack matrixStack) {
        this.drawSelectedSchematicInfo((WidgetFileBrowserBase.DirectoryEntry)this.getLastSelectedEntry(), matrixStack);
    }

    protected void drawSelectedSchematicInfo(@Nullable WidgetFileBrowserBase.DirectoryEntry entry, PoseStack matrixStack) {
        int x = this.posX + this.totalWidth - this.infoWidth;
        int y = this.posY;
        int height = Math.min(this.infoHeight, this.parent.getMaxInfoHeight());
        RenderUtils.drawOutlinedBox((int)x, (int)y, (int)this.infoWidth, (int)height, (int)-1610612736, (int)-6710887);
        if (entry == null) {
            return;
        }
        SchematicMetadata meta = this.getSchematicMetadata(entry);
        if (meta != null) {
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int textColor = -1061109568;
            int valueColor = -1;
            String str = StringUtils.translate((String)"litematica.gui.label.schematic_info.name", (Object[])new Object[0]);
            this.drawString(matrixStack, str, x += 3, y += 3, textColor);
            this.drawString(matrixStack, meta.getName(), x + 4, y += 12, valueColor);
            str = StringUtils.translate((String)"litematica.gui.label.schematic_info.schematic_author", (Object[])new Object[]{meta.getAuthor()});
            this.drawString(matrixStack, str, x, y += 12, textColor);
            String strDate = DATE_FORMAT.format(new Date(meta.getTimeCreated()));
            str = StringUtils.translate((String)"litematica.gui.label.schematic_info.time_created", (Object[])new Object[]{strDate});
            this.drawString(matrixStack, str, x, y += 12, textColor);
            y += 12;
            if (meta.hasBeenModified()) {
                strDate = DATE_FORMAT.format(new Date(meta.getTimeModified()));
                str = StringUtils.translate((String)"litematica.gui.label.schematic_info.time_modified", (Object[])new Object[]{strDate});
                this.drawString(matrixStack, str, x, y, textColor);
                y += 12;
            }
            str = StringUtils.translate((String)"litematica.gui.label.schematic_info.region_count", (Object[])new Object[]{meta.getRegionCount()});
            this.drawString(matrixStack, str, x, y, textColor);
            y += 12;
            if (this.parent.f_96544_ >= 340) {
                str = StringUtils.translate((String)"litematica.gui.label.schematic_info.total_volume", (Object[])new Object[]{meta.getTotalVolume()});
                this.drawString(matrixStack, str, x, y, textColor);
                str = StringUtils.translate((String)"litematica.gui.label.schematic_info.total_blocks", (Object[])new Object[]{meta.getTotalBlocks()});
                this.drawString(matrixStack, str, x, y += 12, textColor);
                str = StringUtils.translate((String)"litematica.gui.label.schematic_info.enclosing_size", (Object[])new Object[0]);
                this.drawString(matrixStack, str, x, y += 12, textColor);
                areaSize = meta.getEnclosingSize();
                tmp = String.format("%d x %d x %d", areaSize.m_123341_(), areaSize.m_123342_(), areaSize.m_123343_());
                this.drawString(matrixStack, tmp, x + 4, y += 12, valueColor);
                y += 12;
            } else {
                str = StringUtils.translate((String)"litematica.gui.label.schematic_info.total_blocks_and_volume", (Object[])new Object[]{meta.getTotalBlocks(), meta.getTotalVolume()});
                this.drawString(matrixStack, str, x, y, textColor);
                areaSize = meta.getEnclosingSize();
                tmp = String.format("%d x %d x %d", areaSize.m_123341_(), areaSize.m_123342_(), areaSize.m_123343_());
                str = StringUtils.translate((String)"litematica.gui.label.schematic_info.enclosing_size_value", (Object[])new Object[]{tmp});
                this.drawString(matrixStack, str, x, y += 12, textColor);
                y += 12;
            }
            Pair<ResourceLocation, DynamicTexture> pair = this.cachedPreviewImages.get(entry.getFullPath());
            if (pair != null) {
                y += 14;
                int iconSize = ((DynamicTexture)pair.getRight()).m_117991_().m_84982_();
                boolean needsScaling = height < this.infoHeight;
                RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (needsScaling) {
                    iconSize = height - y + this.posY - 6;
                }
                RenderUtils.drawOutlinedBox((int)(x + 4), (int)y, (int)iconSize, (int)iconSize, (int)-1610612736, (int)-6710887);
                this.bindTexture((ResourceLocation)pair.getLeft());
                GuiComponent.m_93133_((PoseStack)matrixStack, (int)(x + 4), (int)y, (float)0.0f, (float)0.0f, (int)iconSize, (int)iconSize, (int)iconSize, (int)iconSize);
            }
        }
    }

    public void clearSchematicMetadataCache() {
        this.clearPreviewImages();
        this.cachedMetadata.clear();
        this.cachedPreviewImages.clear();
    }

    @Nullable
    protected SchematicMetadata getSchematicMetadata(WidgetFileBrowserBase.DirectoryEntry entry) {
        File file = new File(entry.getDirectory(), entry.getName());
        SchematicMetadata meta = this.cachedMetadata.get(file);
        if (meta == null && !this.cachedMetadata.containsKey(file)) {
            if (entry.getName().endsWith(".litematic") && (meta = LitematicaSchematic.readMetadataFromFile(entry.getDirectory(), entry.getName())) != null) {
                this.createPreviewImage(file, meta);
            }
            this.cachedMetadata.put(file, meta);
        }
        return meta;
    }

    private void clearPreviewImages() {
        for (Pair<ResourceLocation, DynamicTexture> pair : this.cachedPreviewImages.values()) {
            this.mc.m_91097_().m_118513_((ResourceLocation)pair.getLeft());
        }
    }

    private void createPreviewImage(File file, SchematicMetadata meta) {
        int size;
        int[] previewImageData = meta.getPreviewImagePixelData();
        if (previewImageData != null && previewImageData.length > 0 && (size = (int)Math.sqrt(previewImageData.length)) * size == previewImageData.length) {
            try {
                NativeImage image = new NativeImage(size, size, false);
                DynamicTexture tex = new DynamicTexture(image);
                ResourceLocation rl = new ResourceLocation("litematica", DigestUtils.sha1Hex((String)file.getAbsolutePath()));
                this.mc.m_91097_().m_118495_(rl, (AbstractTexture)tex);
                int i = 0;
                for (int y = 0; y < size; ++y) {
                    for (int x = 0; x < size; ++x) {
                        int val = previewImageData[i++];
                        val = val & 0xFF00FF00 | (val & 0xFF0000) >> 16 | (val & 0xFF) << 16;
                        image.m_84988_(x, y, val);
                    }
                }
                tex.m_117985_();
                this.cachedPreviewImages.put(file, (Pair<ResourceLocation, DynamicTexture>)Pair.of((Object)rl, (Object)tex));
            }
            catch (Exception e) {
                Litematica.logger.warn("Failed to create a preview image", (Throwable)e);
            }
        }
    }

    public static class FileFilterSchematics
    implements FileFilter {
        @Override
        public boolean accept(File pathName) {
            String name = pathName.getName();
            return name.endsWith(".litematic") || name.endsWith(".schem") || name.endsWith(".schematic") || name.endsWith(".nbt");
        }
    }
}

