/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.mojang.blaze3d.vertex.BufferBuilder;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.render.schematic.BufferBuilderCache;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherLitematica;
import fi.dy.masa.litematica.render.schematic.ChunkRenderTaskSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRendererSchematicVbo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.Logger;

public class ChunkRenderWorkerLitematica
implements Runnable {
    private static final Logger LOGGER = Litematica.logger;
    private final ChunkRenderDispatcherLitematica chunkRenderDispatcher;
    private final BufferBuilderCache bufferCache;
    private boolean shouldRun = true;

    public ChunkRenderWorkerLitematica(ChunkRenderDispatcherLitematica chunkRenderDispatcherIn) {
        this(chunkRenderDispatcherIn, null);
    }

    public ChunkRenderWorkerLitematica(ChunkRenderDispatcherLitematica chunkRenderDispatcherIn, @Nullable BufferBuilderCache bufferCache) {
        this.chunkRenderDispatcher = chunkRenderDispatcherIn;
        this.bufferCache = bufferCache;
    }

    @Override
    public void run() {
        while (this.shouldRun) {
            try {
                this.processTask(this.chunkRenderDispatcher.getNextChunkUpdate());
            }
            catch (InterruptedException e) {
                LOGGER.debug("Stopping chunk worker due to interrupt");
                return;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Batching chunks");
                Minecraft.m_91087_().m_199935_(() -> Minecraft.m_91087_().m_91354_(crashreport));
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTask(final ChunkRenderTaskSchematic task) throws InterruptedException {
        task.getLock().lock();
        try {
            if (task.getStatus() != ChunkRenderTaskSchematic.Status.PENDING) {
                if (!task.isFinished()) {
                    LOGGER.warn("Chunk render task was {} when I expected it to be pending; ignoring task", (Object)task.getStatus());
                }
                return;
            }
            task.setStatus(ChunkRenderTaskSchematic.Status.COMPILING);
        }
        finally {
            task.getLock().unlock();
        }
        Entity entity = Minecraft.m_91087_().m_91288_();
        if (entity == null) {
            task.finish();
        } else {
            task.setRegionRenderCacheBuilder(this.getRegionRenderCacheBuilder());
            ChunkRenderTaskSchematic.Type taskType = task.getType();
            if (taskType == ChunkRenderTaskSchematic.Type.REBUILD_CHUNK) {
                task.getRenderChunk().rebuildChunk(task);
            } else if (taskType == ChunkRenderTaskSchematic.Type.RESORT_TRANSPARENCY) {
                task.getRenderChunk().resortTransparency(task);
            }
            task.getLock().lock();
            try {
                if (task.getStatus() != ChunkRenderTaskSchematic.Status.COMPILING) {
                    if (!task.isFinished()) {
                        LOGGER.warn("Chunk render task was {} when I expected it to be compiling; aborting task", (Object)task.getStatus());
                    }
                    this.freeRenderBuilder(task);
                    return;
                }
                task.setStatus(ChunkRenderTaskSchematic.Status.UPLOADING);
            }
            finally {
                task.getLock().unlock();
            }
            final ChunkRenderDataSchematic chunkRenderData = task.getChunkRenderData();
            ArrayList futuresList = Lists.newArrayList();
            BufferBuilderCache buffers = task.getBufferCache();
            ChunkRendererSchematicVbo renderChunk = task.getRenderChunk();
            if (taskType == ChunkRenderTaskSchematic.Type.REBUILD_CHUNK) {
                for (RenderType layer : RenderType.m_110506_()) {
                    if (chunkRenderData.isBlockLayerEmpty(layer)) continue;
                    BufferBuilder buffer = buffers.getBlockBufferByLayer(layer);
                    futuresList.add(this.chunkRenderDispatcher.uploadChunkBlocks(layer, buffer, renderChunk, chunkRenderData, task.getDistanceSq()));
                }
                for (ChunkRendererSchematicVbo.OverlayRenderType type : ChunkRendererSchematicVbo.OverlayRenderType.values()) {
                    if (chunkRenderData.isOverlayTypeEmpty(type)) continue;
                    BufferBuilder buffer = buffers.getOverlayBuffer(type);
                    futuresList.add(this.chunkRenderDispatcher.uploadChunkOverlay(type, buffer, renderChunk, chunkRenderData, task.getDistanceSq()));
                }
            } else if (taskType == ChunkRenderTaskSchematic.Type.RESORT_TRANSPARENCY) {
                BufferBuilder buffer;
                RenderType layer = RenderType.m_110466_();
                if (!chunkRenderData.isBlockLayerEmpty(layer)) {
                    buffer = buffers.getBlockBufferByLayer(layer);
                    futuresList.add(this.chunkRenderDispatcher.uploadChunkBlocks(RenderType.m_110466_(), buffer, renderChunk, chunkRenderData, task.getDistanceSq()));
                }
                if (!chunkRenderData.isOverlayTypeEmpty(ChunkRendererSchematicVbo.OverlayRenderType.QUAD)) {
                    buffer = buffers.getOverlayBuffer(ChunkRendererSchematicVbo.OverlayRenderType.QUAD);
                    futuresList.add(this.chunkRenderDispatcher.uploadChunkOverlay(ChunkRendererSchematicVbo.OverlayRenderType.QUAD, buffer, renderChunk, chunkRenderData, task.getDistanceSq()));
                }
            }
            final ListenableFuture listenablefuture = Futures.allAsList((Iterable)futuresList);
            task.addFinishRunnable(new Runnable(){

                @Override
                public void run() {
                    listenablefuture.cancel(false);
                }
            });
            Futures.addCallback((ListenableFuture)listenablefuture, (FutureCallback)new FutureCallback<List<Object>>(){

                public void onSuccess(@Nullable List<Object> list) {
                    block6: {
                        ChunkRenderWorkerLitematica.this.freeRenderBuilder(task);
                        task.getLock().lock();
                        try {
                            if (task.getStatus() == ChunkRenderTaskSchematic.Status.UPLOADING) {
                                task.setStatus(ChunkRenderTaskSchematic.Status.DONE);
                                break block6;
                            }
                            if (!task.isFinished()) {
                                LOGGER.warn("Chunk render task was {} when I expected it to be uploading; aborting task", (Object)task.getStatus());
                            }
                        }
                        finally {
                            task.getLock().unlock();
                        }
                        return;
                    }
                    task.getRenderChunk().setChunkRenderData(chunkRenderData);
                }

                public void onFailure(Throwable throwable) {
                    ChunkRenderWorkerLitematica.this.freeRenderBuilder(task);
                    if (!(throwable instanceof CancellationException) && !(throwable instanceof InterruptedException)) {
                        Minecraft.m_91087_().m_199935_(() -> CrashReport.m_127521_((Throwable)throwable, (String)"Rendering Litematica chunk"));
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }

    private BufferBuilderCache getRegionRenderCacheBuilder() throws InterruptedException {
        return this.bufferCache != null ? this.bufferCache : this.chunkRenderDispatcher.allocateRenderBuilder();
    }

    private void freeRenderBuilder(ChunkRenderTaskSchematic generator) {
        BufferBuilderCache builderCache = generator.getBufferCache();
        builderCache.clear();
        if (this.bufferCache == null) {
            this.chunkRenderDispatcher.freeRenderBuilder(builderCache);
        }
    }

    public void notifyToStop() {
        this.shouldRun = false;
    }
}

