/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.interfaces.IMessageConsumer;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.render.MessageRenderer;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class InfoUtils {
    private static final MessageRenderer IN_GAME_MESSAGES = new MessageRenderer(-1610612736, 0).setBackgroundStyle(true, false).setCentered(true, false).setExpandUp(true);
    public static final IStringConsumer INFO_MESSAGE_CONSUMER = new InfoMessageConsumer();

    public static void showGuiMessage(Message.MessageType type, String translationKey, Object ... args) {
        InfoUtils.showGuiMessage(type, 5000, translationKey, args);
    }

    public static void showGuiMessage(Message.MessageType type, int lifeTime, String translationKey, Object ... args) {
        if (GuiUtils.getCurrentScreen() instanceof IMessageConsumer) {
            ((IMessageConsumer)GuiUtils.getCurrentScreen()).addMessage(type, lifeTime, translationKey, args);
        }
    }

    public static void showGuiOrActionBarMessage(Message.MessageType type, String translationKey, Object ... args) {
        InfoUtils.showGuiOrActionBarMessage(type, 5000, translationKey, args);
    }

    public static void showGuiOrActionBarMessage(Message.MessageType type, int lifeTime, String translationKey, Object ... args) {
        if (GuiUtils.getCurrentScreen() instanceof IMessageConsumer) {
            ((IMessageConsumer)GuiUtils.getCurrentScreen()).addMessage(type, lifeTime, translationKey, args);
        } else {
            String msg = type.getFormatting() + StringUtils.translate(translationKey, args) + GuiBase.TXT_RST;
            InfoUtils.printActionbarMessage(msg, new Object[0]);
        }
    }

    public static void showGuiOrInGameMessage(Message.MessageType type, String translationKey, Object ... args) {
        InfoUtils.showGuiOrInGameMessage(type, 5000, translationKey, args);
    }

    public static void showGuiOrInGameMessage(Message.MessageType type, int lifeTime, String translationKey, Object ... args) {
        if (GuiUtils.getCurrentScreen() instanceof IMessageConsumer) {
            ((IMessageConsumer)GuiUtils.getCurrentScreen()).addMessage(type, lifeTime, translationKey, args);
        } else {
            InfoUtils.showInGameMessage(type, lifeTime, translationKey, args);
        }
    }

    public static void showGuiAndInGameMessage(Message.MessageType type, String translationKey, Object ... args) {
        InfoUtils.showGuiAndInGameMessage(type, 5000, translationKey, args);
    }

    public static void showGuiAndInGameMessage(Message.MessageType type, int lifeTime, String translationKey, Object ... args) {
        InfoUtils.showGuiMessage(type, lifeTime, translationKey, args);
        InfoUtils.showInGameMessage(type, lifeTime, translationKey, args);
    }

    public static void printActionbarMessage(String key, Object ... args) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            mc.f_91065_.m_93051_(ChatType.GAME_INFO, (Component)new TranslatableComponent(key, args), Util.f_137441_);
        }
    }

    public static void showInGameMessage(Message.MessageType type, String translationKey, Object ... args) {
        InfoUtils.showInGameMessage(type, 5000, translationKey, args);
    }

    public static void showInGameMessage(Message.MessageType type, int lifeTime, String translationKey, Object ... args) {
        IN_GAME_MESSAGES.addMessage(type, lifeTime, translationKey, args);
    }

    public static void printBooleanConfigToggleMessage(String prettyName, boolean newValue) {
        String pre = newValue ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
        String status = StringUtils.translate("malilib.message.value." + (newValue ? "on" : "off"), new Object[0]);
        String message = StringUtils.translate("malilib.message.toggled", prettyName, pre + status + GuiBase.TXT_RST);
        InfoUtils.printActionbarMessage(message, new Object[0]);
    }

    public static void renderInGameMessages(PoseStack matrixStack) {
        int x = GuiUtils.getScaledWindowWidth() / 2;
        int y = GuiUtils.getScaledWindowHeight() - 76;
        IN_GAME_MESSAGES.drawMessages(x, y, matrixStack);
    }

    public static class InfoMessageConsumer
    implements IStringConsumer {
        @Override
        public void setString(String string) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                mc.f_91065_.m_93051_(ChatType.GAME_INFO, (Component)new TranslatableComponent(string), Util.f_137441_);
            }
        }
    }
}

