/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.malilib.config.IConfigInteger;
import fi.dy.masa.malilib.gui.GuiDialogBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.GuiTextFieldInteger;
import fi.dy.masa.malilib.gui.interfaces.IDialogHandler;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.render.shader.ShaderProgram;
import fi.dy.masa.malilib.util.StringUtils;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;

public class GuiColorEditorHSV
extends GuiDialogBase {
    protected static final ShaderProgram SHADER_HUE = new ShaderProgram("malilib", null, "shaders/sv_selector.frag");
    protected final IConfigInteger config;
    @Nullable
    protected final IDialogHandler dialogHandler;
    @Nullable
    protected Element clickedElement;
    @Nullable
    protected Element currentTextInputElement;
    protected GuiTextFieldGeneric textFieldFullColor;
    protected GuiTextFieldGeneric textFieldH;
    protected GuiTextFieldGeneric textFieldS;
    protected GuiTextFieldGeneric textFieldV;
    protected GuiTextFieldGeneric textFieldR;
    protected GuiTextFieldGeneric textFieldG;
    protected GuiTextFieldGeneric textFieldB;
    protected GuiTextFieldGeneric textFieldA;
    protected boolean mouseDown;
    protected int color;
    protected int xHS;
    protected int yHS;
    protected int xHFullSV;
    protected int xH;
    protected int yH;
    protected int sizeHS;
    protected int widthHFullSV;
    protected int widthSlider;
    protected int heightSlider;
    protected int gapSlider;
    protected float relH;
    protected float relS;
    protected float relV;
    protected float relR;
    protected float relG;
    protected float relB;
    protected float relA;

    public GuiColorEditorHSV(IConfigInteger config, @Nullable IDialogHandler dialogHandler, Screen parent) {
        this.config = config;
        this.dialogHandler = dialogHandler;
        if (this.dialogHandler == null) {
            this.setParent(parent);
        }
        this.title = StringUtils.translate("malilib.gui.title.color_editor", new Object[0]);
        this.setWidthAndHeight(300, 180);
        this.centerOnScreen();
        this.m_6575_(this.mc, this.dialogWidth, this.dialogHeight);
    }

    @Override
    public void setPosition(int left, int top) {
        super.setPosition(left, top);
        this.xHS = this.dialogLeft + 6;
        this.yHS = this.dialogTop + 24;
        this.xH = this.dialogLeft + 160;
        this.yH = this.dialogTop + 24;
        this.xHFullSV = this.xHS + 110;
        this.sizeHS = 102;
        this.widthHFullSV = 16;
        this.widthSlider = 90;
        this.heightSlider = 12;
        this.gapSlider = 6;
    }

    @Override
    public void initGui() {
        this.clearElements();
        int xLabel = this.dialogLeft + 148;
        int xTextField = xLabel + 110;
        int y = this.dialogTop + 24;
        y += this.createComponentElements(xTextField, y, xLabel, Element.H);
        y += this.createComponentElements(xTextField, y, xLabel, Element.S);
        y += this.createComponentElements(xTextField, y, xLabel, Element.V);
        y += this.createComponentElements(xTextField, y, xLabel, Element.R);
        y += this.createComponentElements(xTextField, y, xLabel, Element.G);
        y += this.createComponentElements(xTextField, y, xLabel, Element.B);
        y += this.createComponentElements(xTextField, y, xLabel, Element.A);
        this.addLabel(this.xH - 26, y + 3, 12, 12, 0xFFFFFF, "HEX:");
        this.textFieldFullColor = new GuiTextFieldGeneric(this.xH, y + 1, 68, 14, this.textRenderer);
        this.textFieldFullColor.m_94199_(12);
        this.addTextField(this.textFieldFullColor, new TextFieldListener(null, this));
        this.setColor(this.config.getIntegerValue());
    }

    protected int createComponentElements(int x, int y, int xLabel, Element element) {
        TextFieldListener listener = new TextFieldListener(element, this);
        GuiTextFieldInteger textField = new GuiTextFieldInteger(x, y, 32, 12, this.textRenderer);
        switch (element) {
            case H: {
                this.textFieldH = textField;
                break;
            }
            case S: {
                this.textFieldS = textField;
                break;
            }
            case V: {
                this.textFieldV = textField;
                break;
            }
            case R: {
                this.textFieldR = textField;
                break;
            }
            case G: {
                this.textFieldG = textField;
                break;
            }
            case B: {
                this.textFieldB = textField;
                break;
            }
            case A: {
                this.textFieldA = textField;
                break;
            }
        }
        this.addLabel(xLabel, y, 12, 12, 0xFFFFFF, element.name() + ":");
        this.addTextField(textField, listener);
        return this.heightSlider + this.gapSlider;
    }

    public void m_7861_() {
        this.config.setIntegerValue(this.color);
        super.m_7861_();
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.getParent() != null) {
            this.getParent().m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.mouseDown && this.clickedElement != null) {
            this.updateColorFromMouseInput(this.clickedElement, mouseX, mouseY);
        }
        this.drawColorSelector();
    }

    @Override
    protected void drawScreenBackground(int mouseX, int mouseY) {
        RenderUtils.drawOutlinedBox(this.dialogLeft, this.dialogTop, this.dialogWidth, this.dialogHeight, -16777216, -6710887);
    }

    @Override
    protected void drawTitle(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.drawStringWithShadow(matrixStack, this.title, this.dialogLeft + 10, this.dialogTop + 6, -1);
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.onKeyTyped(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.dialogHandler != null) {
            this.dialogHandler.closeDialog();
            return true;
        }
        return super.onKeyTyped(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.clickedElement = this.getHoveredElement(mouseX, mouseY);
        if (this.clickedElement != null) {
            this.mouseDown = true;
            this.updateColorFromMouseInput(this.clickedElement, mouseX, mouseY);
        }
        return super.onMouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean onMouseReleased(int mouseX, int mouseY, int mouseButton) {
        this.mouseDown = false;
        this.clickedElement = null;
        return super.onMouseReleased(mouseX, mouseY, mouseButton);
    }

    protected float[] getCurrentColorHSV() {
        return this.getColorHSV(this.color);
    }

    protected float[] getColorHSV(int color) {
        int r = color >>> 16 & 0xFF;
        int g = color >>> 8 & 0xFF;
        int b = color & 0xFF;
        float[] hsv = new float[3];
        Color.RGBtoHSB(r, g, b, hsv);
        return hsv;
    }

    protected void setColor(int color) {
        this.color = color;
        this.relA = (float)((color & 0xFF000000) >>> 24) / 255.0f;
        this.setHSVFromRGB(color);
        this.setRGBFromHSV();
        this.currentTextInputElement = null;
    }

    protected void setHSVFromRGB() {
        this.setHSVFromRGB(this.relR, this.relG, this.relB);
    }

    protected void setHSVFromRGB(float r, float g, float b) {
        float[] hsv = new float[3];
        int ri = (int)(r * 255.0f);
        int gi = (int)(g * 255.0f);
        int bi = (int)(b * 255.0f);
        int ai = (int)(this.relA * 255.0f);
        Color.RGBtoHSB(ri, gi, bi, hsv);
        this.relH = hsv[0];
        this.relS = hsv[1];
        this.relV = hsv[2];
        this.color = ai << 24 | ri << 16 | gi << 8 | bi;
        this.updateTextFieldsHSV(this.relH, this.relS, this.relV);
    }

    protected void setHSVFromRGB(int rgb) {
        float[] hsv = this.getColorHSV(rgb);
        this.relH = hsv[0];
        this.relS = hsv[1];
        this.relV = hsv[2];
        this.updateTextFieldsHSV(this.relH, this.relS, this.relV);
    }

    protected void setRGBFromHSV() {
        this.setRGBFromHSV(this.relH, this.relS, this.relV);
    }

    protected void setRGBFromHSV(float h, float s, float v) {
        int rgb = Color.HSBtoRGB(h, s, v);
        int ai = (int)(this.relA * 255.0f);
        this.color = ai << 24 | rgb & 0xFFFFFF;
        this.relR = (float)(rgb >>> 16 & 0xFF) / 255.0f;
        this.relG = (float)(rgb >>> 8 & 0xFF) / 255.0f;
        this.relB = (float)(rgb & 0xFF) / 255.0f;
        this.updateTextFieldsRGB();
    }

    protected void updateColorFromMouseInput(Element element, int mouseX, int mouseY) {
        if (element == Element.SV) {
            mouseX = Mth.m_14045_((int)mouseX, (int)this.xHS, (int)(this.xHS + this.sizeHS));
            mouseY = Mth.m_14045_((int)mouseY, (int)this.yHS, (int)(this.yHS + this.sizeHS));
            int relX = mouseX - this.xHS;
            int relY = mouseY - this.yHS;
            float saturation = 1.0f - (float)relY / (float)this.sizeHS;
            float value = (float)relX / (float)this.sizeHS;
            this.relS = saturation;
            this.relV = value;
            this.setRGBFromHSV();
            this.updateTextField(Element.S);
            this.updateTextField(Element.V);
        } else if (element == Element.H_FULL_SV) {
            float hue;
            mouseY = Mth.m_14045_((int)mouseY, (int)this.yHS, (int)(this.yHS + this.sizeHS));
            int relY = mouseY - this.yHS;
            this.relH = hue = 1.0f - (float)relY / (float)this.sizeHS;
            this.setRGBFromHSV();
            this.updateTextField(Element.H);
        } else {
            mouseX = Mth.m_14045_((int)mouseX, (int)this.xH, (int)(this.xH + this.widthSlider));
            int relX = mouseX - this.xH;
            float relVal = (float)relX / (float)this.widthSlider;
            switch (element) {
                case H: {
                    this.relH = relVal;
                    this.setRGBFromHSV();
                    this.updateTextField(Element.H);
                    break;
                }
                case S: {
                    this.relS = relVal;
                    this.setRGBFromHSV();
                    this.updateTextField(Element.S);
                    break;
                }
                case V: {
                    this.relV = relVal;
                    this.setRGBFromHSV();
                    this.updateTextField(Element.V);
                    break;
                }
                case R: {
                    this.relR = relVal;
                    this.setHSVFromRGB();
                    this.updateTextField(Element.R);
                    break;
                }
                case G: {
                    this.relG = relVal;
                    this.setHSVFromRGB();
                    this.updateTextField(Element.G);
                    break;
                }
                case B: {
                    this.relB = relVal;
                    this.setHSVFromRGB();
                    this.updateTextField(Element.B);
                    break;
                }
                case A: {
                    this.relA = relVal;
                    this.setHSVFromRGB();
                    this.updateTextField(Element.A);
                    break;
                }
            }
        }
    }

    protected void updateTextFieldsHSV(float h, float s, float v) {
        this.updateTextField(Element.HEX);
        this.updateTextField(Element.H);
        this.updateTextField(Element.S);
        this.updateTextField(Element.V);
    }

    protected void updateTextFieldsRGB() {
        this.updateTextField(Element.HEX);
        this.updateTextField(Element.R);
        this.updateTextField(Element.G);
        this.updateTextField(Element.B);
        this.updateTextField(Element.A);
    }

    protected void updateTextField(Element type) {
        if (this.currentTextInputElement != type) {
            switch (type) {
                case HEX: {
                    this.textFieldFullColor.m_94144_(String.format("#%08X", this.color));
                    break;
                }
                case H: {
                    this.textFieldH.m_94144_(String.valueOf((int)(this.relH * 360.0f)));
                    break;
                }
                case S: {
                    this.textFieldS.m_94144_(String.valueOf((int)(this.relS * 100.0f)));
                    break;
                }
                case V: {
                    this.textFieldV.m_94144_(String.valueOf((int)(this.relV * 100.0f)));
                    break;
                }
                case R: {
                    this.textFieldR.m_94144_(String.valueOf((int)(this.relR * 255.0f)));
                    break;
                }
                case G: {
                    this.textFieldG.m_94144_(String.valueOf((int)(this.relG * 255.0f)));
                    break;
                }
                case B: {
                    this.textFieldB.m_94144_(String.valueOf((int)(this.relB * 255.0f)));
                    break;
                }
                case A: {
                    this.textFieldA.m_94144_(String.valueOf((int)(this.relA * 255.0f)));
                    break;
                }
            }
        }
    }

    protected void drawColorSelector() {
        int x = this.xH - 1;
        int y = this.yH - 1;
        int w = this.widthSlider + 2;
        int h = this.heightSlider + 2;
        int z = 0;
        int yd = this.heightSlider + this.gapSlider;
        int cx = this.xHS;
        int cy = this.yHS + this.sizeHS + 8;
        int cw = this.sizeHS;
        int ch = 16;
        RenderUtils.drawOutline(x, y, w, h, -1056964609, z);
        RenderUtils.drawOutline(x, y += yd, w, h, -1056964609, z);
        RenderUtils.drawOutline(x, y += yd, w, h, -1056964609, z);
        RenderUtils.drawOutline(x, y += yd, w, h, -1056964609, z);
        RenderUtils.drawOutline(x, y += yd, w, h, -1056964609, z);
        RenderUtils.drawOutline(x, y += yd, w, h, -1056964609, z);
        RenderUtils.drawOutline(x, y += yd, w, h, -1056964609, z);
        x = this.xHS;
        y = this.yHS;
        w = this.sizeHS;
        h = this.sizeHS;
        RenderUtils.drawOutline(x - 1, y - 1, w + 2, h + 2, -1056964609, z);
        RenderUtils.drawOutline(cx - 1, cy - 1, cw + 2, ch + 2, -1056964609, z);
        RenderUtils.drawOutline(this.xHFullSV, y - 1, this.widthHFullSV, this.sizeHS + 2, -1056964609, z);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderUtils.setupBlend();
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_((double)x, (double)y, (double)z).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_5483_((double)x, (double)(y + h), (double)z).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_5483_((double)(x + w), (double)(y + h), (double)z).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)(x + w), (double)y, (double)z).m_7421_(1.0f, 1.0f).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        int r = (int)(this.relR * 255.0f);
        int g = (int)(this.relG * 255.0f);
        int b = (int)(this.relB * 255.0f);
        int a = 255;
        int c = 255;
        buffer.m_5483_((double)cx, (double)cy, (double)z).m_6122_(r, g, b, a).m_5752_();
        buffer.m_5483_((double)cx, (double)(cy + ch), (double)z).m_6122_(r, g, b, a).m_5752_();
        buffer.m_5483_((double)(cx + cw), (double)(cy + ch), (double)z).m_6122_(r, g, b, a).m_5752_();
        buffer.m_5483_((double)(cx + cw), (double)cy, (double)z).m_6122_(r, g, b, a).m_5752_();
        int yt = y + (int)((1.0f - this.relS) * (float)h);
        buffer.m_5483_((double)(x - 1), (double)yt, (double)z).m_6122_(c, c, c, a).m_5752_();
        buffer.m_5483_((double)(x - 1), (double)(yt + 1), (double)z).m_6122_(c, c, c, a).m_5752_();
        buffer.m_5483_((double)(x + w + 1), (double)(yt + 1), (double)z).m_6122_(c, c, c, a).m_5752_();
        buffer.m_5483_((double)(x + w + 1), (double)yt, (double)z).m_6122_(c, c, c, a).m_5752_();
        int xt = x + (int)(this.relV * (float)w);
        buffer.m_5483_((double)xt, (double)(y - 1), (double)z).m_6122_(c, c, c, a).m_5752_();
        buffer.m_5483_((double)xt, (double)(y + h + 1), (double)z).m_6122_(c, c, c, a).m_5752_();
        buffer.m_5483_((double)(xt + 1), (double)(y + h + 1), (double)z).m_6122_(c, c, c, a).m_5752_();
        buffer.m_5483_((double)(xt + 1), (double)(y - 1), (double)z).m_6122_(c, c, c, a).m_5752_();
        x = this.xH;
        w = this.widthSlider;
        h = this.heightSlider;
        yd = this.heightSlider + this.gapSlider;
        GuiColorEditorHSV.renderHueBarVertical(this.xHFullSV + 1, this.yHS, z, this.widthHFullSV - 2, this.sizeHS, 1.0f, 1.0f, buffer);
        GuiColorEditorHSV.renderBarMarkerVerticalBar(this.xHFullSV, this.yHS, z, this.widthHFullSV, this.sizeHS, this.relH, buffer);
        GuiColorEditorHSV.renderHueBarHorizontal(x, y, z, w, h, this.relS, this.relV, buffer);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(x, y, z, w, h, this.relH, buffer);
        int color1 = Color.HSBtoRGB(this.relH, 0.0f, this.relV);
        int color2 = Color.HSBtoRGB(this.relH, 1.0f, this.relV);
        GuiColorEditorHSV.renderGradientColorBar(x, y += yd, z, w, h, color1, color2, buffer);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(x, y, z, w, h, this.relS, buffer);
        color1 = Color.HSBtoRGB(this.relH, this.relS, 0.0f);
        color2 = Color.HSBtoRGB(this.relH, this.relS, 1.0f);
        GuiColorEditorHSV.renderGradientColorBar(x, y += yd, z, w, h, color1, color2, buffer);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(x, y, z, w, h, this.relV, buffer);
        color1 = this.color & 0xFF00FFFF | 0xFF000000;
        color2 = this.color | 0xFFFF0000;
        GuiColorEditorHSV.renderGradientColorBar(x, y += yd, z, w, h, color1, color2, buffer);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(x, y, z, w, h, (float)r / 255.0f, buffer);
        color1 = this.color & 0xFFFF00FF | 0xFF000000;
        color2 = this.color | 0xFF00FF00;
        GuiColorEditorHSV.renderGradientColorBar(x, y += yd, z, w, h, color1, color2, buffer);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(x, y, z, w, h, (float)g / 255.0f, buffer);
        color1 = this.color & 0xFFFFFF00 | 0xFF000000;
        color2 = this.color | 0xFF0000FF;
        GuiColorEditorHSV.renderGradientColorBar(x, y += yd, z, w, h, color1, color2, buffer);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(x, y, z, w, h, (float)b / 255.0f, buffer);
        a = (int)(this.relA * 255.0f);
        color1 = this.color & 0xFFFFFF;
        color2 = this.color | 0xFF000000;
        GuiColorEditorHSV.renderGradientColorBar(x, y += yd, z, w, h, color1, color2, buffer);
        GuiColorEditorHSV.renderBarMarkerHorizontalBar(x, y, z, w, h, (float)a / 255.0f, buffer);
        y += yd;
        tessellator.m_85914_();
        RenderSystem.m_69461_();
    }

    public static void renderGradientColorBar(int x, int y, float z, int width, int height, int colorStart, int colorEnd, BufferBuilder buffer) {
        int a1 = colorStart >>> 24 & 0xFF;
        int r1 = colorStart >>> 16 & 0xFF;
        int g1 = colorStart >>> 8 & 0xFF;
        int b1 = colorStart & 0xFF;
        int a2 = colorEnd >>> 24 & 0xFF;
        int r2 = colorEnd >>> 16 & 0xFF;
        int g2 = colorEnd >>> 8 & 0xFF;
        int b2 = colorEnd & 0xFF;
        buffer.m_5483_((double)x, (double)y, (double)z).m_6122_(r1, g1, b1, a1).m_5752_();
        buffer.m_5483_((double)x, (double)(y + height), (double)z).m_6122_(r1, g1, b1, a1).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), (double)z).m_6122_(r2, g2, b2, a2).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, (double)z).m_6122_(r2, g2, b2, a2).m_5752_();
    }

    public static void renderHueBarHorizontal(int x, int y, float z, int width, int height, float saturation, float value, BufferBuilder buffer) {
        GuiColorEditorHSV.renderHueBar(x, y, z, 0, height, width / 6, 0, saturation, value, buffer);
    }

    public static void renderHueBarVertical(int x, int y, float z, int width, int height, float saturation, float value, BufferBuilder buffer) {
        y = y + height - height / 6;
        GuiColorEditorHSV.renderHueBar(x, y, z, width, 0, 0, height / 6, saturation, value, buffer);
    }

    public static void renderHueBar(int x, int y, float z, int width, int height, int segmentWidth, int segmentHeight, float saturation, float value, BufferBuilder buffer) {
        int color1 = Color.HSBtoRGB(0.0f, saturation, value);
        int color2 = Color.HSBtoRGB(0.16666667f, saturation, value);
        GuiColorEditorHSV.renderHueBarSegment(x, y, z, width, height, segmentWidth, segmentHeight, color1, color2, buffer);
        color1 = Color.HSBtoRGB(0.16666667f, saturation, value);
        color2 = Color.HSBtoRGB(0.33333334f, saturation, value);
        GuiColorEditorHSV.renderHueBarSegment(x += segmentWidth, y -= segmentHeight, z, width, height, segmentWidth, segmentHeight, color1, color2, buffer);
        color1 = Color.HSBtoRGB(0.33333334f, saturation, value);
        color2 = Color.HSBtoRGB(0.5f, saturation, value);
        GuiColorEditorHSV.renderHueBarSegment(x += segmentWidth, y -= segmentHeight, z, width, height, segmentWidth, segmentHeight, color1, color2, buffer);
        color1 = Color.HSBtoRGB(0.5f, saturation, value);
        color2 = Color.HSBtoRGB(0.6666667f, saturation, value);
        GuiColorEditorHSV.renderHueBarSegment(x += segmentWidth, y -= segmentHeight, z, width, height, segmentWidth, segmentHeight, color1, color2, buffer);
        color1 = Color.HSBtoRGB(0.6666667f, saturation, value);
        color2 = Color.HSBtoRGB(0.8333333f, saturation, value);
        GuiColorEditorHSV.renderHueBarSegment(x += segmentWidth, y -= segmentHeight, z, width, height, segmentWidth, segmentHeight, color1, color2, buffer);
        color1 = Color.HSBtoRGB(0.8333333f, saturation, value);
        color2 = Color.HSBtoRGB(1.0f, saturation, value);
        GuiColorEditorHSV.renderHueBarSegment(x += segmentWidth, y -= segmentHeight, z, width, height, segmentWidth, segmentHeight, color1, color2, buffer);
    }

    public static void renderHueBarSegment(int x, int y, float z, int width, int height, int segmentWidth, int segmentHeight, int color1, int color2, BufferBuilder buffer) {
        int r1 = color1 >>> 16 & 0xFF;
        int g1 = color1 >>> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >>> 16 & 0xFF;
        int g2 = color2 >>> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = 255;
        buffer.m_5483_((double)x, (double)(y + segmentHeight), (double)z).m_6122_(r1, g1, b1, a).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height + segmentHeight), (double)z).m_6122_(r1, g1, b1, a).m_5752_();
        buffer.m_5483_((double)(x + width + segmentWidth), (double)(y + height), (double)z).m_6122_(r2, g2, b2, a).m_5752_();
        buffer.m_5483_((double)(x + segmentWidth), (double)y, (double)z).m_6122_(r2, g2, b2, a).m_5752_();
    }

    public static void renderHSSelector(int xStart, int yStart, float z, int width, int height, float hue, BufferBuilder buffer) {
        int x2 = xStart + width;
        for (int y = yStart; y <= yStart + height; ++y) {
            float saturation = 1.0f - (float)(y - yStart) / (float)height;
            int color1 = Color.HSBtoRGB(hue, saturation, 0.0f);
            int color2 = Color.HSBtoRGB(hue, saturation, 1.0f);
            int r1 = color1 >>> 16 & 0xFF;
            int g1 = color1 >>> 8 & 0xFF;
            int b1 = color1 & 0xFF;
            int r2 = color2 >>> 16 & 0xFF;
            int g2 = color2 >>> 8 & 0xFF;
            int b2 = color2 & 0xFF;
            int a = 255;
            buffer.m_5483_((double)xStart, (double)y, (double)z).m_6122_(r1, g1, b1, a).m_5752_();
            buffer.m_5483_((double)x2, (double)y, (double)z).m_6122_(r2, g2, b2, a).m_5752_();
        }
    }

    public static void renderBarMarkerHorizontalBar(int x, int y, float z, int barWidth, int barHeight, float value, BufferBuilder buffer) {
        int s = 2;
        int c = 255;
        buffer.m_5483_((double)((x += (int)((float)barWidth * value)) - s), (double)(y - s), (double)z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_((double)x, (double)(y + s), (double)z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_((double)x, (double)(y + s), (double)z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_((double)(x + s), (double)(y - s), (double)z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_((double)(x - s), (double)((y += barHeight) + s), (double)z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_((double)(x + s), (double)(y + s), (double)z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_((double)x, (double)(y - s), (double)z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_((double)x, (double)(y - s), (double)z).m_6122_(c, c, c, c).m_5752_();
    }

    public static void renderBarMarkerVerticalBar(int x, int y, float z, int barWidth, int barHeight, float value, BufferBuilder buffer) {
        int s = 2;
        int c = 255;
        buffer.m_5483_((double)(x - s), (double)((y += (int)((float)barHeight * (1.0f - value))) - s), (double)z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_((double)(x - s), (double)(y + s), (double)z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_((double)(x + s), (double)y, (double)z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_((double)(x + s), (double)y, (double)z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_((double)((x += barWidth) + s), (double)(y - s), (double)z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_((double)(x - s), (double)y, (double)z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_((double)(x - s), (double)y, (double)z).m_6122_(c, c, c, c).m_5752_();
        buffer.m_5483_((double)(x + s), (double)(y + s), (double)z).m_6122_(c, c, c, c).m_5752_();
    }

    @Nullable
    protected Element getHoveredElement(int mouseX, int mouseY) {
        if (mouseX >= this.xHS && mouseX <= this.xHS + this.sizeHS && mouseY >= this.yHS && mouseY <= this.yHS + this.sizeHS) {
            return Element.SV;
        }
        if (mouseX >= this.xHFullSV && mouseX <= this.xHFullSV + this.widthHFullSV && mouseY >= this.yHS && mouseY <= this.yHS + this.sizeHS) {
            return Element.H_FULL_SV;
        }
        if (mouseX >= this.xH && mouseX <= this.xH + this.widthSlider) {
            int relY;
            int index;
            int h = this.heightSlider + this.gapSlider;
            if (mouseY >= this.yH && mouseY <= this.yH + h * 7 - this.gapSlider && (index = (relY = mouseY - this.yH) / h) < 7 && relY % h < this.heightSlider) {
                return Element.values()[index];
            }
        }
        return null;
    }

    protected static enum Element {
        H,
        S,
        V,
        R,
        G,
        B,
        A,
        SV,
        H_FULL_SV,
        HEX;

    }

    protected static class TextFieldListener
    implements ITextFieldListener<GuiTextFieldGeneric> {
        protected final GuiColorEditorHSV gui;
        @Nullable
        protected final Element type;

        protected TextFieldListener(@Nullable Element type, GuiColorEditorHSV gui) {
            this.gui = gui;
            this.type = type;
        }

        @Override
        public boolean onTextChange(GuiTextFieldGeneric textField) {
            int colorOld = this.gui.color;
            if (this.type == null) {
                this.gui.currentTextInputElement = Element.HEX;
                this.gui.setColor(StringUtils.getColor(textField.m_94155_(), colorOld));
            } else {
                try {
                    int val = Integer.parseInt(textField.m_94155_());
                    float[] hsv = this.gui.getCurrentColorHSV();
                    int colorNew = colorOld;
                    switch (this.type) {
                        case H: {
                            val = Mth.m_14045_((int)val, (int)0, (int)360);
                            float h = (float)val / 360.0f;
                            colorNew = Color.HSBtoRGB(h, hsv[1], hsv[2]);
                            break;
                        }
                        case S: {
                            val = Mth.m_14045_((int)val, (int)0, (int)100);
                            float s = (float)val / 100.0f;
                            colorNew = Color.HSBtoRGB(hsv[0], s, hsv[2]);
                            break;
                        }
                        case V: {
                            val = Mth.m_14045_((int)val, (int)0, (int)100);
                            float v = (float)val / 100.0f;
                            colorNew = Color.HSBtoRGB(hsv[0], hsv[1], v);
                            break;
                        }
                        case R: {
                            val = Mth.m_14045_((int)val, (int)0, (int)255);
                            colorNew = colorOld & 0xFFFF | val << 16;
                            break;
                        }
                        case G: {
                            val = Mth.m_14045_((int)val, (int)0, (int)255);
                            colorNew = colorOld & 0xFF00FF | val << 8;
                            break;
                        }
                        case B: {
                            val = Mth.m_14045_((int)val, (int)0, (int)255);
                            colorNew = colorOld & 0xFFFF00 | val;
                            break;
                        }
                        case A: {
                            val = Mth.m_14045_((int)val, (int)0, (int)255);
                            colorNew = colorOld & 0xFFFFFF | val << 24;
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    if (colorNew != colorOld) {
                        this.gui.currentTextInputElement = this.type;
                        this.gui.setColor(colorNew);
                    }
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

