/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.util.ItemType;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public class InventoryUtils {
    private static final NonNullList<ItemStack> EMPTY_LIST = NonNullList.m_122779_();

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return ItemStack.m_41758_((ItemStack)stack1, (ItemStack)stack2) && ItemStack.m_41658_((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean areStacksEqualIgnoreDurability(ItemStack stack1, ItemStack stack2) {
        return ItemStack.m_41758_((ItemStack)stack1, (ItemStack)stack2) && ItemStack.m_41658_((ItemStack)stack1, (ItemStack)stack2);
    }

    public static void swapSlots(AbstractContainerMenu container, int slotNum, int hotbarSlot) {
        Minecraft mc = Minecraft.m_91087_();
        mc.f_91072_.m_171799_(container.f_38840_, slotNum, hotbarSlot, ClickType.SWAP, (Player)mc.f_91074_);
    }

    public static boolean isRegularInventorySlot(int slotNumber, boolean allowOffhand) {
        return slotNumber > 8 && (allowOffhand || slotNumber < 45);
    }

    public static int findEmptySlotInPlayerInventory(AbstractContainerMenu containerPlayer, boolean allowOffhand, boolean reverse) {
        int startSlot = reverse ? containerPlayer.f_38839_.size() - 1 : 0;
        int endSlot = reverse ? -1 : containerPlayer.f_38839_.size();
        int increment = reverse ? -1 : 1;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            Slot slot = (Slot)containerPlayer.f_38839_.get(slotNum);
            ItemStack stackSlot = slot.m_7993_();
            if (!stackSlot.m_41619_() || !InventoryUtils.isRegularInventorySlot(slot.f_40219_, allowOffhand)) continue;
            return slot.f_40219_;
        }
        return -1;
    }

    public static int findSlotWithItem(AbstractContainerMenu container, ItemStack stackReference, boolean reverse) {
        int startSlot = reverse ? container.f_38839_.size() - 1 : 0;
        int endSlot = reverse ? -1 : container.f_38839_.size();
        int increment = reverse ? -1 : 1;
        boolean isPlayerInv = container instanceof InventoryMenu;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            Slot slot = (Slot)container.f_38839_.get(slotNum);
            if (isPlayerInv && !InventoryUtils.isRegularInventorySlot(slot.f_40219_, false) || !InventoryUtils.areStacksEqualIgnoreDurability(slot.m_7993_(), stackReference)) continue;
            return slot.f_40219_;
        }
        return -1;
    }

    public static boolean swapItemToMainHand(ItemStack stackReference, Minecraft mc) {
        LocalPlayer player = mc.f_91074_;
        boolean isCreative = player.m_7500_();
        if (InventoryUtils.areStacksEqual(stackReference, player.m_21205_())) {
            return false;
        }
        if (isCreative) {
            player.m_150109_().m_36012_(stackReference);
            mc.f_91072_.m_105241_(player.m_21205_(), 36 + player.m_150109_().f_35977_);
            return true;
        }
        int slot = InventoryUtils.findSlotWithItem((AbstractContainerMenu)player.f_36095_, stackReference, true);
        if (slot != -1) {
            int currentHotbarSlot = player.m_150109_().f_35977_;
            mc.f_91072_.m_171799_(player.f_36095_.f_38840_, slot, currentHotbarSlot, ClickType.SWAP, (Player)mc.f_91074_);
            return true;
        }
        return false;
    }

    @Nullable
    public static Container getInventory(Level world, BlockPos pos) {
        boolean isLoaded = world.m_46805_(pos);
        if (!isLoaded) {
            return null;
        }
        BlockEntity te = world.m_46745_(pos).m_7702_(pos);
        if (te instanceof Container) {
            BlockPos posAdj;
            boolean isLoadedAdj;
            ChestType type;
            Container inv = (Container)te;
            BlockState state = world.m_8055_(pos);
            if (state.m_60734_() instanceof ChestBlock && te instanceof ChestBlockEntity && (type = (ChestType)state.m_61143_((Property)ChestBlock.f_51479_)) != ChestType.SINGLE && (isLoadedAdj = world.m_46805_(posAdj = pos.m_121945_(ChestBlock.m_51584_((BlockState)state))))) {
                BlockState stateAdj = world.m_8055_(posAdj);
                BlockEntity te2 = world.m_46745_(posAdj).m_7702_(posAdj);
                if (stateAdj.m_60734_() == state.m_60734_() && te2 instanceof ChestBlockEntity && stateAdj.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE && stateAdj.m_61143_((Property)ChestBlock.f_51478_) == state.m_61143_((Property)ChestBlock.f_51478_)) {
                    Container invRight = type == ChestType.RIGHT ? inv : (Container)te2;
                    Container invLeft = type == ChestType.RIGHT ? (Container)te2 : inv;
                    inv = new CompoundContainer(invRight, invLeft);
                }
            }
            return inv;
        }
        return null;
    }

    public static boolean shulkerBoxHasItems(ItemStack stackShulkerBox) {
        CompoundTag tag;
        CompoundTag nbt = stackShulkerBox.m_41783_();
        if (nbt != null && nbt.m_128425_("BlockEntityTag", 10) && (tag = nbt.m_128469_("BlockEntityTag")).m_128425_("Items", 9)) {
            ListTag tagList = tag.m_128437_("Items", 10);
            return tagList.size() > 0;
        }
        return false;
    }

    public static NonNullList<ItemStack> getStoredItems(ItemStack stackIn) {
        CompoundTag tagBlockEntity;
        CompoundTag nbt = stackIn.m_41783_();
        if (nbt != null && nbt.m_128425_("BlockEntityTag", 10) && (tagBlockEntity = nbt.m_128469_("BlockEntityTag")).m_128425_("Items", 9)) {
            NonNullList items = NonNullList.m_122779_();
            ListTag tagList = tagBlockEntity.m_128437_("Items", 10);
            int count = tagList.size();
            for (int i = 0; i < count; ++i) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)tagList.m_128728_(i));
                if (stack.m_41619_()) continue;
                items.add((Object)stack);
            }
            return items;
        }
        return NonNullList.m_122779_();
    }

    public static NonNullList<ItemStack> getStoredItems(ItemStack stackIn, int slotCount) {
        CompoundTag tagBlockEntity;
        CompoundTag nbt = stackIn.m_41783_();
        if (nbt != null && nbt.m_128425_("BlockEntityTag", 10) && (tagBlockEntity = nbt.m_128469_("BlockEntityTag")).m_128425_("Items", 9)) {
            ListTag tagList = tagBlockEntity.m_128437_("Items", 10);
            int count = tagList.size();
            byte maxSlot = -1;
            if (slotCount <= 0) {
                for (int i = 0; i < count; ++i) {
                    CompoundTag tag = tagList.m_128728_(i);
                    byte slot = tag.m_128445_("Slot");
                    if (slot <= maxSlot) continue;
                    maxSlot = slot;
                }
                slotCount = maxSlot + 1;
            }
            NonNullList items = NonNullList.m_122780_((int)slotCount, (Object)ItemStack.f_41583_);
            for (int i = 0; i < count; ++i) {
                CompoundTag tag = tagList.m_128728_(i);
                ItemStack stack = ItemStack.m_41712_((CompoundTag)tag);
                byte slot = tag.m_128445_("Slot");
                if (slot < 0 || slot >= items.size() || stack.m_41619_()) continue;
                items.set((int)slot, (Object)stack);
            }
            return items;
        }
        return EMPTY_LIST;
    }

    public static Object2IntOpenHashMap<ItemType> getStoredItemCounts(ItemStack stackShulkerBox) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        NonNullList<ItemStack> items = InventoryUtils.getStoredItems(stackShulkerBox);
        for (ItemStack stack : items) {
            if (stack.m_41619_()) continue;
            map.addTo((Object)new ItemType(stack), stack.m_41613_());
        }
        return map;
    }

    public static Object2IntOpenHashMap<ItemType> getInventoryItemCounts(Container inv) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        int slots = inv.m_6643_();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = inv.m_8020_(slot);
            if (stack.m_41619_()) continue;
            map.addTo((Object)new ItemType(stack, false, true), stack.m_41613_());
            if (!(stack.m_41720_() instanceof BlockItem) || !(((BlockItem)stack.m_41720_()).m_40614_() instanceof ShulkerBoxBlock) || !InventoryUtils.shulkerBoxHasItems(stack)) continue;
            Object2IntOpenHashMap<ItemType> boxCounts = InventoryUtils.getStoredItemCounts(stack);
            for (ItemType type : boxCounts.keySet()) {
                map.addTo((Object)type, boxCounts.getInt((Object)type));
            }
        }
        return map;
    }

    public static Container getAsInventory(NonNullList<ItemStack> items) {
        SimpleContainer inv = new SimpleContainer(items.size());
        for (int slot = 0; slot < items.size(); ++slot) {
            inv.m_6836_(slot, (ItemStack)items.get(slot));
        }
        return inv;
    }
}

